/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.List;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.MoveUsage;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.projectile.EmeraldProjectile;
import net.arna.jcraft.common.entity.projectile.JAttackEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.ICustomDamageHandler;
import net.arna.jcraft.common.util.IOwnable;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HGNetEntity
extends JAttackEntity
implements GeoEntity,
ICustomDamageHandler {
    public static final EntityDataAccessor<Integer> SKIN;
    public static final EntityDataAccessor<Integer> STATE;
    public static final EntityDataAccessor<Boolean> CHARGED;
    private int animTimer = 0;
    private Vec3 target;
    private int lifeTime = 620;
    private static final int FIRE_COOLDOWN = 200;
    private static final int CONSTRICT_COOLDOWN = 200;
    private int fireCooldown = 0;
    private int constrictCooldown = 0;
    private boolean finalAttack = false;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SPAWN;
    private static final RawAnimation WILT;
    private static final RawAnimation CONSTRICT;
    private static final RawAnimation IDLE;

    public HGNetEntity(Level world) {
        super((EntityType<? extends LivingEntity>)((EntityType)JEntityTypeRegistry.HG_NET.get()), world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKIN, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(CHARGED, (Object)true);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void setCharged(boolean charged) {
        if (this.isCharged() != charged) {
            this.f_19804_.m_135381_(CHARGED, (Object)charged);
        }
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public int getSkin() {
        return (Integer)this.f_19804_.m_135370_(SKIN);
    }

    public void setState(int state) {
        if (this.getState() != state) {
            this.f_19804_.m_135381_(STATE, (Object)state);
        }
    }

    public void setSkin(int skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public void tryFireAt(Vec3 target, boolean finalAttack) {
        if (this.isCharged() && JUtils.canAct(this) && this.getState() != 2) {
            this.m_5496_((SoundEvent)JSoundRegistry.HG_SPLASH.get(), 1.0f, 1.0f);
            this.target = target;
            this.fireCooldown = 200;
            this.setCharged(false);
            if (finalAttack) {
                this.finalAttack = true;
                this.animTimer = 50;
            } else {
                this.animTimer = 25;
            }
        }
    }

    public void m_8119_() {
        if (this.m_146900_().m_60815_()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (--this.lifeTime <= 0 || this.master == null) {
                this.m_146870_();
                return;
            }
            if (this.lifeTime <= 20) {
                this.setState(3);
                return;
            }
            if (JUtils.canAct(this)) {
                Vec3 upVec = GravityChangerAPI.getEyeOffset((Entity)this);
                if (this.f_19797_ == 1) {
                    Vec3 launchVec = upVec.m_82490_(0.2);
                    JUtils.displayHitbox(this.m_9236_(), this.m_20191_());
                    this.getInsideEntities().forEach(living -> {
                        if (!living.m_20365_((Entity)this.master)) {
                            Attacks.damageLogic(this.m_9236_(), living, launchVec, 15, 3, false, 5.0f, false, 10, this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (Entity)this.master, CommonHitPropertyComponent.HitAnimation.HIGH);
                        }
                    });
                }
                if (this.getState() == 2) {
                    if (this.animTimer == 0) {
                        JUtils.displayHitbox(this.m_9236_(), this.m_20191_());
                        this.getInsideEntities().forEach(living -> {
                            if (!JUtils.isBlocking(living) && !living.m_20365_((Entity)this.master)) {
                                JCraft.stun(living, 17, 0, (Entity)this.master);
                            }
                        });
                    } else if (this.animTimer <= -20) {
                        this.setState(0);
                    }
                } else if (this.animTimer > 0) {
                    if (this.animTimer % 8 == 0) {
                        for (int i = 0; i < 3; ++i) {
                            EmeraldProjectile emerald = new EmeraldProjectile(this.m_9236_(), this.getMaster());
                            Vec3 heightOffset = upVec.m_82490_(0.8);
                            Vec3 emeraldPos = this.m_20182_().m_82549_(heightOffset).m_82549_(JUtils.randUnitVec(this.m_217043_()));
                            emerald.m_146884_(emeraldPos);
                            emerald.m_20256_(this.target.m_82546_(emeraldPos).m_82541_().m_82490_(1.5));
                            if (this.finalAttack) {
                                emerald.withReflect();
                            }
                            this.m_9236_().m_7967_((Entity)emerald);
                        }
                    }
                } else if (this.finalAttack) {
                    this.lifeTime = 20;
                }
            } else if (this.animTimer > 0) {
                this.setState(0);
                this.animTimer = 0;
            }
            if (--this.fireCooldown < 0) {
                this.setCharged(true);
            }
            --this.constrictCooldown;
            --this.animTimer;
        }
    }

    private List<LivingEntity> getInsideEntities() {
        return this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_(), EntitySelector.f_20403_.and(EntitySelector.f_20406_).and(entity -> !entity.equals((Object)this)));
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7334_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.tryConstrict(entity);
    }

    public void m_7324_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.tryConstrict(entity);
    }

    private void tryConstrict(Entity entity) {
        StandEntity stand;
        JAttackEntity attackEntity;
        Player player;
        if (entity == null) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return;
        }
        if (!JUtils.canAct(this)) {
            return;
        }
        if (this.master == null || entity.m_20365_((Entity)this.master)) {
            return;
        }
        if (entity instanceof JAttackEntity && (attackEntity = (JAttackEntity)entity).getMaster() == this.master) {
            return;
        }
        if (entity instanceof StandEntity && (stand = (StandEntity)entity).getUser() == this.master) {
            return;
        }
        if (this.getState() < 2 && this.constrictCooldown <= 0) {
            this.setState(2);
            this.constrictCooldown = 200;
            this.animTimer = 6;
        }
    }

    @Nullable
    protected SoundEvent m_7975_(@NonNull DamageSource source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return SoundEvents.f_12386_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11755_;
    }

    public boolean m_20068_() {
        return false;
    }

    public boolean m_7998_(@NonNull Entity entity, boolean force) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return false;
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity source) {
        if (effect.m_19544_() == JStatusRegistry.DAZED.get()) {
            return super.m_147207_(effect, source);
        }
        return false;
    }

    public static AttributeSupplier.Builder createNetAttributes() {
        return HGNetEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 10.0);
    }

    @Override
    public boolean reflectsDamage() {
        return false;
    }

    @Override
    public boolean handleDamage(Vec3 kbVec, int stunTicks, int stunLevel, boolean overrideStun, float damage, boolean lift, int blockstun, DamageSource source, Entity attacker, CommonHitPropertyComponent.HitAnimation hitAnimation, MoveUsage moveUsage, boolean canBackstab, boolean unblockable) {
        IOwnable ownable;
        return attacker != this.master && (!(attacker instanceof IOwnable) || (ownable = (IOwnable)attacker).getMaster() != this.master);
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        tag.m_128405_("lifeTime", this.lifeTime);
        this.writeMasterNbt(tag);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.lifeTime = tag.m_128451_("lifeTime");
        this.readMasterNbt(tag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 6, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        if (this.f_19797_ < 5) {
            state.setAnimation(SPAWN);
        } else if (this.getState() == 3) {
            state.setAnimation(WILT);
        } else if (this.getState() == 2) {
            state.setAnimation(CONSTRICT);
        } else {
            state.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static {
        STATE = SynchedEntityData.m_135353_(HGNetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SKIN = SynchedEntityData.m_135353_(HGNetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CHARGED = SynchedEntityData.m_135353_(HGNetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SPAWN = RawAnimation.begin().thenPlay("animation.hg_nets.spawn");
        WILT = RawAnimation.begin().thenPlay("animation.hg_nets.wilt");
        CONSTRICT = RawAnimation.begin().thenPlay("animation.hg_nets.constrict");
        IDLE = RawAnimation.begin().thenLoop("animation.hg_nets.idle");
    }
}

