/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.projectile.LargeIcicleProjectile;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IceBranchProjectile
extends AbstractArrow
implements GeoEntity {
    private static final int MAX_CHAIN_LENGTH = 10;
    private final int chainIndex;
    private LivingEntity livingOwner;
    private boolean grown = false;
    private boolean lockRotation = false;
    private boolean lockVelocity = true;
    private final Comparator<Entity> distanceComparator = (entity1, entity2) -> {
        double distance1 = this.m_20280_((Entity)entity1);
        double distance2 = this.m_20280_((Entity)entity2);
        return Double.compare(distance1, distance2);
    };
    public static final double LENGTH = 1.0;
    public static final int DEATH_TICK = 100;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation FIRE = RawAnimation.begin().thenPlayAndHold("animation.ice_branch.spawn");

    public IceBranchProjectile(Level level) {
        super((EntityType)JEntityTypeRegistry.ICE_BRANCH.get(), level);
        this.chainIndex = 0;
    }

    public IceBranchProjectile(Level level, LivingEntity owner, int chainIndex) {
        super((EntityType)JEntityTypeRegistry.ICE_BRANCH.get(), level);
        this.m_5602_((Entity)owner);
        this.livingOwner = owner;
        this.m_20242_(true);
        this.m_36790_(true);
        this.chainIndex = chainIndex;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public void m_146926_(float xRot) {
        if (this.lockRotation) {
            return;
        }
        super.m_146926_(xRot);
    }

    public void m_146922_(float yRot) {
        if (this.lockRotation) {
            return;
        }
        super.m_146922_(yRot);
    }

    public void m_20256_(@NonNull Vec3 deltaMovement) {
        if (deltaMovement == null) {
            throw new NullPointerException("deltaMovement is marked non-null but is null");
        }
        if (this.lockVelocity) {
            return;
        }
        super.m_20256_(deltaMovement);
    }

    public void m_8119_() {
        this.lockRotation = true;
        super.m_8119_();
        this.lockRotation = false;
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ == 1) {
                Vec3 rotVec = this.m_20171_(this.m_146909_(), -this.m_146908_());
                for (int i = 0; i < 6; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? LargeIcicleProjectile.ICE_PARTICLE : ParticleTypes.f_175821_), this.m_20185_(), this.m_20186_(), this.m_20189_(), (this.f_19796_.m_188583_() - rotVec.f_82479_) * 0.1, (this.f_19796_.m_188583_() - rotVec.f_82480_) * 0.1, (this.f_19796_.m_188583_() - rotVec.f_82481_) * 0.1);
                }
            } else if (this.f_19797_ == 100) {
                for (int i = 0; i < 6; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)LargeIcicleProjectile.ICE_PARTICLE, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_());
                }
            } else if (this.f_19796_.m_188501_() < 0.1f) {
                this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ParticleTypes.f_123764_ : ParticleTypes.f_175821_), this.m_20185_() + this.f_19796_.m_188583_() * 0.25, this.m_20186_() + this.f_19796_.m_188583_() * 0.25, this.m_20189_() + this.f_19796_.m_188583_() * 0.25, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.livingOwner == null) {
            this.m_146870_();
            return;
        }
        if (this.f_19797_ == 1) {
            Vec3 rotVec = this.m_20171_(this.m_146909_(), -this.m_146908_());
            Vec3 pos = this.m_20182_();
            Level level = this.m_9236_();
            Set<LivingEntity> hurt = JUtils.generateHitbox(level, pos.m_82549_(rotVec.m_82490_(-0.25)), 1.25, e -> true);
            boolean hit = false;
            for (LivingEntity living : hurt) {
                if (!this.canAttack(living)) continue;
                hit = !JUtils.isBlocking(living);
                LivingEntity target = JUtils.getUserIfStand(living);
                Attacks.damageLogic(level, target, Vec3.f_82478_, 30 - 10 * this.chainIndex / 10, 0, false, 4.0f, true, 10, level.m_269111_().m_269333_(this.livingOwner), (Entity)this.livingOwner, CommonHitPropertyComponent.HitAnimation.MID);
            }
            if (hit) {
                Vec3 frontPos = pos.m_82549_(rotVec.m_82490_(-0.5));
                this.m_5496_(SoundEvents.f_144205_, 1.0f, 1.0f);
                ServerLevel serverWorld = (ServerLevel)level;
                JCraft.createParticle(serverWorld, frontPos.f_82479_ + this.f_19796_.m_188583_() * 0.25, frontPos.f_82480_ + this.f_19796_.m_188583_() * 0.25, frontPos.f_82481_ + this.f_19796_.m_188583_() * 0.25, JParticleType.HIT_SPARK_1);
                JUtils.around(serverWorld, frontPos, 128.0).forEach(serverPlayer -> serverWorld.m_8624_(serverPlayer, (ParticleOptions)LargeIcicleProjectile.ICE_PARTICLE, false, frontPos.f_82479_ - 0.25, frontPos.f_82480_ - 0.25, frontPos.f_82481_ - 0.25, 10, 0.5, 0.5, 0.5, 0.1));
                this.grown = true;
            }
        } else if (this.chainIndex < 10 && !this.grown && this.f_19797_ == 10) {
            ServerLevel serverWorld = (ServerLevel)this.m_9236_();
            Vec3 rotVec = this.m_20171_(this.m_146909_(), -this.m_146908_());
            Vec3 initialPos = this.m_20182_().m_82549_(rotVec.m_82490_(-1.0));
            Optional<Entity> target = serverWorld.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(32.0), EntitySelector.f_20406_).stream().filter(livingEntity -> livingEntity != this.livingOwner && !livingEntity.m_20365_((Entity)this.livingOwner)).min(this.distanceComparator);
            boolean shouldSplit = this.chainIndex % 4 == 2;
            float inaccuracy = shouldSplit ? 25.0f : 0.0f;
            for (int i = 0; i < (shouldSplit ? 2 : 1); ++i) {
                IceBranchProjectile next = new IceBranchProjectile(this.m_9236_(), this.livingOwner, this.chainIndex + 1);
                if (target.isPresent()) {
                    LivingEntity nearestTarget = (LivingEntity)target.get();
                    float currentXRot = this.m_146909_();
                    float currentYRot = this.m_146908_();
                    Vec3 toTargetVec = nearestTarget.m_20182_().m_82546_(this.m_20182_());
                    double dx = toTargetVec.f_82479_;
                    double dy = toTargetVec.f_82480_;
                    double dz = toTargetVec.f_82481_;
                    double flatDist = Math.sqrt(dx * dx + dz * dz);
                    float targetXRot = (float)(Mth.m_14136_((double)dy, (double)flatDist) * 57.29577951308232);
                    float targetYRot = (float)(-(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232)) - 90.0f;
                    float clampedXRot = Mth.m_14148_((float)currentXRot, (float)targetXRot, (float)25.0f) + (float)this.f_19796_.m_188583_() * inaccuracy;
                    float clampedYRot = -Mth.m_14148_((float)currentYRot, (float)targetYRot, (float)25.0f) + (float)this.f_19796_.m_188583_() * inaccuracy;
                    Vec3 toTarget = this.m_20171_(clampedXRot, clampedYRot).m_82541_();
                    next.m_146926_(clampedXRot);
                    next.m_146922_(-clampedYRot);
                    next.m_146884_(initialPos.m_82549_(toTarget.m_82490_(-1.0)));
                } else {
                    float xRot = this.m_146909_() + this.f_19796_.m_188501_() * 60.0f - 30.0f;
                    float yRot = this.m_146908_() + this.f_19796_.m_188501_() * 60.0f - 30.0f;
                    Vec3 newRotVec = this.m_20171_(xRot, yRot).m_82541_();
                    next.m_146926_(xRot);
                    next.m_146922_(-yRot);
                    next.m_146884_(initialPos.m_82549_(newRotVec.m_82490_(-1.0)));
                }
                next.f_19860_ = next.m_146909_();
                next.f_19859_ = next.m_146908_();
                this.m_9236_().m_7967_((Entity)next);
            }
            this.grown = true;
        } else if (this.f_19797_ == 90) {
            this.lockVelocity = false;
            this.m_20242_(false);
            this.m_36790_(false);
        } else if (this.f_19797_ == 100) {
            this.m_146870_();
        }
    }

    private boolean canAttack(LivingEntity living) {
        if (living == this.livingOwner) {
            return false;
        }
        return this.livingOwner == null || JComponentPlatformUtils.getStandComponent(this.livingOwner).getStand() != living;
    }

    protected void m_6532_(@NonNull HitResult result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
    }

    @NonNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<IceBranchProjectile> state) {
        return state.setAndContinue(FIRE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

