/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.projectile.JAttackEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IcicleProjectile
extends AbstractArrow
implements GeoEntity {
    private int ticksInAir;
    private int bouncesLeft = 5;
    private float damage = 1.0f;
    private boolean reflect = false;
    private static final BlockParticleOption ICE_PARTICLE = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50126_.m_49966_());
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public IcicleProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.ICICLE.get(), world);
    }

    public IcicleProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.ICICLE.get(), owner, world);
        this.m_36740_(SoundEvents.f_11983_);
    }

    public void withReflect() {
        this.reflect = true;
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_6901_() {
        this.m_146870_();
    }

    public void m_8119_() {
        double z;
        double y;
        double x;
        super.m_8119_();
        if (!this.f_36703_) {
            ++this.ticksInAir;
        } else if (this.m_9236_().f_46443_) {
            x = this.m_20185_();
            y = this.m_20186_();
            z = this.m_20189_();
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ICE_PARTICLE, x, y, z, this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_());
            }
        }
        if (this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188583_() < -0.002) {
                x = this.m_20185_();
                y = this.m_20186_();
                z = this.m_20189_();
                Vec3 velocity = this.m_20184_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
            return;
        }
        if (this.ticksInAir > 200) {
            this.m_146870_();
        }
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_6532_(@NonNull HitResult hitResult) {
        if (hitResult == null) {
            throw new NullPointerException("hitResult is marked non-null but is null");
        }
        if (this.reflect) {
            HitResult.Type type = hitResult.m_6662_();
            if (type == HitResult.Type.ENTITY) {
                this.m_5790_((EntityHitResult)hitResult);
                this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
            } else if (type == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (this.bouncesLeft-- > 0) {
                    Vec3i normal = blockHitResult.m_82434_().m_122436_();
                    double currentVelocity = this.m_20184_().m_82553_();
                    this.m_20256_(this.m_20184_().m_82549_(Vec3.m_82528_((Vec3i)normal)).m_82541_().m_82490_(currentVelocity * 0.75));
                } else {
                    this.m_8060_(blockHitResult);
                    BlockPos blockPos = blockHitResult.m_82425_();
                    this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockPos)));
                }
            }
        } else {
            super.m_6532_(hitResult);
        }
        this.f_19864_ = true;
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        JAttackEntity attackEntity;
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (owner != null && owner.m_20363_(entity) || entity == owner) {
            return;
        }
        if (entity instanceof JAttackEntity && (attackEntity = (JAttackEntity)entity).getMaster() == owner) {
            return;
        }
        int blockstun = 4;
        int stunT = 10;
        JUtils.projectileDamageLogic((Projectile)this, this.m_9236_(), entity, this.m_20184_().m_82541_().m_82490_(0.3), stunT, 1, false, this.damage, blockstun, CommonHitPropertyComponent.HitAnimation.MID);
        this.m_5496_(SoundEvents.f_11983_, 1.0f, 1.0f);
        this.m_146870_();
    }

    protected float m_6882_() {
        return 0.97f;
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        tag.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.ticksInAir = tag.m_128448_("life");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

