/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.component.living.CommonVampireComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.common.entity.stand.AbstractKillerQueenEntity;
import net.arna.jcraft.common.item.BloodBottleItem;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemTossProjectile
extends AbstractArrow {
    protected static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(ItemTossProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Integer> RICOCHETS = SynchedEntityData.m_135353_(ItemTossProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ItemTossProjectile(Level level) {
        super((EntityType)JEntityTypeRegistry.ITEM_TOSS_PROJECTILE.get(), level);
        this.setItem(ItemStack.f_41583_);
    }

    public ItemTossProjectile(LivingEntity shooter, Level level, ItemStack item) {
        super((EntityType)JEntityTypeRegistry.ITEM_TOSS_PROJECTILE.get(), shooter, level);
        this.setItem(item);
        if (this.getItem().m_204117_(JTagRegistry.HEAVY_IMPACT)) {
            this.m_36781_(2.0);
            this.m_36735_(4);
        } else {
            this.m_36781_(0.0);
            this.m_36735_(0);
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.f_19804_.m_135370_(ITEM);
    }

    protected void setItem(@NotNull ItemStack item) {
        this.f_19804_.m_135381_(ITEM, (Object)item.m_255036_(1));
    }

    public int getRicochets() {
        return (Integer)this.f_19804_.m_135370_(RICOCHETS);
    }

    protected void incrementRicochets() {
        this.f_19804_.m_135381_(RICOCHETS, (Object)(this.getRicochets() + 1));
    }

    protected ItemStack m_7941_() {
        return this.getItem();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(RICOCHETS, (Object)0);
    }

    public boolean m_6060_() {
        return this.getItem().m_204117_(JTagRegistry.BURNS_ON_IMPACT);
    }

    protected void m_7761_(LivingEntity target) {
        if (this.getItem().m_204117_(JTagRegistry.BLINDS_ON_IMPACT)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40));
        }
        if (this.getItem().m_204117_(JTagRegistry.SLOWS_ON_IMPACT)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60));
        }
        if (this.getItem().m_204117_(JTagRegistry.POISONS_ON_IMPACT)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60));
        }
    }

    protected boolean maybeExplode() {
        if (!this.m_9236_().f_46443_ && (this.getItem().m_204117_(JTagRegistry.EXPLODES_ON_IMPACT) || this.m_19749_() instanceof AbstractKillerQueenEntity)) {
            boolean grief = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, grief, Level.ExplosionInteraction.MOB);
            this.m_146870_();
            return true;
        }
        return false;
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type type = result.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)result);
        } else if (type == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            this.m_8060_(blockHitResult);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        AbstractHorse horse;
        LivingEntity livingEntity;
        boolean bl;
        DamageSource damageSource;
        Entity entity = result.m_82443_();
        Entity entity2 = this.m_19749_();
        if (entity2 == null) {
            damageSource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damageSource = this.m_269291_().m_269418_((AbstractArrow)this, entity2);
            if (entity2 instanceof LivingEntity) {
                ((LivingEntity)entity2).m_21335_(entity);
            }
        }
        boolean bl2 = bl = entity.m_6095_() == EntityType.f_20566_;
        if (this.m_6060_() && !bl) {
            entity.m_20254_(5);
        }
        entity.m_6469_(damageSource, (float)this.m_36789_());
        if (bl) {
            return;
        }
        boolean effectActivated = false;
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (this.m_150123_() > 0) {
                double d = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6 * d);
                if (vec3.m_82556_() > 0.0) {
                    livingEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                }
            }
            this.m_7761_(livingEntity);
        }
        if (this.maybeExplode()) {
            return;
        }
        if (entity instanceof LivingEntity && ((livingEntity = (LivingEntity)entity) instanceof ServerPlayer || livingEntity.m_6095_().m_204039_(JTagRegistry.CAN_HAVE_STAND)) && this.getItem().m_150930_((Item)JItemRegistry.STAND_DISC.get())) {
            StandType itemStand = null;
            int itemSkin = 0;
            CompoundTag data = this.getItem().m_41784_();
            if (data.m_128441_("StandID")) {
                itemStand = StandTypeUtil.readFromNBT(data, "StandID");
            }
            if (data.m_128425_("Skin", 3)) {
                itemSkin = data.m_128451_("Skin");
            }
            if (itemStand != null && !JCraft.getExclusiveStandsData().isStandUsed(itemStand)) {
                CommonStandComponent standData = JComponentPlatformUtils.getStandComponent(livingEntity);
                if (standData.getType() == null) {
                    standData.setTypeAndSkin(itemStand, itemSkin);
                    JCraft.summon(this.m_9236_(), livingEntity);
                }
                effectActivated = true;
            }
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (this.getItem().m_204117_(JTagRegistry.EQUIPABLES)) {
                mob.m_255207_(this.getItem());
                effectActivated = true;
            }
        }
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (this.getItem().m_41614_()) {
                Player player;
                if (this.getItem().m_41720_() instanceof BloodBottleItem && livingEntity instanceof Player) {
                    Player player2 = (Player)livingEntity;
                    CommonVampireComponent vampireComponent = JComponentPlatformUtils.getVampirism((LivingEntity)player2);
                    if (vampireComponent.isVampire()) {
                        CompoundTag nbt = this.getItem().m_41784_();
                        int blood = (int)Math.floor(nbt.m_128457_("Blood"));
                        vampireComponent.setBlood(Math.min(20.0f, vampireComponent.getBlood() + (float)blood));
                        effectActivated = true;
                    }
                } else if (livingEntity instanceof Player && !JComponentPlatformUtils.getVampirism((LivingEntity)(player = (Player)livingEntity)).isVampire()) {
                    livingEntity.m_5584_(this.m_9236_(), this.getItem());
                    if (this.getItem().m_41720_() instanceof BowlFoodItem) {
                        this.setItem(Items.f_42399_.m_7968_());
                        this.dropItem(result.m_82450_());
                    }
                    effectActivated = true;
                }
            }
        }
        if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            if (this.getItem().m_150930_(Items.f_42416_)) {
                float prevHealHealth = golem.m_21223_();
                golem.m_5634_(25.0f);
                if (golem.m_21223_() != prevHealHealth) {
                    float g = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
                    this.m_5496_(SoundEvents.f_12009_, 1.0f, g);
                }
                effectActivated = true;
            }
        }
        if (entity instanceof Saddleable) {
            Saddleable saddleable = (Saddleable)entity;
            if (this.getItem().m_150930_(Items.f_42450_)) {
                saddleable.m_5853_(null);
                float g = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
                this.m_5496_(saddleable.m_246265_(), 1.0f, g);
                effectActivated = true;
            }
        }
        if (entity instanceof AbstractHorse && (horse = (AbstractHorse)entity).m_6010_(this.getItem())) {
            horse.f_30520_.m_6836_(1, this.getItem());
            effectActivated = true;
        }
        if (!this.m_9236_().f_46443_ && this.getItem().m_204117_(JTagRegistry.EXPLODES_ON_IMPACT)) {
            entity.m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, entity2), 6.0f);
        }
        if (this.m_36796_() <= 0) {
            if (!(effectActivated || this.getItem().m_204117_(JTagRegistry.BLINDS_ON_IMPACT) || this.getItem().m_204117_(JTagRegistry.BURNS_ON_IMPACT) || this.getItem().m_204117_(JTagRegistry.HEAVY_IMPACT) || this.getItem().m_204117_(JTagRegistry.EXPLODES_ON_IMPACT) || this.getItem().m_204117_(JTagRegistry.SLOWS_ON_IMPACT) || this.getItem().m_204117_(JTagRegistry.POISONS_ON_IMPACT))) {
                this.dropItem(result.m_82450_());
            }
            this.m_146870_();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void m_8060_(BlockHitResult result) {
        block23: {
            Item box;
            BlockPos pos;
            ItemStack item;
            block28: {
                block27: {
                    Item context;
                    block26: {
                        block25: {
                            Item kineticEnergy2;
                            block24: {
                                BlockState blockstate = this.m_9236_().m_8055_(result.m_82425_());
                                blockstate.m_60669_(this.m_9236_(), blockstate, result, (Projectile)this);
                                BlockState hitBlock = this.m_9236_().m_8055_(result.m_82425_());
                                double hardness = hitBlock.m_60734_().m_155943_();
                                if (hardness < 0.0) {
                                    hardness = Double.MAX_VALUE;
                                }
                                if (this.maybeExplode()) {
                                    return;
                                }
                                this.incrementRicochets();
                                if (this.getRicochets() <= this.maxRicochets()) {
                                    boolean lowEnergy;
                                    Vec3i intNormal = result.m_82434_().m_122436_();
                                    Vec3 normal = new Vec3((double)intNormal.m_123341_(), (double)intNormal.m_123342_(), (double)intNormal.m_123343_());
                                    Vec3 impactVec = this.m_20184_();
                                    double impactAngleRad = Math.acos(normal.m_82526_(impactVec.m_82541_())) - 1.5707963267948966;
                                    double impactAngleDeg = Math.toDegrees(impactAngleRad);
                                    double kineticEnergy2 = this.mass() * impactVec.m_82556_() / 2.0;
                                    double penAngle = this.penetrationAngle() + hardness * 5.0;
                                    boolean bl = lowEnergy = kineticEnergy2 < 0.001;
                                    if (impactAngleDeg <= penAngle && !lowEnergy) {
                                        this.m_20256_(impactVec.m_82549_(normal).m_82490_(0.5 / hardness));
                                        return;
                                    }
                                }
                                item = this.getItem();
                                pos = result.m_82425_().m_121945_(result.m_82434_());
                                kineticEnergy2 = item.m_41720_();
                                if (!(kineticEnergy2 instanceof BlockItem)) break block24;
                                BlockItem block = (BlockItem)kineticEnergy2;
                                if (!(item.m_204117_(JTagRegistry.BRITTLE) && hardness >= (double)Blocks.f_50069_.m_155943_() || InteractionResult.SUCCESS == block.m_40576_(new BlockPlaceContext(new UseOnContext(this.m_9236_(), null, InteractionHand.MAIN_HAND, item, result))))) {
                                    this.dropItem(result.m_82450_());
                                }
                                break block23;
                            }
                            kineticEnergy2 = item.m_41720_();
                            if (!(kineticEnergy2 instanceof AxeItem)) break block25;
                            AxeItem axe = (AxeItem)kineticEnergy2;
                            BlockState blockState = this.m_9236_().m_8055_(result.m_82425_());
                            Optional stripped = axe.m_150690_(blockState);
                            if (stripped.isPresent()) {
                                this.m_9236_().m_46597_(result.m_82425_(), (BlockState)stripped.get());
                                item.m_41622_(1, (LivingEntity)this.m_19749_(), owner -> {});
                            }
                            this.dropItem(result.m_82450_());
                            break block23;
                        }
                        if (!(item.m_41720_() instanceof HoeItem)) break block26;
                        context = new UseOnContext(this.m_9236_(), null, InteractionHand.MAIN_HAND, item, result);
                        Pair pair = (Pair)HoeItem.f_41332_.get(this.m_9236_().m_8055_(result.m_82425_()).m_60734_());
                        if (pair != null) {
                            Predicate predicate = (Predicate)pair.getFirst();
                            Consumer consumer = (Consumer)pair.getSecond();
                            if (predicate.test(context) && !this.m_9236_().f_46443_) {
                                consumer.accept(context);
                                context.m_43722_().m_41622_(1, (LivingEntity)this.m_19749_(), owner -> {});
                            }
                        }
                        this.dropItem(result.m_82450_());
                        break block23;
                    }
                    context = item.m_41720_();
                    if (!(context instanceof BucketItem)) break block27;
                    BucketItem bucket = (BucketItem)context;
                    if (bucket.f_40687_ == Fluids.f_76191_) break block27;
                    if (bucket.m_142073_(null, this.m_9236_(), result.m_82425_(), result)) {
                        bucket.m_142131_(null, this.m_9236_(), item, pos);
                        this.setItem(Items.f_42446_.m_7968_());
                    }
                    this.dropItem(result.m_82450_());
                    break block23;
                }
                if (!item.m_204117_(ItemTags.f_13158_)) break block28;
                box = this.m_9236_().m_8055_(result.m_82425_());
                if (box.m_60713_(Blocks.f_50131_) && !((Boolean)box.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue()) {
                    BlockEntity blockEntity = this.m_9236_().m_7702_(result.m_82425_());
                    if (blockEntity instanceof JukeboxBlockEntity) {
                        JukeboxBlockEntity boxEntity = (JukeboxBlockEntity)blockEntity;
                        boxEntity.m_272287_(item.m_41777_());
                        break block23;
                    } else {
                        this.dropItem(result.m_82450_());
                    }
                    break block23;
                } else {
                    this.dropItem(result.m_82450_());
                }
                break block23;
            }
            box = item.m_41720_();
            if (box instanceof PotionItem) {
                PotionItem potion = (PotionItem)box;
                ThrownPotion thrown = new ThrownPotion(this.m_9236_(), result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_);
                Potion effect = PotionUtils.m_43579_((ItemStack)item);
                thrown.m_37446_(item);
                if (potion instanceof LingeringPotionItem) {
                    thrown.m_37537_(item, effect);
                } else {
                    thrown.m_37547_(PotionUtils.m_43547_((ItemStack)item), null);
                }
                int i = effect.m_43491_() ? 2007 : 2002;
                this.m_9236_().m_46796_(i, pos, PotionUtils.m_43575_((ItemStack)item));
            } else if (item.m_41720_() instanceof ExperienceBottleItem) {
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_46796_(2002, pos, PotionUtils.m_43559_((Potion)Potions.f_43599_));
                    int amount = 3 + this.m_9236_().f_46441_.m_188503_(5) + this.m_9236_().f_46441_.m_188503_(5);
                    ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)result.m_82450_(), (int)amount);
                }
            } else {
                Item amount = item.m_41720_();
                if (amount instanceof SpawnEggItem) {
                    SpawnEggItem egg = (SpawnEggItem)amount;
                    EntityType entityType2 = egg.m_43228_(item.m_41783_());
                    if (!this.m_9236_().m_5776_()) {
                        entityType2.m_20592_((ServerLevel)this.m_9236_(), item, null, pos, MobSpawnType.SPAWN_EGG, true, false);
                    }
                } else {
                    this.dropItem(result.m_82450_());
                }
            }
        }
        this.f_36703_ = true;
        this.m_146870_();
    }

    private void dropItem(Vec3 pos) {
        Vec3 vec3 = pos.m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vecN = vec3.m_82541_().m_82490_(0.05);
        Containers.m_18992_((Level)this.m_9236_(), (double)(this.m_20185_() - vecN.f_82479_), (double)(this.m_20186_() - vecN.f_82480_), (double)(this.m_20189_() - vecN.f_82481_), (ItemStack)this.getItem());
    }

    public int maxRicochets() {
        if (this.getItem().m_204117_(JTagRegistry.SUPER_BOUNCY)) {
            return 15;
        }
        if (this.getItem().m_204117_(JTagRegistry.BOUNCY)) {
            return 10;
        }
        if (this.getItem().m_204117_(JTagRegistry.SOMEWHAT_BOUNCY)) {
            return 5;
        }
        return 0;
    }

    public double penetrationAngle() {
        if (this.getItem().m_204117_(JTagRegistry.ACUTE)) {
            return 15.0;
        }
        if (this.getItem().m_204117_(JTagRegistry.OBTUSE)) {
            return 60.0;
        }
        return 45.0;
    }

    public double mass() {
        if (this.getItem().m_204117_(JTagRegistry.VERY_HEAVY)) {
            return 50.0;
        }
        if (this.getItem().m_204117_(JTagRegistry.HEAVY)) {
            return 10.0;
        }
        if (this.getItem().m_204117_(JTagRegistry.LIGHT)) {
            return 0.1;
        }
        return 1.0;
    }
}

