/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.Set;
import java.util.function.Predicate;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class KnifeProjectile
extends AbstractArrow
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> LIGHTNING = SynchedEntityData.m_135353_(KnifeProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean explosive = false;
    private int ticksInAir;
    private boolean delayed = false;
    private boolean delayFired = false;
    private int delayTime;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public KnifeProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.KNIFE.get(), world);
    }

    public KnifeProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.KNIFE.get(), owner, world);
    }

    public Boolean getLightning() {
        return (Boolean)this.f_19804_.m_135370_(LIGHTNING);
    }

    public void setLightning(Boolean li) {
        this.f_19804_.m_135381_(LIGHTNING, (Object)li);
    }

    public void setDelayedLightning(int dt) {
        this.setLightning(true);
        this.delayed = true;
        this.delayTime = dt;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LIGHTNING, (Object)false);
    }

    @NonNull
    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)JItemRegistry.KNIFE.get());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_36703_) {
            ++this.ticksInAir;
        }
        if (!this.getLightning().booleanValue()) {
            if (this.ticksInAir > 640 && !this.m_9236_().f_46443_) {
                this.m_146870_();
            }
            return;
        }
        if (this.m_9236_().f_46443_) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, (x + this.f_19854_) / 2.0, (y + this.f_19855_) / 2.0, (z + this.f_19856_) / 2.0, 0.0, 0.0, 0.0);
            return;
        }
        if (this.ticksInAir > 200 || this.f_36703_) {
            if (this.explosive) {
                this.explode();
            }
            this.m_146870_();
        }
        if (!this.delayed) {
            return;
        }
        --this.delayTime;
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        if (this.delayTime >= 1) {
            this.m_20256_(this.m_20184_().m_82490_(0.5));
            return;
        }
        if (this.delayFired) {
            return;
        }
        Vec3 eP = owner.m_146892_();
        Vec3 rangeMod = owner.m_20154_().m_82490_(24.0);
        EntityHitResult eHit = ProjectileUtil.m_37287_((Entity)owner, (Vec3)eP, (Vec3)eP.m_82549_(rangeMod), (AABB)owner.m_20191_().m_82400_(24.0), (Predicate)EntitySelector.f_20403_, (double)576.0);
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(eP, eP.m_82549_(rangeMod), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, owner));
        this.m_5496_((SoundEvent)JSoundRegistry.TWOH_SHOOT.get(), 1.0f, 1.0f);
        Vec3 hitPos = hitResult.m_82450_();
        if (eHit != null) {
            hitPos = eHit.m_82450_();
        }
        this.m_20256_(new Vec3(hitPos.f_82479_ - this.m_20185_(), hitPos.f_82480_ - this.m_20186_(), hitPos.f_82481_ - this.m_20189_()).m_82541_());
        this.f_19812_ = true;
        this.delayFired = true;
    }

    private void explode() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        JCraft.createParticle((ServerLevel)this.m_9236_(), x, y, z, JParticleType.FLASH);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, x, y, z, (SoundEvent)JSoundRegistry.TWOH_SHOOT.get(), SoundSource.PLAYERS, 0.5f, 0.5f);
        }
        Entity owner = this.m_19749_();
        Vec3 pos = this.m_20182_();
        Set<LivingEntity> hurt = JUtils.generateHitbox(this.m_9236_(), pos, 1.5, e -> !e.m_20365_(owner));
        for (LivingEntity living : hurt) {
            LivingEntity target = JUtils.getUserIfStand(living);
            Vec3 kbVec = target.m_20182_().m_82546_(pos).m_82541_();
            Attacks.damageLogic(this.m_9236_(), target, kbVec, 10, 1, false, 1.0f, true, 9, this.m_9236_().m_269111_().m_269104_(owner, (Entity)this), this.m_19749_(), CommonHitPropertyComponent.HitAnimation.MID, false);
        }
    }

    public void m_8038_(@NonNull ServerLevel world, @NonNull LightningBolt lightning) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (lightning == null) {
            throw new NullPointerException("lightning is marked non-null but is null");
        }
        this.setLightning(true);
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.delayed && this.delayTime > 1) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (owner != null && owner.m_20363_(entity) || entity == owner) {
            return;
        }
        if (this.m_6060_()) {
            entity.m_20254_(5);
        }
        int blockstun = 4;
        int stunT = 0;
        if (this.getLightning().booleanValue()) {
            stunT = 20;
            blockstun = 6;
        } else {
            this.m_5552_(this.m_7941_(), 0.1f);
        }
        if (this.explosive) {
            this.explode();
        }
        JUtils.projectileDamageLogic((Projectile)this, this.m_9236_(), entity, Vec3.f_82478_, stunT, 1, false, 2.0f, blockstun, CommonHitPropertyComponent.HitAnimation.MID);
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            JComponentPlatformUtils.getMiscData(living).stab();
        }
        this.m_146870_();
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        tag.m_128376_("life", (short)this.ticksInAir);
        tag.m_128379_("lightning", this.getLightning().booleanValue());
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.ticksInAir = tag.m_128448_("life");
        this.setLightning(tag.m_128471_("lightning"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

