/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.projectile.IcicleProjectile;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LargeIcicleProjectile
extends AbstractArrow
implements GeoEntity {
    public static final BlockParticleOption ICE_PARTICLE = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50126_.m_49966_());
    private int ticksInAir;
    private LivingEntity livingOwner;
    private boolean projectile = false;
    private boolean instant = false;
    private boolean lockVelocity = false;
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(LargeIcicleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_INSTANT = SynchedEntityData.m_135353_(LargeIcicleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation FIRE = RawAnimation.begin().thenPlayAndHold("animation.large_icicle.spawn");
    private static final RawAnimation FIRE_INSTANT = RawAnimation.begin().thenPlayAndHold("animation.large_icicle.spawn_instant");

    public void lock() {
        this.lockVelocity = true;
    }

    public LargeIcicleProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.LARGE_ICICLE.get(), world);
    }

    public LargeIcicleProjectile(Level world, @NonNull LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.LARGE_ICICLE.get(), owner, world);
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        this.m_36790_(true);
        this.m_5602_((Entity)owner);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.livingOwner = owner;
        this.m_36740_(SoundEvents.f_11983_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(IS_INSTANT, (Object)false);
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public void setInstant(boolean instant) {
        this.instant = instant;
        this.f_19804_.m_135381_(IS_INSTANT, (Object)instant);
    }

    public void markProjectile() {
        this.projectile = true;
    }

    public void m_20256_(@NonNull Vec3 deltaMovement) {
        if (deltaMovement == null) {
            throw new NullPointerException("deltaMovement is marked non-null but is null");
        }
        if (this.lockVelocity) {
            return;
        }
        super.m_20256_(deltaMovement);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.livingOwner == null) {
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity living;
                this.livingOwner = living = (LivingEntity)entity;
            } else {
                this.m_146870_();
                return;
            }
        }
        ++this.ticksInAir;
        if (this.m_9236_().f_46443_) {
            if (this.ticksInAir == 1) {
                double x = this.m_20185_();
                double y = this.m_20186_();
                double z = this.m_20189_();
                Vec3 velocity = this.m_20184_().m_82541_();
                for (int i = 0; i < 24; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ICE_PARTICLE : ParticleTypes.f_175821_), x, y, z, (velocity.f_82479_ + this.f_19796_.m_188583_()) * 0.25, (velocity.f_82480_ + this.f_19796_.m_188583_()) * 0.25, (velocity.f_82481_ + this.f_19796_.m_188583_()) * 0.25);
                }
            }
            return;
        }
        if (this.projectile) {
            Vec3 velocity = this.m_20184_();
            BlockPos blockPos = this.m_20183_();
            BlockPos forward = this.m_20183_().m_7918_((int)velocity.f_82479_, (int)velocity.f_82480_, (int)velocity.f_82481_);
            if (this.ticksInAir > 30 || this.m_9236_().m_8055_(blockPos).m_60815_() || this.m_9236_().m_8055_(forward).m_60815_()) {
                this.detonate();
            } else {
                Vec3 gravity = Vec3.m_82528_((Vec3i)GravityChangerAPI.getGravityDirection((Entity)this).m_122436_());
                this.lockVelocity = false;
                this.m_20256_(velocity.m_82490_(0.99));
                this.m_5997_(gravity.f_82479_ * 9.81 / 400.0, gravity.f_82480_ * 9.81 / 400.0, gravity.f_82481_ * 9.81 / 400.0);
                this.lockVelocity = true;
                Vec3 pos = this.m_20182_();
                Vec3 direction = velocity.m_82541_();
                Set<LivingEntity> hurt = JUtils.generateHitbox(this.m_9236_(), pos.m_82549_(direction), 1.75, e -> true);
                boolean hit = false;
                for (LivingEntity living : hurt) {
                    if (this.cantAttack(living)) continue;
                    hit = !JUtils.isBlocking(living);
                    LivingEntity target = JUtils.getUserIfStand(living);
                    Vec3 kbVec = direction.m_82490_(0.75);
                    int stun = 15;
                    Attacks.damageLogic(this.m_9236_(), target, kbVec, stun, 3, false, 3.0f, true, 4, this.m_9236_().m_269111_().m_269333_(this.livingOwner), (Entity)this.livingOwner, CommonHitPropertyComponent.HitAnimation.CRUSH, false, false);
                }
                if (hit) {
                    Vec3 frontPos = pos.m_82549_(direction);
                    JCraft.createParticle((ServerLevel)this.m_9236_(), frontPos.f_82479_ + this.f_19796_.m_188583_() * 0.25, frontPos.f_82480_ + this.f_19796_.m_188583_() * 0.25, frontPos.f_82481_ + this.f_19796_.m_188583_() * 0.25, JParticleType.HIT_SPARK_2);
                }
            }
        } else if (this.instant) {
            if (this.ticksInAir == 1) {
                this.attack();
            } else if (this.ticksInAir > 10) {
                this.m_146870_();
            }
        } else if (this.ticksInAir < 10) {
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else if (this.ticksInAir == 10) {
            this.attack();
        } else if (this.ticksInAir > 50) {
            this.m_146870_();
        }
    }

    private void attack() {
        float scale = ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
        boolean perfect = scale == 1.0f && this.instant;
        Vec3 pos = this.m_20182_();
        Vec3 direction = this.m_20184_().m_82541_();
        Set<LivingEntity> hurt = JUtils.generateHitbox(this.m_9236_(), pos.m_82549_(direction.m_82490_(1.25 * (double)scale)), 1.75 * (double)scale, e -> true);
        hurt.addAll(JUtils.generateHitbox(this.m_9236_(), pos.m_82549_(direction.m_82490_(2.25 * (double)scale)), 1.25 * (double)scale, e -> true));
        boolean hit = false;
        for (LivingEntity living : hurt) {
            if (this.cantAttack(living)) continue;
            hit = !JUtils.isBlocking(living);
            LivingEntity target = JUtils.getUserIfStand(living);
            Vec3 kbVec = direction.m_82490_(0.75 * (double)scale + (double)(perfect ? 1 : 0));
            int stun = (int)(15.0f * scale);
            if (this.instant) {
                stun += 9;
            }
            Attacks.damageLogic(this.m_9236_(), target, kbVec, stun, 3, false, 7.0f * scale + (perfect ? 3.0f : 0.0f), true, (int)(13.0f * scale), this.m_9236_().m_269111_().m_269333_(this.livingOwner), (Entity)this.livingOwner, CommonHitPropertyComponent.HitAnimation.CRUSH, false, perfect);
        }
        if (hit) {
            Vec3 frontPos = pos.m_82549_(direction.m_82490_(2.5));
            JCraft.createParticle((ServerLevel)this.m_9236_(), frontPos.f_82479_ + this.f_19796_.m_188583_() * 0.25 * (double)scale, frontPos.f_82480_ + this.f_19796_.m_188583_() * 0.25 * (double)scale, frontPos.f_82481_ + this.f_19796_.m_188583_() * 0.25 * (double)scale, JParticleType.HIT_SPARK_2);
            if (perfect) {
                JComponentPlatformUtils.getShockwaveHandler(this.m_9236_()).addShockwave(frontPos, direction, 2.0f);
            }
        }
        this.m_5496_(SoundEvents.f_12520_, 1.0f, 1.0f);
    }

    public void detonate() {
        Vec3 direction = this.m_20184_().m_82541_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        float pitch = -this.m_146909_();
        float yaw = -this.m_146908_() + 180.0f;
        for (int set = 0; set < 3; ++set) {
            for (int i = 0; i < 3; ++i) {
                float pitchOffset;
                IcicleProjectile icicle = new IcicleProjectile(this.m_9236_(), this.livingOwner);
                float yawOffset = 10.0f * (float)(i - 1);
                float f = pitchOffset = i == 1 ? 10.0f : -10.0f;
                if (set % 2 == 0) {
                    pitchOffset = -pitchOffset;
                }
                icicle.m_7678_(x, y, z, yaw, pitch);
                JUtils.shoot((Projectile)icicle, null, pitch + pitchOffset, yaw + yawOffset, 0.0f, 0.5f + 0.5f / (float)(set + 1), 0.0f);
                this.m_9236_().m_7967_((Entity)icicle);
            }
            x += direction.f_82479_;
            y += direction.f_82480_;
            z += direction.f_82481_;
        }
        this.m_6074_();
        this.m_9236_().m_6263_(null, x, y, z, SoundEvents.f_11983_, SoundSource.NEUTRAL, 1.0f, 0.8f);
    }

    public void m_142036_() {
        super.m_142036_();
        if (((Boolean)this.f_19804_.m_135370_(IS_INSTANT)).booleanValue()) {
            return;
        }
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Vec3 velocity = this.m_20184_().m_82541_();
        for (int i = 0; i < 32; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ICE_PARTICLE : ParticleTypes.f_175821_), x, y, z, (velocity.f_82479_ + this.f_19796_.m_188583_()) * 0.5, (velocity.f_82480_ + this.f_19796_.m_188583_()) * 0.5, (velocity.f_82481_ + this.f_19796_.m_188583_()) * 0.5);
        }
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    private boolean cantAttack(LivingEntity living) {
        if (living == this.livingOwner) {
            return true;
        }
        return this.livingOwner != null && JComponentPlatformUtils.getStandComponent(this.livingOwner).getStand() == living;
    }

    protected void m_6532_(@NonNull HitResult hitResult) {
        if (hitResult == null) {
            throw new NullPointerException("hitResult is marked non-null but is null");
        }
        if (this.m_9236_().m_5776_() || !this.projectile) {
            return;
        }
        this.detonate();
    }

    protected float m_6882_() {
        return 1.0f;
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        tag.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.ticksInAir = tag.m_128448_("life");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<LargeIcicleProjectile> state) {
        return state.setAndContinue((Boolean)this.f_19804_.m_135370_(IS_INSTANT) != false ? FIRE_INSTANT : FIRE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

