/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JStatRegistry;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class LaserProjectile
extends AbstractArrow
implements GeoEntity {
    private int lifetime = 60;
    private final IntOpenHashSet hit = new IntOpenHashSet(8);
    private boolean unblockable = false;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public LaserProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.LASER_PROJECTILE.get(), world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public LaserProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.LASER_PROJECTILE.get(), owner, world);
        Player player;
        if (owner instanceof Player && !(player = (Player)owner).m_9236_().m_5776_()) {
            player.m_36220_((ResourceLocation)JStatRegistry.VAMPIRE_LASER.get());
        }
    }

    protected void m_6901_() {
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            Vec3 vel = this.m_20184_();
            if (this.f_19797_ == 1) {
                int i;
                for (i = 0; i < 20; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123815_, x, y, z, (vel.f_82479_ + this.f_19796_.m_188583_() * 0.5) * 0.2, (vel.f_82480_ + this.f_19796_.m_188583_() * 0.5) * 0.2, (vel.f_82481_ + this.f_19796_.m_188583_() * 0.5) * 0.2);
                }
                for (i = 0; i < 10; ++i) {
                    Vec3 frontVel = vel.m_82490_(this.f_19796_.m_188500_());
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123815_, x, y, z, frontVel.f_82479_, frontVel.f_82480_, frontVel.f_82481_);
                }
            } else {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, vel.f_82479_ / 2.0, vel.f_82480_ / 2.0, vel.f_82481_ / 2.0);
            }
        } else if (--this.lifetime < 1) {
            this.m_146870_();
        }
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (owner.m_20363_(entity) || entity == owner || this.hit.contains(entity.m_19879_())) {
            return;
        }
        JUtils.projectileDamageLogic((Projectile)this, this.m_9236_(), entity, this.m_20184_(), 20, 1, false, 5.0f, 0, CommonHitPropertyComponent.HitAnimation.CRUSH, this.unblockable, false);
        this.hit.add(entity.m_19879_());
    }

    protected float m_6882_() {
        return 1.0f;
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean m_20068_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setUnblockable(boolean unblockable) {
        this.unblockable = unblockable;
    }
}

