/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.List;
import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.projectile.JAttackEntity;
import net.arna.jcraft.common.util.IOwnable;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LifeDetectorEntity
extends JAttackEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> EXPLODED = SynchedEntityData.m_135353_(LifeDetectorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity target;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation EXPLODE = RawAnimation.begin().thenLoop("animation.detector.explode");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.detector.idle");

    public boolean hasExploded() {
        return (Boolean)this.f_19804_.m_135370_(EXPLODED);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EXPLODED, (Object)false);
    }

    public LifeDetectorEntity(Level world) {
        super((EntityType<? extends LivingEntity>)((EntityType)JEntityTypeRegistry.LIFE_DETECTOR.get()), world);
    }

    public boolean m_6779_(@Nullable LivingEntity target) {
        IOwnable ownable;
        if (target == null || this.master == null) {
            return false;
        }
        if (target == this || target == this.master) {
            return false;
        }
        if (target.m_20365_((Entity)this.master)) {
            return false;
        }
        if (target instanceof IOwnable && (ownable = (IOwnable)target).getMaster() == this.master) {
            return false;
        }
        return target.m_142066_() && target.m_6084_() && JUtils.canDamage(this.m_9236_().m_269111_().m_269333_(this.master), (Entity)target);
    }

    private void explode() {
        this.m_20334_(0.0, 0.0, 0.0);
        this.f_19864_ = true;
        Vec3 pos = this.m_20182_();
        Set<LivingEntity> hurt = JUtils.generateHitbox(this.m_9236_(), pos, 2.25, e -> true);
        for (LivingEntity living : hurt) {
            if (!this.m_6779_(living)) continue;
            LivingEntity target = JUtils.getUserIfStand(living);
            Vec3 kbVec = target.m_20182_().m_82546_(pos).m_82541_();
            Attacks.damageLogic(this.m_9236_(), target, kbVec, 10, 1, false, 5.0f, true, 9, this.m_9236_().m_269111_().m_269333_(this.master), (Entity)this.master, CommonHitPropertyComponent.HitAnimation.MID, false);
        }
        this.f_19804_.m_135381_(EXPLODED, (Object)true);
        this.m_5496_(SoundEvents.f_11874_, 1.0f, 1.0f);
        this.m_6074_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.master == null) {
            this.m_6074_();
        }
        if (this.hasExploded()) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
        } else {
            if (this.target == null) {
                if (this.f_19797_ % 2 == 0) {
                    LivingEntity finalTarget = null;
                    List targets = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(32.0), EntitySelector.f_20402_);
                    for (LivingEntity t : targets) {
                        if (!this.m_6779_(t)) continue;
                        if (finalTarget == null) {
                            finalTarget = t;
                            continue;
                        }
                        if (!(t.m_20182_().m_82557_(this.m_20182_()) < finalTarget.m_20182_().m_82557_(this.m_20182_()))) continue;
                        finalTarget = t;
                    }
                    this.target = finalTarget;
                }
            } else if (this.target.m_6084_()) {
                Vec3 eyePos = this.target.m_146892_();
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, eyePos);
                if (this.m_20238_(eyePos) < 2.5) {
                    this.explode();
                }
            } else {
                this.target = null;
            }
            if (!this.hasExploded() && (this.f_19797_ >= 300 || this.m_21223_() <= 0.0f)) {
                this.explode();
            }
            this.m_20256_(this.m_20184_().m_82549_(this.m_20154_().m_82490_(0.5)).m_82490_(0.25));
            this.f_19864_ = true;
        }
    }

    public boolean m_5825_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(@NonNull DamageSource source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return SoundEvents.f_12031_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12031_;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_7998_(@NonNull Entity entity, boolean force) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return false;
    }

    public static AttributeSupplier.Builder createDetectorAttributes() {
        return LifeDetectorEntity.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22266_(Attributes.f_22278_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22284_).m_22266_(Attributes.f_22285_);
    }

    @NonNull
    protected AABB m_142242_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double s = this.hasExploded() ? 0.1 : 0.5;
        return new AABB(x + s, y + s, z + s, x - s, y - s, z - s);
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        this.writeMasterNbt(tag);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.readMasterNbt(tag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        return state.setAndContinue(this.hasExploded() ? EXPLODE : IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

