/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.ArrayList;
import java.util.HashSet;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.MagiciansRedEntity;
import net.arna.jcraft.common.entity.stand.TheSunEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MeteorProjectile
extends AbstractArrow
implements GeoEntity {
    private static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.m_135353_(MeteorProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int ticksInAir = 0;
    private int ticksInGround = 0;
    @Nullable
    private final TheSunEntity sun;
    private boolean explosive = false;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation EXPLODE = RawAnimation.begin().thenPlayAndHold("animation.meteor.explode");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("animation.meteor.spawn").thenLoop("animation.meteor.idle");

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKIN, (Object)0);
    }

    public int getSkin() {
        return (Integer)this.f_19804_.m_135370_(SKIN);
    }

    public void setSkin(int skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public MeteorProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.METEOR.get(), world);
        this.sun = null;
    }

    public MeteorProjectile(Level world, LivingEntity owner, @Nullable TheSunEntity sun) {
        super((EntityType)JEntityTypeRegistry.METEOR.get(), owner, world);
        this.sun = sun;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected boolean m_20073_() {
        return false;
    }

    @NonNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_11874_;
    }

    public void setExplosive(boolean explosive) {
        this.explosive = explosive;
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (owner.m_20363_(entity) || entity == owner || entity == this.sun) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            this.f_36703_ = true;
            return;
        }
        entity.m_20254_(3);
        JUtils.projectileDamageLogic((Projectile)this, this.m_9236_(), entity, this.m_20184_(), 20, 1, false, 6.0f, 10, CommonHitPropertyComponent.HitAnimation.HIGH);
        if (this.explosive && this.ticksInGround < 1) {
            this.explode();
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            this.ticksInGround = 1;
        } else {
            this.m_146870_();
        }
    }

    protected void m_8060_(@NonNull BlockHitResult blockHitResult) {
        if (blockHitResult == null) {
            throw new NullPointerException("blockHitResult is marked non-null but is null");
        }
        if (!this.m_9236_().m_5776_()) {
            Direction movementDirection = this.m_6374_();
            BlockPos blockPos2 = this.m_20183_();
            if (BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)blockPos2, (Direction)movementDirection)) {
                BlockState blockState2 = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockPos2);
                this.m_9236_().m_7731_(blockPos2, blockState2, 11);
            }
            MagiciansRedEntity.ignite(this.m_9236_(), blockHitResult.m_82425_());
        }
        this.f_36703_ = true;
        super.m_8060_(blockHitResult);
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        tag.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.ticksInAir = tag.m_128448_("life");
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            Vec3 vel = this.m_20184_();
            this.m_9236_().m_7106_((ParticleOptions)(this.getSkin() == 2 ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), this.m_20185_() + (double)(this.f_19796_.m_188501_() * 0.5f) - 0.25, this.m_20186_() + (double)(this.f_19796_.m_188501_() * 0.5f) - 0.25, this.m_20189_() + (double)(this.f_19796_.m_188501_() * 0.5f) - 0.25, vel.f_82479_ / 2.0, vel.f_82480_ / 2.0, vel.f_82481_ / 2.0);
            if (this.f_36703_) {
                ++this.ticksInGround;
            }
        } else {
            if (this.f_36703_) {
                if (this.explosive && this.ticksInGround == 0) {
                    this.explode();
                }
                ++this.ticksInGround;
                if (!this.explosive || this.ticksInGround > 10) {
                    this.m_146870_();
                    return;
                }
            } else {
                ++this.ticksInAir;
                if (this.ticksInAir >= 600) {
                    this.m_146870_();
                    return;
                }
            }
            if (!(this.m_19749_() instanceof LivingEntity)) {
                this.m_146870_();
                return;
            }
            TheSunEntity.dryOut((ServerLevel)this.m_9236_(), this.m_20183_());
        }
    }

    private void explode() {
        Entity owner = this.m_19749_();
        HashSet<Entity> filter = new HashSet<Entity>();
        filter.add(owner);
        filter.add((Entity)this);
        ArrayList<LivingEntity> hurtAll = new ArrayList<LivingEntity>(JUtils.generateHitbox(this.m_9236_(), this.m_20182_(), 2.0, filter));
        hurtAll.removeIf(e -> !JUtils.canDamage(JDamageSources.create(this.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268468_), (Entity)e));
        if (!hurtAll.isEmpty()) {
            for (LivingEntity l : hurtAll) {
                LivingEntity target = JUtils.getUserIfStand(l);
                Attacks.damageLogic(this.m_9236_(), target, l.m_20182_().m_82546_(this.m_20182_()).m_82541_(), 20, 3, false, 5.0f, false, 10, JDamageSources.create(this.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268468_), owner, CommonHitPropertyComponent.HitAnimation.LAUNCH);
            }
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        if (this.f_36703_) {
            if (this.ticksInGround == 1) {
                state.getController().setAnimation(EXPLODE);
            }
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

