/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.SilverChariotEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RapierProjectile
extends AbstractArrow
implements GeoEntity {
    public static final ResourceLocation POSSESSED_TEXTURE = JCraft.id("textures/entity/stands/silver_chariot/rapier_possessed.png");
    public static final ResourceLocation ARMOR_OFF_TEXTURE = JCraft.id("textures/entity/stands/silver_chariot/rapier_no_armor.png");
    private static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.m_135353_(RapierProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private final StandEntity<?, ?> origin;
    private int ticksInAir;
    private int bouncesLeft = 5;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public RapierProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.RAPIER.get(), world);
        this.origin = null;
    }

    public RapierProjectile(Level world, LivingEntity owner, @NonNull StandEntity<?, ?> silverChariot) {
        super((EntityType)JEntityTypeRegistry.RAPIER.get(), owner, world);
        if (silverChariot == null) {
            throw new NullPointerException("silverChariot is marked non-null but is null");
        }
        this.origin = silverChariot;
    }

    public int getSkin() {
        return (Integer)this.f_19804_.m_135370_(SKIN);
    }

    public void setSkin(int skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKIN, (Object)0);
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.f_36703_) {
                Vec3 vel = this.m_20184_();
                for (double i = 0.0; i < 3.0; i += 1.0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, Mth.m_14139_((double)(i / 3.0), (double)this.m_20185_(), (double)this.f_19854_), Mth.m_14139_((double)(i / 3.0), (double)this.m_20186_(), (double)this.f_19855_), Mth.m_14139_((double)(i / 3.0), (double)this.m_20189_(), (double)this.f_19856_), vel.f_82479_, vel.f_82480_, vel.f_82481_);
                }
            }
        } else if (this.origin == null || !this.origin.m_6084_() || ++this.ticksInAir > 640) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (type == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (this.bouncesLeft-- > 0) {
                Vec3i normal = blockHitResult.m_82434_().m_122436_();
                this.m_5997_(normal.m_123341_(), normal.m_123342_(), normal.m_123343_());
            } else {
                this.m_8060_(blockHitResult);
                BlockPos blockPos = blockHitResult.m_82425_();
                this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockPos)));
            }
        }
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (owner.m_20363_(entity) || entity == owner) {
            return;
        }
        if (this.m_6060_()) {
            entity.m_20254_(5);
        }
        JUtils.projectileDamageLogic((Projectile)this, this.m_9236_(), entity, Vec3.f_82478_, 20, 1, false, 2.0f, 6, CommonHitPropertyComponent.HitAnimation.MID);
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
        this.m_146870_();
    }

    protected boolean m_142470_(@NonNull Player player) {
        StandEntity<?, ?> standEntity;
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (player != this.m_19749_() || !((standEntity = JUtils.getStand((LivingEntity)player)) instanceof SilverChariotEntity)) {
            return false;
        }
        SilverChariotEntity silverChariot = (SilverChariotEntity)standEntity;
        silverChariot.setHasRapier(true);
        return true;
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        tag.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.ticksInAir = tag.m_128448_("life");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

