/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.projectile.JAttackEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RedBindEntity
extends JAttackEntity
implements GeoEntity {
    private LivingEntity boundEntity;
    private float boundHealth;
    public static final int LIFE_TIME = 60;
    private int timeLeft = 60;
    private static final EntityDataAccessor<Boolean> EXPLODED = SynchedEntityData.m_135353_(RedBindEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> WIDTH = SynchedEntityData.m_135353_(RedBindEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.red_bind.idle");
    private static final RawAnimation EXPLODE = RawAnimation.begin().thenLoop("animation.red_bind.explode");

    public boolean hasExploded() {
        return (Boolean)this.f_19804_.m_135370_(EXPLODED);
    }

    public float getBoundWidth() {
        return ((Float)this.f_19804_.m_135370_(WIDTH)).floatValue();
    }

    public void setBoundEntity(@NonNull LivingEntity boundEntity) {
        if (boundEntity == null) {
            throw new NullPointerException("boundEntity is marked non-null but is null");
        }
        this.boundEntity = boundEntity;
        this.boundHealth = boundEntity.m_21223_();
        this.f_19804_.m_135381_(WIDTH, (Object)Float.valueOf((float)boundEntity.m_20191_().m_82309_()));
        this.m_7998_((Entity)boundEntity, true);
        boundEntity.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.STANDLESS.get(), this.timeLeft, 0, true, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EXPLODED, (Object)false);
        this.f_19804_.m_135372_(WIDTH, (Object)Float.valueOf(1.0f));
    }

    public RedBindEntity(Level world) {
        super((EntityType<? extends LivingEntity>)((EntityType)JEntityTypeRegistry.RED_BIND.get()), world);
    }

    public double m_6048_() {
        return -1.0;
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.boundEntity == null) {
                Entity entity = this.m_20202_();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    this.setBoundEntity(living);
                }
            } else if (!this.m_20159_() && !this.hasExploded()) {
                this.detonate();
            }
            if (this.boundEntity == null) {
                this.m_146870_();
            } else if (!this.hasExploded() && (--this.timeLeft <= 0 || this.boundEntity.m_21223_() < this.boundHealth)) {
                this.detonate();
            }
            if (this.boundEntity != null && this.boundEntity.m_21124_((MobEffect)JStatusRegistry.STANDLESS.get()) == null) {
                this.boundEntity.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.STANDLESS.get(), 2, 0, true, false));
            }
        }
        super.m_8119_();
    }

    private void detonate() {
        if (this.master != null) {
            Vec3 vel = this.boundEntity.m_20182_().m_82520_(0.0, 0.5, 0.0).m_82546_(this.master.m_20182_());
            Vec3 launch = vel.m_82541_().m_82490_(1.25);
            Attacks.damageLogic(this.boundEntity.m_9236_(), this.boundEntity, launch, 20, 3, true, 6.0f, false, 4, this.m_9236_().m_269111_().m_269333_(this.master), (Entity)this.master, CommonHitPropertyComponent.HitAnimation.MID, false, true);
        }
        this.f_19804_.m_135381_(EXPLODED, (Object)true);
        this.m_6074_();
    }

    public boolean m_5825_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(@NonNull DamageSource source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return SoundEvents.f_12031_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12031_;
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        this.writeMasterNbt(tag);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.readMasterNbt(tag);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<RedBindEntity> state) {
        return state.setAndContinue(this.hasExploded() ? EXPLODE : IDLE);
    }
}

