/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.projectile.JAttackEntity;
import net.arna.jcraft.common.util.IOwnable;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SandTornadoEntity
extends JAttackEntity
implements GeoEntity,
IOwnable {
    private static final EntityDataAccessor<Boolean> DISAPPEARED = SynchedEntityData.m_135353_(SandTornadoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int hitsLeft = 5;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sandtornado.idle");
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenLoop("animation.sandtornado.disappear");

    public SandTornadoEntity(Level world) {
        super((EntityType<? extends LivingEntity>)((EntityType)JEntityTypeRegistry.SAND_TORNADO.get()), world);
    }

    public boolean hasDisappeared() {
        return (Boolean)this.f_19804_.m_135370_(DISAPPEARED);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DISAPPEARED, (Object)false);
    }

    private void disappear() {
        this.f_19804_.m_135381_(DISAPPEARED, (Object)true);
        this.m_6074_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasDisappeared()) {
            if (this.f_20919_ > 26 || this.f_19797_ > 526) {
                this.m_146870_();
            }
            return;
        }
        Vec3 circulation = new Vec3((double)(Mth.m_14031_((float)((float)this.f_19797_ * 0.25f)) * 0.3f), 0.0, (double)(Mth.m_14089_((float)((float)this.f_19797_ * 0.25f)) * 0.3f));
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49992_.m_49966_()), this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)(this.f_19796_.m_188501_() * 2.0f), this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, circulation.f_82479_, 0.0, circulation.f_82481_);
            }
        } else if (this.f_19797_ % 5 == 0) {
            if (this.master == null) {
                if (this.m_6084_()) {
                    this.m_146870_();
                }
                return;
            }
            Set<LivingEntity> toHurt = JUtils.generateHitbox(this.m_9236_(), this.m_146892_(), 1.8, Set.of(this, this.master));
            if (toHurt.isEmpty()) {
                this.m_20256_(this.m_20184_().m_82549_(this.m_20154_().m_82490_(0.5)).m_82490_(0.4));
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.25));
                for (LivingEntity living : toHurt) {
                    LivingEntity target = JUtils.getUserIfStand(living);
                    if (target.m_20365_((Entity)this.master)) {
                        return;
                    }
                    Attacks.damageLogic(this.m_9236_(), target, circulation, 10, 1, false, 2.0f, true, 6, this.m_9236_().m_269111_().m_269333_(this.master), (Entity)this.master, CommonHitPropertyComponent.HitAnimation.MID, false);
                }
                --this.hitsLeft;
            }
            this.f_19864_ = true;
            if (this.hitsLeft < 1 || this.m_21223_() <= 0.0f || this.f_19797_ >= 500) {
                this.disappear();
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        return !damageSource.m_276093_(DamageTypes.f_268724_) && !damageSource.m_276093_(DamageTypes.f_286979_);
    }

    protected void m_7324_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
    }

    public void m_7334_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
    }

    public boolean m_7337_(@NonNull Entity other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(@NonNull DamageSource source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return SoundEvents.f_12335_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12331_;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_7998_(@NonNull Entity entity, boolean force) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return false;
    }

    public static AttributeSupplier.Builder createTornadoAttributes() {
        return SandTornadoEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22266_(Attributes.f_22278_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22284_).m_22266_(Attributes.f_22285_);
    }

    public void m_7380_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7380_(tag);
        this.writeMasterNbt(tag);
    }

    public void m_7378_(@NonNull CompoundTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        super.m_7378_(tag);
        this.readMasterNbt(tag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        return state.setAndContinue(this.hasDisappeared() ? DISAPPEAR : IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

