/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.tickable.MagneticFields;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ScalpelProjectile
extends AbstractArrow
implements GeoEntity {
    public static final float IRON_COST = 5.0f;
    private final IntOpenHashSet pierced = new IntOpenHashSet(4);
    private boolean tempNoGrav = false;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public ScalpelProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.SCALPEL.get(), world);
    }

    public ScalpelProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.SCALPEL.get(), owner, world);
    }

    public static ScalpelProjectile fromMetallica(MetallicaEntity metallica) {
        if (metallica.drainIron(5.0f)) {
            return new ScalpelProjectile(metallica.m_9236_(), metallica.getUserOrThrow());
        }
        return null;
    }

    public void setTempNoGrav() {
        this.tempNoGrav = true;
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.tempNoGrav) {
            if (this.f_19797_ > 3) {
                MagneticFields.MagneticField field;
                if (this.f_19797_ == 4 && (field = MagneticFields.nearestTo(this.m_20182_())) != null && field.pos.m_82557_(this.m_20182_()) < field.getStrength() * field.getStrength()) {
                    this.m_20256_(field.pos.m_82546_(this.m_20182_()).m_82541_().m_82490_(2.0));
                }
                if (this.m_20068_()) {
                    this.m_20242_(false);
                }
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.1));
            }
        }
        if (this.f_36704_ >= 300) {
            this.m_146870_();
        }
    }

    protected void m_8060_(@NonNull BlockHitResult result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        super.m_8060_(result);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.pierced.clear();
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof StandEntity) {
            StandEntity stand = (StandEntity)entity;
            entity = stand.getUser();
        }
        if (entity == null) {
            return;
        }
        if (this.pierced.contains(entity.m_19879_())) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner != null && owner.m_20363_(entity) || entity == owner) {
            return;
        }
        if (this.m_6060_()) {
            entity.m_20254_(5);
        }
        int blockstun = 4;
        int stunT = 10;
        JUtils.projectileDamageLogic((Projectile)this, this.m_9236_(), entity, Vec3.f_82478_, 10, 1, false, 2.0f, 4, CommonHitPropertyComponent.HitAnimation.MID);
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
        this.m_20256_(this.m_20184_().m_82490_(0.5));
        this.f_19864_ = true;
        this.pierced.add(entity.m_19879_());
    }

    protected boolean m_142470_(@NonNull Player player) {
        MetallicaEntity metallica;
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        StandEntity<?, ?> standEntity = JComponentPlatformUtils.getStandComponent((LivingEntity)player).getStand();
        if (standEntity instanceof MetallicaEntity && (metallica = (MetallicaEntity)standEntity).getIron() < 80.0f) {
            metallica.addIron(5.0f);
            return true;
        }
        return super.m_142470_(player);
    }

    @NonNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

