/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class StandArrowEntity
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public StandArrowEntity(Level level) {
        super((EntityType)JEntityTypeRegistry.STAND_ARROW_PROJECTILE.get(), level);
    }

    public StandArrowEntity(LivingEntity shooter, Level level) {
        super((EntityType)JEntityTypeRegistry.STAND_ARROW_PROJECTILE.get(), shooter, level);
    }

    @NonNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)JItemRegistry.STAND_ARROW.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void m_5790_(@NonNull EntityHitResult result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)entity;
            Level level = mob.m_9236_();
            if (level.m_5776_()) {
                return;
            }
            CommonStandComponent standData = JComponentPlatformUtils.getStandComponent(mob);
            if (standData.getType() == null && !mob.m_6095_().m_204039_(JTagRegistry.CAN_NEVER_HAVE_STAND)) {
                standData.setType(StandTypeUtil.getRandomRegular(this.f_19796_));
                mob.m_19877_();
                JCraft.summon(mob.m_9236_(), mob);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(-0.1));
                this.m_146922_(this.m_146908_() + 180.0f);
                this.f_19859_ += 180.0f;
            }
        }
    }
}

