/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.TheSunEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SunBeamProjectile
extends AbstractArrow
implements GeoEntity {
    private int length = 0;
    private static final int MAX_LENGTH = 64;
    @Nullable
    private final TheSunEntity sun;
    private DamageSource damageSource;
    public static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.m_135353_(SunBeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean allowRotation = true;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation FIRE = RawAnimation.begin().thenLoop("animation.sunbeam.fire");

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKIN, (Object)0);
    }

    public int getSkin() {
        return (Integer)this.f_19804_.m_135370_(SKIN);
    }

    public void setSkin(int skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public SunBeamProjectile(Level world, @Nullable LivingEntity owner, @Nullable TheSunEntity sun) {
        super((EntityType)JEntityTypeRegistry.SUN_BEAM.get(), world);
        this.m_5602_((Entity)owner);
        this.m_20242_(true);
        this.sun = sun;
        this.f_19811_ = true;
    }

    public void m_5602_(@Nullable Entity owner) {
        super.m_5602_(owner);
        this.damageSource = JDamageSources.create(this.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268566_, owner);
    }

    @NonNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_7334_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
    }

    public boolean m_7337_(@NonNull Entity other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_146926_(float xRot) {
        if (this.allowRotation) {
            super.m_146926_(xRot);
        }
    }

    public void m_146922_(float yRot) {
        if (this.allowRotation) {
            super.m_146922_(yRot);
        }
    }

    public void m_8119_() {
        this.allowRotation = false;
        super.m_8119_();
        if (this.sun != null) {
            this.m_146884_(this.m_20182_().m_82549_(JUtils.deltaPos((Entity)this.sun)));
        }
        Vec3 curPos = this.m_20182_();
        if (this.f_19797_ > 5 && this.f_19797_ <= 10) {
            this.length += 12;
        }
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ <= 20) {
                Vec3 velocity = this.m_20184_().m_82490_(this.f_19796_.m_188500_() * (double)this.length * 10.0);
                this.m_9236_().m_7106_((ParticleOptions)(this.getSkin() == 2 ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), curPos.f_82479_ + this.f_19796_.m_188583_() * 0.25, curPos.f_82480_ + this.f_19796_.m_188583_() * 0.25, curPos.f_82481_ + this.f_19796_.m_188583_() * 0.25, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
        } else if (this.f_19797_ <= 20) {
            Entity entity;
            if (this.f_19797_ % 3 == 0 && (entity = this.m_19749_()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                HashSet<Entity> filter = new HashSet<Entity>();
                filter.add((Entity)owner);
                filter.add((Entity)this.sun);
                filter.add((Entity)this);
                if (owner.m_20160_()) {
                    filter.addAll(owner.m_20197_());
                }
                Vec3 towardsVec = this.m_20184_().m_82541_();
                ArrayList<LivingEntity> hurtAll = new ArrayList<LivingEntity>();
                double hitboxSize = 2.0;
                for (double i = 0.0; i < (double)this.length / hitboxSize; i += 1.0) {
                    Vec3 laserPos = curPos.m_82549_(towardsVec.m_82490_(i * hitboxSize));
                    Set<LivingEntity> targets = JUtils.generateHitbox(this.m_9236_(), laserPos, hitboxSize, filter);
                    targets.removeIf(hurtAll::contains);
                    hurtAll.addAll(targets);
                    TheSunEntity.dryOut((ServerLevel)this.m_9236_(), BlockPos.m_274446_((Position)laserPos));
                }
                hurtAll.removeIf(e -> !JUtils.canDamage(this.damageSource, (Entity)e));
                if (!hurtAll.isEmpty()) {
                    for (LivingEntity l : hurtAll) {
                        LivingEntity target = JUtils.getUserIfStand(l);
                        int stun = 10;
                        Attacks.damageLogic(this.m_9236_(), target, Vec3.f_82478_, stun, 1, false, 1.0f, true, 2, this.damageSource, (Entity)owner, CommonHitPropertyComponent.HitAnimation.values()[this.f_19796_.m_188503_(3)]);
                    }
                    Vec3 hitPos = ((LivingEntity)hurtAll.get(0)).m_20182_();
                    JCraft.createParticle((ServerLevel)this.m_9236_(), hitPos.f_82479_ + this.f_19796_.m_188583_() * 0.25, hitPos.f_82480_ + this.f_19796_.m_188583_() * 0.25, hitPos.f_82481_ + this.f_19796_.m_188583_() * 0.25, JParticleType.HIT_SPARK_1);
                }
            }
        } else if (this.f_19797_ >= 24) {
            this.m_6074_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<SunBeamProjectile> state) {
        return state.setAndContinue(FIRE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

