/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.projectile;

import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.splatter.SplatterType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WSAcidProjectile
extends AbstractArrow
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> MYH = SynchedEntityData.m_135353_(WSAcidProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeOnSurface = 0;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation MELT_IDLE = RawAnimation.begin().thenLoop("animation.wsacid.meltidle");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.wsacid.idle");

    public WSAcidProjectile(Level world) {
        super((EntityType)JEntityTypeRegistry.WS_ACID_PROJECTILE.get(), world);
    }

    public WSAcidProjectile(Level world, LivingEntity owner) {
        super((EntityType)JEntityTypeRegistry.WS_ACID_PROJECTILE.get(), owner, world);
        this.m_36740_(SoundEvents.f_12390_);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.f_19811_ = true;
    }

    public void markMeltYourHeart() {
        this.f_19804_.m_135381_(MYH, (Object)true);
    }

    private void splat() {
        JUtils.getSplatterManager(this.m_9236_()).addSplatter(this.m_20182_(), SplatterType.ACID, 1.0f, this.m_19749_());
        this.m_146870_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MYH, (Object)false);
    }

    protected void m_5790_(@NonNull EntityHitResult entityHitResult) {
        if (entityHitResult == null) {
            throw new NullPointerException("entityHitResult is marked non-null but is null");
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        if (((Boolean)this.f_19804_.m_135370_(MYH)).booleanValue()) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (owner.m_20363_(entity) || entity == owner) {
            return;
        }
        if (entity instanceof LivingEntity) {
            StandEntity stand;
            LivingEntity living;
            LivingEntity target = living = (LivingEntity)entity;
            if (entity instanceof StandEntity && (stand = (StandEntity)entity).hasUser()) {
                target = stand.getUserOrThrow();
            }
            Attacks.damageLogic(this.m_9236_(), target, Vec3.f_82478_, 10, 1, false, 5.0f, false, 6, this.m_9236_().m_269111_().m_269390_((Entity)this, owner), owner, CommonHitPropertyComponent.HitAnimation.MID);
            target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.WSPOISON.get(), 60, 0, false, true));
            this.m_146870_();
        }
        if (entity instanceof EndCrystal) {
            EndCrystal endCrystal = (EndCrystal)entity;
            endCrystal.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, owner), 2.0f);
        }
        this.m_5496_(SoundEvents.f_11778_, 1.0f, 0.5f);
    }

    protected void m_6901_() {
        super.m_6901_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.timeOnSurface++ >= 100) {
            this.m_146870_();
        }
        this.splat();
    }

    public void m_8119_() {
        Entity owner = this.m_19749_();
        if (owner == null) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            return;
        }
        if (this.f_19803_) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            for (int h = 0; h < 128; ++h) {
                double pX = x + this.f_19796_.m_188500_() * 2.0 - 1.0;
                double pY = y + this.f_19796_.m_188500_() * 2.0 - 1.0;
                double pZ = z + this.f_19796_.m_188500_() * 2.0 - 1.0;
                Vec3 awayVector = this.m_20156_().m_82490_(0.3);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123764_, pX, pY, pZ, -awayVector.f_82479_, -awayVector.f_82480_, awayVector.f_82481_);
            }
        }
        super.m_8119_();
        if (!this.f_36703_) {
            Vec3 vel = this.m_20184_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123764_, this.m_20185_(), this.m_20186_(), this.m_20189_(), vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }

    @NonNull
    public ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean m_20068_() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        return state.setAndContinue((Boolean)this.f_19804_.m_135370_(MYH) != false ? MELT_IDLE : IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

