/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.Supplier;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.PoseModifierGroup;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.attack.moves.killerqueen.BombPlantAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.ExplosiveDashAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.KQDetonateAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractKillerQueenEntity<E extends AbstractKillerQueenEntity<E, S>, S extends Enum<S>>
extends StandEntity<E, S> {
    public static final Supplier<IPoseModifier> POSE = () -> PoseModifierGroup.builder().modifier(PoseModifierGroup.builder().condition(ModifierCondition.USER_NOT_MOVING).modifier(PoseModifiers.parse("leftArm.yRot += 15deg;\nleftArm.xRot -= 15deg;\nleftArm.zRot += 45deg;\n", ModifierCondition.LEFT_ARM_EMPTY)).modifier(PoseModifiers.parse("rightArm.yRot -= 15deg;\nrightArm.xRot -= 15deg;\nrightArm.zRot -= 45deg;\n", ModifierCondition.RIGHT_ARM_EMPTY)).build()).modifier(PoseModifiers.parse("body.xRot -= 5deg;\nleftLeg.z -= 1;\nrightLeg.z -= 1;\n", new ModifierCondition[0])).build();
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LOW = (SimpleAttack)((SimpleAttack)new SimpleAttack(0, 8, 13, 0.85f, 4.0f, 10, 1.5f, 0.25f, 0.1f).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"Low Punch"), (Component)Component.m_237113_((String)"frametrap tool, low stun"));
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 13, 0.8f, 3.0f, 20, 1.5f, 0.5f, 0.1f).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Second Punch"), (Component)Component.m_237113_((String)"frametrap tool"));
    public static final KQDetonateAttack DETONATE = (KQDetonateAttack)new KQDetonateAttack(20, 5, 6, 1.0f).withInfo((Component)Component.m_237113_((String)"Detonate"), (Component)Component.m_237113_((String)"tiny windup, move queueing is disabled while Detonate is active"));
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(25, 6, 10, 0.75f, 3.0f, 10, 1.5f, 0.25f, 0.1f).noLoopPrevention()).withImpactSound(JSoundRegistry.IMPACT_6)).withCrouchingVariant(DETONATE)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"combo starter, decent speed, has two followups"));
    public static final MainBarrageAttack<AbstractKillerQueenEntity<?, ?>> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(240, 0, 40, 0.75f, 1.0f, 20, 2.0f, 0.1f, 0.0f, 3, Blocks.f_152550_.m_155943_()).withSound(JSoundRegistry.KQ_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, medium stun"));
    public static final BombPlantAttack BOMB_PLANT = (BombPlantAttack)((BombPlantAttack)((BombPlantAttack)new BombPlantAttack(140, 12, 20, 1.0f, 9, 1.5f, 0.0f).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withBlockStun(8)).withInfo((Component)Component.m_237113_((String)"Bomb Plant"), (Component)Component.m_237113_((String)"crouch to plant on the ground below you, stealthily"));
    public static final ExplosiveDashAttack EXPLOSIVE_DASH = (ExplosiveDashAttack)new ExplosiveDashAttack(240).withInfo((Component)Component.m_237113_((String)"Explosive Dash"), (Component)Component.m_237113_((String)"instantly boosts the user in the aimed direction"));
    protected ItemEntity coin;

    protected AbstractKillerQueenEntity(StandType type, Level worldIn) {
        super(type, worldIn);
    }

    protected void detonate() {
        if (this.canAttack()) {
            this.setMove(DETONATE, this.getDetonateState());
            this.m_5496_((SoundEvent)JSoundRegistry.KQ_DETONATE.get(), 1.0f, 1.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean initMove(MoveClass moveClass) {
        LivingEntity user = this.getUserOrThrow();
        switch (moveClass) {
            case LIGHT: {
                boolean idling;
                boolean bl = idling = this.getMoveStun() <= 0;
                if (this.getCurrentMove() == null || this.getCurrentMove().getFollowup() == null) {
                    if (!idling) return true;
                    if (!user.m_6144_()) return super.initMove(MoveClass.LIGHT);
                    this.detonate();
                    return true;
                } else {
                    if (this.getMoveStun() >= this.getCurrentMove().getWindupPoint()) return true;
                    if (user.m_6144_()) {
                        this.detonate();
                        return true;
                    } else {
                        AbstractMove followup = this.getCurrentMove().getFollowup();
                        this.setMove(followup, followup.getAnimation());
                    }
                }
                return true;
            }
            case SPECIAL1: {
                CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(user);
                if (!user.m_6047_() || cooldowns.getCooldown(CooldownType.STAND_SP1) > 0) return this.handleMove(MoveClass.SPECIAL1);
                BlockPos standingOn = user.m_20183_().m_121945_(GravityChangerAPI.getGravityDirection((Entity)user));
                if (this.m_9236_().m_8055_(standingOn).m_60795_()) return true;
                JComponentPlatformUtils.getBombTracker(user).getMainBomb().setBomb(standingOn);
                cooldowns.setCooldown(CooldownType.STAND_SP1, BOMB_PLANT.getCooldown());
                return true;
            }
        }
        return super.initMove(moveClass);
    }

    @Override
    public void desummon() {
        if (this.coin != null) {
            this.coin.m_146870_();
        }
        super.desummon();
    }

    @Override
    public MoveSelectionResult specificMoveSelectionCriterion(AbstractMove<?, ? super E> attack, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        if (enemyStand != null && enemyStand.blocking) {
            return MoveSelectionResult.STOP;
        }
        return super.specificMoveSelectionCriterion(attack, mob, target, stunTicks, enemyMoveStun, distance, enemyStand, enemyAttack);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.hasUser() && this.getCurrentMove() instanceof KQDetonateAttack) {
            this.queuedMove = null;
        }
    }

    protected abstract S getDetonateState();
}

