/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.attack.moves.purplehaze.BackhandAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.FullReleaseAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.LaunchCapsuleAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.LaunchCapsulesAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.PHGroundSlamAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.PHRekkaAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractPurpleHazeEntity<E extends AbstractPurpleHazeEntity<E, S>, S extends Enum<S>>
extends StandEntity<E, S> {
    protected PoisonType poisonType = PoisonType.HARMING;
    public static final KnockdownAttack<AbstractPurpleHazeEntity<?, ?>> BACKHAND_FOLLOWUP = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 13, 20, 0.75f, 6.0f, 13, 1.75f, 0.5f, 0.35f, 25).withImpactSound(JSoundRegistry.IMPACT_2)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Hammerfist"), (Component)Component.m_237113_((String)"1s knockdown"));
    public static final BackhandAttack BACKHAND = (BackhandAttack)((BackhandAttack)((BackhandAttack)((BackhandAttack)((BackhandAttack)((BackhandAttack)new BackhandAttack(14, 6, 14, 0.75f, 6.0f, 20, 1.5f, 0.25f, -0.6f, 0.5f).withFollowup(BACKHAND_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_4)).withExtraHitBox(0.0, 0.35, 1.25)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Backhand"), (Component)Component.m_237113_((String)"launches vertically, infects (3s) on hit"));
    public static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 9, 20, 0.75f, 6.0f, 13, 1.6f, 1.25f, -0.1f).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Kick"), (Component)Component.m_237113_((String)"fast combo finisher"));
    public static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(9, 6, 9, 0.75f, 5.0f, 11, 1.5f, 0.25f, 0.1f).withImpactSound(JSoundRegistry.IMPACT_1)).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(BACKHAND)).noLoopPrevention()).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"fast combo starter"));
    public static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> HEAVY = (SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(20, 10, 20, 0.75f, 7.0f, 14, 2.0f, 1.25f, -0.1f).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Uppercut"), (Component)Component.m_237113_((String)"launcher"));
    public static final MainBarrageAttack<AbstractPurpleHazeEntity<?, ?>> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 40, 0.75f, 1.0f, 30, 2.0f, 0.25f, 0.0f, 3, Blocks.f_152550_.m_155943_()).withSound(JSoundRegistry.PH_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final LaunchCapsulesAttack LAUNCH_CAPSULES = (LaunchCapsulesAttack)((LaunchCapsulesAttack)new LaunchCapsulesAttack(120, 9, 18, 0.75f).withSound(JSoundRegistry.PH_CAPSULE2)).withInfo((Component)Component.m_237113_((String)"Triple Capsule Launch"), (Component)Component.m_237113_((String)"launches 3 capsules close by"));
    public static final LaunchCapsuleAttack LAUNCH_CAPSULE = (LaunchCapsuleAttack)((LaunchCapsuleAttack)((LaunchCapsuleAttack)new LaunchCapsuleAttack(120, 7, 14, 0.75f).withSound(JSoundRegistry.PH_CAPSULE1)).withCrouchingVariant(LAUNCH_CAPSULES)).withInfo((Component)Component.m_237113_((String)"Capsule Launch"), (Component)Component.m_237113_((String)"launches a single, fast capsule at the aimed location"));
    public static final FullReleaseAttack FULL_RELEASE = (FullReleaseAttack)((FullReleaseAttack)((FullReleaseAttack)((FullReleaseAttack)((FullReleaseAttack)new FullReleaseAttack(600, 30, 0.75f, 3.0f, 11, 1.75f, 0.45f, 0.2f, (IntCollection)IntSet.of((int)14, (int)24)).withSound(JSoundRegistry.PH_ULTIMATE)).withHitSpark(JParticleType.HIT_SPARK_1)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withHyperArmor()).withInfo((Component)Component.m_237113_((String)"Full Release"), (Component)Component.m_237113_((String)"launches 2 sets of 3 capsules in a hexagonal pattern, uninterruptable"));
    public static final KnockdownAttack<AbstractPurpleHazeEntity<?, ?>> REKKA3 = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 10, 20, 1.0f, 5.0f, 15, 2.0f, 0.75f, 0.3f, 55).withSound(JSoundRegistry.PH_REKKA3)).withLaunch()).withImpactSound(JSoundRegistry.IMPACT_1)).withBlockStun(8)).withInfo((Component)Component.m_237113_((String)"Rekka (Final Hit)"), (Component)Component.m_237113_((String)"knockdown, low blockstun"));
    public static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> REKKA2 = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 9, 18, 1.0f, 4.0f, 16, 1.75f, 0.5f, 0.0f).withSound(JSoundRegistry.PH_REKKA2)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Rekka (2nd Hit)"), (Component)Component.m_237113_((String)"links into Light"));
    public static final PHRekkaAttack REKKA1 = (PHRekkaAttack)((PHRekkaAttack)((PHRekkaAttack)((PHRekkaAttack)((PHRekkaAttack)((PHRekkaAttack)new PHRekkaAttack(100, 7, 14, 1.0f, 4.0f, 15, 1.5f, 0.5f, 0.0f).withSound(JSoundRegistry.PH_REKKA1)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(1.5)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withMobilityType(MobilityType.DASH)).withInfo((Component)Component.m_237113_((String)"Rekka Series"), (Component)Component.m_237113_((String)"A set of three attacks, which cancel into each other during recovery.\nLast hit knocks down for 2.5s"));
    public static final PHGroundSlamAttack GROUND_SLAM = (PHGroundSlamAttack)((PHGroundSlamAttack)((PHGroundSlamAttack)((PHGroundSlamAttack)((PHGroundSlamAttack)new PHGroundSlamAttack(120, 10, 18, 0.75f, 6.0f, 10, 1.75f, 0.3f, 0.3f).withSound(JSoundRegistry.PH_GROUNDSLAM)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withInfo((Component)Component.m_237113_((String)"Ground Slam"), (Component)Component.m_237113_((String)"places down a Purple Haze cloud"));

    protected AbstractPurpleHazeEntity(StandType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        if (moveClass == MoveClass.SPECIAL2) {
            boolean idling;
            LivingEntity user = this.getUserOrThrow();
            if (user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
                return false;
            }
            AbstractMove move = this.getCurrentMove();
            boolean bl = idling = this.getMoveStun() <= 0;
            if (move == null || move.getMoveClass() != MoveClass.SPECIAL2) {
                if (idling) {
                    return this.handleMove(MoveClass.SPECIAL2);
                }
                return false;
            }
            if (move.getFollowup() != null && move.hasWindupPassed(this)) {
                this.setMove(move.getFollowup(), move.getFollowup().getAnimation());
            }
            return true;
        }
        return super.handleMove(moveClass);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isRemoteAndControllable()) {
            return;
        }
        if (this.m_9236_().m_5776_()) {
            JCraft.getClientEntityHandler().purpleHazeRemoteClientTick(this);
        } else {
            double f = this.getRemoteForwardInput();
            double s = this.getRemoteSideInput();
            boolean jump = this.getRemoteJumpInput();
            this.tickRemoteMovement(f, s, jump);
            this.tickRemoteState(f, s, this.m_20096_());
        }
    }

    public void nextPoisonType() {
        int next = this.poisonType.ordinal() + 1;
        this.poisonType = PoisonType.values()[next % PoisonType.values().length];
    }

    protected abstract void tickRemoteState(double var1, double var3, boolean var5);

    public void tickRemoteMovement(double f, double s, boolean jump) {
        boolean swimming;
        Vec3 pos = this.m_20182_();
        if (this.lastRemoteInputTime - this.f_19797_ > 2) {
            this.updateRemoteInputs(0, 0, false, false);
        }
        Vec3 rotVec = this.m_20154_();
        double dragMult = this.getMoveStun() > 0 ? 0.2 : 0.4;
        double moveSpeed = 0.24;
        boolean onGround = this.m_20096_();
        boolean climbing = this.m_146900_().m_204343_().anyMatch(tag -> tag == BlockTags.f_13082_);
        boolean bl = swimming = !this.m_9236_().m_6425_(this.m_20183_()).m_76178_();
        if (climbing || swimming) {
            dragMult *= 0.5;
        }
        if ((climbing || swimming) && jump) {
            this.m_5997_(0.0, 0.1, 0.0);
        } else if (onGround) {
            if (jump) {
                this.m_5997_(0.0, 0.75, 0.0);
                this.setRemoteJumpInput(false);
            }
        } else {
            moveSpeed = 0.024;
            dragMult = 0.4;
        }
        this.remoteSpeed = this.remoteSpeed.m_82549_(rotVec.m_82490_(f * moveSpeed)).m_82549_(rotVec.m_82524_(1.5707963f).m_82490_(s * moveSpeed));
        this.remoteSpeed = this.remoteSpeed.m_82490_(dragMult);
        Vec3 userPos = this.getUserOrThrow().m_20182_();
        if (pos.m_82549_(this.remoteSpeed).m_82557_(userPos) > 25.0) {
            this.remoteSpeed = userPos.m_82546_(pos).m_82490_(0.05);
        }
        this.m_5997_(this.remoteSpeed.f_82479_, this.remoteSpeed.f_82480_, this.remoteSpeed.f_82481_);
        this.f_19812_ = true;
        this.f_19864_ = true;
    }

    public static void infect(LivingEntity target, int ticks) {
        AbstractPurpleHazeEntity.infect(target, ticks, (MobEffect)JStatusRegistry.PHPOISON.get());
    }

    public static void infect(LivingEntity target, int ticks, MobEffect effect) {
        MobEffectInstance instance = target.m_21124_(effect);
        if (instance != null) {
            target.m_7292_(new MobEffectInstance(effect, instance.m_19557_() + ticks, 2));
        } else {
            target.m_7292_(new MobEffectInstance(effect, ticks, 2));
        }
    }

    public PoisonType getPoisonType() {
        return this.poisonType;
    }

    public static enum PoisonType {
        HARMING,
        NULLIFYING,
        DEBILITATING;

    }
}

