/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonGravityShiftComponent;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.CMoonInversionAction;
import net.arna.jcraft.common.attack.moves.cmoon.CGroundSlamAttack;
import net.arna.jcraft.common.attack.moves.cmoon.GravPunchAttack;
import net.arna.jcraft.common.attack.moves.cmoon.GravitationalHopMove;
import net.arna.jcraft.common.attack.moves.cmoon.GravityShiftMove;
import net.arna.jcraft.common.attack.moves.cmoon.GravityShiftPulseMove;
import net.arna.jcraft.common.attack.moves.cmoon.LaunchAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.entity.projectile.BlockProjectile;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.joml.Vector3f;

public class CMoonEntity
extends StandEntity<CMoonEntity, State> {
    public static final MoveSet<CMoonEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.C_MOON, CMoonEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(220.0f).evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.cmoon")).proCount(4).conCount(2).freeSpace((Component)Component.m_237113_((String)"Passive: Inversion, all physical hits deal an extra half heart after 2s\n\n    BNBs:\n    -going up?\n    Light>Barrage>jump>Block Launch>Light>Only One Punch>Block Launch (Projectile Hit)>...\n        ...Grav. Hop>Ground Slam\n        ...Gut Punch")).skinName((Component)Component.m_237113_((String)"Inversion")).skinName((Component)Component.m_237113_((String)"Gravity")).skinName((Component)Component.m_237113_((String)"Rose")).build()).summonData(SummonData.of(JSoundRegistry.CMOON_SUMMON)).build();
    public static final int GRAVITY_CHANGE_DURATION = 600;
    public static final SimpleAttack<CMoonEntity> INVERSION_PUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(0, 12, 0.75f, 5.0f, 9, 0.5f, -0.1f).withAnim(State.INVERSION_PUNCH)).withImpactSound(JSoundRegistry.IMPACT_1)).withAction(CMoonInversionAction.addInversion(70, 0.5f, true))).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Inversion Punch"), (Component)Component.m_237113_((String)"very low stun, delayed slowness"));
    public static final SimpleAttack<CMoonEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 12, 0.75f, 6.0f, 7, 1.5f, 1.0f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withAction(CMoonInversionAction.addInversion(40, 0.5f, false))).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<CMoonEntity> PUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(5, 7, 0.75f, 5.0f, 10, 0.2f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(INVERSION_PUNCH)).withImpactSound(JSoundRegistry.IMPACT_1)).withAction(CMoonInversionAction.addInversion(40, 0.5f, false))).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final MainBarrageAttack<CMoonEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 40, 0.75f, 0.75f, 20, 2.0f, 0.25f, 0.0f, 4, Blocks.f_50080_.m_155943_()).withSound(JSoundRegistry.CMOON_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_3)).withAction(CMoonInversionAction.addInversion(40, 0.25f, false))).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, medium stun"));
    public static final SimpleAttack<CMoonEntity> GUT_PUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(30, 19, 30, 1.0f, 8.0f, 10, 2.0f, 1.5f, 0.0f).withSound(JSoundRegistry.CMOON_DONUT)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withAction(CMoonInversionAction.addInversion(40, 0.5f, false))).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withExtraHitBox(0.0, 0.25, 1.25)).withInfo((Component)Component.m_237113_((String)"Gut Punch"), (Component)Component.m_237113_((String)"slow, uninterruptible combo finisher"));
    public static final LaunchAttack LAUNCH = (LaunchAttack)((LaunchAttack)((LaunchAttack)((LaunchAttack)((LaunchAttack)new LaunchAttack(60, 14, 21, 0.75f, 5.0f, 19, 1.75f, 0.9f, 0.3f).withSound(JSoundRegistry.CMOON_GROUNDSHOOT)).withImpactSound(JSoundRegistry.IMPACT_5)).withAction(CMoonInversionAction.addInversion(40, 0.5f, false))).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withInfo((Component)Component.m_237113_((String)"Block Launch"), (Component)Component.m_237113_((String)"lifts a block from the ground and launches it at a delay/crouching and using this button resets the delay on nearby blocks"));
    public static final GravPunchAttack GRAV_PUNCH = (GravPunchAttack)((GravPunchAttack)((GravPunchAttack)((GravPunchAttack)((GravPunchAttack)((GravPunchAttack)((GravPunchAttack)new GravPunchAttack(300, 20, 32, 1.0f, 8.0f, 45, 1.75f, 0.35f, -0.3f).withSound(JSoundRegistry.CMOON_GRAV_PUNCH)).withImpactSound(JSoundRegistry.CMOON_GRAV_PUNCH_HIT)).withAction(CMoonInversionAction.addInversion(40, 0.5f, false))).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withExtraHitBox(1.0)).withInfo((Component)Component.m_237113_((String)"Only One Punch"), (Component)Component.m_237113_((String)"inverts enemy gravity and floats on hit (3s), high stun"));
    public static final CGroundSlamAttack GROUND_SLAM = (CGroundSlamAttack)((CGroundSlamAttack)((CGroundSlamAttack)((CGroundSlamAttack)((CGroundSlamAttack)((CGroundSlamAttack)((CGroundSlamAttack)new CGroundSlamAttack(18, 10, 18, 1.0f, 7.0f, 17, 3.0f, 0.2f, 1.4f).withSound(JSoundRegistry.CMOON_GROUNDSLAM)).withImpactSound(JSoundRegistry.IMPACT_10)).withAction(CMoonInversionAction.addInversion(40, 0.5f, false))).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withHitSpark(JParticleType.HIT_SPARK_2)).withStaticY()).withInfo((Component)Component.m_237113_((String)"Ground Slam"), (Component)Component.m_237113_((String)"launches downwards, combo starter/extender, knocks down if it hits while user is crouching"));
    public static final GravityShiftMove GRAV_SHIFT = (GravityShiftMove)((GravityShiftMove)new GravityShiftMove(1400, 20, 32, 1.0f).withSound(JSoundRegistry.CMOON_GRAVSHIFT)).withInfo((Component)Component.m_237113_((String)"Gravity Shift Radial"), (Component)Component.m_237113_((String)"repulses or attracts entities within 64m\nlasts 10 seconds\nswap between attraction/repulsion by pressing ultimate again"));
    public static final GravityShiftPulseMove GRAV_SHIFT_PULSE = (GravityShiftPulseMove)((GravityShiftPulseMove)((GravityShiftPulseMove)new GravityShiftPulseMove(1400, 20, 32, 1.0f).withCrouchingVariant(GRAV_SHIFT)).withSound(JSoundRegistry.CMOON_GRAVSHIFT_DIRECTIONAL)).withInfo((Component)Component.m_237113_((String)"Gravity Shift Directional"), (Component)Component.m_237113_((String)"changes the gravitational direction of entities within 16m to the direction the user is looking in\nlasts 30 seconds\nall affected entities cannot take fall damage\naffected entities lose the gravity shift if they move 100m away from the user\n"));
    public static final GravitationalHopMove GRAVITATIONAL_HOP = (GravitationalHopMove)new GravitationalHopMove(340, 200, 60).withInfo((Component)Component.m_237113_((String)"Gravitational Hop/Local Gravity Change"), (Component)Component.m_237113_((String)"if used mid air, jumps up and grants 2s slow falling/otherwise changes your gravitational direction"));
    private final List<Inversion> inversions = new ArrayList<Inversion>();

    public CMoonEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.C_MOON.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.4f, 1.0f, 0.6f), new Vector3f(1.0f, 0.4f, 0.6f), new Vector3f(0.4f, 0.8f, 1.0f), new Vector3f(1.0f, 0.2f, 0.6f)};
    }

    public void addInversion(LivingEntity target, int time, float damage, boolean slow) {
        this.inversions.add(new Inversion(time, damage, target, slow));
    }

    private static void registerMoves(MoveMap<CMoonEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, PUNCH, State.LIGHT);
        moves.register(MoveClass.HEAVY, GUT_PUNCH, State.DONUT);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, GRAV_PUNCH, State.GRAV_PUNCH);
        moves.register(MoveClass.SPECIAL2, LAUNCH, State.GROUND_SHOOT);
        moves.register(MoveClass.SPECIAL3, GROUND_SLAM, State.GROUND_SLAM);
        moves.register(MoveClass.ULTIMATE, GRAV_SHIFT_PULSE, State.DIRECTIONAL_SHIFT).withCrouchingVariant(State.GRAV_SHIFT);
        moves.register(MoveClass.UTILITY, GRAVITATIONAL_HOP);
    }

    @Override
    public boolean shouldOffsetHeight() {
        State state = (State)this.getState();
        if (state == State.GROUND_SLAM || state == State.GROUND_SHOOT) {
            return false;
        }
        return super.shouldOffsetHeight();
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        switch (moveClass) {
            case SPECIAL2: {
                if (!this.hasUser() || !this.getUserOrThrow().m_6144_()) {
                    return super.initMove(moveClass);
                }
                this.m_9236_().m_6443_(BlockProjectile.class, this.m_20191_().m_82400_(16.0), p -> p.m_6084_() && p.getMaster() == this.getUser()).forEach(BlockProjectile::markRefresh);
                return true;
            }
            case ULTIMATE: {
                CommonGravityShiftComponent shiftComponent = JComponentPlatformUtils.getGravityShift(this.getUserOrThrow());
                if (!shiftComponent.isActive()) {
                    return super.initMove(moveClass);
                }
                shiftComponent.swapRadialType();
                return true;
            }
            case LIGHT: {
                if (!this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
                    return super.initMove(moveClass);
                }
                return true;
            }
        }
        return super.initMove(moveClass);
    }

    @Override
    public void standBlock() {
        LivingEntity user = this.getUser();
        if (user == null) {
            return;
        }
        List toDeflect = this.m_9236_().m_6443_(Projectile.class, this.m_20191_().m_82400_(0.75), EntitySelector.f_20402_);
        for (Projectile projectile : toDeflect) {
            if (projectile.m_19749_() == user) continue;
            projectile.m_20256_(projectile.m_20182_().m_82546_(this.m_20182_()).m_82541_());
            projectile.f_19864_ = true;
        }
        JCraft.stun(user, 2, 2);
        user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, 2, false, false));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        LivingEntity user = this.getUserOrThrow();
        for (int i = 0; i < this.inversions.size(); ++i) {
            Inversion inversion = this.inversions.get(i);
            int time = inversion.getTime();
            inversion.setTime(time - 1);
            if (time >= 1) continue;
            LivingEntity entity = inversion.getEntity();
            Attacks.damage((Entity)this, inversion.getDamage(), this.m_9236_().m_269111_().m_269333_(user), entity);
            this.inversions.remove(i);
            if (inversion.doSlow) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1, true, false));
            }
            --i;
        }
    }

    @Override
    @NonNull
    public CMoonEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    protected String getSummonAnimation() {
        return "animation.cmoon.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    private static class Inversion {
        private int time;
        private float damage;
        private LivingEntity entity;
        private boolean doSlow = false;

        private Inversion(int time, float damage, LivingEntity entity) {
            this.time = time;
            this.damage = damage;
            this.entity = entity;
        }

        private Inversion(int time, float damage, LivingEntity entity, boolean doSlow) {
            this.time = time;
            this.damage = damage;
            this.entity = entity;
            this.doSlow = doSlow;
        }

        public int getTime() {
            return this.time;
        }

        public float getDamage() {
            return this.damage;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public boolean isDoSlow() {
            return this.doSlow;
        }

        public void setTime(int time) {
            this.time = time;
        }

        public void setDamage(float damage) {
            this.damage = damage;
        }

        public void setEntity(LivingEntity entity) {
            this.entity = entity;
        }

        public void setDoSlow(boolean doSlow) {
            this.doSlow = doSlow;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Inversion)) {
                return false;
            }
            Inversion other = (Inversion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            if (Float.compare(this.getDamage(), other.getDamage()) != 0) {
                return false;
            }
            if (this.isDoSlow() != other.isDoSlow()) {
                return false;
            }
            LivingEntity this$entity = this.getEntity();
            LivingEntity other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Inversion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTime();
            result = result * 59 + Float.floatToIntBits(this.getDamage());
            result = result * 59 + (this.isDoSlow() ? 79 : 97);
            LivingEntity $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            return result;
        }

        public String toString() {
            return "CMoonEntity.Inversion(time=" + this.getTime() + ", damage=" + this.getDamage() + ", entity=" + String.valueOf(this.getEntity()) + ", doSlow=" + this.isDoSlow() + ")";
        }
    }

    public static enum State implements StandAnimationState<CMoonEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cmoon.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cmoon.block"))),
        DONUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.donut"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cmoon.barrage"))),
        GRAV_PUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.gravpunch"))),
        GROUND_SLAM(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.groundslam"))),
        GROUND_SHOOT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.groundshoot"))),
        GRAV_SHIFT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.gravshift"))),
        DIRECTIONAL_SHIFT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.directionalshift"))),
        INVERSION_PUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.inversionpunch"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cmoon.light_followup")));

        private final Consumer<AnimationState<CMoonEntity>> animator;

        private State(Consumer<AnimationState<CMoonEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(CMoonEntity attacker, AnimationState<CMoonEntity> state) {
            this.animator.accept(state);
        }
    }
}

