/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CinderellaEntity
extends StandEntity<CinderellaEntity, State> {
    public static final MoveSet<CinderellaEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.CINDERELLA, CinderellaEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.of(StandInfo.of((Component)Component.m_237115_((String)"entity.jcraft.cinderella"))).withObtainable(false);
    public static final SimpleAttack<CinderellaEntity> LIGHT = (SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(7, 11, 0.75f, 4.0f, 11, 0.15f, 0.2f).withImpactSound(JSoundRegistry.IMPACT_2)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));

    public CinderellaEntity(Level world) {
        super((StandType)JStandTypeRegistry.CINDERELLA.get(), world);
    }

    private static void registerMoves(MoveMap<CinderellaEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.hasUser() || JUtils.getStand(this.getUserOrThrow()) != this || this.getUserOrThrow().m_146895_() != this) {
            this.m_146870_();
        }
    }

    @Override
    @NonNull
    public CinderellaEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.cinderella.summon";
    }

    public static enum State implements StandAnimationState<CinderellaEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cinderella.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cinderella.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cinderella.block")));

        private final Consumer<AnimationState<CinderellaEntity>> animator;

        private State(Consumer<AnimationState<CinderellaEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(CinderellaEntity attacker, AnimationState<CinderellaEntity> state) {
            this.animator.accept(state);
        }
    }
}

