/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.EffectAction;
import net.arna.jcraft.common.attack.moves.cream.AbstractSurpriseMove;
import net.arna.jcraft.common.attack.moves.cream.BallChargeAttack;
import net.arna.jcraft.common.attack.moves.cream.BallModeEnterMove;
import net.arna.jcraft.common.attack.moves.cream.BallModeExitMove;
import net.arna.jcraft.common.attack.moves.cream.ConsumeAttack;
import net.arna.jcraft.common.attack.moves.cream.CreamComboAttack;
import net.arna.jcraft.common.attack.moves.cream.DestroyAttack;
import net.arna.jcraft.common.attack.moves.cream.DetachChargeMove;
import net.arna.jcraft.common.attack.moves.cream.SurpriseMove;
import net.arna.jcraft.common.attack.moves.shared.ChargeBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CreamEntity
extends StandEntity<CreamEntity, State> {
    public static final MoveSet<CreamEntity, State> DEFAULT_MOVE_SET = MoveSetManager.create(JStandTypeRegistry.CREAM, CreamEntity::registerDefaultMoves, State.class);
    public static final MoveSet<CreamEntity, State> HALF_BALL_MOVE_SET = MoveSetManager.create(JStandTypeRegistry.CREAM, "half_ball", CreamEntity::registerHalfBallMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(220.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.cream")).proCount(4).conCount(3).freeSpace((Component)Component.m_237113_((String)"BNBs (i. - in Cream):\n    Light>Assault>Light>Grab\n    i.Light>land+s.OFF>s.ON+Assault>Light>Charge>Grab\n    Chop>Destroy>Surprise\n    Chop>Void")).skinName((Component)Component.m_237113_((String)"Menace")).skinName((Component)Component.m_237113_((String)"Eraser")).skinName((Component)Component.m_237113_((String)"White Void")).build()).summonData(SummonData.of(JSoundRegistry.CREAM_SUMMON)).build();
    public static final SimpleAttack<CreamEntity> BITE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 13, 0.75f, 6.0f, 20, 1.75f, 0.75f, 0.3f).withAction(EffectAction.inflict(MobEffects.f_19597_, 40, 1))).withAnim(State.BITE)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withSound(SoundEvents.f_11865_)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Bite"), (Component)Component.m_237113_((String)"applies Slowness II (2s) on hit"));
    public static final SimpleAttack<CreamEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 14, 0.75f, 6.0f, 8, 1.75f, 1.1f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_3)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Chop"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<CreamEntity> PUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(6, 14, 0.75f, 5.0f, 20, 0.3f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(BITE)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Backhand"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleAttack<CreamEntity> VERTICAL_CHOP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(30, 20, 30, 1.0f, 8.0f, 40, 1.5f, 0.8f, 0.0f).withSound(JSoundRegistry.CREAM_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_3)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Vertical Chop"), (Component)Component.m_237113_((String)"slow, uninterruptible combo starter"));
    public static final CreamComboAttack COMBO = (CreamComboAttack)((CreamComboAttack)((CreamComboAttack)((CreamComboAttack)new CreamComboAttack(0, 36, 0.75f, 5.0f, 20, 2.0f, 0.2f, 0.0f, (IntCollection)IntSet.of((int)10, (int)17, (int)25)).withSound(JSoundRegistry.CREAM_COMBO)).withImpactSound(JSoundRegistry.IMPACT_3)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Assault"), (Component)Component.m_237113_((String)"medium windup, good stun"));
    public static final SimpleAttack<CreamEntity> GRAB_HIT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 13, 20, 1.0f, 6.0f, 5, 2.0f, 1.5f, 0.0f).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Grab (Hit)"), (Component)Component.m_237119_());
    public static final GrabAttack<CreamEntity, State> GRAB = (GrabAttack)((GrabAttack)new GrabAttack(280, 8, 20, 1.0f, 3.0f, 30, 1.5f, 0.0f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT)).withSound(JSoundRegistry.CREAM_GRAB)).withInfo((Component)Component.m_237113_((String)"Grab"), (Component)Component.m_237113_((String)"unblockable, knocks back"));
    public static final SurpriseMove SURPRISE = (SurpriseMove)((SurpriseMove)new SurpriseMove(100, 14, 24, 1.0f).withSound(JSoundRegistry.CREAM_SUMMON)).withInfo((Component)Component.m_237113_((String)"Surprise"), (Component)Component.m_237113_((String)"Cream disappears into the ground, then pops out in a nearby looked location.\nIf used while crouching, Cream appears in front of the user.\n"));
    public static final ChargeBarrageAttack<CreamEntity> CHARGE = (ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)new ChargeBarrageAttack(100, 15, 30, 4.0f, 2.0f, 10, 1.5f, 0.5f, 0.0f, 3, false).withAction(EffectAction.inflict(JStatusRegistry.KNOCKDOWN, 25, 0, true, false))).withLaunchNoShockwave()).withImpactSound(JSoundRegistry.IMPACT_5)).withBlockableType(BlockableType.NON_BLOCKABLE)).withInfo((Component)Component.m_237113_((String)"Charge"), (Component)Component.m_237113_((String)"4 block range, unblockable knockdown"));
    public static final DestroyAttack DESTROY = (DestroyAttack)((DestroyAttack)((DestroyAttack)((DestroyAttack)((DestroyAttack)((DestroyAttack)((DestroyAttack)new DestroyAttack(100, 21, 30, 1.0f, 8.0f, 5, 2.0f, 1.25f, 0.0f, 35).withCrouchingVariant(CHARGE)).withSound(JSoundRegistry.CREAM_OVERHEAD)).withImpactSound(JSoundRegistry.IMPACT_5)).withLaunch()).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE)).withInfo((Component)Component.m_237113_((String)"Destroy"), (Component)Component.m_237113_((String)"slow, uninterruptible, unblockable knockdown"));
    public static final ConsumeAttack CONSUME = (ConsumeAttack)((ConsumeAttack)new ConsumeAttack(640, 35, 40, 1.0f, 2.0f, 0, 2.0f, 0.0f, 0.0f).withSound(JSoundRegistry.CREAM_CONSUME)).withInfo((Component)Component.m_237113_((String)"Void"), (Component)Component.m_237113_((String)"high windup, 6 seconds"));
    public static final BallModeEnterMove ENTER = (BallModeEnterMove)((BallModeEnterMove)new BallModeEnterMove(40, 10, 15, 0.0f).withSound(JSoundRegistry.CREAM_ENTER)).withInfo((Component)Component.m_237113_((String)"Enter Cream"), (Component)Component.m_237113_((String)"Cream consumes itself and the user halfway, increasing mobility and decreasing defense"));
    public static final BallModeExitMove EXIT = (BallModeExitMove)((BallModeExitMove)new BallModeExitMove(40, 5, 15, 0.0f).withSound(JSoundRegistry.CREAM_EXIT)).withInfo((Component)Component.m_237113_((String)"Exit Cream"), (Component)Component.m_237113_((String)"Cream and its user return from the void"));
    public static final SimpleAttack<CreamEntity> SWIPE = (SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 14, 0.5f, 5.0f, 20, 2.0f, 0.75f, 0.2f).withImpactSound(JSoundRegistry.IMPACT_3)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Swipe"), (Component)Component.m_237113_((String)"quick air-to-ground poke"));
    public static final KnockdownAttack<CreamEntity> OVERHEAD_SMASH = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 14, 20, 0.5f, 9.0f, 15, 2.0f, 1.25f, 0.3f, 35).withSound(JSoundRegistry.CREAM_SMASH)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Overhead Smash"), (Component)Component.m_237113_((String)"slow, uninterruptible launcher"));
    public static final SimpleMultiHitAttack<CreamEntity> BALL_COMBO = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(0, 36, 0.5f, 7.0f, 15, 2.0f, 0.1f, 0.3f, (IntCollection)IntSet.of((int)10, (int)17, (int)25)).withSound(JSoundRegistry.CREAM_COMBO)).withImpactSound(JSoundRegistry.IMPACT_3)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Aerial Assault"), (Component)Component.m_237113_((String)"less stun than grounded version"));
    public static final BallChargeAttack BALL_CHARGE = (BallChargeAttack)((BallChargeAttack)new BallChargeAttack(200, 13, 28, 1.0f, false).withSound(JSoundRegistry.CREAM_BALLDASH)).withInfo((Component)Component.m_237113_((String)"Void Charge"), (Component)Component.m_237113_((String)"Cream quickly transforms into a black hole and charges in the pointed direction"));
    public static final DetachChargeMove DETACH_CHARGE = (DetachChargeMove)((DetachChargeMove)new DetachChargeMove(200, 13, 28, 1.0f).withSound(JSoundRegistry.CREAM_BALLDASH)).withInfo((Component)Component.m_237113_((String)"Detaching Void Charge"), (Component)Component.m_237113_((String)"Cream quickly transforms into a black hole and charges in the pointed direction.\nThe user exits cream upon performing this move."));
    public static final BallChargeAttack BALL_DESTROY = (BallChargeAttack)((BallChargeAttack)new BallChargeAttack(200, 13, 28, 1.0f, true).withSound(JSoundRegistry.CREAM_BALLDASH)).withInfo((Component)Component.m_237113_((String)"Destroy"), (Component)Component.m_237113_((String)"Cream quickly transforms into a black hole and charges in a downward curve"));
    private static final EntityDataAccessor<Integer> VOID_TIME = SynchedEntityData.m_135353_(CreamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HALF_BALL = SynchedEntityData.m_135353_(CreamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vec3 chargeDir;
    private boolean charging = false;

    public CreamEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.CREAM.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.5f, 0.1f, 0.3f), new Vector3f(0.5f, 0.6f, 0.8f), new Vector3f(1.0f, 0.5f, 0.7f), new Vector3f(1.0f, 0.5f, 0.5f)};
    }

    @Override
    public Vector3f getAuraColor() {
        if (this.getVoidTime() > 0) {
            return new Vector3f();
        }
        return super.getAuraColor();
    }

    public void beginHalfBall() {
        this.f_19804_.m_135381_(HALF_BALL, (Object)true);
        this.maxStandGauge = 45.0f;
        this.switchMoveSet(HALF_BALL_MOVE_SET.getName());
    }

    public void endHalfBall() {
        this.f_19804_.m_135381_(HALF_BALL, (Object)false);
        this.maxStandGauge = 90.0f;
        this.switchMoveSet(DEFAULT_MOVE_SET.getName());
    }

    @Override
    public StandData getStandData() {
        StandData data = super.getStandData();
        if (this.isHalfBall()) {
            return data.withIdleDistance(0.0f).withBlockDistance(0.0f);
        }
        return data;
    }

    public boolean isHalfBall() {
        return (Boolean)this.f_19804_.m_135370_(HALF_BALL);
    }

    public int getVoidTime() {
        return (Integer)this.f_19804_.m_135370_(VOID_TIME);
    }

    public void setVoidTime(int vTime) {
        this.f_19804_.m_135381_(VOID_TIME, (Object)vTime);
        if (vTime == 0) {
            this.setReset(true);
        }
    }

    private static void registerHalfBallMoves(MoveMap<CreamEntity, State> moves) {
        moves.register(MoveClass.LIGHT, SWIPE, State.BALL_LIGHT);
        moves.register(MoveClass.HEAVY, OVERHEAD_SMASH, State.BALL_HEAVY);
        moves.register(MoveClass.BARRAGE, BALL_COMBO, State.BALL_COMBO);
        moves.register(MoveClass.SPECIAL1, BALL_CHARGE, State.BALL_CONSUME);
        moves.register(MoveClass.SPECIAL2, DETACH_CHARGE, State.BALL_CONSUME);
        moves.register(MoveClass.SPECIAL3, BALL_DESTROY, State.BALL_CONSUME);
        moves.register(MoveClass.UTILITY, EXIT, State.EXIT);
        moves.register(MoveClass.ULTIMATE, CONSUME, State.CONSUME);
    }

    private static void registerDefaultMoves(MoveMap<CreamEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, PUNCH, State.LIGHT);
        moves.register(MoveClass.HEAVY, VERTICAL_CHOP, State.HEAVY);
        moves.register(MoveClass.BARRAGE, COMBO, State.COMBO);
        moves.register(MoveClass.SPECIAL1, GRAB, State.GRAB);
        moves.register(MoveClass.SPECIAL2, SURPRISE, State.SURPRISE);
        moves.register(MoveClass.SPECIAL3, DESTROY, State.DESTROY).withCrouchingVariant(State.CHARGE);
        moves.register(MoveClass.UTILITY, ENTER, State.ENTER);
        moves.register(MoveClass.ULTIMATE, CONSUME, State.CONSUME);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(VOID_TIME, (Object)0);
        this.m_20088_().m_135372_(HALF_BALL, (Object)false);
    }

    @Override
    public boolean canAttack() {
        if (this.hasUser() && !(this.getUser() instanceof Player) && this.getVoidTime() > 0) {
            return false;
        }
        return super.canAttack();
    }

    @Override
    public boolean shouldOffsetHeight() {
        if (this.isHalfBall()) {
            return false;
        }
        return super.shouldOffsetHeight();
    }

    @NonNull
    protected AABB m_142242_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (this.isHalfBall()) {
            return new AABB(x - 0.6, y + 0.0, z - 0.6, x + 0.6, y + 1.4, z + 0.6);
        }
        if (this.getState() == State.SURPRISE) {
            return new AABB(x - 0.6, y + 0.0, z - 0.6, x + 0.6, y + 0.3, z + 0.6);
        }
        return super.m_142242_();
    }

    @Override
    public void desummon() {
        if (this.getVoidTime() > 0) {
            this.setVoidTime(0);
            return;
        }
        super.desummon();
    }

    public void m_142687_(@NonNull Entity.RemovalReason reason) {
        Player player;
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        LivingEntity livingEntity = this.getUser();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_() && !player.m_5833_()) {
            Abilities abilities = player.m_150110_();
            abilities.f_35935_ = false;
            abilities.f_35936_ = false;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(abilities));
            }
        }
        super.m_142687_(reason);
    }

    @Override
    public boolean defaultToNear() {
        if (this.charging) {
            return false;
        }
        return super.defaultToNear();
    }

    @Override
    public void m_8119_() {
        boolean userIsPlayer;
        boolean voiding;
        boolean server;
        super.m_8119_();
        boolean bl = server = !this.m_9236_().m_5776_();
        if (!this.hasUser()) {
            return;
        }
        LivingEntity user = this.getUserOrThrow();
        boolean notCreativeOrSpectator = false;
        Vec3 pos = this.m_146892_();
        int voidTime = this.getVoidTime();
        boolean bl2 = voiding = voidTime > 0;
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            boolean bl3 = notCreativeOrSpectator = !playerEntity.m_7500_() && !playerEntity.m_5833_();
            if (notCreativeOrSpectator && !this.charging && !this.isFree()) {
                playerEntity.m_150110_().f_35935_ = voiding;
            }
            userIsPlayer = true;
        } else {
            userIsPlayer = false;
        }
        if (server) {
            if (!this.charging) {
                if (this.getCurrentMove() != null) {
                    this.setVoidTime(0);
                    this.resetAlphaOverride();
                    voiding = false;
                }
                this.idleOverride = this.getVoidTime() > 0;
            }
            user.m_20331_(this.getVoidTime() > 0);
        }
        if (voiding) {
            if (server) {
                boolean hurt;
                if (this.m_9236_().m_46469_().m_46207_(JCraft.STAND_GRIEFING)) {
                    BlockPos blockPos = this.m_20183_();
                    BlockPos from = blockPos.m_7918_(-1, -1, -1);
                    BlockPos to = blockPos.m_7918_(1, 2, 1);
                    BlockPos.m_121940_((BlockPos)from, (BlockPos)to).forEach(p -> {
                        if (this.m_9236_().m_8055_(p).m_60734_().m_7325_() > 100.1f) {
                            return;
                        }
                        if (!JServerConfig.CREAM_ITEM_ERASE.getValue()) {
                            Block.m_49950_((BlockState)this.m_9236_().m_8055_(p), (Level)this.m_9236_(), (BlockPos)p);
                        }
                        this.m_9236_().m_46597_(p, Block.m_49803_((int)0));
                    });
                }
                if (notCreativeOrSpectator && !this.isFree()) {
                    user.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 25, 0, false, false));
                }
                if (this.charging) {
                    if (this.isFree()) {
                        Vector3f vector3f;
                        Vector3f newPos = this.getFreePos();
                        AbstractMove abstractMove = this.getCurrentMove();
                        if (abstractMove instanceof AbstractSurpriseMove) {
                            AbstractSurpriseMove surpriseMove = (AbstractSurpriseMove)abstractMove;
                            vector3f = surpriseMove.getOutDir();
                        } else {
                            vector3f = new Vector3f();
                        }
                        Vector3f outDir = vector3f;
                        newPos.add((Vector3fc)outDir);
                        this.setFreePos(newPos);
                        if (this.getMoveStun() == 1) {
                            this.setFree(false);
                        }
                    } else if (this.chargeDir != null) {
                        user.m_20256_(this.chargeDir);
                        user.f_19864_ = true;
                        if (user instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)user;
                            player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
                        }
                    }
                } else {
                    this.setStateNoReset(State.IDLE);
                    if (!userIsPlayer) {
                        this.handleAIVoid(user, voidTime);
                    }
                }
                AABB damageBox = new AABB(pos.m_82520_(1.5, 1.5, 1.5), pos.m_82492_(1.5, 1.5, 1.5));
                List toDamage = this.m_9236_().m_6443_(Entity.class, damageBox, EntitySelector.f_20402_.and(EntitySelector.f_20406_));
                JUtils.displayHitbox(this.m_9236_(), damageBox);
                toDamage.remove(user);
                toDamage.remove(this);
                int stun = 2;
                float damage = 1.5f;
                if (this.charging) {
                    hurt = this.getMoveStun() % 2 == 0;
                    stun = 4;
                    damage = 5.0f;
                } else {
                    hurt = this.f_19797_ % 4 == 0;
                    this.setAlphaOverride(0.0f);
                }
                for (Entity ent : toDamage) {
                    if (ent instanceof ItemEntity) {
                        if (!JServerConfig.CREAM_ITEM_ERASE.getValue()) continue;
                        ent.m_146870_();
                        continue;
                    }
                    if (!(ent instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)ent;
                    if (hurt) {
                        JCraft.stun(livingEntity, stun, 0, (Entity)user);
                        JUtils.cancelMoves(livingEntity);
                    }
                    livingEntity.m_6469_(this.m_9236_().m_269111_().m_269341_(), damage);
                }
                if (--voidTime < 1) {
                    this.resetAlphaOverride();
                }
                this.setVoidTime(voidTime);
                this.setDistanceOffset(0.0f);
            } else {
                for (int i = 0; i < 16; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, pos.f_82479_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f), pos.f_82480_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f), pos.f_82481_ + (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f), 0.0, 0.0, 0.0);
                }
            }
        } else {
            if (this.isIdle() && this.charging) {
                this.charging = false;
                this.setFree(false);
            }
            if (!this.isHalfBall()) {
                return;
            }
            this.setAlphaOverride(0.1f);
            user.m_183634_();
            user.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 5, 9, true, false));
            if (user instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)user;
                if (serverPlayer.m_21255_()) {
                    serverPlayer.m_36321_();
                }
                if (this.lastRemoteInputTime - this.f_19797_ > 4) {
                    this.updateRemoteInputs(0, 0, false, false);
                }
                Vec3 finalSpeed = Vec3.f_82478_;
                if (!this.blocking && !user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
                    float side;
                    Vec3 gravityVec = new Vec3(GravityChangerAPI.getGravityDirection((Entity)this).m_253071_());
                    Vec3 userVel = JUtils.deltaPos((Entity)user);
                    Vec3 userPos = user.m_20182_();
                    Vec3 groundPos = this.m_9236_().m_45547_(new ClipContext(userPos, userPos.m_82549_(gravityVec.m_82490_(24.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)user)).m_82450_();
                    double groundDist = groundPos.m_82554_(pos);
                    if (groundDist < 2.0) {
                        groundDist = 2.0;
                    }
                    Vec3 stabilization = userVel.m_82559_(gravityVec).m_82490_(10.0 / groundDist);
                    if (this.getRemoteJumpInput()) {
                        user.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 10, 2, true, false));
                        if (groundDist < 5.0) {
                            GravityChangerAPI.addWorldVelocity((Entity)user, stabilization.m_82546_(gravityVec.m_82490_(0.25 / groundDist)));
                        }
                    }
                    Vec3 rotVec = Vec3.m_82498_((float)this.m_146909_(), (float)this.m_146908_());
                    Vec3 moveRotVec = Vec3.f_82478_;
                    float forward = (float)this.getRemoteForwardInput();
                    if (forward != 0.0f) {
                        moveRotVec = moveRotVec.m_82549_(rotVec.m_82490_((double)forward));
                    }
                    if ((side = (float)this.getRemoteSideInput()) != 0.0f) {
                        moveRotVec = moveRotVec.m_82549_(rotVec.m_82524_(1.5707964f * side));
                    }
                    finalSpeed = finalSpeed.m_82549_(moveRotVec.m_82541_().m_82490_(0.034));
                    user.m_5997_(finalSpeed.f_82479_, finalSpeed.f_82480_, finalSpeed.f_82481_);
                    user.f_19864_ = true;
                }
            } else {
                this.resetAlphaOverride();
            }
        }
    }

    private void handleAIVoid(LivingEntity user, int voidTime) {
        double y = user.m_20186_();
        Vec3 vel = new Vec3(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
        CombatEntry damageRecord = user.m_21231_().m_19298_();
        Entity targetEntity = null;
        if (damageRecord != null) {
            targetEntity = damageRecord.f_19250_().m_7639_();
        }
        if (targetEntity == null && user instanceof Mob) {
            Mob mob = (Mob)user;
            targetEntity = mob.m_5448_();
        }
        if (targetEntity == null) {
            targetEntity = user.m_21188_();
        }
        Vec3 target = targetEntity != null ? targetEntity.m_20182_() : this.m_20182_().m_82520_(Math.sin((double)this.f_19797_ * 0.2) * 2.0, Math.sin((double)this.f_19797_ * 0.2) / 4.0, Math.cos((double)this.f_19797_ * 0.2) * 2.0);
        double dY = Mth.m_14008_((double)(target.m_7098_() - y), (double)-1.0, (double)1.0);
        vel = vel.m_82549_(target.m_82546_(user.m_20182_().m_82520_(this.f_19796_.m_188500_() * 2.0, this.f_19796_.m_188500_() * 3.0, this.f_19796_.m_188500_() * 3.0)).m_82541_()).m_82490_(0.3);
        user.m_20256_(vel);
        user.m_20343_(user.m_20185_(), y += dY, user.m_20189_());
        if (voidTime < 10) {
            user.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 5, 1, true, false));
        }
    }

    @Override
    @NonNull
    public CreamEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    protected String getSummonAnimation() {
        return "animation.cream.summon";
    }

    @Override
    public State getIdleState() {
        return State.IDLE;
    }

    @Override
    public State getBlockState() {
        return this.isHalfBall() ? State.BALL_BLOCK : State.BLOCK;
    }

    public Vec3 getChargeDir() {
        return this.chargeDir;
    }

    public boolean isCharging() {
        return this.charging;
    }

    public void setChargeDir(Vec3 chargeDir) {
        this.chargeDir = chargeDir;
    }

    public void setCharging(boolean charging) {
        this.charging = charging;
    }

    public static enum State implements StandAnimationState<CreamEntity>
    {
        IDLE((cream, builder) -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cream." + (cream.getVoidTime() > 0 ? "void" : (cream.isHalfBall() ? "ball" : "")) + "idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.light"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.light_followup"))),
        BALL_LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.balllight"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cream.block"))),
        BALL_BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.cream.ballblock"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.heavy"))),
        BALL_HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.ballheavy"))),
        COMBO(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.combo"))),
        BALL_COMBO(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.ballcombo"))),
        CONSUME(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.consume"))),
        BALL_CONSUME(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.ballconsume"))),
        SURPRISE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.surprise"))),
        CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.charge"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.grab_hit"))),
        ENTER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.enter"))),
        EXIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.exit"))),
        DESTROY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.destroy"))),
        BITE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.cream.bite")));

        private final BiConsumer<CreamEntity, AnimationState<CreamEntity>> animator;

        private State(Consumer<AnimationState<CreamEntity>> animator) {
            this((CreamEntity creamEntity, AnimationState<CreamEntity> builder) -> animator.accept((AnimationState<CreamEntity>)builder));
        }

        private State(BiConsumer<CreamEntity, AnimationState<CreamEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(CreamEntity attacker, AnimationState<CreamEntity> state) {
            this.animator.accept(attacker, state);
        }
    }
}

