/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.LungeAction;
import net.arna.jcraft.common.attack.actions.PlaySoundAction;
import net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap.CloneSpawnMove;
import net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap.D4CCounterAttack;
import net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap.D4CGrabAttack;
import net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap.DimensionalHopMove;
import net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap.FlagMove;
import net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap.GiveGunMove;
import net.arna.jcraft.common.attack.moves.dirtydeedsdonedirtcheap.ItemPlaceMove;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class D4CEntity
extends StandEntity<D4CEntity, State> {
    public static final MoveSet<D4CEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.D4C, D4CEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-45.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.d4c")).proCount(4).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs: (outdated)\n    -the lazy zoner\n    Light>Barrage>Light>Grab/Charge\n\n    -the western\n    Light>Summon Gun>Barrage>Light~stand.OFF>M2>M2>M2>~s.ON+Light>Charge")).skinName((Component)Component.m_237113_((String)"Jojoveller")).skinName((Component)Component.m_237113_((String)"Teaser")).skinName((Component)Component.m_237113_((String)"Spangled")).build()).summonData(SummonData.builder().sound((Supplier<SoundEvent>)JSoundRegistry.D4C_SUMMON).playGenericSound(true).build()).build();
    public static final ItemPlaceMove ITEM_PLACE = (ItemPlaceMove)((ItemPlaceMove)new ItemPlaceMove(20, 8, 12, 0.75f).withAnim(State.ITEM_PLACE)).withInfo((Component)Component.m_237113_((String)"Item Place"), (Component)Component.m_237113_((String)"places an item from an alternate universe on the ground, which attracts other such items"));
    public static final SimpleAttack<D4CEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 9, 14, 0.75f, 7.0f, 8, 1.75f, 1.25f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withSound(JSoundRegistry.D4C_LIGHT)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.0, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Deadly Blow"), (Component)Component.m_237113_((String)"combo finisher, more blockstun than other light followups"));
    public static final SimpleAttack<D4CEntity> CHOP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(20, 9, 15, 0.75f, 5.0f, 20, 1.5f, 0.25f, -0.1f).noLoopPrevention()).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(ITEM_PLACE)).withImpactSound(JSoundRegistry.IMPACT_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Chop"), (Component)Component.m_237113_((String)"relatively quick combo starter"));
    public static final MainBarrageAttack<D4CEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(240, 0, 40, 0.75f, 0.8f, 30, 2.0f, 0.25f, 0.0f, 3, Blocks.f_152550_.m_155943_()).withSound(JSoundRegistry.D4C_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_2)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final SimpleAttack<D4CEntity> CHARGE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(100, 14, 25, 1.0f, 8.0f, 12, 2.0f, 1.5f, -0.2f).withInitAction(LungeAction.lunge(0.75f, 0.15f).onGround())).withSound(JSoundRegistry.D4C_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_2)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Charge"), (Component)Component.m_237113_((String)"user & stand charge forward, uninterruptible launcher"));
    public static final DimensionalHopMove DIM_HOP = (DimensionalHopMove)((DimensionalHopMove)new DimensionalHopMove(1200, 40, 60, 1.0f, 0.0f, 0, 1.75f, 0.0f, 0.0f).withSound(JSoundRegistry.D4C_DIMHOP)).withInfo((Component)Component.m_237113_((String)"Dimensional Hop"), (Component)Component.m_237113_((String)"travels to a random dimension at exact coordinates, if user was hit in the last 30s, he is forced back, certified death button"));
    public static final GiveGunMove GIVE_GUN = (GiveGunMove)((GiveGunMove)new GiveGunMove(280, 10, 14, 0.75f).withSound(JSoundRegistry.D4C_THROW)).withInfo((Component)Component.m_237113_((String)"Summon Gun"), (Component)Component.m_237113_((String)"gives the user a revolver"));
    public static final SimpleAttack<D4CEntity> GRAB_HIT_FINAL = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 26, 34, 0.75f, 4.0f, 9, 2.0f, 1.2f, 0.0f).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Grab (Final Hit)"), (Component)Component.m_237119_());
    public static final SimpleMultiHitAttack<D4CEntity> GRAB_HIT = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(0, 34, 0.75f, 4.0f, 10, 2.0f, 0.0f, 0.0f, (IntCollection)IntSet.of((int)11, (int)17, (int)26)).withImpactSound(JSoundRegistry.IMPACT_1)).withAction(PlaySoundAction.playSound(JSoundRegistry.REVOLVER_FIRE))).withStunType(StunType.UNBURSTABLE)).withFinisher(17, GRAB_HIT_FINAL)).withInfo((Component)Component.m_237113_((String)"Grab (Final Hit)"), (Component)Component.m_237119_());
    public static final D4CGrabAttack GRAB = (D4CGrabAttack)((D4CGrabAttack)((D4CGrabAttack)new D4CGrabAttack(280, 12, 21, 0.75f, 0.0f, 40, 1.5f, 0.0f, 0.0f, GRAB_HIT, 25, 1.0).withCrouchingVariant(GIVE_GUN)).withSound(JSoundRegistry.D4C_THROW)).withInfo((Component)Component.m_237113_((String)"Grab"), (Component)Component.m_237113_((String)"unblockable, combo finisher"));
    public static final D4CCounterAttack COUNTER = (D4CCounterAttack)new D4CCounterAttack(300, 5, 35, 0.75f).withInfo((Component)Component.m_237113_((String)"Counter"), (Component)Component.m_237113_((String)"0.25s startup, 1.5s duration, high damage, knocks back when hit"));
    public static final CloneSpawnMove CLONE_SPAWN = (CloneSpawnMove)((CloneSpawnMove)new CloneSpawnMove(300, 40, 50, 1.0f).withSound(JSoundRegistry.D4C_DIMHOP)).withInfo((Component)Component.m_237113_((String)"Dimensional Clone"), (Component)Component.m_237113_((String)"summons an unlimited number of servants, crouch and interact to give/take items, press a special button to change their weapon\nServant types:\nDEFAULT - Iron Sword\nSPECIAL 1 - Wooden Axe\nSPECIAL 2 - Bow\nSPECIAL 3 - None"));
    public static final FlagMove FLAG = (FlagMove)((FlagMove)new FlagMove(200, 10, 60, 0.0f).withSound(JSoundRegistry.D4C_UTILITY)).withInfo((Component)Component.m_237113_((String)"Dimensional Phase"), (Component)Component.m_237113_((String)"hides in a flag in an un-stunnable, floating state"));

    public D4CEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.D4C.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.9f, 0.5f, 0.7f), new Vector3f(0.5f, 0.8f, 0.9f), new Vector3f(0.4f, 0.4f, 1.0f), new Vector3f(1.0f, 0.5f, 0.2f)};
    }

    private static void registerMoves(MoveMap<D4CEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, CHOP, State.LIGHT);
        moves.register(MoveClass.HEAVY, CHARGE, State.HEAVY);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, CLONE_SPAWN, State.DIM_HOP);
        moves.register(MoveClass.SPECIAL2, GRAB, State.THROW).withCrouchingVariant(State.GIVE_GUN);
        moves.register(MoveClass.SPECIAL3, COUNTER, State.COUNTER);
        moves.register(MoveClass.ULTIMATE, DIM_HOP, State.DIM_HOP);
        moves.register(MoveClass.UTILITY, FLAG, State.FLAG);
    }

    public void equipRevolver() {
        this.m_8061_(EquipmentSlot.MAINHAND, ((Item)JItemRegistry.FV_REVOLVER.get()).m_7968_());
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        switch (moveClass) {
            case ULTIMATE: {
                if (!(this.getCurrentMove() instanceof DimensionalHopMove)) break;
                this.setMoveStun(0);
                this.setCurrentMove(null);
                break;
            }
            case LIGHT: {
                if (!this.tryFollowUp(moveClass, MoveClass.LIGHT)) break;
                return true;
            }
        }
        return super.initMove(moveClass);
    }

    @NonNull
    protected AABB m_142242_() {
        if (this.getState() == State.FLAG) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            return new AABB(x + 0.5, y + 0.5, z + 0.5, x - 0.5, y, z - 0.5);
        }
        return super.m_142242_();
    }

    @Override
    @NonNull
    public D4CEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    protected String getSummonAnimation() {
        return "animation.d4c.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<D4CEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.d4c.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.d4c.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.d4c.barrage"))),
        DIM_HOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.dimhop"))),
        THROW(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.throw"))),
        THROW_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.throwhit"))),
        COUNTER(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.d4c.counter"))),
        COUNTER_MISS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.counter_miss"))),
        GIVE_GUN(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.givegun"))),
        FLAG(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.flag"))),
        ITEM_PLACE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.itemplace"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.d4c.light_followup")));

        private final Consumer<AnimationState<D4CEntity>> animator;

        private State(Consumer<AnimationState<D4CEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(D4CEntity attacker, AnimationState<D4CEntity> state) {
            this.animator.accept(state);
        }
    }
}

