/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.LevitationPoseModifier;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.attack.moves.goldexperience.requiem.FlightMove;
import net.arna.jcraft.common.attack.moves.goldexperience.requiem.LifeBeamAttack;
import net.arna.jcraft.common.attack.moves.goldexperience.requiem.NullificationAttack;
import net.arna.jcraft.common.attack.moves.goldexperience.requiem.OverheadKickAttack;
import net.arna.jcraft.common.attack.moves.goldexperience.requiem.ReturnToZeroMove;
import net.arna.jcraft.common.attack.moves.shared.BarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.HealMove;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleHoldableMove;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GEREntity
extends StandEntity<GEREntity, State> {
    public static final MoveSet<GEREntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.GOLD_EXPERIENCE_REQUIEM, GEREntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-30.0f).evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.ger")).proCount(5).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs:\n-the scorpy patty (sets up stand off transition)\n(Light>)Barrage>jump>Overhead Kick>Life Beam>Light>Life Beam (second hit)\n-knockdown experience\nLight>Barrage>Life Beam>Light~Overhead Smash>Life Beam (second hit)")).skinName((Component)Component.m_237113_((String)"Silver")).skinName((Component)Component.m_237113_((String)"Manga")).skinName((Component)Component.m_237113_((String)"Cherry Blossom")).build()).build();
    public static final Supplier<IPoseModifier> POSE = LevitationPoseModifier::new;
    public static final SimpleAttack<GEREntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 13, 0.75f, 6.0f, 8, 1.5f, 1.0f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<GEREntity> DOWNWARD_KICK = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(20, 5, 12, 0.75f, 4.0f, 20, 1.25f, 0.4f, 0.33f).withAnim(State.AIR_LIGHT)).withFollowup(LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(0.0, -1.0, 1.0)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Downward Kick"), (Component)Component.m_237113_((String)"medium stun combo starter, low hitbox, low blockstun"));
    public static final OverheadKickAttack OVERHEAD_KICK = (OverheadKickAttack)((OverheadKickAttack)((OverheadKickAttack)((OverheadKickAttack)((OverheadKickAttack)new OverheadKickAttack(24, 14, 24, 1.0f, 9.0f, 40, 1.5f, 0.8f, 0.25f).withSound(JSoundRegistry.GER_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(0.0, -1.0, 1.0)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Overhead Kick"), (Component)Component.m_237113_((String)"slow, high stun combo starter"));
    public static final SimpleAttack<GEREntity> KICK_BARRAGE_FINISHER = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 9, 1.0f, 1.0f, 10, 1.75f, 1.1f, 0.0f).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunchNoShockwave()).withInfo((Component)Component.m_237113_((String)"Kick Barrage (Final Hit)"), (Component)Component.m_237119_());
    public static final BarrageAttack<GEREntity> KICK_BARRAGE = (BarrageAttack)((BarrageAttack)((BarrageAttack)new BarrageAttack(140, 0, 48, 1.0f, 1.0f, 20, 1.5f, 0.3f, 0.0f, 3).withFinisher(37, KICK_BARRAGE_FINISHER)).withSound(JSoundRegistry.GER_KICKBARRAGE)).withInfo((Component)Component.m_237113_((String)"Kick Barrage"), (Component)Component.m_237113_((String)"fast combo finisher, knocks back"));
    public static final SimpleAttack<GEREntity> PUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(10, 5, 9, 0.75f, 5.0f, 8, 1.5f, 0.2f, -0.1f).noLoopPrevention()).withAerialVariant(DOWNWARD_KICK)).withImpactSound(JSoundRegistry.IMPACT_1)).withBlockStun(4)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final KnockdownAttack<GEREntity> OVERHEAD_SMASH = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack<GEREntity>(0, 10, 19, 1.0f, 9.0f, 10, 1.5f, 1.1f, 0.0f, 30).withAerialVariant(OVERHEAD_KICK)).withSound(JSoundRegistry.GER_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_2)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withExtraHitBox(1.5)).withInfo((Component)Component.m_237113_((String)"Overhead Smash"), (Component)Component.m_237113_((String)"slow, uninterruptible knockdown"));
    public static final MainBarrageAttack<GEREntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 30, 0.75f, 1.0f, 20, 2.0f, 0.25f, 0.0f, 3, Blocks.f_152550_.m_155943_()).withAerialVariant(KICK_BARRAGE)).withSound(JSoundRegistry.GE_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final HealMove<GEREntity> HEAL = (HealMove)((HealMove)new HealMove(520, 10, 16, 1.0f, 1.25f, 0.0f, 6.0f, HealMove.HealTarget.TARGETS, true).withSound(JSoundRegistry.GE_HEAL)).withInfo((Component)Component.m_237113_((String)"Healing Hand (Others)"), (Component)Component.m_237119_());
    public static final HealMove<GEREntity> HEAL_SELF = (HealMove)((HealMove)((HealMove)new HealMove(520, 10, 14, 1.0f, 0.0f, 0.0f, 4.0f, HealMove.HealTarget.USER, false).withCrouchingVariant(HEAL)).withSound(JSoundRegistry.GE_HEAL)).withInfo((Component)Component.m_237113_((String)"Healing Hand"), (Component)Component.m_237113_((String)"standing: heals user for 2 hearts, crouching: heals others for 3 hearts, pacifies angered mobs"));
    public static final LifeBeamAttack LIFE_BEAM = (LifeBeamAttack)((LifeBeamAttack)new LifeBeamAttack(0, 1, 10, 1.1f).withSound(JSoundRegistry.GER_LASER_FIRE)).withInfo((Component)Component.m_237113_((String)"Life Beam"), (Component)Component.m_237113_((String)""));
    public static final SimpleHoldableMove<GEREntity> LIFE_BEAM_CHARGE = (SimpleHoldableMove)((SimpleHoldableMove)((SimpleHoldableMove)new SimpleHoldableMove<GEREntity>(100, 0, 40, 1.1f, 9).withFollowup(LIFE_BEAM)).withSound(JSoundRegistry.GER_LASER)).withInfo((Component)Component.m_237113_((String)"Life Beam"), (Component)Component.m_237113_((String)"Summons a fast rock projectile that turns into a homing scorpion a small time after landing.\nIf charged for a minimum of 0.9 seconds, the scorpion inflicts poison and deals more stun."));
    public static final NullificationAttack NULLIFICATION = (NullificationAttack)((NullificationAttack)new NullificationAttack(480, 5, 35, 1.0f).withSound(JSoundRegistry.GE_HEAL)).withInfo((Component)Component.m_237113_((String)"Nullification"), (Component)Component.m_237113_((String)"0.25s windup, 1.5s counter, stuns on hit"));
    public static final ReturnToZeroMove RETURN_TO_ZERO = (ReturnToZeroMove)((ReturnToZeroMove)new ReturnToZeroMove(1200, 30, 32, 1.0f).withSound(JSoundRegistry.GER_SETUP)).withInfo((Component)Component.m_237113_((String)"Return to Zero"), (Component)Component.m_237113_((String)"initial press: saves the state of every entity in a 4 chunk radius, second press: reverts all states except users\nDoesn't affect player inventories"));
    public static final FlightMove FLIGHT = (FlightMove)((FlightMove)new FlightMove(320, 1, 0, 0.0f, 20).withSound(JSoundRegistry.GER_FLY)).withInfo((Component)Component.m_237113_((String)"Flight"), (Component)Component.m_237113_((String)"1 second of flight"));
    private static final EntityDataAccessor<Integer> FLIGHT_TIME = SynchedEntityData.m_135353_(GEREntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GEREntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.GOLD_EXPERIENCE_REQUIEM.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.7f, 0.8f, 1.0f), new Vector3f(0.8f, 0.7f, 1.0f), new Vector3f(1.0f, 0.3f, 0.7f), new Vector3f(1.0f, 0.0f, 1.0f)};
    }

    private static void registerMoves(MoveMap<GEREntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, PUNCH, State.LIGHT);
        moves.register(MoveClass.HEAVY, OVERHEAD_SMASH, State.HEAVY).withAerialVariant(State.AIR_HEAVY);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE).withAerialVariant(State.AIR_BARRAGE);
        moves.register(MoveClass.SPECIAL1, HEAL_SELF, State.HEAL_SELF).withCrouchingVariant(State.HEAL);
        moves.register(MoveClass.SPECIAL2, LIFE_BEAM_CHARGE, State.LASER).withFollowup(State.LASER_FIRE);
        moves.register(MoveClass.SPECIAL3, NULLIFICATION, State.COUNTER);
        moves.register(MoveClass.ULTIMATE, RETURN_TO_ZERO, State.SETUP);
        moves.register(MoveClass.UTILITY, FLIGHT);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLIGHT_TIME, (Object)0);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (moveClass == MoveClass.ULTIMATE) {
            ReturnToZeroMove rtzMove = this.getMoveMap().findMoveByType(ReturnToZeroMove.class).orElse(null);
            if (rtzMove != null && rtzMove.returnToZero(this)) {
                return true;
            }
            return super.initMove(moveClass);
        }
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        return super.initMove(moveClass);
    }

    public int getFlightTime() {
        return (Integer)this.f_19804_.m_135370_(FLIGHT_TIME);
    }

    public void setFlightTime(int i) {
        this.f_19804_.m_135381_(FLIGHT_TIME, (Object)i);
    }

    @Override
    public void desummon() {
        if (this.getFlightTime() > 0) {
            this.setFlightTime(0);
            return;
        }
        super.desummon();
    }

    public void m_142687_(@NonNull Entity.RemovalReason reason) {
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        LivingEntity livingEntity = this.getUser();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35935_ && !player.m_7500_() && !player.m_5833_()) {
                Abilities abilities = player.m_150110_();
                abilities.f_35935_ = false;
                abilities.f_35936_ = false;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(abilities));
                }
            }
        }
        super.m_142687_(reason);
    }

    @Override
    public void m_8119_() {
        if (this.f_19797_ == 1) {
            this.m_5496_((SoundEvent)JSoundRegistry.GER_SUMMON.get(), 1.0f, 1.0f);
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            Player player;
            LivingEntity livingEntity;
            if (this.getState() == State.LASER && this.getMoveStun() == LIFE_BEAM_CHARGE.getDuration() - 18) {
                Vec3 offset = GravityChangerAPI.getEyeOffset((Entity)this);
                double x = this.m_20185_() + offset.f_82479_;
                double y = this.m_20186_() + offset.f_82480_;
                double z = this.m_20189_() + offset.f_82481_;
                for (int i = 0; i < 12; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_());
                }
            }
            if ((livingEntity = this.getUser()) instanceof Player && !(player = (Player)livingEntity).m_7500_() && !player.m_5833_()) {
                player.m_150110_().f_35935_ = this.getFlightTime() > 1;
            }
        }
    }

    @Override
    @NonNull
    public GEREntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.ger.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<GEREntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.ger.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.ger.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.ger.barrage"))),
        HEAL_SELF(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.healself"))),
        HEAL(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.heal"))),
        LASER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.laser"))),
        LASER_FIRE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.laser_fire"))),
        COUNTER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.counter"))),
        COUNTER_MISS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.counter_miss"))),
        AIR_HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.airheavy"))),
        AIR_LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.airlight"))),
        AIR_BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.airbarrage"))),
        SETUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.setup"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ger.light_followup")));

        private final Consumer<AnimationState<GEREntity>> animator;

        private State(Consumer<AnimationState<GEREntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(GEREntity attacker, AnimationState<GEREntity> state) {
            this.animator.accept(state);
        }
    }
}

