/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.core.HitBoxData;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.goldexperience.BerryBushAttack;
import net.arna.jcraft.common.attack.moves.goldexperience.LifeGiverAttack;
import net.arna.jcraft.common.attack.moves.goldexperience.OverclockAttack;
import net.arna.jcraft.common.attack.moves.goldexperience.TreeAttack;
import net.arna.jcraft.common.attack.moves.shared.HealMove;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.MovementSlowingSimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GoldExperienceEntity
extends StandEntity<GoldExperienceEntity, State> {
    public static final MoveSet<GoldExperienceEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.GOLD_EXPERIENCE, GoldExperienceEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-30.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.goldexperience")).proCount(4).conCount(3).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the giogio\n    Light>Barrage>Light>Tree>Rekka 1~2~3\n\n    -the superprince of gaming\n    Rekka 1~2>Light>Barrage>Light>Tree>Heavy")).skinName((Component)Component.m_237113_((String)"Anime")).skinName((Component)Component.m_237113_((String)"Spectre")).skinName((Component)Component.m_237113_((String)"Burning Passion")).build()).summonData(SummonData.of(JSoundRegistry.GE_SUMMON)).build();
    public static final BerryBushAttack BERRY_BUSH = (BerryBushAttack)((BerryBushAttack)((BerryBushAttack)new BerryBushAttack(40, 16, 20, 1.25f, 4.0f, 5, 1.5f, 0.75f, 0.2f).withAnim(State.LIFE_GIVER)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Place Berry Bush"), (Component)Component.m_237113_((String)"places an almost-ripe berry bush on the ground, this move cannot be aimed up or down"));
    public static final SimpleAttack<GoldExperienceEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 12, 0.75f, 6.0f, 7, 1.5f, 1.0f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<GoldExperienceEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(15, 6, 9, 0.75f, 5.0f, 7, 1.5f, 0.2f, -0.1f).noLoopPrevention()).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(BERRY_BUSH)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter, low stun"));
    public static final MovementSlowingSimpleAttack<GoldExperienceEntity> HEAVY = (MovementSlowingSimpleAttack)((MovementSlowingSimpleAttack)((MovementSlowingSimpleAttack)((MovementSlowingSimpleAttack)((MovementSlowingSimpleAttack)((MovementSlowingSimpleAttack)new MovementSlowingSimpleAttack(22, 13, 22, 1.0f, 9.0f, 10, 1.5f, 1.5f, 0.0f).withExtraHitBox(new HitBoxData(0.0, 0.0, 1.25))).withImpactSound(JSoundRegistry.IMPACT_2)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Shoulder Smash"), (Component)Component.m_237113_((String)"slow, uninterruptible combo finisher"));
    public static final MainBarrageAttack<GoldExperienceEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 30, 0.75f, 1.0f, 20, 2.0f, 0.25f, 0.0f, 3, Blocks.f_50705_.m_155943_()).withSound(JSoundRegistry.GE_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final HealMove<GoldExperienceEntity> HEAL_OTHERS = (HealMove)((HealMove)new HealMove(520, 10, 16, 1.0f, 1.25f, 0.0f, 4.0f, HealMove.HealTarget.TARGETS, false).withSound(JSoundRegistry.GE_HEAL)).withInfo((Component)Component.m_237113_((String)"Healing Hand (others)"), (Component)Component.m_237119_());
    public static final HealMove<GoldExperienceEntity> HEAL_SELF = (HealMove)((HealMove)((HealMove)new HealMove(520, 10, 14, 1.0f, 0.0f, 0.0f, 4.0f, HealMove.HealTarget.USER, false).withCrouchingVariant(HEAL_OTHERS)).withSound(JSoundRegistry.GE_HEAL)).withInfo((Component)Component.m_237113_((String)"Healing Hand"), (Component)Component.m_237113_((String)"standing: heals user for 2 hearts, crouching: heals others for 2 hearts, pacifies angered mobs"));
    public static final TreeAttack TREE = (TreeAttack)((TreeAttack)((TreeAttack)new TreeAttack(280, 10, 24, 1.0f, 5.0f, 15, 1.75f, 0.2f, -0.1f).withImpactSound(JSoundRegistry.IMPACT_8)).withSound(JSoundRegistry.GE_TREE)).withInfo((Component)Component.m_237113_((String)"Tree Summon"), (Component)Component.m_237113_((String)"two-hitting launch"));
    public static final LifeGiverAttack LIFE_GIVER = (LifeGiverAttack)((LifeGiverAttack)new LifeGiverAttack(300, 16, 25, 1.0f).withSound(JSoundRegistry.GE_HEAL)).withInfo((Component)Component.m_237113_((String)"Life Giver"), (Component)Component.m_237113_((String)"STANDING: turns any stackable item into a snake, lasts for 25s and stuns for 0.5s on hit\nCROUCHING: turns any stackable item into a frog, lasts for 15s and reflects damage, follows user\nAERIAL: turns any item into a butterfly, lasts forever"));
    public static final OverclockAttack OVERCLOCK = (OverclockAttack)((OverclockAttack)((OverclockAttack)new OverclockAttack(920, 22, 31, 1.0f, 9.0f, 60, 2.0f, 0.9f, 0.0f).withImpactSound(JSoundRegistry.IMPACT_10)).withBlockableType(BlockableType.NON_BLOCKABLE)).withInfo((Component)Component.m_237113_((String)"Overclock"), (Component)Component.m_237113_((String)"slow, unblockable, devastating stun"));
    public static final KnockdownAttack<GoldExperienceEntity> REKKA3 = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 12, 24, 1.0f, 6.0f, 15, 2.0f, 0.75f, 0.0f, 50).withAnim(State.REKKA3)).withSound(JSoundRegistry.GE_REKKA3)).withLaunch()).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withBlockStun(8)).withInfo((Component)Component.m_237113_((String)"Rekka (Final Hit)"), (Component)Component.m_237113_((String)"knockdown, low blockstun"));
    public static final SimpleAttack<GoldExperienceEntity> REKKA2 = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 9, 18, 1.0f, 5.0f, 16, 1.75f, 0.5f, 0.0f).withAnim(State.REKKA2)).withSound(JSoundRegistry.GE_REKKA2)).withImpactSound(JSoundRegistry.IMPACT_2)).withFollowup(REKKA3)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Rekka (2nd Hit)"), (Component)Component.m_237113_((String)"links into Light"));
    public static final SimpleAttack<GoldExperienceEntity> REKKA1 = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 14, 1.0f, 5.0f, 15, 1.5f, 0.5f, 0.0f).withAnim(State.REKKA1)).withSound(JSoundRegistry.GE_REKKA1)).withImpactSound(JSoundRegistry.IMPACT_2)).withFollowup(REKKA2)).withExtraHitBox(1.25)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Rekka Series"), (Component)Component.m_237113_((String)"a set of three attacks, which cancel into each other during recovery"));

    public GoldExperienceEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.GOLD_EXPERIENCE.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 0.7f, 0.2f), new Vector3f(0.3f, 0.6f, 1.0f), new Vector3f(1.0f, 0.3f, 0.7f), new Vector3f(1.0f, 0.0f, 0.0f)};
    }

    private static void registerMoves(MoveMap<GoldExperienceEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
        moves.register(MoveClass.HEAVY, HEAVY, State.HEAVY);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, HEAL_SELF, State.HEAL_SELF).withCrouchingVariant(State.HEAL);
        moves.register(MoveClass.SPECIAL2, REKKA1, State.REKKA1).withFollowup(State.REKKA2).withFollowup(State.REKKA3);
        moves.register(MoveClass.SPECIAL3, LIFE_GIVER, State.LIFE_GIVER);
        moves.register(MoveClass.ULTIMATE, OVERCLOCK, State.OVERCLOCK);
        moves.register(MoveClass.UTILITY, TREE, State.TREE);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        switch (moveClass) {
            case SPECIAL2: {
                boolean idling;
                LivingEntity user = this.getUserOrThrow();
                if (user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
                    return false;
                }
                boolean bl = idling = this.getMoveStun() <= 0;
                if (this.getCurrentMove() == null || this.getCurrentMove().getMoveClass() != MoveClass.SPECIAL2) {
                    if (idling) {
                        return this.handleMove(MoveClass.SPECIAL2);
                    }
                    return false;
                }
                if (this.getCurrentMove().getFollowup() == null || !this.getCurrentMove().hasWindupPassed(this)) break;
                this.setMove(this.getCurrentMove().getFollowup(), (State)this.getCurrentMove().getFollowup().getAnimation());
                break;
            }
            case SPECIAL3: {
                if (!this.canAttack() || !this.hasUser()) {
                    return false;
                }
                LivingEntity user = this.getUserOrThrow();
                LifeGiverAttack.LifeGiverType toSummon = LifeGiverAttack.LifeGiverType.SNAKE;
                if (user.m_20096_()) {
                    if (user.m_6144_()) {
                        toSummon = LifeGiverAttack.LifeGiverType.FROG;
                    }
                } else {
                    toSummon = LifeGiverAttack.LifeGiverType.BUTTERFLY;
                }
                LifeGiverAttack.LifeGiverType finalToSummon = toSummon;
                this.getMoveMap().findMoveByType(LifeGiverAttack.class).ifPresent(move -> move.setTypeToSummon(finalToSummon));
                return this.handleMove(MoveClass.SPECIAL3);
            }
            case LIGHT: {
                if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) break;
                return super.initMove(moveClass);
            }
        }
        return super.initMove(moveClass);
    }

    @Override
    public void queueMove(MoveInputType type) {
        if ((this.getState() == State.REKKA2 || this.getState() == State.REKKA3) && type == MoveInputType.SPECIAL2) {
            return;
        }
        super.queueMove(type);
    }

    @Override
    public MoveSelectionResult specificMoveSelectionCriterion(AbstractMove<?, ? super GoldExperienceEntity> attack, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        return attack == LIFE_GIVER ? (mob.m_21205_().m_41619_() && mob.m_21206_().m_41619_() ? MoveSelectionResult.STOP : MoveSelectionResult.USE) : super.specificMoveSelectionCriterion(attack, mob, target, stunTicks, enemyMoveStun, distance, enemyStand, enemyAttack);
    }

    @Override
    public boolean shouldOffsetHeight() {
        if (this.getState() == State.LIFE_GIVER) {
            return false;
        }
        return super.shouldOffsetHeight();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    @NonNull
    public GoldExperienceEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.ge.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<GoldExperienceEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.ge.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.ge.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.ge.barrage"))),
        HEAL_SELF(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.healself"))),
        HEAL(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.heal"))),
        TREE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.tree"))),
        LIFE_GIVER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.lifegiver"))),
        REKKA1(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.rekka1"))),
        REKKA2(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.rekka2"))),
        REKKA3(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.rekka3"))),
        OVERCLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.overclock"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.ge.light_followup")));

        private final Consumer<AnimationState<GoldExperienceEntity>> animator;

        private State(Consumer<AnimationState<GoldExperienceEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(GoldExperienceEntity attacker, AnimationState<GoldExperienceEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

