/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.hierophantgreen.EmeraldSplashAttack;
import net.arna.jcraft.common.attack.moves.hierophantgreen.NetSetMove;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.PilotModeMove;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleHoldableMove;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.entity.projectile.HGNetEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.IOwnable;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HGEntity
extends StandEntity<HGEntity, State> {
    public static final MoveSet<HGEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.HIEROPHANT_GREEN, HGEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(220.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.hierophantgreen")).proCount(3).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the calamari\n    Light>Barrage>Net Set>delay.Emarald Splash>crouch.Emerald Splash>\n    ...Extend>crouch.Light~Light\n    ...Sendoff")).skinName((Component)Component.m_237113_((String)"Cold")).skinName((Component)Component.m_237113_((String)"Burning")).skinName((Component)Component.m_237113_((String)"Seaside")).build()).summonData(SummonData.of(JSoundRegistry.HG_SUMMON)).build();
    public static final SimpleUppercutAttack<HGEntity> AIR_LIGHT = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 7, 14, 0.75f, 5.0f, 15, 1.5f, 0.4f, -0.3f, 0.4f).withAnim(State.AIR_LIGHT)).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Backward Flip Kick"), (Component)Component.m_237113_((String)"launches up"));
    public static final KnockdownAttack<HGEntity> CROUCHING_LIGHT_FOLLOWUP = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 9, 16, 0.75f, 6.0f, 13, 1.75f, 0.75f, 0.4f, 35).withSound(JSoundRegistry.HG_CROUCH_LIGHT)).withAnim(State.CROUCHING_LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Sweep"), (Component)Component.m_237113_((String)"1.5s knockdown"));
    public static final SimpleAttack<HGEntity> CROUCHING_LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(7, 11, 0.75f, 5.0f, 12, 0.15f, 0.3f).withAnim(State.CROUCHING_LIGHT)).withFollowup(CROUCHING_LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Low Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleUppercutAttack<HGEntity> LIGHT_FOLLOWUP = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 10, 15, 0.75f, 6.0f, 13, 1.75f, 0.5f, -0.2f, 0.4f).withSound(JSoundRegistry.HG_LIGHT_FOLLOWUP)).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_3)).withBlockStun(4)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Uppercut"), (Component)Component.m_237113_((String)"reset tool, combos back into light"));
    public static final SimpleAttack<HGEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(7, 9, 0.75f, 5.0f, 10, 0.15f, 0.2f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(CROUCHING_LIGHT)).withAerialVariant(AIR_LIGHT)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleAttack<HGEntity> SENDOFF = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 11, 20, 1.0f, 8.0f, 16, 2.0f, 1.5f, 0.0f).withSound(JSoundRegistry.WS_DONUT)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_3)).withLaunch()).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHyperArmor()).withInfo((Component)Component.m_237113_((String)"Sendoff"), (Component)Component.m_237113_((String)"uninterruptible launcher"));
    public static final SimpleMultiHitAttack<HGEntity> BARRAGE = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(200, 28, 1.0f, 2.0f, 20, 2.0f, 0.3f, 0.25f, (IntCollection)IntSet.of((int[])new int[]{3, 9, 15, 17, 25})).withSound(JSoundRegistry.HG_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, medium stun"));
    public static final SimpleAttack<HGEntity> EXTEND_FORWARD_SECOND = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 13, 21, 1.0f, 5.0f, 16, 0.0f, 0.4f, 0.0f).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withExtraHitBox(2.5, -0.5, 1.5)).withExtraHitBox(3.5, -0.6, 1.5)).withInfo((Component)Component.m_237113_((String)"Extend (Forward, Second Hit)"), (Component)Component.m_237119_());
    public static final SimpleAttack<HGEntity> EXTEND_FORWARD = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 10, 21, 1.0f, 5.0f, 15, 1.5f, 0.7f, 0.2f).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withSound(JSoundRegistry.HG_EXTEND)).withExtraHitBox(2.0, -0.1, 1.5)).withFinisher(12, EXTEND_FORWARD_SECOND)).withInfo((Component)Component.m_237113_((String)"Extend (Forward)"), (Component)Component.m_237113_((String)"Hierophant extends its arm forward in a far-reaching attack"));
    public static final SimpleAttack<HGEntity> EXTEND_UP_SECOND = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 13, 21, 1.0f, 5.0f, 16, 0.0f, 0.4f, 0.0f).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withExtraHitBox(2.0, 0.5, 1.5)).withExtraHitBox(3.0, 0.75, 1.5)).withInfo((Component)Component.m_237113_((String)"Extend (Upward, Second Hit)"), (Component)Component.m_237119_());
    public static final SimpleAttack<HGEntity> EXTEND_UP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 10, 21, 1.0f, 5.0f, 15, 1.5f, 0.7f, -0.2f).withCrouchingVariant(EXTEND_FORWARD)).withSound(JSoundRegistry.HG_EXTEND)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withExtraHitBox(2.0, 0.1, 1.5)).withFinisher(12, EXTEND_UP_SECOND)).withInfo((Component)Component.m_237113_((String)"Extend (Upward)"), (Component)Component.m_237113_((String)"Hierophant extends its arm upward in a far-reaching attack"));
    public static final EmeraldSplashAttack EMERALD_SPLASH = (EmeraldSplashAttack)((EmeraldSplashAttack)new EmeraldSplashAttack(0, 12, 1.0f, 0.0f, 0, 0.0f, 0.0f, IntSet.of((int)1, (int)3, (int)5), 1.5f, false).withSound(JSoundRegistry.HG_SPLASH)).withInfo((Component)Component.m_237113_((String)"Emerald Splash (Fire)"), (Component)Component.m_237119_());
    public static final SimpleHoldableMove<HGEntity> EMERALD_CHARGE = (SimpleHoldableMove)((SimpleHoldableMove)new SimpleHoldableMove<HGEntity>(100, 0, 40, 1.0f, 7).withFollowup(EMERALD_SPLASH)).withInfo((Component)Component.m_237113_((String)"Emerald Splash"), (Component)Component.m_237113_((String)"Fires 3 bursts of emeralds at the opponent.\nBursts contain 3-6 emeralds depending on how long you hold."));
    public static final NetSetMove NET_SET = (NetSetMove)((NetSetMove)new NetSetMove(200, 9, 15, 1.0f).withSound(JSoundRegistry.HG_NET_SET)).withInfo((Component)Component.m_237113_((String)"Tentacle Place"), (Component)Component.m_237113_((String)"Places a Hierophant Tentacle at Hierophant's feet.\nTentacles automatically grasp anything that touches them that isn't the user (10s cooldown).\nUse crouching Emerald Splash to fire from the Tentacles remotely.\nTentacles cannot fire if grabbing.\n"));
    public static final PilotModeMove<HGEntity> PILOT_MODE = (PilotModeMove)new PilotModeMove(20).withInfo((Component)Component.m_237113_((String)"Pilot Mode"), (Component)Component.m_237119_());
    public static final EmeraldSplashAttack EMERALD_SUPER = (EmeraldSplashAttack)((EmeraldSplashAttack)new EmeraldSplashAttack(500, 40, 1.0f, 0.0f, 0, 0.0f, 0.0f, IntSet.of((int[])new int[]{12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32}), 2.0f, true).withReflect().withSound(JSoundRegistry.HG_SPLASH)).withInfo((Component)Component.m_237113_((String)"All-Consuming Emerald Splash"), (Component)Component.m_237113_((String)"Fires a long, oppressive stream of emeralds at the opponent.\nThese emeralds may bounce off walls up to 5 times.\nNearby Tentacles will do the same, but immediately start wilting after use.\n"));

    public HGEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.HIEROPHANT_GREEN.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.2f, 0.9f, 0.2f), new Vector3f(0.2f, 0.2f, 0.9f), new Vector3f(0.4f, 0.4f, 0.5f), new Vector3f(1.0f, 0.65f, 0.44f)};
    }

    private static void registerMoves(MoveMap<HGEntity, State> moves) {
        MoveMap.Entry<HGEntity, State> light = moves.register(MoveClass.LIGHT, LIGHT, State.LIGHT);
        light.withFollowup(State.LIGHT_FOLLOWUP);
        MoveMap.Entry<HGEntity, State> crouchingLight = light.withCrouchingVariant(State.CROUCHING_LIGHT);
        crouchingLight.withFollowup(State.CROUCHING_LIGHT_FOLLOWUP);
        light.withAerialVariant(State.AIR_LIGHT);
        moves.register(MoveClass.HEAVY, SENDOFF, State.SENDOFF);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, EMERALD_CHARGE, State.EMERALD_CHARGE).withFollowup(State.EMERALD_SPLASH);
        moves.register(MoveClass.SPECIAL2, EXTEND_UP, State.EXTEND_UP).withCrouchingVariant(State.EXTEND_FORWARD);
        moves.register(MoveClass.SPECIAL3, NET_SET, State.NET_SET);
        moves.register(MoveClass.ULTIMATE, EMERALD_SUPER, State.EMERALD_SUPER);
        moves.register(MoveClass.UTILITY, PILOT_MODE);
    }

    private void fireNearbyNets(@NonNull LivingEntity user, boolean isSuper) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        List nets = this.m_9236_().m_6443_(HGNetEntity.class, this.m_20191_().m_82400_(64.0), EntitySelector.f_20406_);
        HGEntity shooter = this.isRemote() ? this : user;
        Vec3 heightOffset = GravityChangerAPI.getEyeOffset((Entity)shooter).m_82490_(0.5);
        Vec3 eyePos = shooter.m_20182_().m_82549_(heightOffset);
        if (nets.isEmpty()) {
            return;
        }
        Vec3 pos = JUtils.raycastAll((Entity)shooter, eyePos, eyePos.m_82549_(user.m_20154_().m_82490_(96.0)), ClipContext.Fluid.NONE, entity -> {
            IOwnable ownable;
            return !(entity instanceof IOwnable) || (ownable = (IOwnable)entity).getMaster() != user;
        }).m_82450_();
        for (HGNetEntity net : nets) {
            if (net.getMaster() != user) continue;
            net.tryFireAt(pos, isSuper);
        }
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        LivingEntity user = this.getUserOrThrow();
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        if (moveClass != MoveClass.SPECIAL1 || !user.m_6144_()) {
            if (moveClass == MoveClass.ULTIMATE) {
                if (super.initMove(MoveClass.ULTIMATE)) {
                    this.fireNearbyNets(user, true);
                    return true;
                }
                return false;
            }
            return super.initMove(moveClass);
        }
        if (!JUtils.canAct(user)) {
            return false;
        }
        this.fireNearbyNets(user, false);
        return true;
    }

    @Override
    public void togglePilotMode() {
        this.setRemote(!this.isRemote());
        this.switchMoveSet(MOVE_SET.getName());
    }

    @Override
    public double getEngagementDistance() {
        return 64.0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        boolean isRemote = this.isRemote();
        this.m_20242_(isRemote);
        if (!isRemote) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            JCraft.getClientEntityHandler().hierophantGreenRemoteClientTick(this);
        } else {
            double f = this.getRemoteForwardInput();
            double s = this.getRemoteSideInput();
            this.tickRemoteMovement(f, s, this.getRemoteJumpInput(), this.getRemoteSneakInput());
            if (this.getState() == State.IDLE && this.getMoveStun() <= 0) {
                if (s > 0.0) {
                    this.setStateNoReset(State.RIGHT);
                }
                if (s < 0.0) {
                    this.setStateNoReset(State.LEFT);
                }
                if (f < 0.0) {
                    this.setStateNoReset(State.BACKWARD);
                }
                if (f > 0.0) {
                    this.setStateNoReset(State.FORWARD);
                }
            }
        }
    }

    public void tickRemoteMovement(double f, double s, boolean jump, boolean sneak) {
        this.m_183634_();
        Vec3 pos = this.m_20182_();
        if (this.lastRemoteInputTime - this.f_19797_ > 2) {
            this.updateRemoteInputs(0, 0, false, false);
        }
        Vec3 rotVec = new Vec3(this.m_20154_().f_82479_, 0.0, this.m_20154_().f_82481_).m_82541_();
        double dragMult = this.getMoveStun() > 0 ? 0.1 : 0.2;
        double moveSpeed = 0.5;
        Vec3 upVec = GravityChangerAPI.getEyeOffset((Entity)this);
        if (jump) {
            this.remoteSpeed = this.remoteSpeed.m_82549_(upVec.m_82490_(0.5));
        }
        if (sneak) {
            this.remoteSpeed = this.remoteSpeed.m_82546_(upVec.m_82490_(0.5));
        }
        this.remoteSpeed = this.remoteSpeed.m_82549_(rotVec.m_82490_(f * 0.5)).m_82549_(rotVec.m_82524_(1.5707963f).m_82490_(s * 0.5));
        this.remoteSpeed = this.remoteSpeed.m_82490_(dragMult);
        Vec3 userPos = this.getUserOrThrow().m_20182_();
        if (pos.m_82549_(this.remoteSpeed).m_82557_(userPos) > 900.0) {
            this.remoteSpeed = userPos.m_82546_(pos).m_82490_(0.025);
        }
        this.m_5997_(-this.m_20184_().f_82479_ * 0.2, -this.m_20184_().f_82480_ * 0.2, -this.m_20184_().f_82481_ * 0.2);
        this.m_5997_(this.remoteSpeed.f_82479_, this.remoteSpeed.f_82480_, this.remoteSpeed.f_82481_);
        this.f_19812_ = true;
        this.f_19864_ = true;
    }

    @Override
    @NonNull
    public HGEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.hg.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<HGEntity>
    {
        IDLE((hg, builder) -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.hg.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.light"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.light_followup"))),
        CROUCHING_LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.crouching_light"))),
        CROUCHING_LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.crouching_light_followup"))),
        AIR_LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.air_light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.hg.block"))),
        SENDOFF(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.sendoff"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.hg.barrage"))),
        NET_SET(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.net_place"))),
        EMERALD_CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.emerald_charge"))),
        EMERALD_SPLASH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.emerald_splash"))),
        EMERALD_SUPER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.emerald_super"))),
        EXTEND_UP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.extend_up"))),
        EXTEND_FORWARD(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.extend_forward"))),
        UPPERCUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.hg.uppercut"))),
        FORWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.hg.forw"))),
        BACKWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.hg.back"))),
        LEFT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.hg.left"))),
        RIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.hg.right")));

        private final BiConsumer<HGEntity, AnimationState<HGEntity>> animator;

        private State(Consumer<AnimationState<HGEntity>> animator) {
            this((HGEntity whiteSnake, AnimationState<HGEntity> builder) -> animator.accept((AnimationState<HGEntity>)builder));
        }

        private State(BiConsumer<HGEntity, AnimationState<HGEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(HGEntity attacker, AnimationState<HGEntity> builder) {
            this.animator.accept(attacker, builder);
        }
    }
}

