/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.PlaySoundAction;
import net.arna.jcraft.common.attack.moves.horus.ChasingFreezeAttack;
import net.arna.jcraft.common.attack.moves.horus.HorusBarrageAttack;
import net.arna.jcraft.common.attack.moves.horus.HorusDetonateAttack;
import net.arna.jcraft.common.attack.moves.horus.HorusDivekickAttack;
import net.arna.jcraft.common.attack.moves.horus.IceLanceAttack;
import net.arna.jcraft.common.attack.moves.horus.IcicleFireAttack;
import net.arna.jcraft.common.attack.moves.horus.PerfectFreezeAttack;
import net.arna.jcraft.common.attack.moves.horus.ScatterAttack;
import net.arna.jcraft.common.attack.moves.horus.StompAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleHoldableMove;
import net.arna.jcraft.common.entity.projectile.LargeIcicleProjectile;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HorusEntity
extends StandEntity<HorusEntity, State> {
    public static final MoveSet<HorusEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.HORUS, HorusEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.horus")).proCount(2).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -bad birdie\n    Light~Light>dash>crouch.Light\n\n")).skinName((Component)Component.m_237113_((String)"Pearl")).skinName((Component)Component.m_237113_((String)"Dual")).skinName((Component)Component.m_237113_((String)"Evil Incarnation")).build()).summonData(SummonData.of(JSoundRegistry.HORUS_SUMMON)).build();
    public static final SimpleAttack<HorusEntity> LIGHT_CROUCHING_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 15, 25, 0.75f, 7.0f, 25, 1.85f, 1.5f, 0.2f).withAnim(State.IMPALE)).withImpactSound(JSoundRegistry.IMPACT_9)).withBlockStun(25)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Impale"), (Component)Component.m_237113_((String)"slow reset tool, high stun and blockstun"));
    public static final SimpleAttack<HorusEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 9, 13, 0.75f, 6.0f, 10, 1.5f, 1.0f, 0.2f).withAnim(State.LIGHT_FOLLOWUP)).withCrouchingVariant(LIGHT_CROUCHING_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_3)).withLaunch()).withBlockStun(4)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Finisher"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<HorusEntity> LIGHT_LOW = (SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(9, 5, 9, 0.95f, 4.0f, 8, 1.25f, 0.25f, 0.5f).withImpactSound(JSoundRegistry.IMPACT_9)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withInfo((Component)Component.m_237113_((String)"Low Claw"), (Component)Component.m_237113_((String)"faster and further hitting than standing, but doesn't combo into anything"));
    public static final SimpleAttack<HorusEntity> LIGHT_AIR = (SimpleAttack)((SimpleAttack)new SimpleAttack(11, 6, 11, 0.75f, 5.0f, 12, 1.5f, 0.25f, 0.5f).withImpactSound(JSoundRegistry.IMPACT_9)).withInfo((Component)Component.m_237113_((String)"Downward Claw"), (Component)Component.m_237113_((String)"quick combo starter, meant for air-to-ground"));
    public static final SimpleAttack<HorusEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(6, 11, 0.75f, 5.0f, 12, 0.2f, 0.0f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(LIGHT_LOW)).withAerialVariant(LIGHT_AIR)).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Slash"), (Component)Component.m_237113_((String)"quick combo starter, has a standing and crouching followup"));
    public static final HorusBarrageAttack BARRAGE = (HorusBarrageAttack)((HorusBarrageAttack)new HorusBarrageAttack(240, 5, 80, 0.75f, 0.0f, 0, 0.0f, 0.0f, 0.0f, 5).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"4s max duration, can be held"))).withAction(PlaySoundAction.playSound(JSoundRegistry.HORUS_BARRAGE_FIRE));
    public static final HorusDetonateAttack DETONATE = (HorusDetonateAttack)((HorusDetonateAttack)new HorusDetonateAttack(0, 10, 12, 0.75f).withAnim(State.DETONATE)).withInfo((Component)Component.m_237113_((String)"Detonate"), (Component)Component.m_237119_());
    public static final StompAttack STOMP = (StompAttack)((StompAttack)((StompAttack)((StompAttack)((StompAttack)((StompAttack)new StompAttack(22, 11, 22, 0.75f, 9.0f, 12, 1.3f, 0.6f, 0.4f).withFollowup(DETONATE)).withSound(JSoundRegistry.HORUS_STOMP)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Stomp"), (Component)Component.m_237113_((String)"summons a large icicle, press Heavy again to detonate it"));
    public static final HorusDivekickAttack DIVEKICK = (HorusDivekickAttack)((HorusDivekickAttack)((HorusDivekickAttack)((HorusDivekickAttack)new HorusDivekickAttack(240, 8, 25, 8.0f, 6.0f, 19, 1.5f, 0.23f, 0.3f).withImpactSound(JSoundRegistry.IMPACT_1)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Beak Dive"), (Component)Component.m_237113_((String)"Lasts longer the lower you aim while starting the move.\nStalls the user in the air when starting.\nRemoves fall damage."));
    public static final IceLanceAttack LANCE = (IceLanceAttack)((IceLanceAttack)((IceLanceAttack)new IceLanceAttack(80, 18, 24, 0.75f).withAnim(State.LANCE)).withInfo((Component)Component.m_237113_((String)"Ice Lance"), (Component)Component.m_237113_((String)"Also slow, slightly higher cooldown.\nFires a large icicle that detonates after 2s."))).withSound(JSoundRegistry.HORUS_LANCE_CHARGE);
    public static final ScatterAttack SCATTER = (ScatterAttack)((ScatterAttack)((ScatterAttack)new ScatterAttack(60, 16, 20, 0.75f).withCrouchingVariant(LANCE)).withInfo((Component)Component.m_237113_((String)"Scatter"), (Component)Component.m_237113_((String)"Relatively slow, very low cooldown.\nFires 6 icicles that bounce off walls."))).withSound(JSoundRegistry.HORUS_SCATTER);
    public static final IcicleFireAttack CHARGE_FIRE = (IcicleFireAttack)new IcicleFireAttack(0, 1, 11, 0.75f).withInfo((Component)Component.m_237113_((String)"Icicle Fire"), (Component)Component.m_237119_());
    public static final SimpleHoldableMove<HorusEntity> CHARGE_ICICLE = (SimpleHoldableMove)((SimpleHoldableMove)((SimpleHoldableMove)new SimpleHoldableMove<HorusEntity>(0, IcicleFireAttack.MAX_ICICLE_CHARGE_TIME + 1, IcicleFireAttack.MAX_ICICLE_CHARGE_TIME, 0.75f, 9).withFollowup(CHARGE_FIRE)).withArmor(3)).withInfo((Component)Component.m_237113_((String)"Icicle Charge"), (Component)Component.m_237113_((String)"3 armor points while charging\nCan be held, and released 0.45s in.\nIf charged fully, attack becomes unblockable and launches far."));
    public static final ChasingFreezeAttack PLACE = (ChasingFreezeAttack)((ChasingFreezeAttack)new ChasingFreezeAttack(200, 8, 14, 0.75f).withInfo((Component)Component.m_237113_((String)"Chasing Freeze"), (Component)Component.m_237119_())).withSound(JSoundRegistry.HORUS_PlACE_CREEPING_ICE);
    public static final PerfectFreezeAttack PERFECT_FREEZE = (PerfectFreezeAttack)((PerfectFreezeAttack)new PerfectFreezeAttack(1000, 14, 30, 0.0f, 4.0f, 10, 2.5f, 0.3f, 0.0f).withInfo((Component)Component.m_237113_((String)"Perfect Freeze"), (Component)Component.m_237113_((String)"freezes all nearby enemies\nsummons 3 ice branches to chase opponents\nstops all nearby projectiles"))).withSound(JSoundRegistry.HORUS_PlACE_CREEPING_ICE);
    private WeakReference<LargeIcicleProjectile> lastLargeIcicle = new WeakReference<Object>(null);

    public HorusEntity(Level world) {
        super((StandType)JStandTypeRegistry.HORUS.get(), world);
        this.auraColors = new Vector3f[]{new Vector3f(0.2f, 0.5f, 0.8f), new Vector3f(0.3f, 0.6f, 1.0f), new Vector3f(1.0f, 0.3f, 0.7f), new Vector3f(1.0f, 0.0f, 0.0f)};
    }

    public LargeIcicleProjectile getLastLargeIcicle() {
        return (LargeIcicleProjectile)((Object)this.lastLargeIcicle.get());
    }

    public void setLastLargeIcicle(LargeIcicleProjectile icicle) {
        this.lastLargeIcicle = new WeakReference<LargeIcicleProjectile>(icicle);
    }

    private static void registerMoves(MoveMap<HorusEntity, State> moves) {
        MoveMap.Entry<HorusEntity, State> light = moves.register(MoveClass.LIGHT, LIGHT, State.LIGHT);
        light.withFollowup(State.LIGHT_FOLLOWUP).withCrouchingVariant(State.IMPALE);
        light.withCrouchingVariant(State.LIGHT_LOW);
        light.withAerialVariant(State.LIGHT_AIR);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.HEAVY, STOMP, State.STOMP).withFollowup(State.DETONATE);
        moves.registerImmediate(MoveClass.SPECIAL1, SCATTER, State.SCATTER);
        moves.register(MoveClass.SPECIAL2, CHARGE_ICICLE, State.CHARGE_ICICLE).withFollowup(State.CHARGE_FIRE);
        moves.register(MoveClass.SPECIAL3, PLACE, State.PLACE);
        moves.register(MoveClass.ULTIMATE, PERFECT_FREEZE, State.ULTIMATE);
        moves.register(MoveClass.UTILITY, DIVEKICK, State.DIVEKICK);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.HEAVY)) {
            return true;
        }
        if (moveClass == MoveClass.LIGHT && this.getCurrentMove() != null && this.getCurrentMove().getMoveClass() == MoveClass.LIGHT && this.getMoveStun() < this.getCurrentMove().getWindupPoint()) {
            AbstractMove followup = this.getCurrentMove().getFollowup();
            if (followup != null) {
                if (this.getUserOrThrow().m_20163_()) {
                    followup = followup.getCrouchingVariant();
                }
                if (followup != null) {
                    this.setMove(followup, (State)Objects.requireNonNull(followup).getAnimation());
                }
            }
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        int moveStun = this.getMoveStun();
        LivingEntity user = JUtils.getUserIfStand((LivingEntity)this);
        if (user != null) {
            FrostWalkerEnchantment.m_45018_((LivingEntity)user, (Level)this.m_9236_(), (BlockPos)this.m_20097_().m_7494_(), (int)2);
        }
        if (moveStun > IcicleFireAttack.MAX_ICICLE_CHARGE_TIME + 1 || !this.m_9236_().m_5776_()) {
            return;
        }
        if (this.getState() == State.CHARGE_ICICLE) {
            double completion = (double)moveStun / ((double)IcicleFireAttack.MAX_ICICLE_CHARGE_TIME + 1.0);
            Vec3 direction = this.m_20154_().m_82549_(GravityChangerAPI.getEyeOffset((Entity)this).m_82490_(0.75));
            if (this.f_19796_.m_188500_() >= completion) {
                Vec3 offset = new Vec3(this.f_19796_.m_188583_() * completion, this.f_19796_.m_188583_() * completion, this.f_19796_.m_188583_() * completion);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + direction.f_82479_ + offset.f_82479_, this.m_20186_() + direction.f_82480_ + offset.f_82480_, this.m_20189_() + direction.f_82481_ + offset.f_82481_, -offset.f_82479_ / 6.0, -offset.f_82480_ / 6.0, -offset.f_82481_ / 6.0);
            }
            this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ParticleTypes.f_123764_ : LargeIcicleProjectile.ICE_PARTICLE), this.m_20185_() + direction.f_82479_, this.m_20186_() + direction.f_82480_, this.m_20189_() + direction.f_82481_, 0.0, 0.0, 0.0);
        } else if (this.getState() == State.ULTIMATE && this.getMoveStun() == PERFECT_FREEZE.getWindupPoint()) {
            for (int i = 0; i < 64; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + this.f_19796_.m_188583_(), this.m_20189_() + this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_());
                this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ParticleTypes.f_123764_ : LargeIcicleProjectile.ICE_PARTICLE), this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + this.f_19796_.m_188583_(), this.m_20189_() + this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_());
            }
        }
    }

    @Override
    @NonNull
    public HorusEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.horus.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<HorusEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.horus.idle"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.horus.block"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.light"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.light_followup"))),
        LIGHT_LOW(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.light_low"))),
        LIGHT_AIR(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.light_air"))),
        IMPALE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.impale"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.barrage"))),
        STOMP(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.stomp"))),
        DETONATE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.detonate"))),
        DIVEKICK(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.divekick"))),
        DIVEKICK_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.divekick_hit"))),
        SCATTER(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.scatter"))),
        CHARGE_ICICLE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.charge_icicle"))),
        CHARGE_FIRE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.charge_fire"))),
        PLACE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.place"))),
        ULTIMATE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.ultimate"))),
        LANCE(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.horus.lance")));

        private final Consumer<AnimationState<HorusEntity>> animator;

        private State(Consumer<AnimationState<HorusEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(HorusEntity attacker, AnimationState<HorusEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

