/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.RenderUtils;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust.BTDDetonateAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust.BTDGrabHitAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust.BTDPlantAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust.BubbleAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust.BubbleCounterAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust.ElbowAttack;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.entity.stand.AbstractKillerQueenEntity;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class KQBTDEntity
extends AbstractKillerQueenEntity<KQBTDEntity, State> {
    public static final MoveSet<KQBTDEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.KILLER_QUEEN_BITES_THE_DUST, KQBTDEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-30.0f).evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.kqbtd")).proCount(4).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs:\n-the kitty cat\nLight~Low>Barrage>Bomb Plant/Bites the Dust Plant\n\n-the ol razzle dazzle\n(Already bomb planted) Light~Low>Barrage>Light>Elbow>Detonate")).skinName((Component)Component.m_237113_((String)"Veiled")).skinName((Component)Component.m_237113_((String)"Back from the Dead")).skinName((Component)Component.m_237113_((String)"Garf")).build()).summonData(SummonData.builder().sound((Supplier<SoundEvent>)JSoundRegistry.KQBTD_SUMMON).playGenericSound(true).build()).build();
    public static final Supplier<IPoseModifier> POSE = AbstractKillerQueenEntity.POSE;
    public static final ElbowAttack ELBOW = (ElbowAttack)((ElbowAttack)((ElbowAttack)((ElbowAttack)((ElbowAttack)new ElbowAttack(0, 5, 9, 0.75f, 7.5f, 10, 1.0f, 1.1f, 0.0f).withSound(JSoundRegistry.KQBTD_ELBOW)).withImpactSound(JSoundRegistry.IMPACT_4)).withHitSpark(JParticleType.HIT_SPARK_2)).withBlockStun(3)).withInfo((Component)Component.m_237113_((String)"Elbow"), (Component)Component.m_237113_((String)"fast, short-range knockback, very low blockstun"));
    public static final BubbleCounterAttack BUBBLE_COUNTER = (BubbleCounterAttack)new BubbleCounterAttack(480, 5, 20, 1.0f).withInfo((Component)Component.m_237113_((String)"Stray Cat Counter"), (Component)Component.m_237113_((String)"0.25s windup counter, turns opponent into your primary bomb"));
    public static final BubbleAttack BUBBLE = (BubbleAttack)((BubbleAttack)((BubbleAttack)new BubbleAttack(60, 15, 18, 0.75f).withCrouchingVariant(BUBBLE_COUNTER)).withSound(JSoundRegistry.KQ_UPPERCUT)).withInfo((Component)Component.m_237113_((String)"Stray Cat Bubble"), (Component)Component.m_237113_((String)"launches an explosive bubble guided by your view rotation"));
    public static final BTDDetonateAttack BTD_DETONATE = (BTDDetonateAttack)((BTDDetonateAttack)new BTDDetonateAttack(20, 5, 6, 0.75f).withSound(JSoundRegistry.KQ_DETONATE)).withInfo((Component)Component.m_237113_((String)"Detonate"), (Component)Component.m_237119_());
    public static final BTDPlantAttack BTD_PLANT = (BTDPlantAttack)((BTDPlantAttack)((BTDPlantAttack)new BTDPlantAttack(800, 14, 24, 1.0f, 10, 1.5f, 0.0f).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withBlockStun(8)).withInfo((Component)Component.m_237113_((String)"Bites the Dust Plant"), (Component)Component.m_237113_((String)"press the same button to detonate, sending the affected enemy back to their previous location"));
    public static final BTDGrabHitAttack GRAB_HIT = (BTDGrabHitAttack)((BTDGrabHitAttack)((BTDGrabHitAttack)new BTDGrabHitAttack(0, 42, 0.75f, 5.0f, 15, 2.0f, 0.0f, 0.5f, (IntCollection)IntSet.of((int)8, (int)22, (int)32)).withImpactSound(JSoundRegistry.IMPACT_1)).withStunType(StunType.UNBURSTABLE)).withInfo((Component)Component.m_237113_((String)"Takedown (hit)"), (Component)Component.m_237119_());
    public static final GrabAttack<KQBTDEntity, State> GRAB = (GrabAttack)new GrabAttack<KQBTDEntity, State>(220, 12, 28, 0.75f, 0.0f, 20, 1.75f, 0.1f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT), 31, 1.0).withInfo((Component)Component.m_237113_((String)"Takedown"), (Component)Component.m_237113_((String)"high damage grab"));
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LOW = (SimpleAttack)AbstractKillerQueenEntity.LOW.copy().withAnim(State.LOW);
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)AbstractKillerQueenEntity.LIGHT_FOLLOWUP.copy().withAnim(State.LIGHT_FOLLOWUP)).withFollowup(LOW);
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LIGHT = (SimpleAttack)AbstractKillerQueenEntity.LIGHT.copy().withFollowup(LIGHT_FOLLOWUP);
    private WeakReference<LivingEntity> btdEntity = new WeakReference<Object>(null);
    private Vec3 btdPos = Vec3.f_82478_;

    public KQBTDEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.KILLER_QUEEN_BITES_THE_DUST.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.9f, 0.7f, 0.8f), new Vector3f(0.3f, 1.0f, 0.5f), new Vector3f(0.8f, 0.2f, 0.2f), new Vector3f(0.8f, 0.6f, 0.2f)};
    }

    @Override
    public Vector3f getAuraColor() {
        int skin = this.getSkin();
        float deltaTick = (float)RenderUtils.getCurrentTick() * 50.0f % 2.0f;
        return switch (skin) {
            case 1 -> new Vector3f((Vector3fc)this.auraColors[skin]).mul(1.0f, deltaTick, 1.0f);
            case 2 -> new Vector3f((Vector3fc)this.auraColors[skin]).mul(deltaTick, 1.0f, 1.0f);
            case 3 -> new Vector3f((Vector3fc)this.auraColors[skin]).mul(1.0f, deltaTick, deltaTick);
            default -> new Vector3f((Vector3fc)this.auraColors[skin]).mul(deltaTick * 0.5f, deltaTick, 1.0f);
        };
    }

    private static void registerMoves(MoveMap<KQBTDEntity, State> moves) {
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.UTILITY, EXPLOSIVE_DASH);
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
        moves.register(MoveClass.HEAVY, ELBOW, State.HEAVY);
        moves.register(MoveClass.SPECIAL1, BOMB_PLANT, State.BOMB_PLANT);
        moves.register(MoveClass.SPECIAL2, BUBBLE, State.BUBBLE).withCrouchingVariant(State.BUBBLE_COUNTER);
        moves.register(MoveClass.SPECIAL3, GRAB, State.GRAB);
        moves.register(MoveClass.ULTIMATE, BTD_PLANT, State.BTD_PLANT);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (moveClass == MoveClass.ULTIMATE) {
            if (this.btdEntity.get() != null) {
                return this.handleMove(BTD_DETONATE, CooldownType.ULTIMATE, State.DETONATE);
            }
            return this.handleMove(MoveClass.ULTIMATE);
        }
        return super.initMove(moveClass);
    }

    @Override
    @NonNull
    public KQBTDEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NonNull
    protected String getSummonAnimation() {
        return "animation.kqbtd.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    @Override
    protected State getDetonateState() {
        return State.DETONATE;
    }

    public WeakReference<LivingEntity> getBtdEntity() {
        return this.btdEntity;
    }

    public void setBtdEntity(WeakReference<LivingEntity> btdEntity) {
        this.btdEntity = btdEntity;
    }

    public Vec3 getBtdPos() {
        return this.btdPos;
    }

    public void setBtdPos(Vec3 btdPos) {
        this.btdPos = btdPos;
    }

    public static enum State implements StandAnimationState<KQBTDEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.kqbtd.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.kqbtd.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.kqbtd.barrage"))),
        DETONATE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.detonate"))),
        BOMB_PLANT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.bombplant"))),
        BUBBLE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.bubble"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.light_followup"))),
        LOW(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.low"))),
        BUBBLE_COUNTER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.bubblecounter"))),
        COUNTER_MISS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.counter_miss"))),
        BTD_PLANT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.btdplant"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kqbtd.grab_hit")));

        private final Consumer<AnimationState<KQBTDEntity>> animator;

        private State(Consumer<AnimationState<KQBTDEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(KQBTDEntity attacker, AnimationState<KQBTDEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

