/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.attack.moves.killerqueen.CoinTossMove;
import net.arna.jcraft.common.attack.moves.killerqueen.KQGrabAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.KQGrabHitAttack;
import net.arna.jcraft.common.attack.moves.killerqueen.SheerHeartAttackAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.entity.stand.AbstractKillerQueenEntity;
import net.arna.jcraft.common.entity.stand.KQBTDEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public final class KillerQueenEntity
extends AbstractKillerQueenEntity<KillerQueenEntity, State> {
    public static final MoveSet<KillerQueenEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.KILLER_QUEEN, KillerQueenEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-30.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.killerqueen")).proCount(4).conCount(3).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -Standard bomb plant confirm and SHA setup\n    Light~Light>Barrage>Bomb plant>Detonate(>Sheer Heart Attack)\n\n    -Confirm while bomb plant is on cd\n    Light~Light>Barrage>Heavy(>Sheer Heart Attack)")).skinName((Component)Component.m_237113_((String)"Gunpowder")).skinName((Component)Component.m_237113_((String)"Deadly")).skinName((Component)Component.m_237113_((String)"1999")).build()).build();
    public static final Supplier<IPoseModifier> POSE = AbstractKillerQueenEntity.POSE;
    public static final SimpleAttack<KillerQueenEntity> HEAVY = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 16, 24, 0.75f, 9.0f, 10, 2.0f, 1.75f, 0.0f).withHitSpark(JParticleType.HIT_SPARK_3)).withSound(JSoundRegistry.KQ_UPPERCUT)).withSound(JSoundRegistry.KQ_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_4)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Haymaker"), (Component)Component.m_237113_((String)"slow, uninterruptible launcher"));
    public static final SheerHeartAttackAttack SHEER_HEART_ATTACK = (SheerHeartAttackAttack)new SheerHeartAttackAttack(1000, 16, 20, 1.0f).withInfo((Component)Component.m_237113_((String)"Sheer Heart Attack"), (Component)Component.m_237113_((String)"creates an automatic, heat-seeking sub-stand that explodes on contact, reflects 25% damage back to owner"));
    public static final KQGrabHitAttack GRAB_HIT = (KQGrabHitAttack)new KQGrabHitAttack(0, 13, 20, 1.0f, 8).withInfo((Component)Component.m_237113_((String)"Grab (hit)"), (Component)Component.m_237119_());
    public static final KQGrabAttack GRAB = (KQGrabAttack)new KQGrabAttack(300, 12, 20, 0.75f, 0.0f, 20, 1.75f, 0.1f, 0.0f, GRAB_HIT).withInfo((Component)Component.m_237113_((String)"Grab"), (Component)Component.m_237113_((String)"grabs opponent by the face, then detonates them, launching them upwards"));
    public static final CoinTossMove COIN_TOSS = new CoinTossMove(240);
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LOW = (SimpleAttack)AbstractKillerQueenEntity.LOW.copy().withAnim(KQBTDEntity.State.LOW);
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)AbstractKillerQueenEntity.LIGHT_FOLLOWUP.copy().withAnim(KQBTDEntity.State.LIGHT_FOLLOWUP)).withFollowup(LOW);
    public static final SimpleAttack<AbstractKillerQueenEntity<?, ?>> LIGHT = (SimpleAttack)AbstractKillerQueenEntity.LIGHT.copy().withFollowup(LIGHT_FOLLOWUP);

    public KillerQueenEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.KILLER_QUEEN.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.9f, 0.7f, 0.8f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.5f, 0.2f, 0.6f), new Vector3f(0.4f, 0.7f, 1.0f)};
    }

    private static void registerMoves(MoveMap<KillerQueenEntity, State> moves) {
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.UTILITY, EXPLOSIVE_DASH);
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
        moves.register(MoveClass.HEAVY, HEAVY, State.HEAVY);
        moves.register(MoveClass.SPECIAL1, BOMB_PLANT, State.BOMB_PLANT);
        moves.register(MoveClass.SPECIAL2, GRAB, State.GRAB);
        moves.register(MoveClass.SPECIAL3, COIN_TOSS);
        moves.register(MoveClass.ULTIMATE, SHEER_HEART_ATTACK, State.SHA);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (moveClass == MoveClass.SPECIAL1 && this.coin != null) {
            this.coin.m_146870_();
        }
        return super.initMove(moveClass);
    }

    @Override
    @NonNull
    public KillerQueenEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NonNull
    protected String getSummonAnimation() {
        return "animation.killerqueen.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    @Override
    protected State getDetonateState() {
        return State.DETONATE;
    }

    public static enum State implements StandAnimationState<KillerQueenEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.killerqueen.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.killerqueen.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.killerqueen.barrage"))),
        DETONATE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.detonate"))),
        BOMB_PLANT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.bombplant"))),
        SHA(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.sha"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.light_followup"))),
        LOW(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.low"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.killerqueen.grab_hit")));

        private final Consumer<AnimationState<KillerQueenEntity>> animator;

        private State(Consumer<AnimationState<KillerQueenEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(KillerQueenEntity attacker, AnimationState<KillerQueenEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

