/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.registries.RegistrySupplier;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.PoseModifierGroup;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.EffectAction;
import net.arna.jcraft.common.attack.moves.kingcrimson.BloodThrowAttack;
import net.arna.jcraft.common.attack.moves.kingcrimson.EpitaphAttack;
import net.arna.jcraft.common.attack.moves.kingcrimson.KCDonutAttack;
import net.arna.jcraft.common.attack.moves.kingcrimson.PredictionMove;
import net.arna.jcraft.common.attack.moves.kingcrimson.TimeEraseMove;
import net.arna.jcraft.common.attack.moves.shared.BarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.shared.TimeSkipMove;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class KingCrimsonEntity
extends StandEntity<KingCrimsonEntity, State> {
    public static final MoveSet<KingCrimsonEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.KING_CRIMSON, KingCrimsonEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleDistance(1.0f).idleRotation(-65.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.kingcrimson")).proCount(4).conCount(4).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the gamer (THE bnb)\n    Light>Barrage>delay.Move Cancel>Light>Heavy~Overhead\n\n    -the loop zoopler (sub optimal damage for a setup that kills them if you guess right)\n    Eye Chop>Donut>Light>Heavy~Overhead>Time Erase\n\n    -hits like a firetruck (death)\n    Donut>Move Cancel>Timeskip>Barrage>Move Cancel>Light>Heavy>Move Cancel>Eye Chop>Sweep\n")).skinName((Component)Component.m_237113_((String)"Royal")).skinName((Component)Component.m_237113_((String)"Manga")).skinName((Component)Component.m_237113_((String)"Nightshade")).build()).summonData(SummonData.of(JSoundRegistry.KC_SUMMON)).build();
    public static final Supplier<IPoseModifier> POSE = () -> PoseModifierGroup.builder().condition(ModifierCondition.USER_NOT_MOVING).modifier(PoseModifiers.parse("body.yRot += 30deg", new ModifierCondition[0])).modifier(PoseModifiers.parse("leftArm.yRot += 30deg;\nleftArm.z -= 2.1;\n", ModifierCondition.LEFT_ARM_EMPTY)).modifier(PoseModifiers.parse("rightArm.yRot += 30deg;\nrightArm.z += 2.1;\n", ModifierCondition.RIGHT_ARM_EMPTY_OR_ITEM)).modifier(PoseModifiers.parse("leftLeg.z -= 1;\nrightLeg.z += 1.5;\n\nrightLeg.yRot += 45deg;\n", new ModifierCondition[0])).build();
    public static final KnockdownAttack<KingCrimsonEntity> SWEEP = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 10, 20, 0.85f, 5.0f, 20, 1.5f, 0.4f, 0.3f, 35).withAnim(State.SWEEP)).withImpactSound(JSoundRegistry.IMPACT_4)).withBlockStun(6)).withExtraHitBox(1.0)).withInfo((Component)Component.m_237113_((String)"Sweep"), (Component)Component.m_237113_((String)"quick combo finisher, knocks down"));
    public static final SimpleMultiHitAttack<KingCrimsonEntity> DUAL_CHOP = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(40, 23, 0.85f, 4.0f, 21, 1.5f, 0.2f, -0.1f, (IntCollection)IntSet.of((int)10, (int)16)).noLoopPrevention()).withSound(JSoundRegistry.KC_DUAL_CHOP)).withCrouchingVariant(SWEEP)).withImpactSound(JSoundRegistry.IMPACT_4)).withInfo((Component)Component.m_237113_((String)"Dual Chop"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final BarrageAttack<KingCrimsonEntity> BARRAGE_FINISHER = (BarrageAttack)((BarrageAttack)((BarrageAttack)((BarrageAttack)new BarrageAttack(0, 0, 50, 0.85f, 1.0f, 10, 1.5f, 1.1f, 0.0f, 3).withImpactSound(JSoundRegistry.IMPACT_6)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Barrage (Final Hit)"), (Component)Component.m_237119_());
    public static final MainBarrageAttack<KingCrimsonEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 40, 0.85f, 1.0f, 20, 1.5f, 0.1f, 0.0f, 3, Blocks.f_50080_.m_155943_()).withFinisher(36, BARRAGE_FINISHER)).withSound(JSoundRegistry.KC_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender/finisher, medium stun, knocks back"));
    public static final KnockdownAttack<KingCrimsonEntity> OVERHEAD_HOOK = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 22, 32, 0.85f, 9.0f, 11, 2.0f, 1.5f, 0.0f, 35).withSound(JSoundRegistry.KC_HEAVY2)).withHitSpark(JParticleType.HIT_SPARK_3)).withBlockStun(10)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Overhead Hook"), (Component)Component.m_237113_((String)"long windup, knockdown"));
    public static final SimpleAttack<KingCrimsonEntity> VERTICAL_CHOP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 12, 19, 0.85f, 6.0f, 25, 1.5f, 0.6f, 0.0f).withFollowup(OVERHEAD_HOOK)).withFollowupFrame(7)).withSound(JSoundRegistry.KC_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_9)).withExtraHitBox(0.0, 0.5, 1.0)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Vertical Chop"), (Component)Component.m_237113_((String)"medium windup combo starter, has a true followup in the form of a slow, armored knockdown"));
    public static final BloodThrowAttack BLOOD_THROW = (BloodThrowAttack)new BloodThrowAttack(200, 10, 15, 1.0f).withInfo((Component)Component.m_237113_((String)"Blood Throw"), (Component)Component.m_237113_((String)"throws a stunning, blinding blood projectile, crouch while it comes out for higher speed"));
    public static final SimpleAttack<KingCrimsonEntity> EYE_CHOP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack<KingCrimsonEntity>(0, 20, 29, 1.0f, 9.0f, 27, 1.75f, 0.7f, -0.3f).withCrouchingVariant(BLOOD_THROW)).withSound(JSoundRegistry.KC_EYE_CHOP)).withImpactSound(JSoundRegistry.IMPACT_9)).withAction(EffectAction.inflict(MobEffects.f_19610_, 200, 0))).withHitSpark(JParticleType.HIT_SPARK_2)).withExtraHitBox(0.0, 0.5, 1.0)).withBlockStun(4)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Eye Chop"), (Component)Component.m_237113_((String)"blindness on hit, combo starter, low blockstun"));
    public static final KCDonutAttack DONUT = (KCDonutAttack)((KCDonutAttack)((KCDonutAttack)((KCDonutAttack)((KCDonutAttack)((KCDonutAttack)new KCDonutAttack(48, 30, 48, 1.0f, 14.0f, 10, 1.75f, 1.5f, 0.1f).withSound(JSoundRegistry.KC_DONUT)).withImpactSound(JSoundRegistry.IMPACT_7)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Donut"), (Component)Component.m_237113_((String)"slow, uninterruptable, extremely damaging launcher"));
    public static final EpitaphAttack EPITAPH = (EpitaphAttack)new EpitaphAttack(480, 4, 34, -1.0f).withInfo((Component)Component.m_237113_((String)"Epitaph"), (Component)Component.m_237113_((String)"0.2s windup, 1.5s counter, combo starter. Cannot be buffered."));
    public static final PredictionMove PREDICTION = (PredictionMove)((PredictionMove)((PredictionMove)new PredictionMove(480, 4, 104, -1.0f).withCrouchingVariant(EPITAPH)).withSound(JSoundRegistry.KC_EPITAPH)).withInfo((Component)Component.m_237113_((String)"Prediction/Move Cancel"), (Component)Component.m_237113_((String)"This move cannot be buffered.\nShows the projected future location of nearby entities, using Time Erase will force them to the projected locations. (20s TE cooldown)\nWhile predicting, you are slowed down.\nMove Cancel - Using Special 3 during any move cancels it and puts Time Erase on a 7s cooldown. (But does not require TE to be usable)"));
    public static final TimeEraseMove TIME_ERASE = (TimeEraseMove)new TimeEraseMove(1000, 5, 15, 1.0f, 120).withInfo((Component)Component.m_237113_((String)"Time Erase"), (Component)Component.m_237113_((String)"6 seconds duration, cancellable by doing anything with King Crimson"));
    public static final TimeSkipMove<KingCrimsonEntity> TIME_SKIP = (TimeSkipMove)((TimeSkipMove)new TimeSkipMove(300, 16.0).withSound((RegistrySupplier)JSoundRegistry.TE_TP)).withParticles().withInfo((Component)Component.m_237113_((String)"Timeskip"), (Component)Component.m_237113_((String)"16m range"));
    private static final EntityDataAccessor<Integer> TIME_ERASE_TIME = SynchedEntityData.m_135353_(KingCrimsonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public KingCrimsonEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.KING_CRIMSON.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.9f, 0.5f, 0.7f), new Vector3f(1.0f, 0.4f, 0.4f), new Vector3f(0.3f, 0.0f, 0.5f)};
    }

    public int getTETime() {
        return (Integer)this.f_19804_.m_135370_(TIME_ERASE_TIME);
    }

    public void setTETime(int teTime) {
        this.f_19804_.m_135381_(TIME_ERASE_TIME, (Object)teTime);
    }

    private static void registerMoves(MoveMap<KingCrimsonEntity, State> moves) {
        moves.register(MoveClass.LIGHT, DUAL_CHOP, State.DUAL_CHOP).withCrouchingVariant(State.SWEEP);
        moves.register(MoveClass.HEAVY, VERTICAL_CHOP, State.HEAVY).withFollowup(State.OVERHEAD);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, EYE_CHOP, State.EYE_CHOP).withCrouchingVariant(State.BLOOD_THROW);
        moves.register(MoveClass.SPECIAL2, DONUT, State.DONUT);
        moves.register(MoveClass.SPECIAL3, PREDICTION, State.PREDICT).withCrouchingVariant(State.EPITAPH);
        moves.register(MoveClass.ULTIMATE, TIME_ERASE, State.TIME_ERASE);
        moves.register(MoveClass.UTILITY, TIME_SKIP, State.TIME_SKIP);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TIME_ERASE_TIME, (Object)0);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        switch (moveClass) {
            case ULTIMATE: {
                if (super.initMove(moveClass)) {
                    return true;
                }
                if (this.canAttack() && this.getTETime() > 0) {
                    this.getTimeEraseMove().cancelTE(this);
                    return true;
                }
                return false;
            }
            case SPECIAL3: {
                boolean start;
                LivingEntity user = this.getUserOrThrow();
                boolean bl = start = this.getMoveStun() <= 0;
                if (start) {
                    return super.initMove(moveClass);
                }
                this.moveCancel();
                CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(user);
                if (cooldowns.getCooldown(CooldownType.STAND_ULTIMATE) < 140) {
                    cooldowns.setCooldown(CooldownType.STAND_ULTIMATE, 140);
                }
                Vec3 oPos = user.m_20182_();
                AABB bBox = user.m_20191_();
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130130_(2);
                buf.writeDouble(oPos.f_82479_);
                buf.writeDouble(oPos.f_82480_);
                buf.writeDouble(oPos.f_82481_);
                buf.writeDouble(bBox.m_82362_());
                buf.writeDouble(bBox.m_82376_());
                buf.writeDouble(bBox.m_82385_());
                ServerChannelFeedbackPacket.send(JUtils.around((ServerLevel)this.m_9236_(), oPos, 128.0), buf);
                if (!(user instanceof ServerPlayer)) break;
                ServerPlayer player = (ServerPlayer)user;
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)JPacketRegistry.S2C_EPITAPH_STATE, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer().writeBoolean(false)));
                break;
            }
            case UTILITY: {
                if (this.getTETime() > 0) {
                    this.getTimeEraseMove().cancelTE(this);
                }
                return super.initMove(moveClass);
            }
            default: {
                if (moveClass == MoveClass.HEAVY && this.getState() == State.HEAVY && this.queuedMove == MoveInputType.HEAVY) {
                    this.queuedMove = null;
                }
                return super.initMove(moveClass);
            }
        }
        return true;
    }

    @Override
    public void queueMove(MoveInputType type) {
        if ((this.getState() == State.HEAVY || this.getState() == State.OVERHEAD) && type == MoveInputType.HEAVY) {
            return;
        }
        super.queueMove(type);
    }

    public void moveCancel() {
        this.getMoveMap().findMoveByType(PredictionMove.class).ifPresent(m -> m.cancelPrediction(this));
        this.setCurrentMove(null);
        this.queuedMove = null;
        this.setMoveStun(2);
        this.setState(State.IDLE);
        this.setReset(true);
    }

    @Override
    public void desummon() {
        if (this.getTETime() < 1) {
            super.desummon();
        } else {
            this.getTimeEraseMove().cancelTE(this);
        }
    }

    @NonNull
    protected AABB m_142242_() {
        if (this.getTETime() > 0) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            return new AABB(x, y, z, x, y + 0.1, z);
        }
        return super.m_142242_();
    }

    public TimeEraseMove getTimeEraseMove() {
        return this.getMove(TimeEraseMove.class);
    }

    @Override
    @NonNull
    public KingCrimsonEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.kingcrimson.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<KingCrimsonEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.kingcrimson.idle"))),
        DUAL_CHOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.dual_chop"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.kingcrimson.block"))),
        OVERHEAD(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.overhead"))),
        DONUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.donut"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.kingcrimson.barrage"))),
        EYE_CHOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.eye_chop"))),
        TIME_ERASE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.time_erase"))),
        EPITAPH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.epitaph"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.heavy"))),
        BLOOD_THROW(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.bloodthrow"))),
        PREDICT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.predict"))),
        COUNTER_MISS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.counter_miss"))),
        SWEEP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.kingcrimson.sweep"))),
        TIME_SKIP(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.kingcrimson.idle")));

        private final Consumer<AnimationState<KingCrimsonEntity>> animator;

        private State(Consumer<AnimationState<KingCrimsonEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(KingCrimsonEntity attacker, AnimationState<KingCrimsonEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

