/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.EffectAction;
import net.arna.jcraft.common.attack.moves.madeinheaven.CircleAttack;
import net.arna.jcraft.common.attack.moves.madeinheaven.FuryChopAttack;
import net.arna.jcraft.common.attack.moves.madeinheaven.JudgementAttack;
import net.arna.jcraft.common.attack.moves.madeinheaven.SpeedSliceAttack;
import net.arna.jcraft.common.attack.moves.madeinheaven.TimeAccelerationMove;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.network.s2c.TimeAccelStatePacket;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MadeInHeavenEntity
extends StandEntity<MadeInHeavenEntity, State> {
    public static final MoveSet<MadeInHeavenEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.MADE_IN_HEAVEN, MadeInHeavenEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-45.0f).evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.mih")).proCount(4).conCount(2).freeSpace((Component)Component.m_237113_((String)"PASSIVE: Speed I\n\nBNBs:\n    -the flashbang\n    (Donut>Light>)Speed Slice>Low Kick>Fury Chop>Light>Barrage>dash>Light~Light\n")).skinName((Component)Component.m_237113_((String)"Cruel")).skinName((Component)Component.m_237113_((String)"Daft")).skinName((Component)Component.m_237113_((String)"Nightmare")).build()).summonData(SummonData.of(JSoundRegistry.MIH_SUMMON)).build();
    public static final SimpleAttack<MadeInHeavenEntity> SPEED_CHOP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 11, 0.75f, 3.0f, 8, 1.5f, 0.5f, -0.1f).withAnim(State.SPEED_CHOP)).withAction(EffectAction.inflict(JStatusRegistry.BLEEDING, 80, 1, true, false, true))).withImpactSound(SoundEvents.f_12514_)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Speed Chop"), (Component)Component.m_237113_((String)"tiny stun, procs bleed"));
    public static final SimpleAttack<MadeInHeavenEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 12, 0.75f, 5.0f, 8, 1.5f, 1.0f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withInfo((Component)Component.m_237113_((String)"Kick"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<MadeInHeavenEntity> SLICE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(8, 5, 8, 0.75f, 4.0f, 10, 1.5f, 0.15f, -0.1f).noLoopPrevention()).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(SPEED_CHOP)).withImpactSound(SoundEvents.f_12514_)).withInfo((Component)Component.m_237113_((String)"Slice"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleAttack<MadeInHeavenEntity> BARRAGE_FINISHER = (SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 9, 0.85f, 1.0f, 10, 1.5f, 1.1f, 0.0f).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Barrage (Final Hit)"), (Component)Component.m_237119_());
    public static final MainBarrageAttack<MadeInHeavenEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(200, 0, 32, 0.85f, 1.0f, 10, 2.0f, 0.1f, 0.0f, 2, Blocks.f_50705_.m_155943_()).withFinisher(23, BARRAGE_FINISHER)).withSound(JSoundRegistry.MIH_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"short, knocks back"));
    public static final SpeedSliceAttack SPEED_SLICE = (SpeedSliceAttack)((SpeedSliceAttack)new SpeedSliceAttack(300, 10, 11, 1.25f, 6.0f, 1.5f, 1.0f).withSound(JSoundRegistry.MIH_SPEEDSLICE)).withInfo((Component)Component.m_237113_((String)"Speed Slice"), (Component)Component.m_237113_((String)"short windup, harming teleport with hitstun and light knockback"));
    public static final KnockdownAttack<MadeInHeavenEntity> LEG_CRUSHER = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(19, 9, 19, 0.85f, 7.0f, 22, 1.5f, 0.35f, 0.2f, 45).withSound(JSoundRegistry.MIH_LEGCRUSHER)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withExtraHitBox(0.0, -0.5, 1.0)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Leg Crusher"), (Component)Component.m_237113_((String)"knocks down (2s)"));
    public static final SimpleAttack<MadeInHeavenEntity> LOW_KICK = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(17, 8, 17, 0.85f, 6.0f, 26, 1.5f, 0.25f, 0.2f).withCrouchingVariant(LEG_CRUSHER)).withSound(JSoundRegistry.MIH_LEGCRUSHER)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(0.0, -0.5, 1.0)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Low Kick"), (Component)Component.m_237113_((String)"combo starter/extender, mih hoofs the enemies legs in a quick, stunning attack"));
    public static final FuryChopAttack FURY_CHOP = (FuryChopAttack)((FuryChopAttack)((FuryChopAttack)((FuryChopAttack)((FuryChopAttack)new FuryChopAttack(24, 15, 24, 0.85f, 7.0f, 20, 1.6f, 0.25f, 0.2f).withSound(JSoundRegistry.MIH_FURYCHOP)).withImpactSound(JSoundRegistry.IMPACT_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Fury Chop"), (Component)Component.m_237113_((String)"combo extender, on hit gives haste(8s) to user and mining fatigue(8s) to victim, on whiff the fatigue goes to user"));
    public static final SimpleAttack<MadeInHeavenEntity> DONUT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(200, 26, 32, 0.75f, 8.5f, 40, 2.0f, -0.2f, 0.2f).withSound(JSoundRegistry.STAND_DESUMMON)).withImpactSound(JSoundRegistry.IMPACT_7)).withHyperArmor()).withBlockStun(4)).withHitSpark(JParticleType.HIT_SPARK_3)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Roundabout Donut"), (Component)Component.m_237113_((String)"feigns stand desummon, uninterruptible combo starter"));
    public static final TimeAccelerationMove TIME_ACCELERATION = (TimeAccelerationMove)((TimeAccelerationMove)new TimeAccelerationMove(1400, 20, 40, 1.0f, (Either<Integer, IntOption>)Either.right((Object)JServerConfig.MIH_TIME_ACCELERATION_DURATION)).withSound(JSoundRegistry.MIH_TACCEL)).withInfo((Component)Component.m_237113_((String)"Time Acceleration"), (Component)Component.m_237113_((String)"allows charging the speedometer for 30s\nit is charged by landing hits\nthe speedometer impacts the level of speed and haste granted by Time Acceleration\nif the speedometer is full and the charging period finishes, enemies become standless for 15s"));
    public static final CircleAttack CIRCLE = (CircleAttack)((CircleAttack)new CircleAttack(300, 13, 14, 1.25f).withSound(JSoundRegistry.MIH_CIRCLE)).withInfo((Component)Component.m_237113_((String)"Heaven's Judgement"), (Component)Component.m_237113_((String)"rapidly circles a looked-at target within 4m at a radius of 7m"));
    public static final JudgementAttack JUDGEMENT = (JudgementAttack)((JudgementAttack)((JudgementAttack)new JudgementAttack(300, 20, 60, 1.25f, 2).withCrouchingVariant(CIRCLE)).withSound(JSoundRegistry.MIH_JUDGEMENT)).withInfo((Component)Component.m_237113_((String)"Divine Severance"), (Component)Component.m_237113_((String)"Made in Heaven rapidly speed slices an area, then finishes with a large, launching slice"));
    private static final EntityDataAccessor<Integer> ACCEL_TIME = SynchedEntityData.m_135353_(MadeInHeavenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPEEDOMETER = SynchedEntityData.m_135353_(MadeInHeavenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> AFTER_IMAGE = SynchedEntityData.m_135353_(MadeInHeavenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CIRCLING_TARGET = SynchedEntityData.m_135353_(MadeInHeavenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAXIMUM_SPEEDOMETER = 30;
    private int speedometer = 0;

    public MadeInHeavenEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.MADE_IN_HEAVEN.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.9f, 0.8f, 0.8f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.0f, 1.0f)};
    }

    private static void registerMoves(MoveMap<MadeInHeavenEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, SLICE, State.SLICE);
        moves.register(MoveClass.HEAVY, DONUT, State.DONUT);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, LOW_KICK, State.LOW_KICK).withCrouchingVariant(State.LEG_CRUSHER);
        moves.register(MoveClass.SPECIAL2, FURY_CHOP, State.FURY_CHOP);
        moves.register(MoveClass.SPECIAL3, JUDGEMENT, State.JUDGEMENT).withCrouchingVariant(State.CIRCLE_STARTUP);
        moves.register(MoveClass.ULTIMATE, TIME_ACCELERATION, State.TIME_ACCELERATION);
        moves.register(MoveClass.UTILITY, SPEED_SLICE, State.SPEED_SLICE);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (!this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return super.initMove(moveClass);
        }
        return true;
    }

    @Override
    public void onPerform(AbstractMove<?, ? super MadeInHeavenEntity> move, Set<LivingEntity> targets) {
        this.tryIncrementSpeedometer(targets);
    }

    public int getAccelTime() {
        return (Integer)this.f_19804_.m_135370_(ACCEL_TIME);
    }

    public void setAccelTime(int aTime) {
        this.f_19804_.m_135381_(ACCEL_TIME, (Object)aTime);
    }

    public int getSpeedometer() {
        return (Integer)this.f_19804_.m_135370_(SPEEDOMETER);
    }

    public void incrementSpeedometer() {
        if (this.speedometer >= 30) {
            return;
        }
        ++this.speedometer;
    }

    public void setSpeedometer(int speedometer) {
        this.speedometer = speedometer;
        this.f_19804_.m_135381_(SPEEDOMETER, (Object)this.speedometer);
    }

    public boolean getAfterimage() {
        return (Boolean)this.f_19804_.m_135370_(AFTER_IMAGE);
    }

    public void setAfterimage(boolean a) {
        this.f_19804_.m_135381_(AFTER_IMAGE, (Object)a);
    }

    public LivingEntity getCircleTarget() {
        LivingEntity entity;
        Entity entity2 = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(CIRCLING_TARGET)).intValue());
        return entity2 instanceof LivingEntity ? (entity = (LivingEntity)entity2) : null;
    }

    public void setCirclingTarget(LivingEntity target) {
        this.f_19804_.m_135381_(CIRCLING_TARGET, (Object)(target == null ? -1 : target.m_19879_()));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ACCEL_TIME, (Object)0);
        this.m_20088_().m_135372_(SPEEDOMETER, (Object)0);
        this.m_20088_().m_135372_(AFTER_IMAGE, (Object)false);
        this.m_20088_().m_135372_(CIRCLING_TARGET, (Object)-1);
    }

    @Override
    public boolean handleMove(AbstractMove<?, ? super MadeInHeavenEntity> move, CooldownType cooldownType, State animState) {
        if (!move.canBeInitiated(this)) {
            return false;
        }
        LivingEntity player = this.getUserOrThrow();
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(player);
        int cooldown = cooldowns.getCooldown(cooldownType);
        if (cooldown > 0) {
            return false;
        }
        int cdDiv = this.getAccelTime() > 0 ? 2 : 1;
        cooldowns.setCooldown(cooldownType, move.getCooldown() / cdDiv);
        this.setMove(move, animState);
        return true;
    }

    private void tryIncrementSpeedometer(Set<LivingEntity> targets) {
        if (this.getAccelTime() > 0 && !targets.isEmpty()) {
            this.incrementSpeedometer();
        }
    }

    @Override
    public void desummon() {
        if (!this.m_9236_().m_5776_() && this.getAccelTime() > 0) {
            TimeAccelStatePacket.sendStop(this);
        }
        super.desummon();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.hasUser()) {
            return;
        }
        LivingEntity user = this.getUserOrThrow();
        int aTime = this.getAccelTime();
        if (!user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            if (aTime > 0) {
                int amplifier = this.speedometer / 3;
                user.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, amplifier, true, false));
                user.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 20, amplifier, true, false));
            } else {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 0, true, false));
            }
        }
        if (this.m_9236_().f_46443_) {
            LivingEntity clientCircleTarget = this.getCircleTarget();
            if (clientCircleTarget != null) {
                MadeInHeavenEntity.lookAtWithoutReset(user, EntityAnchorArgument.Anchor.EYES, clientCircleTarget.m_146892_());
            }
            if (this.getAccelTime() > 1) {
                CircleAttack.createSpeedParticles(this, (Entity)this);
                List toCatch = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82400_(96.0), EntitySelector.f_20406_);
                for (Entity entity : toCatch) {
                    if (entity instanceof LivingEntity) continue;
                    Vec3 vec3 = new Vec3(entity.f_19854_, entity.f_19855_, entity.f_19856_);
                    if (entity.m_20182_().m_82557_(vec3) > 0.0) {
                        CircleAttack.createSpeedParticles(this, entity);
                    }
                    entity.m_8119_();
                }
            }
            return;
        }
        this.setSpeedometer(this.speedometer);
    }

    private static void lookAtWithoutReset(LivingEntity entity, EntityAnchorArgument.Anchor anchorPoint, Vec3 target) {
        entity.f_19859_ = entity.m_146908_();
        entity.f_20884_ = entity.m_213816_();
        entity.f_20886_ = entity.m_6080_();
        entity.f_19860_ = entity.m_146909_();
        Vec3 vec3d = anchorPoint.m_90377_((Entity)entity);
        double d = target.f_82479_ - vec3d.f_82479_;
        double e = target.f_82480_ - vec3d.f_82480_;
        double f = target.f_82481_ - vec3d.f_82481_;
        double g = Math.sqrt(d * d + f * f);
        entity.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)e, (double)g) * 57.2957763671875)))));
        entity.m_146922_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f)));
        entity.m_5616_(entity.m_146908_());
    }

    @Override
    @NonNull
    public MadeInHeavenEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.mih.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<MadeInHeavenEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.mih.idle"))),
        SLICE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.slice"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.mih.block"))),
        DONUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.donut"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.mih.barrage"))),
        SPEED_SLICE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.speedslice"))),
        JUDGEMENT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.judgement"))),
        LEG_CRUSHER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.legcrusher"))),
        FURY_CHOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.furychop"))),
        TIME_ACCELERATION(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.taccel"))),
        CIRCLE_STARTUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.circlestartup"))),
        SPEED_CHOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.speedchop"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.light_followup"))),
        LOW_KICK(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mih.lowkick")));

        private final Consumer<AnimationState<MadeInHeavenEntity>> animator;

        private State(Consumer<AnimationState<MadeInHeavenEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(MadeInHeavenEntity attacker, AnimationState<MadeInHeavenEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

