/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.Collection;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.PlaySoundAction;
import net.arna.jcraft.common.attack.core.MoveMapImpl;
import net.arna.jcraft.common.attack.moves.magiciansred.CrossfireAttack;
import net.arna.jcraft.common.attack.moves.magiciansred.CrossfireHurricaneAttack;
import net.arna.jcraft.common.attack.moves.magiciansred.CrossfireVariationAttack;
import net.arna.jcraft.common.attack.moves.magiciansred.FlamethrowerAttack;
import net.arna.jcraft.common.attack.moves.magiciansred.LifeDetectorAttack;
import net.arna.jcraft.common.attack.moves.magiciansred.RedBindAttack;
import net.arna.jcraft.common.attack.moves.magiciansred.RedirectAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MagiciansRedEntity
extends StandEntity<MagiciansRedEntity, State> {
    public static final MoveSet<MagiciansRedEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.MAGICIANS_RED, "default", MagiciansRedEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(225.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.mr")).proCount(3).conCount(3).freeSpace((Component)Component.m_237113_((String)"PASSIVE: Fire Resistance\n\nBNBs:\n    -the \"this move is fire\"\n    Light>Crossfire\n\n    -the happy camper\n    Light>Low Kick>Variation/Life Detector\n\n    -the \"omg i have setups????\"\n    Light>Hammerfist>dash>Light>Red Bind>\n    ...Life Detector/Variation>any physical hit\n    ...Hurricane")).skinName((Component)Component.m_237113_((String)"Purple")).skinName((Component)Component.m_237113_((String)"OVA")).skinName((Component)Component.m_237113_((String)"Neon")).build()).summonData(SummonData.of(JSoundRegistry.MR_SUMMON)).build();
    public static final RedirectAttack REDIRECT = (RedirectAttack)((RedirectAttack)((RedirectAttack)new RedirectAttack(0, 7, 10, 0.75f).withAnim(State.REDIRECT)).withSound(JSoundRegistry.MR_REDIRECT)).withInfo((Component)Component.m_237113_((String)"Redirect"), (Component)Component.m_237113_((String)"redirects all the users ankhs to where they're looking"));
    public static final SimpleAttack<MagiciansRedEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 14, 0.65f, 6.0f, 12, 1.5f, 1.2f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<MagiciansRedEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(20, 5, 8, 0.75f, 5.0f, 16, 1.5f, 0.2f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(REDIRECT)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final KnockdownAttack<MagiciansRedEntity> HEAVY = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 12, 22, 1.0f, 7.0f, 10, 1.75f, 0.5f, 0.6f, 40).withAnim(State.HEAVY)).withSound(JSoundRegistry.MR_HEAVY)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withInfo((Component)Component.m_237113_((String)"Low Kick"), (Component)Component.m_237113_((String)"medium windup knockdown"));
    public static final SimpleAttack<MagiciansRedEntity> HAMMERFIST_FLARE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 1, 5, 1.0f, 6.0f, 10, 1.75f, 1.5f, -0.2f).withLaunch()).withHitSpark(JParticleType.HIT_SPARK_3)).withAction(PlaySoundAction.playSound(SoundEvents.f_11874_))).withInfo((Component)Component.m_237113_((String)"Hammerfist Flare"), (Component)Component.m_237113_((String)"launcher"));
    public static final SimpleAttack<MagiciansRedEntity> HAMMERFIST = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 10, 20, 1.0f, 3.0f, 13, 1.75f, 0.2f, 0.0f).withSound(JSoundRegistry.MR_CROSSFIRE)).withFinisher(15, HAMMERFIST_FLARE)).withCrouchingVariant(HEAVY)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Hammerfist"), (Component)Component.m_237113_((String)"two-hit launcher"));
    public static final FlamethrowerAttack FLAMETHROWER = (FlamethrowerAttack)((FlamethrowerAttack)((FlamethrowerAttack)new FlamethrowerAttack(200, 0, 40, 0.75f, 0.4f, 0, 2.0f, 0.25f, 0.0f, 3).withArmor(1)).withSound(JSoundRegistry.MR_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Flamethrower"), (Component)Component.m_237113_((String)"fast reliable damage cash-out tool, no stun, burns for 3 seconds"));
    public static final CrossfireAttack CROSSFIRE = (CrossfireAttack)((CrossfireAttack)new CrossfireAttack(100, 8, 10, 0.75f).withSound(JSoundRegistry.MR_CROSSFIRE)).withInfo((Component)Component.m_237113_((String)"Crossfire"), (Component)Component.m_237113_((String)"fires 3 stunning ankhs"));
    public static final CrossfireVariationAttack CROSSFIRE_VARIATION = (CrossfireVariationAttack)((CrossfireVariationAttack)new CrossfireVariationAttack(600, 12, 17, 0.75f).withSound(JSoundRegistry.MR_CROSSFIRE)).withInfo((Component)Component.m_237113_((String)"Crossfire Variation"), (Component)Component.m_237113_((String)"summons 6 ankhs that orbit around the user, crouch as they come out to increase orbit distance"));
    public static final CrossfireHurricaneAttack CROSSFIRE_HURRICANE = (CrossfireHurricaneAttack)((CrossfireHurricaneAttack)new CrossfireHurricaneAttack(800, 18, 22, 0.75f).withSound(JSoundRegistry.MR_ULT)).withInfo((Component)Component.m_237113_((String)"Crossfire Hurricane"), (Component)Component.m_237113_((String)"summons slow, homing fire hurricane that knocks down, lasts for 3 seconds after hitting anything"));
    public static final RedBindAttack RED_BIND = (RedBindAttack)((RedBindAttack)((RedBindAttack)new RedBindAttack(100, 12, 22, 0.75f, 3.0f, 15, 1.5f, 0.0f, 0.0f).withSound(JSoundRegistry.MR_REDBIND)).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Red Bind"), (Component)Component.m_237113_((String)"on hit, wraps opponent in fiery rings that launch them in the direction they are hit"));
    public static final LifeDetectorAttack LIFE_DETECTOR = (LifeDetectorAttack)((LifeDetectorAttack)new LifeDetectorAttack(200, 13, 20, 0.75f).withSound(JSoundRegistry.MR_DETECTOR)).withInfo((Component)Component.m_237113_((String)"Life Detector"), (Component)Component.m_237113_((String)"tracks down nearby life, lasts 15s"));

    public MagiciansRedEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.MAGICIANS_RED.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.9f, 0.6f, 0.3f), new Vector3f(0.8f, 0.3f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.2f, 0.4f)};
        MoveMapImpl<MagiciansRedEntity, State> movemap = new MoveMapImpl<MagiciansRedEntity, State>();
        MagiciansRedEntity.registerMoves(movemap);
        this.getMoveMap().copyFrom(movemap, true);
    }

    private static void registerMoves(MoveMap<MagiciansRedEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
        moves.registerImmediate(MoveClass.HEAVY, HAMMERFIST, State.HAMMER);
        moves.register(MoveClass.BARRAGE, FLAMETHROWER, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, CROSSFIRE, State.CROSSFIRE);
        moves.register(MoveClass.SPECIAL2, CROSSFIRE_VARIATION, State.CROSSFIRE_VARIATION);
        moves.register(MoveClass.SPECIAL3, RED_BIND, State.RED_BIND);
        moves.register(MoveClass.ULTIMATE, CROSSFIRE_HURRICANE, State.CROSSFIRE_HURRICANE);
        moves.register(MoveClass.UTILITY, LIFE_DETECTOR, State.DETECTOR);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (moveClass == MoveClass.LIGHT && this.getCurrentMove() != null && this.getCurrentMove().getMoveClass() == MoveClass.LIGHT && this.getMoveStun() < this.getCurrentMove().getWindupPoint()) {
            AbstractMove followup = this.getCurrentMove().getFollowup();
            if (followup != null) {
                this.setMove(followup, (State)followup.getAnimation());
            }
        } else {
            return super.initMove(moveClass);
        }
        return true;
    }

    public static void ignite(Level world, BlockPos blockPos) {
        BlockEntity blockEntity;
        BlockState state = world.m_8055_(blockPos);
        Block block = state.m_60734_();
        Collection properties = state.m_61147_();
        boolean cantIgnite = false;
        if (properties.contains(BlockStateProperties.f_61362_)) {
            cantIgnite = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_);
        }
        if (block == Blocks.f_50261_) {
            return;
        }
        if (cantIgnite) {
            return;
        }
        if (properties.contains(BlockStateProperties.f_61443_)) {
            world.m_46597_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
        }
        if (block == Blocks.f_50057_) {
            world.m_7731_(blockPos, Blocks.f_50056_.m_49966_(), 3);
            world.m_46796_(2009, blockPos, 0);
            world.m_5594_(null, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, (1.0f + world.m_213780_().m_188501_() * 0.2f) * 0.7f);
        }
        if ((blockEntity = world.m_7702_(blockPos)) instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnaceBlock = (AbstractFurnaceBlockEntity)blockEntity;
            furnaceBlock.f_58316_ = 220;
        }
        if (block instanceof IceBlock) {
            IceBlock iceBlock = (IceBlock)block;
            iceBlock.m_54168_(state, world, blockPos);
        }
    }

    @Override
    public double getEngagementDistance() {
        return 32.0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.hasUser()) {
            return;
        }
        if (this.m_9236_().f_46443_ && this.getState() == State.BARRAGE && FLAMETHROWER.hasWindupPassed(this)) {
            Vec3 rotVec = this.m_20154_();
            Vec3 mouthPos = this.m_146892_().m_82549_(rotVec);
            for (int i = 0; i < 16; ++i) {
                Vec3 vel = this.getUserOrThrow().m_20184_().m_82549_(rotVec.m_82496_(this.f_19796_.m_188501_() - 0.5f).m_82524_(this.f_19796_.m_188501_() - 0.5f).m_82535_(this.f_19796_.m_188501_() - 0.5f).m_82490_(0.2));
                this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188503_(6) == 5 ? ParticleTypes.f_123756_ : ParticleTypes.f_123744_), mouthPos.f_82479_, mouthPos.f_82480_, mouthPos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            }
        }
        this.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19607_, 20, 0, true, false));
    }

    @Override
    @NonNull
    public MagiciansRedEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.mr.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<MagiciansRedEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.mr.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.mr.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.barrage"))),
        CROSSFIRE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.crossfire"))),
        CROSSFIRE_HURRICANE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.crossfirehurricane"))),
        CROSSFIRE_VARIATION(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.crossfirevariation"))),
        REDIRECT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.redirect"))),
        RED_BIND(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.redbind"))),
        DETECTOR(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.detector"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.light_followup"))),
        HAMMER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.mr.hammer")));

        private final Consumer<AnimationState<MagiciansRedEntity>> animator;

        private State(Consumer<AnimationState<MagiciansRedEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(MagiciansRedEntity attacker, AnimationState<MagiciansRedEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

