/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JMarkerExtractorRegistry;
import net.arna.jcraft.api.registry.JMarkerInjectorRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.mandom.CountdownMove;
import net.arna.jcraft.common.attack.moves.mandom.RewindMove;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.common.util.TriConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MandomEntity
extends StandEntity<MandomEntity, State> {
    public static final MoveSet<MandomEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.MANDOM, MandomEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleDistance(0.0f).idleRotation(0.0f).blockDistance(0.0f).info(StandInfo.builder().freeSpace((Component)Component.m_237113_((String)"Mandom is a non-combat stand. its purpose\nis to trap and reset things\nthat happen or maybe what will happen")).name((Component)Component.m_237115_((String)"entity.jcraft.mandom")).proCount(2).conCount(4).skinName((Component)Component.m_237113_((String)"Phase-Shift")).skinName((Component)Component.m_237113_((String)"Aperture")).skinName((Component)Component.m_237113_((String)"Abstract")).build()).summonData(SummonData.builder().sound((Supplier<SoundEvent>)JSoundRegistry.MANDOM_SUMMON).build()).build();
    public static final CountdownMove COUNTDOWN = (CountdownMove)((CountdownMove)new CountdownMove(6, 10, 120, 0.0f, 64, 600, CountdownMove.ENTITY_STUFF_TO_SAVE, (TriConsumer)JMarkerExtractorRegistry.ALL.get(), (TriConsumer)JMarkerInjectorRegistry.ALL.get()).withSound(JSoundRegistry.MANDOM_COUNTDOWN)).withInfo((Component)Component.m_237113_((String)"Countdown"), (Component)Component.m_237113_((String)"Saves position data of all entities in a 64 block radius for 30 seconds. Must be active to use Rewind."));
    public static final RewindMove REWIND = (RewindMove)((RewindMove)new RewindMove(6, 5, 10, 0.0f, 200).withSound(JSoundRegistry.MANDOM_REWIND)).withInfo((Component)Component.m_237113_((String)"Rewind"), (Component)Component.m_237113_((String)"Returns all entities to their saved positions. Requires Countdown to be active."));

    public MandomEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.MANDOM.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 0.2f, 0.6f), new Vector3f(0.6f, 0.2f, 1.0f), new Vector3f(0.7f, 0.7f, 0.7f), new Vector3f(1.0f, 1.0f, 0.2f)};
    }

    private static void registerMoves(MoveMap<MandomEntity, State> moves) {
        moves.register(MoveClass.ULTIMATE, REWIND, State.REWIND);
        moves.register(MoveClass.UTILITY, COUNTDOWN, State.COUNTDOWN);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this.getThis(), "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<MandomEntity> state) {
        AnimationController controller = state.getController();
        if (this.isSameState()) {
            controller.forceAnimationReset();
        }
        State superState = (State)this.getState();
        superState.playAnimation(this.getThis(), state);
        return PlayState.CONTINUE;
    }

    @Override
    public boolean canAttack() {
        if (this.wantToBlock) {
            this.wantToBlock = false;
        }
        return super.canAttack();
    }

    @Override
    public void tryBlock() {
    }

    @Override
    public void onUserMoveInput(AbstractMove<?, ? super MandomEntity> currentMove, MoveInputType type, boolean pressed, boolean moveInitiated) {
        Player player;
        JSpec<?, ?> spec;
        LivingEntity livingEntity;
        CountdownMove countdownMove;
        if (!pressed) {
            return;
        }
        MoveClass moveClass = type.getMoveClass(this.standby);
        if (moveClass == null) {
            return;
        }
        if (!(moveClass != MoveClass.ULTIMATE || (countdownMove = this.getMove(CountdownMove.class)) != null && countdownMove.isCountdownActive())) {
            return;
        }
        if (moveClass == MoveClass.ULTIMATE || moveClass == MoveClass.UTILITY) {
            if (this.canAttack()) {
                this.initMove(moveClass);
            } else if (this.getMoveStun() > 0 && this.getMoveStun() < 7) {
                this.queueMove(type);
            }
            return;
        }
        if (this.hasUser() && (livingEntity = this.getUser()) instanceof Player && (spec = JUtils.getSpec((LivingEntity)(player = (Player)livingEntity))) != null && spec.canAttack() && !spec.initMove(moveClass) && spec.moveStun > 0 && spec.moveStun < 11) {
            spec.queuedMove = type;
        }
    }

    @Override
    public AbstractMove<?, ? super MandomEntity> getFallbackMove() {
        return null;
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        CountdownMove countdownMove;
        if (!(moveClass != MoveClass.ULTIMATE || (countdownMove = this.getMove(CountdownMove.class)) != null && countdownMove.isCountdownActive())) {
            return false;
        }
        return super.initMove(moveClass);
    }

    @Override
    public boolean allowMoveHandling() {
        return true;
    }

    @Override
    @NonNull
    public MandomEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    public State getBlockState() {
        return State.IDLE;
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "summon";
    }

    public static enum State implements StandAnimationState<MandomEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("summon"))),
        COUNTDOWN(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("timer"))),
        REWIND(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("rewind"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("idle")));

        private final Consumer<AnimationState<MandomEntity>> animator;

        private State(Consumer<AnimationState<MandomEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(MandomEntity attacker, AnimationState<MandomEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

