/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.component.living.CommonMiscComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.CancelSpecMoveAction;
import net.arna.jcraft.common.attack.actions.EffectAction;
import net.arna.jcraft.common.attack.actions.MetallicaAddIronAction;
import net.arna.jcraft.common.attack.actions.UserAnimationAction;
import net.arna.jcraft.common.attack.conditions.MetallicaIronCondition;
import net.arna.jcraft.common.attack.moves.metallica.BisectAttack;
import net.arna.jcraft.common.attack.moves.metallica.BisectChargeMove;
import net.arna.jcraft.common.attack.moves.metallica.CreateMagneticFieldMove;
import net.arna.jcraft.common.attack.moves.metallica.ExplodeMagneticFieldMove;
import net.arna.jcraft.common.attack.moves.metallica.FanTossAttack;
import net.arna.jcraft.common.attack.moves.metallica.GiveScalpelMove;
import net.arna.jcraft.common.attack.moves.metallica.HarvestMove;
import net.arna.jcraft.common.attack.moves.metallica.InvisibilityMove;
import net.arna.jcraft.common.attack.moves.metallica.PreciseTossAttack;
import net.arna.jcraft.common.attack.moves.metallica.RazorCoughAttack;
import net.arna.jcraft.common.attack.moves.metallica.RemoteScalpelMove;
import net.arna.jcraft.common.attack.moves.shared.BarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MetallicaEntity
extends StandEntity<MetallicaEntity, State> {
    public static final MoveSet<MetallicaEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.METALLICA, MetallicaEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleDistance(0.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.metallica")).proCount(3).conCount(3).freeSpace((Component)Component.m_237113_((String)"Contains up to 80 units of iron.\nRequires iron to create objects used in attacks.")).skinName((Component)Component.m_237113_((String)"Lead")).skinName((Component)Component.m_237113_((String)"Brass")).skinName((Component)Component.m_237113_((String)"Hollow")).build()).summonData(SummonData.of(JSoundRegistry.METALLICA_SUMMON)).build();
    public static final EntityDataAccessor<Optional<BlockPos>> SIPHON_POS = SynchedEntityData.m_135353_(MetallicaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    public static final EntityDataAccessor<Float> IRON = SynchedEntityData.m_135353_(MetallicaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> INVISIBLE = SynchedEntityData.m_135353_(MetallicaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final float IRON_MAX = 80.0f;
    public static final GiveScalpelMove GIVE_SCALPEL = (GiveScalpelMove)((GiveScalpelMove)((GiveScalpelMove)new GiveScalpelMove(0, 8, 9, 0.0f).withInfo((Component)Component.m_237113_((String)"Give Scalpel"), (Component)Component.m_237119_())).withInitAction(UserAnimationAction.play("mtl.gsl"))).withCondition(MetallicaIronCondition.atLeast(5.0f));
    public static final SimpleAttack<MetallicaEntity> LIGHT_LAUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 18, 22, 0.75f, 5.0f, 6, 1.7f, 1.25f, 0.2f).withLaunch()).withImpactSound(JSoundRegistry.IMPACT_9)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Launch"), (Component)Component.m_237119_());
    public static final SimpleAttack<MetallicaEntity> LIGHT_FOLLOWUP_2 = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 12, 22, 0.75f, 3.0f, 10, 1.6f, 0.25f, 0.2f).withSound(SoundEvents.f_12317_)).withAnim(State.LIGHT_FINAL)).withImpactSound(JSoundRegistry.IMPACT_7)).withFinisher(16, LIGHT_LAUNCH)).withInfo((Component)Component.m_237113_((String)"Impale"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleAttack<MetallicaEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(6, 15, 0.75f, 4.0f, 14, 0.25f, 0.2f).withSound(SoundEvents.f_12317_)).withAnim(State.LIGHT_FOLLOWUP)).withFollowup(LIGHT_FOLLOWUP_2)).withImpactSound(JSoundRegistry.IMPACT_9)).withInfo((Component)Component.m_237113_((String)"Slice (2nd Hit)"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleAttack<MetallicaEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(6, 10, 0.75f, 4.0f, 11, 0.15f, 0.2f).withSound(SoundEvents.f_12317_)).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(GIVE_SCALPEL)).withImpactSound(JSoundRegistry.IMPACT_9)).withInfo((Component)Component.m_237113_((String)"Slice"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final BarrageAttack<MetallicaEntity> BARRAGE = (BarrageAttack)((BarrageAttack)((BarrageAttack)((BarrageAttack)((BarrageAttack)new BarrageAttack(240, 0, 30, 0.75f, 0.8f, 20, 1.6f, 0.25f, 0.0f, 3).withSound(JSoundRegistry.METALLICA_BARRAGE)).withHitSpark(JParticleType.HIT_SPARK_1)).withImpactSound(JSoundRegistry.IMPACT_9)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun, smaller hitbox than most barrages"))).withInitAction(UserAnimationAction.play("mtl.brg"));
    public static final KnockdownAttack<MetallicaEntity> SWEEP = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 7, 14, 0.75f, 5.0f, 8, 1.5f, 0.3f, 0.4f, 35).withSound(JSoundRegistry.METALLICA_BLADE_SWIPE)).withImpactSound(SoundEvents.f_12317_)).withHitSpark(JParticleType.SWEEP_ATTACK)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withExtraHitBox(1.75, -0.4, 0.85)).withStaticY()).withInfo((Component)Component.m_237113_((String)"Sweep"), (Component)Component.m_237113_((String)"Fast 1.5s knockdown.\n\u00a71Requires at least 25% iron to be usable."))).withInitAction(UserAnimationAction.play("mtl.swp"))).withCondition(MetallicaIronCondition.atLeast(20.0f));
    public static final SimpleAttack<MetallicaEntity> CLEAVE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 12, 21, 1.5f, 6.5f, 11, 2.5f, 2.0f, 0.2f).withSound(JSoundRegistry.D4C_LIGHT)).withAnim(State.CLEAVE)).withLaunch()).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_3)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withExtraHitBox(3.0, 0.5, 1.5)).withInfo((Component)Component.m_237113_((String)"Cleave"), (Component)Component.m_237113_((String)"Interruptible, very far-reaching followup."))).withInitAction(UserAnimationAction.play("mtl.clv"))).withCondition(MetallicaIronCondition.atLeast(40.0f));
    public static final SimpleUppercutAttack<MetallicaEntity> SMASH = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 11, 21, 1.0f, 7.5f, 18, 2.0f, 2.0f, 0.2f, -0.5f).withSound(JSoundRegistry.D4C_LIGHT)).withCrouchingVariant(SWEEP)).withFollowup(CLEAVE)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_3)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHyperArmor()).withExtraHitBox(2.0, 0.5, 1.5)).withInfo((Component)Component.m_237113_((String)"Smash"), (Component)Component.m_237113_((String)"Uninterruptible combo starter.\nVery far-reaching.\n\u00a71Requires at least 50% iron to be usable."))).withInitAction(UserAnimationAction.play("mtl.sms"))).withCondition(MetallicaIronCondition.atLeast(40.0f));
    public static final RemoteScalpelMove REMOTE_SCALPEL_MOVE = (RemoteScalpelMove)((RemoteScalpelMove)((RemoteScalpelMove)new RemoteScalpelMove(0, 7, 12, 0.0f).withInfo((Component)Component.m_237113_((String)"Scalpel Toss (Remote)"), (Component)Component.m_237113_((String)"Decently fast, very low cooldown.\nCreates 3 scalpels at the pointed location.\nThey will only fire if in the presence of a magnetic field."))).withInitAction(UserAnimationAction.play("mtl.rs"))).withCondition(MetallicaIronCondition.atLeast(5.0f));
    public static final FanTossAttack FAN_TOSS = (FanTossAttack)((FanTossAttack)((FanTossAttack)((FanTossAttack)new FanTossAttack(0, 7, 12, 0.75f).withSound(JSoundRegistry.METALLICA_SCALPEL_SUMMON)).withInfo((Component)Component.m_237113_((String)"Scalpel Toss (Wide)"), (Component)Component.m_237113_((String)"Decently fast, very low cooldown.\nFires 5 scalpels in a fan pattern."))).withInitAction(UserAnimationAction.play("mtl.ft"))).withCondition(MetallicaIronCondition.atLeast(5.0f));
    public static final PreciseTossAttack PRECISE_TOSS = (PreciseTossAttack)((PreciseTossAttack)((PreciseTossAttack)((PreciseTossAttack)((PreciseTossAttack)((PreciseTossAttack)new PreciseTossAttack(0, 7, 12, 0.75f).withSound(JSoundRegistry.METALLICA_SCALPEL_SUMMON)).withCrouchingVariant(REMOTE_SCALPEL_MOVE)).withAerialVariant(FAN_TOSS)).withInfo((Component)Component.m_237113_((String)"Scalpel Toss (Precise)"), (Component)Component.m_237113_((String)"Decently fast, very low cooldown.\nFires 3 scalpels in the exact pointed direction.\nScalpels disappear after 15s in the ground, and may be picked up to regain iron."))).withInitAction(UserAnimationAction.play("mtl.pt"))).withCondition(MetallicaIronCondition.atLeast(5.0f));
    public static final ExplodeMagneticFieldMove EXPLODE_MAGNETIC_FIELD = (ExplodeMagneticFieldMove)((ExplodeMagneticFieldMove)new ExplodeMagneticFieldMove(140, 10, 20).withInfo((Component)Component.m_237113_((String)"Explode Magnetic Field"), (Component)Component.m_237113_((String)"Reverses the polarity of the nearest aimed magnetic field, then detonates it."))).withInitAction(UserAnimationAction.play("mtl.emf"));
    public static final RazorCoughAttack RAZOR_COUGH_ATTACK = (RazorCoughAttack)((RazorCoughAttack)new RazorCoughAttack(140, 10, 20).withInfo((Component)Component.m_237113_((String)"Internal Attack"), (Component)Component.m_237113_((String)"All living entities within magnetic fields will begin to vomit razors on the ground.\nIncreases Hypoxia for all affected entities."))).withInitAction(UserAnimationAction.play("mtl.rca"));
    public static final CreateMagneticFieldMove CREATE_MAGNETIC_FIELD = (CreateMagneticFieldMove)((CreateMagneticFieldMove)((CreateMagneticFieldMove)new CreateMagneticFieldMove(200, 5, 15).withCrouchingVariant(RAZOR_COUGH_ATTACK)).withInfo((Component)Component.m_237113_((String)"Place Magnetic Field"), (Component)Component.m_237113_((String)"12 meter range.\nMust be pointed at a block.\nSummons an attractive ferromagnetic field which lasts for 1 minute."))).withInitAction(UserAnimationAction.play("mtl.sfk"));
    public static final SimpleAttack<MetallicaEntity> GRAB_HIT_FINAL = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 18, 24, 0.5f, 4.0f, 9, 2.0f, 1.2f, 0.0f).withAction(EffectAction.inflict(JStatusRegistry.HYPOXIA, 200, 0, false, true))).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Grab (Final Hit)"), (Component)Component.m_237119_())).withAction(MetallicaAddIronAction.addIron(15.0f));
    public static final SimpleAttack<MetallicaEntity> GRAB_HIT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 13, 24, 0.5f, 4.0f, 10, 2.0f, 0.0f, 0.0f).withStunType(StunType.UNBURSTABLE)).withInfo((Component)Component.m_237113_((String)"Grab (Second Hit)"), (Component)Component.m_237119_())).withFinisher(14, GRAB_HIT_FINAL)).withAction(MetallicaAddIronAction.addIron(10.0f))).withInitAction(UserAnimationAction.play("mtl.grab_hit").force());
    public static final GrabAttack<MetallicaEntity, State> GRAB = (GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)new GrabAttack(280, 9, 20, 0.5f, 0.0f, 15, 1.5f, 0.0f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT), 17, 0.4).withInfo((Component)Component.m_237113_((String)"Grab"), (Component)Component.m_237113_((String)"Unblockable, inflicts Hypoxia (10s).\nRestores 30 iron.\nCannot be used alongside spec moves and will override them."))).withImpactSound(JSoundRegistry.IMPACT_9)).withInitAction(CancelSpecMoveAction.cancelSpecMove())).withInitAction(UserAnimationAction.play("mtl.grab"));
    public static final InvisibilityMove GO_INVISIBLE = (InvisibilityMove)((InvisibilityMove)((InvisibilityMove)((InvisibilityMove)new InvisibilityMove(20, 10, 15).withSound(JSoundRegistry.METALLICA_INVISIBILITY)).withInfo((Component)Component.m_237113_((String)"Invisibility"), (Component)Component.m_237113_((String)"Projects a field of iron particles that reflect light away from the user.\nUses 5 iron per second.\nCannot be queued."))).withInitAction(UserAnimationAction.play("mtl.ivs"))).withCondition(MetallicaIronCondition.atLeast(5.0f));
    public static final HarvestMove HARVEST = (HarvestMove)((HarvestMove)new HarvestMove(1200, 0.75f, 3).withCrouchingVariant(GO_INVISIBLE)).withInfo((Component)Component.m_237113_((String)"Harvest Iron"), (Component)Component.m_237113_((String)"Harvests 1 iron with a 0.15s interval from the looked at block.\n3 times faster if harvesting from an iron block.\n5m max range.\nCannot be queued."));
    public static final BisectAttack BISECT = (BisectAttack)new BisectAttack(0, 1, 11, 0.75f).withInitAction(UserAnimationAction.play("mtl.bsc_fire"));
    public static final BisectChargeMove BISECT_CHARGE = (BisectChargeMove)((BisectChargeMove)((BisectChargeMove)new BisectChargeMove(600, 81, 80, 0.75f, 12).withInfo((Component)Component.m_237113_((String)"Bisect"), (Component)Component.m_237113_((String)"Chargeable projectile that consumes iron over time to become larger and more powerful.\nUnblockable."))).withFollowup(BISECT)).withInitAction(UserAnimationAction.play("mtl.bsc"));
    private static final BlockParticleOption FAKE_BLOOD = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50088_.m_49966_());
    private int bisectChargeTime = 0;
    private CommonMiscComponent miscComponent;

    public MetallicaEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.METALLICA.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.1f, 0.1f, 0.4f), new Vector3f(0.2f, 0.1f, 0.3f), new Vector3f(0.2f, 0.2f, 0.05f), new Vector3f(0.3f, 0.01f, 0.1f)};
    }

    protected AABB m_142242_() {
        return AABB.m_165882_((Vec3)this.m_20318_(0.0f).m_82520_(0.0, 0.5, 0.0), (double)0.5, (double)1.0, (double)0.5);
    }

    @Override
    public Vector3f getAuraColor() {
        if (this.m_20145_() && (this.isIdle() || this.blocking)) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return super.getAuraColor();
    }

    @Override
    public void setUser(@Nullable LivingEntity user) {
        super.setUser(user);
        if (user == null) {
            return;
        }
        this.miscComponent = JComponentPlatformUtils.getMiscData(this.getUser());
        if (this.miscComponent == null) {
            return;
        }
        this.setIron(this.miscComponent.getMetallicaIron());
    }

    private static void registerMoves(MoveMap<MetallicaEntity, State> moves) {
        MoveMap.Entry<MetallicaEntity, State> light = moves.register(MoveClass.LIGHT, LIGHT, State.LIGHT);
        light.withFollowup(State.LIGHT_FOLLOWUP).withFollowup(State.LIGHT_FINAL);
        light.withCrouchingVariant(State.GIVE_SCALPEL);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        MoveMap.Entry<MetallicaEntity, State> heavy = moves.register(MoveClass.HEAVY, SMASH, State.SMASH);
        heavy.withFollowup(State.CLEAVE);
        heavy.withCrouchingVariant(State.SWEEP);
        MoveMap.Entry<MetallicaEntity, State> sp1 = moves.register(MoveClass.SPECIAL1, PRECISE_TOSS, State.PRECISE_TOSS);
        sp1.withCrouchingVariant(State.NONE);
        sp1.withAerialVariant(State.FAN_TOSS);
        moves.register(MoveClass.SPECIAL2, CREATE_MAGNETIC_FIELD, State.NONE).withCrouchingVariant(State.NONE);
        moves.register(MoveClass.SPECIAL3, GRAB, State.NONE);
        moves.register(MoveClass.ULTIMATE, BISECT_CHARGE, State.BISECT).withFollowup(State.NONE);
        moves.register(MoveClass.UTILITY, HARVEST, State.HARVEST).withCrouchingVariant(State.NONE);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        if (this.tryFollowUp(moveClass, MoveClass.HEAVY)) {
            return true;
        }
        if (moveClass == MoveClass.SPECIAL2 && this.canAttack() && this.getUserOrThrow().m_6144_()) {
            this.setMove(RAZOR_COUGH_ATTACK, State.NONE);
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    public void queueMove(MoveInputType type) {
        if (type == MoveInputType.UTILITY) {
            return;
        }
        super.queueMove(type);
    }

    @Override
    public boolean shouldOffsetHeight() {
        if (this.getState() == State.SWEEP) {
            return false;
        }
        return super.shouldOffsetHeight();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIPHON_POS, Optional.empty());
        this.f_19804_.m_135372_(IRON, (Object)Float.valueOf(80.0f));
        this.f_19804_.m_135372_(INVISIBLE, (Object)false);
    }

    public float getIron() {
        return ((Float)this.f_19804_.m_135370_(IRON)).floatValue();
    }

    public void setIron(float iron) {
        this.f_19804_.m_135381_(IRON, (Object)Float.valueOf(iron));
        if (this.miscComponent == null) {
            return;
        }
        this.miscComponent.setMetallicaIron(iron);
    }

    public void addIron(float add) {
        this.setIron(Mth.m_14036_((float)(((Float)this.f_19804_.m_135370_(IRON)).floatValue() + add), (float)0.0f, (float)80.0f));
    }

    public boolean drainIron(float r) {
        float iron = this.getIron();
        if (iron < r) {
            return false;
        }
        this.setIron(iron - r);
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        if (this.m_20145_() && !this.isIdle() && !this.m_21254_()) {
            JCraft.getClientEntityHandler().displayMetallicaAura(this);
        }
        if (this.getState() != State.GRAB_HIT) {
            return;
        }
        Vec3 toUser = this.getUserOrThrow().m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.5);
        Vec3 midVec = GravityChangerAPI.getEyeOffset((Entity)this).m_82549_(this.m_20182_());
        for (int i = 0; i < 3; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ParticleTypes.f_175830_ : FAKE_BLOOD), midVec.f_82479_ + this.f_19796_.m_188583_() * 0.2 - 0.1, midVec.f_82480_ + this.f_19796_.m_188583_() * 0.2 - 0.1, midVec.f_82481_ + this.f_19796_.m_188583_() * 0.2 - 0.1, toUser.f_82479_, toUser.f_82480_, toUser.f_82481_);
        }
    }

    @Override
    @Nullable
    public Mob standUserPassiveAI() {
        Mob mob = super.standUserPassiveAI();
        if (mob != null && this.hasUser() && this.getIron() < 80.0f) {
            Objects.requireNonNull(this.getUser()).m_20260_(false);
            this.initMove(MoveClass.UTILITY);
        }
        return mob;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        return !damageSource.m_276093_(DamageTypes.f_286979_) && !damageSource.m_276093_(DamageTypes.f_268724_);
    }

    public boolean m_20145_() {
        return (Boolean)this.f_19804_.m_135370_(INVISIBLE);
    }

    @Override
    @NonNull
    public MetallicaEntity getThis() {
        return this;
    }

    public Optional<BlockPos> getSiphonPos() {
        return (Optional)this.f_19804_.m_135370_(SIPHON_POS);
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.metallica.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public int getBisectChargeTime() {
        return this.bisectChargeTime;
    }

    public void setBisectChargeTime(int bisectChargeTime) {
        this.bisectChargeTime = bisectChargeTime;
    }

    public static enum State implements StandAnimationState<MetallicaEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.idle"))),
        NONE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.idle"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.block"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.metallica.light"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.metallica.light2"))),
        LIGHT_FINAL(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.metallica.light3"))),
        PRECISE_TOSS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.metallica.precise_toss"))),
        FAN_TOSS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.metallica.fan_toss"))),
        HARVEST(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.harvest"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.barrage"))),
        SMASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.smash"))),
        CLEAVE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.cleave"))),
        SWEEP(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.sweep"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.grab_hit"))),
        BISECT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.bisect"))),
        GIVE_SCALPEL(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.metallica.give_scalpel")));

        private final Consumer<AnimationState<MetallicaEntity>> animator;

        private State(Consumer<AnimationState<MetallicaEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(MetallicaEntity attacker, AnimationState<MetallicaEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

