/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.purplehaze.BackhandAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.PHRekkaAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.distortion.DistortionMove;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.PilotModeMove;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public final class PurpleHazeDistortionEntity
extends AbstractPurpleHazeEntity<PurpleHazeDistortionEntity, State> {
    public static final MoveSet<PurpleHazeDistortionEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.PURPLE_HAZE_DISTORTION, PurpleHazeDistortionEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(225.0f).evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.purple_haze_distortion")).proCount(3).conCount(3).freeSpace((Component)Component.m_237113_((String)"PASSIVE: 66% resistance to Purple Haze effect\n\nBNBs:\nLight > Rekka1~Rekka2 > crouching Light > Barrage >...\n    ...crouching Light~Light\n    ...Ground Slam\n    ...Light > Grab")).skinName((Component)Component.m_237113_((String)"Black Knight")).skinName((Component)Component.m_237113_((String)"Vintage")).skinName((Component)Component.m_237113_((String)"Reversal")).build()).summonData(SummonData.of(JSoundRegistry.PH_SUMMON)).build();
    @NonNull
    private static final KnockdownAttack<AbstractPurpleHazeEntity<?, ?>> CROUCHING_LIGHT_FOLLOWUP_ATTACK = (KnockdownAttack)BACKHAND_FOLLOWUP.copy().withAnim(State.BACKHAND_FOLLOWUP);
    @NonNull
    private static final BackhandAttack CROUCHING_LIGHT_ATTACK = (BackhandAttack)BACKHAND.copy().withFollowup(CROUCHING_LIGHT_FOLLOWUP_ATTACK);
    @NonNull
    private static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> LIGHT_FOLLOWUP_ATTACK = (SimpleAttack)LIGHT_FOLLOWUP.copy().withAnim(State.LIGHT_FOLLOWUP);
    @NonNull
    private static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> LIGHT_ATTACK = (SimpleAttack)((SimpleAttack)LIGHT.copy().withFollowup(LIGHT_FOLLOWUP_ATTACK)).withCrouchingVariant(CROUCHING_LIGHT_ATTACK);
    @NonNull
    private static final KnockdownAttack<AbstractPurpleHazeEntity<?, ?>> REKKA_3 = (KnockdownAttack)REKKA3.copy().withAnim(State.REKKA3);
    @NonNull
    private static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> REKKA_2 = (SimpleAttack)((SimpleAttack)REKKA2.copy().withAnim(State.REKKA2)).withFollowup(REKKA_3);
    @NonNull
    private static final PHRekkaAttack REKKA_1 = (PHRekkaAttack)((PHRekkaAttack)REKKA1.copy().withAnim(State.REKKA1)).withFollowup(REKKA_2);
    public static final PilotModeMove<PurpleHazeDistortionEntity> PILOT_MODE = (PilotModeMove)new PilotModeMove(20).withInfo((Component)Component.m_237113_((String)"Pilot Mode"), (Component)Component.m_237113_((String)"5m range"));
    public static final DistortionMove DISTORTION = (DistortionMove)((DistortionMove)new DistortionMove(20).withCrouchingVariant(PILOT_MODE)).withInfo((Component)Component.m_237113_((String)"Distortion"), (Component)Component.m_237113_((String)"Toggles virus effects between:\nHarming - standard effect, deals damage over time\nNullifying - removes status effects\nDebilitating - gives blindness and slowness"));
    public static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> GRAB_HIT_FINAL = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 27, 34, 0.75f, 4.0f, 8, 2.0f, 1.25f, 0.0f).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Grab (Final Hit)"), (Component)Component.m_237119_());
    public static final SimpleMultiHitAttack<AbstractPurpleHazeEntity<?, ?>> GRAB_HIT = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(0, 34, 0.75f, 1.0f, 10, 2.0f, 0.0f, 0.0f, (IntCollection)IntSet.of((int[])new int[]{6, 8, 10, 12, 14, 16, 18})).withImpactSound(JSoundRegistry.IMPACT_1)).withStunType(StunType.UNBURSTABLE)).withFinisher(19, GRAB_HIT_FINAL)).withInfo((Component)Component.m_237113_((String)"Grab (Final Hit)"), (Component)Component.m_237119_());
    public static final GrabAttack<PurpleHazeDistortionEntity, State> GRAB = (GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)new GrabAttack(280, 12, 24, 0.75f, 0.0f, 45, 1.5f, 0.0f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT), 25, 1.0).withCrouchingVariant(GROUND_SLAM)).withSound(JSoundRegistry.D4C_THROW)).withImpactSound(JSoundRegistry.PH_GRAB_HIT)).withInfo((Component)Component.m_237113_((String)"Grab"), (Component)Component.m_237113_((String)"unblockable, combo finisher"));

    public PurpleHazeDistortionEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.PURPLE_HAZE_DISTORTION.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.8f, 0.2f, 1.0f), new Vector3f(1.0f, 0.2f, 0.6f), new Vector3f(0.2f, 0.8f, 0.6f), new Vector3f(1.0f, 0.3f, 0.5f)};
    }

    private static void registerMoves(MoveMap<PurpleHazeDistortionEntity, State> moves) {
        MoveMap.Entry<PurpleHazeDistortionEntity, State> light = moves.register(MoveClass.LIGHT, LIGHT_ATTACK, State.PUNCH);
        light.withFollowup(State.LIGHT_FOLLOWUP);
        light.withCrouchingVariant(State.BACKHAND).withFollowup(State.BACKHAND_FOLLOWUP);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.HEAVY, HEAVY, State.HEAVY);
        moves.register(MoveClass.SPECIAL1, LAUNCH_CAPSULE, State.LAUNCH).withCrouchingVariant(State.LAUNCH2);
        moves.register(MoveClass.SPECIAL2, REKKA_1, State.REKKA1).withFollowup(State.REKKA2).withFollowup(State.REKKA3);
        moves.register(MoveClass.SPECIAL3, GRAB, State.GRAB).withCrouchingVariant(State.GROUND_SLAM);
        moves.register(MoveClass.ULTIMATE, FULL_RELEASE, State.FULL_RELEASE);
        moves.register(MoveClass.UTILITY, DISTORTION).withCrouchingVariant(CooldownType.UTILITY, null);
    }

    @Override
    protected void tickRemoteState(double f, double s, boolean dashing) {
        if (this.getState() == State.IDLE) {
            if (s > 0.0) {
                this.setStateNoReset(dashing ? State.RIGHT : State.RIGHT_DASH);
            }
            if (s < 0.0) {
                this.setStateNoReset(dashing ? State.LEFT : State.LEFT_DASH);
            }
            if (f < 0.0) {
                this.setStateNoReset(dashing ? State.BACKWARD : State.BACKWARD_DASH);
            }
            if (f > 0.0) {
                this.setStateNoReset(dashing ? State.FORWARD : State.FORWARD_DASH);
            }
        }
    }

    @Override
    @NonNull
    public PurpleHazeDistortionEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NonNull
    protected String getSummonAnimation() {
        return "animation.purple_haze.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<PurpleHazeDistortionEntity>
    {
        IDLE((PurpleHaze, builder) -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.idle"))),
        PUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.heavy"))),
        FULL_RELEASE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.full_release"))),
        GROUND_SLAM(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.ground_slam"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.barrage"))),
        LAUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.launch"))),
        LAUNCH2(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.launch2"))),
        REKKA1(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.rekka1"))),
        REKKA2(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.rekka2"))),
        REKKA3(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.rekka3"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.grab_hit"))),
        BACKHAND(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.backhand"))),
        BACKHAND_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.backhand_followup"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.light_followup"))),
        FORWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.forw"))),
        BACKWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.back"))),
        LEFT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.left"))),
        RIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.right"))),
        FORWARD_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.fdash"))),
        BACKWARD_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.bdash"))),
        LEFT_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.ldash"))),
        RIGHT_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.rdash")));

        private final BiConsumer<PurpleHazeDistortionEntity, AnimationState<PurpleHazeDistortionEntity>> animator;

        private State(Consumer<AnimationState<PurpleHazeDistortionEntity>> animator) {
            this((PurpleHazeDistortionEntity silverChariot, AnimationState<PurpleHazeDistortionEntity> builder) -> animator.accept((AnimationState<PurpleHazeDistortionEntity>)builder));
        }

        private State(BiConsumer<PurpleHazeDistortionEntity, AnimationState<PurpleHazeDistortionEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(PurpleHazeDistortionEntity attacker, AnimationState<PurpleHazeDistortionEntity> state) {
            this.animator.accept(attacker, state);
        }
    }
}

