/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.player.CommonPhComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.ai.AttackerBrainInfo;
import net.arna.jcraft.common.ai.brain.StandAttackerBrain;
import net.arna.jcraft.common.attack.moves.purplehaze.BackhandAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.PHGroundSlamAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.PHRekkaAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.PlayMove;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class PurpleHazeEntity
extends AbstractPurpleHazeEntity<PurpleHazeEntity, State> {
    public static final MoveSet<PurpleHazeEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.PURPLE_HAZE, PurpleHazeEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(225.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.purple_haze")).proCount(3).conCount(3).freeSpace((Component)Component.m_237113_((String)"PASSIVE: Rage\nBuilds up while the stand is summoned.\nMaxes out after 1 minute. When maxed, aura turns red.\nRage decreases by half with each living thing Purple Haze kills.\nPurple Haze has a chance to target it's own user which increases with rage.\n\nEVOLUTION: Give Purple Haze any flower after it has killed a stand user.\nDoing this 5 times will evolve it into Purple Haze: Distortion.")).skinName((Component)Component.m_237113_((String)"Toxin")).skinName((Component)Component.m_237113_((String)"Stopping Force")).skinName((Component)Component.m_237113_((String)"Reversal")).build()).summonData(SummonData.of(JSoundRegistry.PH_SUMMON)).build();
    @NonNull
    private static final KnockdownAttack<AbstractPurpleHazeEntity<?, ?>> CROUCHING_LIGHT_FOLLOWUP_ATTACK = (KnockdownAttack)((KnockdownAttack)BACKHAND_FOLLOWUP.copy().withAnim(State.BACKHAND_FOLLOWUP)).allowHitUser();
    @NonNull
    private static final BackhandAttack CROUCHING_LIGHT_ATTACK = (BackhandAttack)((BackhandAttack)BACKHAND.copy().withFollowup(CROUCHING_LIGHT_FOLLOWUP_ATTACK)).allowHitUser();
    @NonNull
    private static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> LIGHT_FOLLOWUP_ATTACK = (SimpleAttack)((SimpleAttack)LIGHT_FOLLOWUP.copy().withAnim(State.LIGHT_FOLLOWUP)).allowHitUser();
    @NonNull
    private static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> LIGHT_ATTACK = (SimpleAttack)((SimpleAttack)((SimpleAttack)LIGHT.copy().withFollowup(LIGHT_FOLLOWUP_ATTACK)).withCrouchingVariant(CROUCHING_LIGHT_ATTACK)).allowHitUser();
    @NonNull
    private static final MainBarrageAttack<AbstractPurpleHazeEntity<?, ?>> BARRAGE_ATTACK = (MainBarrageAttack)AbstractPurpleHazeEntity.BARRAGE.copy().allowHitUser();
    @NonNull
    private static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> HEAVY_ATTACK = (SimpleAttack)HEAVY.copy().allowHitUser();
    @NonNull
    private static final KnockdownAttack<AbstractPurpleHazeEntity<?, ?>> REKKA_3 = (KnockdownAttack)((KnockdownAttack)REKKA3.copy().withAnim(State.REKKA3)).allowHitUser();
    @NonNull
    private static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> REKKA_2 = (SimpleAttack)((SimpleAttack)((SimpleAttack)REKKA2.copy().withAnim(State.REKKA2)).withFollowup(REKKA_3)).allowHitUser();
    @NonNull
    private static final PHRekkaAttack REKKA_1 = (PHRekkaAttack)((PHRekkaAttack)((PHRekkaAttack)REKKA1.copy().withAnim(State.REKKA1)).withFollowup(REKKA_2)).allowHitUser();
    @NonNull
    private static final PHGroundSlamAttack GROUND_SLAM = (PHGroundSlamAttack)AbstractPurpleHazeEntity.GROUND_SLAM.copy().allowHitUser();
    public static final SimpleAttack<AbstractPurpleHazeEntity<?, ?>> GRAB_HIT_FINAL = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 27, 34, 0.75f, 4.0f, 8, 2.0f, 1.25f, 0.0f).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).allowHitUser()).withInfo((Component)Component.m_237113_((String)"Grab (Final Hit)"), (Component)Component.m_237119_());
    public static final SimpleMultiHitAttack<AbstractPurpleHazeEntity<?, ?>> GRAB_HIT = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(0, 34, 0.75f, 1.0f, 10, 2.0f, 0.0f, 0.0f, (IntCollection)IntSet.of((int[])new int[]{6, 8, 10, 12, 14, 16, 18})).withImpactSound(JSoundRegistry.IMPACT_1)).withStunType(StunType.UNBURSTABLE)).withFinisher(19, GRAB_HIT_FINAL)).allowHitUser()).withInfo((Component)Component.m_237113_((String)"Grab (Final Hit)"), (Component)Component.m_237119_());
    public static final GrabAttack<PurpleHazeEntity, State> GRAB = (GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)new GrabAttack(280, 12, 24, 0.75f, 0.0f, 45, 1.5f, 0.0f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT), 25, 1.0).withCrouchingVariant(GROUND_SLAM)).withSound(JSoundRegistry.D4C_THROW)).withImpactSound(JSoundRegistry.PH_GRAB_HIT)).allowHitUser()).withInfo((Component)Component.m_237113_((String)"Grab"), (Component)Component.m_237113_((String)"unblockable, combo finisher"));
    private static final PlayMove PLAY = (PlayMove)new PlayMove(0, 30, 31).withInfo((Component)Component.m_237113_((String)"Playing with flower"), (Component)Component.m_237119_());
    public static final int MAX_RAGE = 1200;
    private int rage = 0;
    private boolean flowerable = false;
    private boolean hasFlower = false;
    private boolean toEvolve = false;
    private final AttackerBrainInfo attackerBrainInfo = new AttackerBrainInfo(15);
    final Comparator<Entity> distanceComparator = (entity1, entity2) -> {
        double distance1 = this.m_20280_((Entity)entity1);
        double distance2 = this.m_20280_((Entity)entity2);
        return Double.compare(distance1, distance2);
    };

    public PurpleHazeEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.PURPLE_HAZE.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 0.2f, 0.6f), new Vector3f(0.3f, 1.0f, 0.6f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.5f, 0.3f, 1.0f)};
    }

    @Override
    public Vector3f getAuraColor() {
        if (this.rage == 1200) {
            return new Vector3f(1.0f, 0.0f, 0.0f);
        }
        return super.getAuraColor();
    }

    @Override
    public void desummon() {
        if (this.toEvolve && this.hasUser()) {
            JComponentPlatformUtils.getStandComponent(this.getUserOrThrow()).setType((StandType)JStandTypeRegistry.PURPLE_HAZE_DISTORTION.get());
            JCraft.summon(this.m_9236_(), this.getUserOrThrow());
        }
        super.desummon();
    }

    private static void registerMoves(MoveMap<PurpleHazeEntity, State> moves) {
        MoveMap.Entry<PurpleHazeEntity, State> light = moves.register(MoveClass.LIGHT, LIGHT_ATTACK, State.PUNCH);
        light.withFollowup(State.LIGHT_FOLLOWUP);
        light.withCrouchingVariant(State.BACKHAND).withFollowup(State.BACKHAND_FOLLOWUP);
        moves.register(MoveClass.BARRAGE, BARRAGE_ATTACK, State.BARRAGE);
        moves.register(MoveClass.HEAVY, HEAVY_ATTACK, State.HEAVY);
        moves.register(MoveClass.SPECIAL1, LAUNCH_CAPSULE, State.LAUNCH).withCrouchingVariant(State.LAUNCH2);
        moves.register(MoveClass.SPECIAL2, REKKA_1, State.REKKA1);
        moves.register(MoveClass.SPECIAL3, GRAB, State.GRAB).withCrouchingVariant(State.GROUND_SLAM);
        moves.register(MoveClass.ULTIMATE, FULL_RELEASE, State.FULL_RELEASE);
    }

    @Override
    public void queueMove(MoveInputType type) {
        if (!this.remoteControllable() && this.queuedMove == MoveInputType.STAND_SUMMON) {
            return;
        }
        super.queueMove(type);
    }

    @Override
    public boolean handleMove(MoveClass moveClass) {
        AbstractMove move;
        LivingEntity stateChecker;
        MoveMap.Entry entry = this.getFirstValidEntry(moveClass);
        if (entry == null) {
            return false;
        }
        Object object = stateChecker = this.isRemote() && !this.remoteControllable() ? this : this.getUserOrThrow();
        if (this.hasUser() && !stateChecker.m_20096_() && entry.getAerialVariant() != null) {
            entry = entry.getAerialVariant();
        }
        if (this.hasUser() && stateChecker.m_6144_() && entry.getCrouchingVariant() != null) {
            entry = entry.getCrouchingVariant();
        }
        if (this.hasUser() && !stateChecker.m_20096_() && entry.getAerialVariant() != null) {
            entry = entry.getAerialVariant();
        }
        return this.handleMove((move = entry.getMove()).isCopyOnUse() ? move.copy() : move, entry.getCooldownType(), (State)entry.getAnimState());
    }

    @Override
    public boolean allowMoveHandling() {
        return this.remoteControllable();
    }

    @Override
    public boolean remoteControllable() {
        return false;
    }

    @Override
    public void standBlock() {
        if (!this.hasUser()) {
            return;
        }
        List toDeflect = this.m_9236_().m_6443_(Projectile.class, this.m_20191_().m_82400_(0.75), EntitySelector.f_20402_);
        for (Projectile projectile : toDeflect) {
            if (projectile.m_19749_() == this.getUserOrThrow()) continue;
            projectile.m_20256_(projectile.m_20184_().m_82490_(-0.5).m_82520_(0.0, -0.1, 0.0));
            projectile.f_19864_ = true;
        }
        if (!this.isRemote()) {
            JCraft.stun(this.getUserOrThrow(), 2, 2);
        }
        this.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 3, false, false, true));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.hasFlower) {
            if (this.getMoveStun() > 0) {
                this.rage = 0;
                if (this.f_21344_.m_26572_()) {
                    this.f_21344_.m_26573_();
                }
            } else {
                this.desummon();
            }
        } else {
            if (++this.rage >= 1200) {
                this.rage = 1200;
            }
            if (!this.hasUser()) {
                return;
            }
            LivingEntity user = this.getUser();
            if (!this.m_9236_().m_5776_()) {
                boolean isRemote = this.isRemote();
                if (!this.remoteControllable()) {
                    Player player;
                    LivingEntity target;
                    if (this.getAlphaOverride() != 1.0f) {
                        this.setAlphaOverride(1.0f);
                    }
                    if ((target = this.m_5448_()) != null && !target.m_6084_() || target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
                        target = null;
                    }
                    if (target == null) {
                        List potentialTargets = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(64.0), EntitySelector.f_20406_.and(EntitySelector.f_20403_));
                        potentialTargets.remove(this);
                        potentialTargets.sort(this.distanceComparator);
                        for (LivingEntity potentialTarget : potentialTargets) {
                            StandEntity standEntity;
                            if (!this.m_142582_((Entity)potentialTarget)) continue;
                            if (potentialTarget instanceof StandEntity && (standEntity = (StandEntity)potentialTarget).hasUser()) {
                                this.m_6710_(standEntity.getUserOrThrow());
                            } else if (potentialTarget == user) {
                                if (this.f_19797_ % 20 != 0 || !(this.f_19796_.m_188500_() * 1200.0 <= (double)this.rage)) continue;
                                this.m_6710_(user);
                            } else {
                                this.m_6710_(potentialTarget);
                            }
                            break;
                        }
                    } else {
                        double speed = this.m_21133_(Attributes.f_22279_);
                        if (Objects.requireNonNull(user).m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
                            speed = user.m_6113_();
                        }
                        if (this.f_19797_ % 4 == 0) {
                            this.f_21344_.m_5624_((Entity)target, speed);
                        }
                    }
                    if (!isRemote) {
                        this.setRemote(true);
                    }
                }
                if (isRemote) {
                    this.tickRemoteState(this.m_21566_().m_24999_(), this.m_21566_().f_24980_, this.m_20096_());
                    StandAttackerBrain.tick(this, this.attackerBrainInfo);
                }
            }
        }
    }

    public float m_6113_() {
        return 0.15f;
    }

    protected float m_274460_() {
        return 0.02f;
    }

    @Override
    protected void tickRemoteState(double f, double s, boolean dashing) {
        LivingEntity user = this.getUserOrThrow();
        if (this.getState() == State.IDLE) {
            if (JUtils.canAct(user)) {
                if (s > 0.0) {
                    this.setStateNoReset(dashing ? State.RIGHT : State.RIGHT_DASH);
                }
                if (s < 0.0) {
                    this.setStateNoReset(dashing ? State.LEFT : State.LEFT_DASH);
                }
                if (f < 0.0) {
                    this.setStateNoReset(dashing ? State.BACKWARD : State.BACKWARD_DASH);
                }
                if (f > 0.0) {
                    this.setStateNoReset(dashing ? State.FORWARD : State.FORWARD_DASH);
                }
            } else {
                this.setStateNoReset(State.HURT);
            }
        }
    }

    @Override
    @NonNull
    public PurpleHazeEntity getThis() {
        return this;
    }

    @Override
    public void freshKill(@Nullable LivingEntity entity) {
        super.freshKill(entity);
        if (!StandTypeUtil.isNone(JComponentPlatformUtils.getStandComponent(entity).getType())) {
            this.flowerable = true;
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player == this.getUser() && stack.m_204117_(ItemTags.f_13149_)) {
            if (!this.flowerable) {
                return InteractionResult.FAIL;
            }
            this.m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_());
            stack.m_41774_(1);
            this.flowerable = false;
            this.hasFlower = true;
            if (!this.m_9236_().m_5776_()) {
                this.setMove(PLAY, State.PLAY);
                CommonPhComponent ph = JComponentPlatformUtils.getPhData(player);
                ph.increaseLevel();
                if (ph.getLevel() >= 5) {
                    ph.resetLevel();
                    this.toEvolve = true;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NonNull
    protected String getSummonAnimation() {
        return "animation.purple_haze.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<PurpleHazeEntity>
    {
        IDLE((PurpleHaze, builder) -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.idle"))),
        PUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.heavy"))),
        FULL_RELEASE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.full_release"))),
        GROUND_SLAM(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.ground_slam"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.barrage"))),
        LAUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.launch"))),
        LAUNCH2(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.launch2"))),
        REKKA1(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.rekka1"))),
        REKKA2(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.rekka2"))),
        REKKA3(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.rekka3"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.grab_hit"))),
        BACKHAND(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.backhand"))),
        BACKHAND_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.backhand_followup"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.light_followup"))),
        HURT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.hurt"))),
        PLAY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.purple_haze.play"))),
        FORWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.forw"))),
        BACKWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.back"))),
        LEFT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.left"))),
        RIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.right"))),
        FORWARD_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.fdash"))),
        BACKWARD_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.bdash"))),
        LEFT_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.ldash"))),
        RIGHT_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.purple_haze.rdash")));

        private final BiConsumer<PurpleHazeEntity, AnimationState<PurpleHazeEntity>> animator;

        private State(Consumer<AnimationState<PurpleHazeEntity>> animator) {
            this((PurpleHazeEntity silverChariot, AnimationState<PurpleHazeEntity> builder) -> animator.accept((AnimationState<PurpleHazeEntity>)builder));
        }

        private State(BiConsumer<PurpleHazeEntity, AnimationState<PurpleHazeEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(PurpleHazeEntity attacker, AnimationState<PurpleHazeEntity> state) {
            this.animator.accept(attacker, state);
        }
    }
}

