/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import com.mojang.datafixers.util.Either;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.EffectAction;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.TimeSkipMove;
import net.arna.jcraft.common.attack.moves.shared.TimeStopMove;
import net.arna.jcraft.common.attack.moves.starplatinum.theworld.SPTWGroundSlamAttack;
import net.arna.jcraft.common.attack.moves.starplatinum.theworld.TimeStrikeAttack;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.entity.stand.AbstractStarPlatinumEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.joml.Vector3f;

public final class SPTWEntity
extends AbstractStarPlatinumEntity<SPTWEntity, State> {
    public static final MoveSet<SPTWEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.STAR_PLATINUM_THE_WORLD, SPTWEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(315.0f).evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.sptw")).proCount(4).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the superman\n    Punch>cr.Time Strike>Backhand>What an Ugly Watch>delay Punch>Timestop~Star Breaker>dash/Timeskip>Barrage>Light")).skinName((Component)Component.m_237113_((String)"Judge, Jury, Executioner")).skinName((Component)Component.m_237113_((String)"Diamond")).skinName((Component)Component.m_237113_((String)"Over Heaven")).build()).summonData(SummonData.of(JSoundRegistry.STAR_PLATINUM_SUMMON)).build();
    public static final SPTWGroundSlamAttack GROUND_SLAM = (SPTWGroundSlamAttack)((SPTWGroundSlamAttack)((SPTWGroundSlamAttack)((SPTWGroundSlamAttack)((SPTWGroundSlamAttack)new SPTWGroundSlamAttack(0, 12, 19, 0.75f, 7.0f, 11, 1.8f, 0.0f, 0.8f).withAnim(State.GROUND_SLAM)).withImpactSound(JSoundRegistry.IMPACT_8)).withLaunchNoShockwave()).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237115_((String)"jcraft.sptw.crm1"), (Component)Component.m_237113_((String)"low hitbox, decent damage, launches"));
    public static final SimpleAttack<SPTWEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 5, 14, 0.75f, 6.0f, 12, 1.5f, 1.0f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.m1m1"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<SPTWEntity> PUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(5, 7, 0.75f, 5.0f, 10, 0.2f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(GROUND_SLAM)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.m1"), (Component)Component.m_237113_((String)"quick combo starter, low knockback"));
    public static final MainBarrageAttack<SPTWEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 40, 0.75f, 1.0f, 30, 2.0f, 0.25f, 0.0f, 3, Blocks.f_50080_.m_155943_()).withSound(JSoundRegistry.STAR_PLATINUM_BARRAGE)).withInfo((Component)Component.m_237115_((String)"jcraft.generic.barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final TimeStrikeAttack TIME_STRIKE = (TimeStrikeAttack)((TimeStrikeAttack)((TimeStrikeAttack)new TimeStrikeAttack(300, 7, 11, 0.75f, 5.0f, 12, 1.5f, 0.6f, -0.25f).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(1.0)).withInfo((Component)Component.m_237115_((String)"jcraft.sptw.sp1"), (Component)Component.m_237113_((String)"Teleports forward 2.5m after a short windup, then delivers a fast, low stun hit.\nCrouch to turn around after teleport."));
    public static final SimpleAttack<SPTWEntity> BACKHAND = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 12, 0.75f, 6.0f, 20, 1.5f, 0.25f, 0.0f).withSound(JSoundRegistry.SPTW_BACKHAND)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(1.0)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237115_((String)"jcraft.sptw.sp2"), (Component)Component.m_237113_((String)"fast poke, great stun"));
    public static final KnockdownAttack<SPTWEntity> GRAB_SLAM = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 16, 24, 1.0f, 9.0f, 10, 1.75f, 0.4f, 0.0f, 25).withSound(JSoundRegistry.SPTW_UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_1)).withHyperArmor()).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_3)).withInfo((Component)Component.m_237115_((String)"jcraft.sptw.crsp3hit"), (Component)Component.m_237119_());
    public static final GrabAttack<SPTWEntity, State> GRAB2 = (GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)new GrabAttack(280, 8, 20, 1.0f, 2.0f, 20, 1.5f, 0.1f, 0.0f, GRAB_SLAM, StateContainer.of(State.GRAB_HIT2)).withSound(JSoundRegistry.SPTW_GRAB)).withImpactSound(JSoundRegistry.SPTW_GRABHIT)).withHitAnimation(null)).withInfo((Component)Component.m_237115_((String)"jcraft.sptw.sp3"), (Component)Component.m_237113_((String)"grab, high damage combo-finishing knockdown"));
    public static final SimpleAttack<SPTWEntity> GRAB_HIT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 16, 24, 1.0f, 6.0f, 20, 1.75f, 0.4f, 0.0f).withSound(JSoundRegistry.SPTW_UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_6)).withAction(EffectAction.inflict(MobEffects.f_19620_, 5, 10, true, false))).withLaunch()).withHyperArmor()).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237115_((String)"jcraft.sptw.sp3hit"), (Component)Component.m_237119_());
    public static final GrabAttack<SPTWEntity, State> GRAB = (GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)new GrabAttack<State, State>(280, 8, 20, 1.0f, 2.0f, 20, 1.5f, 0.1f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT)).withCrouchingVariant(GRAB2)).withSound(JSoundRegistry.SPTW_GRAB)).withImpactSound(JSoundRegistry.SPTW_GRABHIT)).withHitAnimation(null)).withInfo((Component)Component.m_237115_((String)"jcraft.sptw.sp3"), (Component)Component.m_237113_((String)"grab, combo-starting uppercut"));
    public static final TimeStopMove<SPTWEntity> TIME_STOP = (TimeStopMove)((TimeStopMove)new TimeStopMove(600, 5, 10, (Either<Integer, IntOption>)Either.right((Object)JServerConfig.SPTW_TIME_STOP_DURATION)).withSound(JSoundRegistry.STAR_PLATINUM_THE_WORLD)).withInfo((Component)Component.m_237115_((String)"jcraft.generic.ts"), (Component)Component.m_237113_((String)"1.75 seconds, extremely low windup"));
    public static final TimeSkipMove<SPTWEntity> TIME_SKIP = (TimeSkipMove)new TimeSkipMove(300, 14.0).withSound((RegistrySupplier)JSoundRegistry.STAR_PLATINUM_TIMESKIP).withInfo((Component)Component.m_237115_((String)"jcraft.generic.tp"), (Component)Component.m_237113_((String)"14m range"));

    public SPTWEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.STAR_PLATINUM_THE_WORLD.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.8f, 0.6f, 1.0f), new Vector3f(1.0f, 0.4f, 0.8f), new Vector3f(0.7f, 0.7f, 1.0f), new Vector3f(0.8f, 1.0f, 1.0f)};
    }

    private static void registerMoves(MoveMap<SPTWEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, PUNCH, State.PUNCH);
        moves.register(MoveClass.HEAVY, STAR_BREAKER, State.HEAVY).withCrouchingVariant(State.GROUND_BREAKER);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, TIME_STRIKE, State.TIME_STRIKE);
        moves.register(MoveClass.SPECIAL2, BACKHAND, State.BACKHAND);
        moves.register(MoveClass.SPECIAL3, GRAB, State.GRAB).withCrouchingVariant(State.GRAB);
        moves.register(MoveClass.ULTIMATE, TIME_STOP, State.TIME_STOP);
        moves.register(MoveClass.UTILITY, TIME_SKIP, State.TIME_SKIP);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    public void desummon() {
        if (this.tsTime > 0) {
            return;
        }
        super.desummon();
    }

    @Override
    @NonNull
    public SPTWEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    protected String getSummonAnimation() {
        return "animation.sptw.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<SPTWEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.sptw.idle"))),
        PUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.punch"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.sptw.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.heavy"))),
        GROUND_BREAKER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.ground_break"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.sptw.barrage"))),
        TIME_STRIKE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.timestrike"))),
        TIME_STOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.timestop"))),
        BACKHAND(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.backhand"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.grabhit"))),
        GRAB_HIT2(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.grabhit2"))),
        TIME_SKIP(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.sptw.idle"))),
        GROUND_SLAM(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.ground_slam"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.sptw.light_followup")));

        private final Consumer<AnimationState<SPTWEntity>> animator;

        private State(Consumer<AnimationState<SPTWEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(SPTWEntity attacker, AnimationState<SPTWEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

