/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import com.mojang.datafixers.util.Either;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.shadowtheworld.ImpalingThrustAttack;
import net.arna.jcraft.common.attack.moves.shadowtheworld.STWChargeAttack;
import net.arna.jcraft.common.attack.moves.shadowtheworld.STWCounterAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleHoldableMove;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.attack.moves.shared.TimeSkipMove;
import net.arna.jcraft.common.attack.moves.shared.TimeStopMove;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.LungeAttack;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.entity.stand.AbstractTheWorldEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public final class ShadowTheWorldEntity
extends AbstractTheWorldEntity<ShadowTheWorldEntity, State> {
    public static final MoveSet<ShadowTheWorldEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.SHADOW_THE_WORLD, ShadowTheWorldEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-45.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.shadow_the_world")).proCount(5).conCount(4).freeSpace((Component)Component.m_237113_((String)"The user is allowed to use spec moves as soon as Shadow The World is performing one.\nDesummons itself upon finishing a move.\n")).skinName((Component)Component.m_237113_((String)"Contrast")).skinName((Component)Component.m_237113_((String)"Frost")).skinName((Component)Component.m_237113_((String)"Predator")).build()).summonData(SummonData.of(JSoundRegistry.STW_WARBLE)).build();
    public static final SimpleUppercutAttack<ShadowTheWorldEntity> UPPERCUT = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 10, 16, 0.75f, 6.0f, 20, 1.5f, 0.25f, -0.6f, 1.0f).withAnim(State.UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(0.0, 0.35, 1.25)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Uppercut"), (Component)Component.m_237113_((String)"slower combo starter, launches vertically"));
    public static final SimpleAttack<ShadowTheWorldEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(5, 7, 0.75f, 5.0f, 10, 0.1f, -0.1f).withImpactSound(JSoundRegistry.IMPACT_1)).withCrouchingVariant(UPPERCUT)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final KnockdownAttack<ShadowTheWorldEntity> GUARD_CANCEL = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 10, 16, 0.75f, 7.0f, 12, 1.75f, 2.0f, 0.0f, 25).withAnim(State.GUARD_CANCEL)).withHyperArmor()).withSound(JSoundRegistry.STW_WARBLE)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_3)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Shoulder Bash"), (Component)Component.m_237113_((String)"uninterruptible get-off-me tool, brief knockdown"));
    public static final LungeAttack LUNGE = (LungeAttack)((LungeAttack)((LungeAttack)((LungeAttack)((LungeAttack)new LungeAttack(0, 14, 20, 0.75f, 8.0f, 19, 1.6f, 2.0f, 0.0f, 10, 6).withCrouchingVariant(GUARD_CANCEL).withSound(JSoundRegistry.STW_WARBLE)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Lunge"), (Component)Component.m_237113_((String)"medium speed launcher"));
    public static final KnockdownAttack<ShadowTheWorldEntity> KNOCKDOWN = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 2, 4, 0.85f, 5.0f, 20, 1.75f, 2.0f, 0.0f, 35).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"3 Hit Combo (Finisher)"), (Component)Component.m_237119_());
    public static final SimpleMultiHitAttack<ShadowTheWorldEntity> THREE_HIT = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(0, 24, 0.85f, 4.0f, 15, 1.5f, 0.35f, 0.2f, (IntCollection)IntSet.of((int)6, (int)14)).withFinisher(20, KNOCKDOWN)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"3 Hit Combo"), (Component)Component.m_237113_((String)"knocks down"));
    public static final ImpalingThrustAttack IMPALING_THRUST_HIT = new ImpalingThrustAttack(0, 1, 11, 0.8f);
    public static final SimpleHoldableMove<ShadowTheWorldEntity> IMPALING_THRUST = (SimpleHoldableMove)((SimpleHoldableMove)((SimpleHoldableMove)((SimpleHoldableMove)new SimpleHoldableMove<ShadowTheWorldEntity>(200, 61, 60, 0.75f, 10).withFollowup(IMPALING_THRUST_HIT)).withInfo((Component)Component.m_237113_((String)"Impaling Thrust"), (Component)Component.m_237113_((String)"chargeable attack, Shadow The World prepares an attack, then stops time and hits everything between the start and end"))).markRanged()).withMobilityType(MobilityType.TELEPORT);
    public static final STWChargeAttack CHARGE = (STWChargeAttack)((STWChargeAttack)((STWChargeAttack)((STWChargeAttack)((STWChargeAttack)((STWChargeAttack)((STWChargeAttack)new STWChargeAttack(100, 5, 19, 5.0f, 5.0f, 20, 1.5f, 0.25f, 0.0f).withSound(JSoundRegistry.TW_CHARGE)).withSound(JSoundRegistry.STW_WARBLE)).withImpactSound(JSoundRegistry.TW_CHARGE_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withBlockStun(11)).withInfo((Component)Component.m_237113_((String)"Forward Charge"), (Component)Component.m_237113_((String)"The World detaches from the user and lunges forward, combo starter"));
    public static final TimeSkipMove<ShadowTheWorldEntity> TIME_SKIP = (TimeSkipMove)((TimeSkipMove)new TimeSkipMove(200, 7.0).withSound((RegistrySupplier)JSoundRegistry.TIME_SKIP)).withSound((RegistrySupplier)JSoundRegistry.STW_ZAP).withInfo((Component)Component.m_237113_((String)"Timeskip"), (Component)Component.m_237113_((String)"7m range"));
    public static final TimeStopMove<ShadowTheWorldEntity> TIME_STOP = (TimeStopMove)((TimeStopMove)new TimeStopMove(1400, 20, 30, (Either<Integer, IntOption>)Either.right((Object)JServerConfig.STW_TIME_STOP_DURATION)).withSound(JSoundRegistry.STW_TS)).withInfo((Component)Component.m_237113_((String)"Timestop"), (Component)Component.m_237113_((String)"2.5 seconds"));
    public static final STWCounterAttack COUNTER = (STWCounterAttack)new STWCounterAttack(400, 5, 20, 0.75f).withInfo((Component)Component.m_237113_((String)"Counter"), (Component)Component.m_237113_((String)"if struck by an opponent, you will stun them and teleport behind them\nduring this, you may not use your spec or move\n"));
    private int desummonTime = 6;
    private static final EntityDataAccessor<Boolean> DESUMMONING = SynchedEntityData.m_135353_(ShadowTheWorldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Vector3f INVIS_AURA = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final RawAnimation DESUMMON_SQUEEZE = RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.desummon");

    public ShadowTheWorldEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.SHADOW_THE_WORLD.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.5f, 0.1f, 0.7f), new Vector3f(0.8f, 0.2f, 0.4f), new Vector3f(0.2f, 0.6f, 8.0f), new Vector3f(0.7f, 0.3f, 1.0f)};
    }

    @Override
    public Vector3f getAuraColor() {
        if (this.getState() == State.COUNTER) {
            return INVIS_AURA;
        }
        return super.getAuraColor();
    }

    @Override
    public void queueMove(MoveInputType type) {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DESUMMONING, (Object)false);
    }

    private static void registerMoves(MoveMap<ShadowTheWorldEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
        moves.registerImmediate(MoveClass.HEAVY, LUNGE, State.LUNGE);
        moves.register(MoveClass.BARRAGE, THREE_HIT, State.THREE_HIT);
        moves.register(MoveClass.SPECIAL1, COUNTER, State.COUNTER);
        moves.register(MoveClass.SPECIAL2, CHARGE, State.CHARGE);
        moves.register(MoveClass.SPECIAL3, IMPALING_THRUST, State.IMPALING_THRUST_CHARGE).withFollowup(State.IMPALING_THRUST_HIT);
        moves.register(MoveClass.ULTIMATE, TIME_STOP, State.TIME_STOP);
        moves.register(MoveClass.UTILITY, TIME_SKIP, State.IDLE);
    }

    public void startAnimatedDesummon() {
        this.f_19804_.m_135381_(DESUMMONING, (Object)true);
        if (this.isFree()) {
            return;
        }
        this.setFree(true);
        this.setFreePos(this.m_20182_().m_252839_());
    }

    public boolean isAnimatedDesummoning() {
        return (Boolean)this.f_19804_.m_135370_(DESUMMONING);
    }

    @Override
    public boolean allowMoveHandling() {
        if (this.isAnimatedDesummoning()) {
            return false;
        }
        if (this.getState() == State.CHARGE_HIT) {
            return false;
        }
        boolean noMove = this.getCurrentMove() == null;
        return noMove || this.getCurrentMove().getMoveClass() == MoveClass.SPECIAL3;
    }

    @Override
    public void cancelMove() {
        if (this.isAnimatedDesummoning()) {
            return;
        }
        super.cancelMove();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isAnimatedDesummoning() && --this.desummonTime < 1) {
            this.m_146870_();
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.tsTime < 1 && (this.getCurrentMove() != null || this.getState() == State.CHARGE_HIT) && this.getMoveStun() == 1 && this.getState() != State.COUNTER) {
            this.setCurrentMove(null);
            this.setMoveStun(this.desummonTime);
            this.startAnimatedDesummon();
        }
    }

    @Override
    public boolean defaultToNear() {
        return !this.isAnimatedDesummoning();
    }

    public boolean m_20147_() {
        if (this.isAnimatedDesummoning()) {
            return true;
        }
        return super.m_20147_();
    }

    @Override
    @NonNull
    public ShadowTheWorldEntity getThis() {
        return this;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this.getThis(), "desummon", 0, this::desummonPredicate)});
    }

    private PlayState desummonPredicate(AnimationState<ShadowTheWorldEntity> state) {
        if (this.isAnimatedDesummoning()) {
            state.getController().setAnimation(DESUMMON_SQUEEZE);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NonNull
    protected String getSummonAnimation() {
        return "animation.shadow_the_world.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public int getDesummonTime() {
        return this.desummonTime;
    }

    public static enum State implements StandAnimationState<ShadowTheWorldEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.shadow_the_world.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.shadow_the_world.block"))),
        LUNGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.lunge"))),
        GUARD_CANCEL(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.guard_cancel"))),
        THREE_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.3hit"))),
        IMPALING_THRUST_CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.impaling_thrust_charge"))),
        IMPALING_THRUST_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.impaling_thrust_hit"))),
        CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.charge"))),
        CHARGE_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.charge_hit"))),
        UPPERCUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.uppercut"))),
        COUNTER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.counter"))),
        TIME_STOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.shadow_the_world.timestop")));

        private final BiConsumer<ShadowTheWorldEntity, AnimationState<ShadowTheWorldEntity>> animator;

        private State(Consumer<AnimationState<ShadowTheWorldEntity>> animator) {
            this((ShadowTheWorldEntity stand, AnimationState<ShadowTheWorldEntity> builder) -> animator.accept((AnimationState<ShadowTheWorldEntity>)builder));
        }

        private State(BiConsumer<ShadowTheWorldEntity, AnimationState<ShadowTheWorldEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(ShadowTheWorldEntity attacker, AnimationState<ShadowTheWorldEntity> builder) {
            this.animator.accept(attacker, builder);
        }
    }
}

