/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.conditions.HoldingAnubisCondition;
import net.arna.jcraft.common.attack.moves.shared.BarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleHoldableMove;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.ArmorOffAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.CircleSlashAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.CleaveAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.GodOfDeathAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.GodOfDeathHitAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.LastShotAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.RayDartAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.SCChargeAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.SCCounterAttack;
import net.arna.jcraft.common.attack.moves.silverchariot.SpinBarrageAttack;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SilverChariotEntity
extends StandEntity<SilverChariotEntity, State> {
    public static final MoveSet<SilverChariotEntity, State> DEFAULT_MOVE_SET = MoveSetManager.create(JStandTypeRegistry.SILVER_CHARIOT, SilverChariotEntity::registerDefaultMoves, State.class);
    public static final MoveSet<SilverChariotEntity, State> POSSESSED_MOVE_SET = MoveSetManager.create(JStandTypeRegistry.SILVER_CHARIOT, "possessed", SilverChariotEntity::registerPossessedMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(225.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.silverchariot")).proCount(4).conCount(3).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    (Armor ON) Light>Barrage>Light>Cleave>Spinning Blade>Shooting Star>Light\n    (Armor ON) Shooting Star>Light>Barrage>Impaling Thrust\n    (Armor OFF) Shooting Star>Light>Spinning Blade>Barrage>Light>Cleave>Impaling Thrust\n    (Armor OFF) Light>Spinning Blade>Barrage>Shooting Star>Cleave>Light\n    (Armor OFF) Impaling Thrust>dash>Barrage>...\n")).skinName((Component)Component.m_237113_((String)"Gold Chariot")).skinName((Component)Component.m_237113_((String)"OVA")).skinName((Component)Component.m_237113_((String)"Vento")).build()).summonData(SummonData.of(JSoundRegistry.SC_SUMMON)).build();
    public static final StandData POSSESSED_DATA = DATA.withInfo(info -> info.freeSpace((Component)Component.m_237113_((String)"BNBs:\n    (Light>)Charge~Barrage>Light>Spinning Blade>Light~Light\n    (Light>)Charge~Barrage>God of Death")));
    public static final LastShotAttack LAST_SHOT = (LastShotAttack)((LastShotAttack)new LastShotAttack(100, 12, 15, 1.0f).withAnim(State.LAST_SHOT)).withInfo((Component)Component.m_237113_((String)"Last Shot"), (Component)Component.m_237113_((String)"Silver Chariot fires his rapier, which can bounce 5 times off walls, nerfs all hitboxes and damage by 25% until returned"));
    public static final SimpleAttack<SilverChariotEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 14, 0.65f, 6.0f, 12, 1.5f, 1.2f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Slash"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<SilverChariotEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(5, 9, 0.65f, 5.0f, 11, 0.15f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(LAST_SHOT)).withSound(JSoundRegistry.SC_POKE)).withInfo((Component)Component.m_237113_((String)"Stab"), (Component)Component.m_237113_((String)"quick combo starter, links into Spinning Blade while armor is off"));
    public static final MainBarrageAttack<SilverChariotEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(240, 0, 40, 0.65f, 0.9f, 25, 2.25f, 0.1f, 0.0f, 3, 1.25f).withSound(JSoundRegistry.SC_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final SimpleAttack<SilverChariotEntity> HEAVY = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(28, 20, 28, 0.65f, 8.0f, 10, 2.0f, 1.5f, 0.0f).withExtraHitBox(2.0, 0.1, 1.0)).withSound(JSoundRegistry.SC_HEAVY)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Impaling Thrust"), (Component)Component.m_237113_((String)"slow, uninterruptible launcher"));
    public static final SpinBarrageAttack ANUBIS_SPIN_BARRAGE = (SpinBarrageAttack)((SpinBarrageAttack)((SpinBarrageAttack)((SpinBarrageAttack)new SpinBarrageAttack(0, 7, 24, 0.65f, 1.0f, 10, 2.0f, 0.15f, -0.2f, 2).withAnim(State.SPIN_2)).withCondition(HoldingAnubisCondition.holdingAnubis())).withSound(JSoundRegistry.SC_SPIN)).withInfo((Component)Component.m_237113_((String)"Divine Blade"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, low stun"));
    public static final BarrageAttack<SilverChariotEntity> SPIN_BARRAGE = (BarrageAttack)((BarrageAttack)((BarrageAttack)((BarrageAttack)new BarrageAttack<SilverChariotEntity>(100, 7, 24, 0.65f, 1.0f, 10, 2.0f, 0.1f, -0.2f, 2).withFollowup(ANUBIS_SPIN_BARRAGE)).withFollowupFrame(6)).withSound(JSoundRegistry.SC_SPIN)).withInfo((Component)Component.m_237113_((String)"Spinning Blade"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, low stun"));
    public static final RayDartAttack RAY_DART_LOW = (RayDartAttack)((RayDartAttack)((RayDartAttack)((RayDartAttack)new RayDartAttack(100, 10, 18, 0.65f, 6.0f, 20, 1.75f, 0.25f, 0.2f).withSound(JSoundRegistry.SC_CHARGE)).withSound(SoundEvents.f_12317_)).withBlockStun(9)).withInfo((Component)Component.m_237113_((String)"Lacerate"), (Component)Component.m_237113_((String)"Anubis Chariot and the user charge forward, high stun, low blockstun."));
    public static final RayDartAttack RAY_DART_HIGH = (RayDartAttack)((RayDartAttack)((RayDartAttack)((RayDartAttack)((RayDartAttack)((RayDartAttack)new RayDartAttack(100, 12, 20, 0.65f, 6.0f, 15, 2.0f, 0.25f, 0.2f).withCrouchingVariant(RAY_DART_LOW)).withSound(JSoundRegistry.SC_CHARGE)).withImpactSound(JSoundRegistry.IMPACT_1)).withBlockStun(16)).withExtraHitBox(1.0, 1.0, 1.0)).withInfo((Component)Component.m_237113_((String)"Split"), (Component)Component.m_237113_((String)"Anubis Chariot and the user charge forward, low stun, high blockstun."));
    public static final CleaveAttack CLEAVE = (CleaveAttack)((CleaveAttack)((CleaveAttack)((CleaveAttack)new CleaveAttack(0, 12, 21, 0.75f, 9.0f, 20, 2.5f, 0.8f, 0.0f).withSound(JSoundRegistry.SC_CLEAVE)).withImpactSound(SoundEvents.f_12317_)).withHyperArmor()).withInfo((Component)Component.m_237113_((String)"Cleave"), (Component)Component.m_237113_((String)"Silver Chariot detaches from the user, delivering an uninterruptible, combo-starting slice"));
    public static final SCChargeAttack CHARGE = (SCChargeAttack)((SCChargeAttack)((SCChargeAttack)new SCChargeAttack(280, 5, 19, 8.0f, 5.0f, 17, 1.5f, 0.25f, 0.0f).withSound(JSoundRegistry.SC_SUMMON)).withBackstab(false)).withInfo((Component)Component.m_237113_((String)"Shooting Star"), (Component)Component.m_237113_((String)"Silver Chariot detaches from the user and charges in the looked direction, combo starter/extender"));
    public static final SCCounterAttack COUNTER = (SCCounterAttack)new SCCounterAttack(480, 4, 34, 0.5f).withInfo((Component)Component.m_237113_((String)"Counter"), (Component)Component.m_237113_((String)"0.2s windup, 1.5s duration, stuns when hit"));
    public static final SimpleMultiHitAttack<SilverChariotEntity> GOD_OF_DEATH_FINAL = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(0, 59, 0.65f, 6.0f, 20, 2.5f, 1.25f, 0.0f, (IntCollection)IntSet.of((int)54)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withLaunch()).withHitSpark(JParticleType.HIT_SPARK_3)).withInfo((Component)Component.m_237113_((String)"God of Death (Final Hit)"), (Component)Component.m_237119_());
    public static final GodOfDeathHitAttack GOD_OF_DEATH_HIT = (GodOfDeathHitAttack)((GodOfDeathHitAttack)((GodOfDeathHitAttack)((GodOfDeathHitAttack)new GodOfDeathHitAttack(0, 59, 0.65f, 4.5f, 32, 2.0f, 0.25f, 0.0f, (IntCollection)IntSet.of((int)13, (int)23)).withFollowup(GOD_OF_DEATH_FINAL)).withImpactSound(JSoundRegistry.IMPACT_1)).withStunType(StunType.UNBURSTABLE)).withInfo((Component)Component.m_237113_((String)"God of Death (Hit)"), (Component)Component.m_237119_());
    public static final GodOfDeathAttack GOD_OF_DEATH = (GodOfDeathAttack)((GodOfDeathAttack)((GodOfDeathAttack)new GodOfDeathAttack(1000, 23, 28, 0.65f, 4.0f, 40, 1.75f, 0.0f, 0.0f).withFollowup(GOD_OF_DEATH_HIT)).withStunType(StunType.UNBURSTABLE)).withInfo((Component)Component.m_237113_((String)"God of Death"), (Component)Component.m_237113_((String)"high-damage beatdown, 1.5s stun on whiff, cannot be combo broken"));
    public static final ArmorOffAttack ARMOR_OFF = (ArmorOffAttack)((ArmorOffAttack)((ArmorOffAttack)new ArmorOffAttack(1200, 6, 15, 0.65f, 4.0f, 7, 1.75f, 0.75f, 0.0f).withSound(JSoundRegistry.SC_ARMOROFF)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Armor Off"), (Component)Component.m_237113_((String)"25s of faster moves"));
    public static final CircleSlashAttack CIRCLE_SLASH = (CircleSlashAttack)((CircleSlashAttack)((CircleSlashAttack)((CircleSlashAttack)new CircleSlashAttack(0, 2, 20, 0.65f, 5.0f, 20, 1.75f, 0.0f, 0.0f).withExtraHitBox(-0.65, 0.0, 2.0)).withLaunch()).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Circle Slash (Hit)"), (Component)Component.m_237119_());
    public static final SimpleHoldableMove<SilverChariotEntity> CIRCLE_CHARGE = (SimpleHoldableMove)((SimpleHoldableMove)((SimpleHoldableMove)new SimpleHoldableMove(0, 101, 100, 0.65f, 15).withFollowup(CIRCLE_SLASH.withAnim(State.CIRCLE_SLASH))).withArmor(2)).withInfo((Component)Component.m_237113_((String)"Circle Slash"), (Component)Component.m_237113_((String)"2 armor points\nCan be held, and released 0.75s in.\nDepending on how much you hold, the damage and launch height increase."));
    private static final EntityDataAccessor<Boolean> HAS_RAPIER = SynchedEntityData.m_135353_(SilverChariotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MODE = SynchedEntityData.m_135353_(SilverChariotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ARMOR_TIME = SynchedEntityData.m_135353_(SilverChariotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SilverChariotEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.SILVER_CHARIOT.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.4f, 0.5f, 1.0f), new Vector3f(0.9f, 0.6f, 0.3f), new Vector3f(0.6f, 0.7f, 1.0f), new Vector3f(0.8f, 0.8f, 0.8f)};
    }

    @Override
    public Vector3f getAuraColor() {
        if (this.isPossessed()) {
            return new Vector3f(1.0f, 0.0f, 0.0f);
        }
        return super.getAuraColor();
    }

    @Override
    protected void switchMoveSet(String name) {
        Vec3 lookDir = this.getMoveMap().findMoveByType(SCChargeAttack.class).map(SCChargeAttack::getLookDir).orElse(null);
        super.switchMoveSet(name);
        this.getMoveMap().findMoveByType(SCChargeAttack.class).ifPresent(m -> m.setLookDir(lookDir));
    }

    @Override
    public StandData getStandData() {
        if (this.isPossessed()) {
            return StandTypeUtil.getStandData(JCraft.id("silver_chariot_possessed"));
        }
        return super.getStandData();
    }

    @Override
    public int getModeOrdinal() {
        return this.getMode().ordinal();
    }

    public int getArmorTime() {
        return (Integer)this.f_19804_.m_135370_(ARMOR_TIME);
    }

    public void setArmorTime(int armorTime) {
        this.f_19804_.m_135381_(ARMOR_TIME, (Object)armorTime);
    }

    public int decrementArmorTime() {
        this.setArmorTime(this.getArmorTime() - 1);
        return this.getArmorTime();
    }

    private static void registerDefaultMoves(MoveMap<SilverChariotEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.STAB);
        moves.register(MoveClass.HEAVY, HEAVY, State.HEAVY);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, SPIN_BARRAGE, State.SPIN);
        moves.register(MoveClass.SPECIAL2, CHARGE, State.P_CHARGE);
        moves.register(MoveClass.SPECIAL3, CLEAVE, State.CLEAVE);
        moves.register(MoveClass.ULTIMATE, ARMOR_OFF, State.ARMOR_OFF);
        moves.register(MoveClass.UTILITY, CIRCLE_CHARGE, State.CIRCLE_CHARGE).withFollowup(State.CIRCLE_SLASH);
    }

    private static void registerPossessedMoves(MoveMap<SilverChariotEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.STAB);
        moves.register(MoveClass.HEAVY, HEAVY, State.HEAVY);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, SPIN_BARRAGE, State.SPIN).withFollowup(State.SPIN_2);
        moves.register(MoveClass.SPECIAL2, RAY_DART_HIGH, State.CHARGE_HIGH).withCrouchingVariant(State.CHARGE_LOW);
        moves.register(MoveClass.SPECIAL3, COUNTER, State.COUNTER);
        moves.register(MoveClass.ULTIMATE, GOD_OF_DEATH, State.BEAT_DOWN_START);
        moves.register(MoveClass.UTILITY, CIRCLE_CHARGE, State.CIRCLE_CHARGE).withFollowup(State.CIRCLE_SLASH);
    }

    public Mode getMode() {
        return Mode.values()[(Integer)this.f_19804_.m_135370_(MODE)];
    }

    public void setMode(Mode mode) {
        this.f_19804_.m_135381_(MODE, (Object)mode.ordinal());
    }

    public boolean hasRapier() {
        return (Boolean)this.f_19804_.m_135370_(HAS_RAPIER);
    }

    public void setHasRapier(boolean hasRapier) {
        this.f_19804_.m_135381_(HAS_RAPIER, (Object)hasRapier);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_RAPIER, (Object)true);
        this.f_19804_.m_135372_(MODE, (Object)Mode.REGULAR.ordinal());
        this.f_19804_.m_135372_(ARMOR_TIME, (Object)0);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        return this.tryFollowUp(moveClass, MoveClass.LIGHT) || super.initMove(moveClass);
    }

    @Override
    public boolean handleMove(AbstractMove<?, ? super SilverChariotEntity> move, CooldownType cooldownType, State animState) {
        if (!move.canBeInitiated(this)) {
            return false;
        }
        LivingEntity user = this.getUserOrThrow();
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(user);
        int cooldown = cooldowns.getCooldown(cooldownType);
        if (cooldown > 0) {
            return false;
        }
        Object attackRef = move.copy();
        if (this.getMode() == Mode.ARMORLESS) {
            ((AbstractMove)attackRef).withWindup((int)((double)((AbstractMove)attackRef).getWindup() * 0.67));
            ((AbstractMove)attackRef).withDuration((int)((double)((AbstractMove)attackRef).getDuration() * 0.67));
        }
        if (!this.hasRapier() && attackRef instanceof AbstractSimpleAttack) {
            AbstractSimpleAttack simpleAttackRef = (AbstractSimpleAttack)attackRef;
            simpleAttackRef.withHitboxSize(simpleAttackRef.getHitboxSize() * 0.75f);
            simpleAttackRef.withDamage(simpleAttackRef.getDamage() * 0.75f);
        }
        this.setMove(attackRef, animState);
        cooldowns.setCooldown(cooldownType, move.getCooldown());
        return true;
    }

    public boolean isPossessed() {
        return this.getMode() == Mode.POSSESSED;
    }

    @Override
    public void m_8119_() {
        boolean hasAnubis;
        super.m_8119_();
        if (!this.hasUser()) {
            return;
        }
        LivingEntity user = this.getUserOrThrow();
        Mode mode = this.getMode();
        if (this.m_9236_().f_46443_) {
            if (mode == Mode.POSSESSED) {
                for (int i = 0; i < 16; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20185_() + this.f_19796_.m_188500_() - 0.5, this.m_20186_() + this.f_19796_.m_188500_() * 0.25 + 0.5, this.m_20189_() + this.f_19796_.m_188500_() - 0.5, 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        boolean bl = hasAnubis = this.m_21206_().m_150930_((Item)JItemRegistry.ANUBIS.get()) || user.m_21205_().m_41720_() == JItemRegistry.ANUBIS.get();
        if (user instanceof Player) {
            Player player = (Player)user;
            hasAnubis |= player.m_150109_().m_36063_(((Item)JItemRegistry.ANUBIS.get()).m_7968_());
            if (this.getCurrentMove() == null) {
                player.m_36356_(this.m_21206_());
                this.m_21206_().m_41774_(1);
            }
        } else if (!this.hasRapier() && this.f_19796_.m_188501_() < 0.1f) {
            this.desummon();
        }
        if (hasAnubis && mode != Mode.POSSESSED) {
            this.setMode(Mode.POSSESSED);
            this.switchMoveSet(POSSESSED_MOVE_SET.getName());
        } else if (!hasAnubis && mode == Mode.POSSESSED) {
            this.setMode(Mode.REGULAR);
            this.switchMoveSet(DEFAULT_MOVE_SET.getName());
        }
    }

    @Override
    @NonNull
    public SilverChariotEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.silverchariot.summon" + (this.isPossessed() ? "_possessed" : "");
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum Mode {
        REGULAR,
        ARMORLESS,
        POSSESSED;

    }

    public static enum State implements StandAnimationState<SilverChariotEntity>
    {
        IDLE((silverChariot, builder) -> {
            RawAnimation rawAnimation = RawAnimation.begin();
            builder.setAnimation(rawAnimation.thenLoop("animation.silverchariot.idle" + (switch (silverChariot.getMode().ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> "";
                case 1 -> "_armorless";
                case 2 -> "_possessed";
            })));
        }),
        STAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.stab"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.barrage"))),
        SPIN(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.spin"))),
        SPIN_2(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.spin_2"))),
        CHARGE_LOW(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.charge_low"))),
        CHARGE_HIGH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.charge_high"))),
        P_CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.pcharge"))),
        P_CHARGE_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.pchargehit"))),
        COUNTER(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.silverchariot.counter"))),
        BEAT_DOWN_START(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.beatdownstart"))),
        BEAT_DOWN(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.beatdown"))),
        CLEAVE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.cleave"))),
        ARMOR_OFF(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.armor_off"))),
        COUNTER_MISS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.counter_miss"))),
        LAST_SHOT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.lastshot"))),
        CIRCLE_CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.circle_charge"))),
        CIRCLE_SLASH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.circle_slash"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.silverchariot.light_followup")));

        private final BiConsumer<SilverChariotEntity, AnimationState<SilverChariotEntity>> animator;

        private State(Consumer<AnimationState<SilverChariotEntity>> animator) {
            this((SilverChariotEntity silverChariot, AnimationState<SilverChariotEntity> builder) -> animator.accept((AnimationState<SilverChariotEntity>)builder));
        }

        private State(BiConsumer<SilverChariotEntity, AnimationState<SilverChariotEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(SilverChariotEntity attacker, AnimationState<SilverChariotEntity> builder) {
            this.animator.accept(attacker, builder);
        }

        @Override
        public void configureController(SilverChariotEntity attacker, AnimationController<SilverChariotEntity> controller) {
            controller.setAnimationSpeed(attacker.getMode() == Mode.ARMORLESS ? 1.5 : 1.0);
        }
    }
}

