/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.PoseModifierGroup;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.shared.ChargeBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.JumpMove;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.attack.moves.shared.StandbyActivationMove;
import net.arna.jcraft.common.attack.moves.shared.StandbyDeactivationMove;
import net.arna.jcraft.common.attack.moves.shared.TossChargeMove;
import net.arna.jcraft.common.attack.moves.shared.TossMove;
import net.arna.jcraft.common.attack.moves.starplatinum.InhaleAttack;
import net.arna.jcraft.common.entity.stand.AbstractStarPlatinumEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.joml.Vector3f;

public final class StarPlatinumEntity
extends AbstractStarPlatinumEntity<StarPlatinumEntity, State> {
    public static final MoveSet<StarPlatinumEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.STAR_PLATINUM, StarPlatinumEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(225.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.starplatinum")).proCount(3).conCount(3).freeSpace((Component)Component.m_237113_((String)"BNBs:\n~ represents a queued attack\n\n    -the classic\n    Punch>Barrage>Punch>Knee>Advancing Barrage~Star Finger~Star Breaker\n\n    -the rushdown\n    Punch~Punch>dash Barrage>cr.Punch>Star Finger>Knee>Punch>Advancing Barrage>Punch~Punch\n\n    -the blowback\n    Inhale>...>Star Finger>Star Breaker>Barrage>...\n\n    -the poke\n    Star Finger>Knee>Punch>Advancing Barrage~Punch>Barrage>Punch>Star Breaker")).skinName((Component)Component.m_237113_((String)"Manga")).skinName((Component)Component.m_237113_((String)"Arcade")).skinName((Component)Component.m_237113_((String)"OVA")).build()).summonData(SummonData.of(JSoundRegistry.STAR_PLATINUM_SUMMON)).build();
    public static final Supplier<IPoseModifier> POSE = () -> PoseModifierGroup.builder().modifier(PoseModifiers.parse("leftArm.xRot = 0;\nleftArm.yRot = -15deg;\nleftArm.zRot = 5deg;\n", ModifierCondition.LEFT_ARM_EMPTY)).modifier(PoseModifiers.parse("rightArm.zRot = 15deg;\nrightArm.xRot *= 0.5;\n", ModifierCondition.RIGHT_ARM_EMPTY)).build();
    public static final SimpleUppercutAttack<StarPlatinumEntity> UPPERCUT = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(20, 8, 14, 0.75f, 6.0f, 20, 1.5f, 0.25f, -0.6f, 0.75f).withAnim(State.UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(0.0, 0.35, 1.25)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.crm1"), (Component)Component.m_237113_((String)"Slower combo starter, launches vertically, good anti-air."));
    public static final SimpleAttack<StarPlatinumEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 6, 10, 0.75f, 6.0f, 8, 1.5f, 1.0f, -0.25f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.0, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.m1m1"), (Component)Component.m_237113_((String)"Quick combo finisher."));
    public static final SimpleAttack<StarPlatinumEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(5, 7, 0.75f, 5.0f, 10, 0.2f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.m1"), (Component)Component.m_237113_((String)"Quick combo starter."));
    public static final MainBarrageAttack<StarPlatinumEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 40, 0.75f, 1.0f, 30, 2.0f, 0.25f, 0.0f, 3, Blocks.f_50080_.m_155943_()).withSound(JSoundRegistry.STAR_PLATINUM_BARRAGE)).withInfo((Component)Component.m_237115_((String)"jcraft.generic.barrage"), (Component)Component.m_237113_((String)"Fast, reliable combo starter/extender, high stun."));
    public static final KnockdownAttack<StarPlatinumEntity> GRAB_HIT = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 10, 20, 1.0f, 6.0f, 15, 1.75f, 0.4f, 0.0f, 35).withSound(JSoundRegistry.SPTW_UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_6)).withHyperArmor()).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.crsp1hit"), (Component)Component.m_237119_());
    public static final GrabAttack<StarPlatinumEntity, State> GRAB = (GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)((GrabAttack)new GrabAttack(0, 8, 20, 1.0f, 2.0f, 20, 1.5f, 0.1f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT), 11, 0.8).withSound(JSoundRegistry.SPTW_GRAB)).withImpactSound(JSoundRegistry.SPTW_GRABHIT)).withHitAnimation(null)).withBlockableType(BlockableType.BLOCKABLE)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.crsp1"), (Component)Component.m_237113_((String)"Blockable grab, knocks down."));
    public static final SimpleAttack<StarPlatinumEntity> STAR_FINGER = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack<State>(0, 12, 20, 0.75f, 5.0f, 30, 1.75f, -0.4f, -0.25f).withCrouchingVariant(GRAB)).withSound(JSoundRegistry.STAR_FINGER)).withBlockStun(5)).withExtraHitBox(2.0, 0.1, 1.0)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.sp1"), (Component)Component.m_237113_((String)"Medium windup combo starter/extender, vacuums on hit, unsafe on block."));
    public static final SimpleUppercutAttack<StarPlatinumEntity> KNEE_UP = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 8, 14, 0.75f, 4.0f, 13, 1.6f, 0.2f, -0.4f, 0.5f).withSound(JSoundRegistry.STAR_PLATINUM_KNEE)).withImpactSound(JSoundRegistry.IMPACT_6)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.airsp2"), (Component)Component.m_237113_((String)"Launches upward, larger and higher hitbox, higher stun, less damage."));
    public static final SimpleAttack<StarPlatinumEntity> KNEE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 12, 0.9f, 6.0f, 9, 1.5f, 0.3f, 0.0f).withAerialVariant(KNEE_UP)).withSound(JSoundRegistry.STAR_PLATINUM_KNEE)).withImpactSound(JSoundRegistry.IMPACT_6)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.sp2"), (Component)Component.m_237113_((String)"Fast poke, low stun."));
    public static final ChargeBarrageAttack<StarPlatinumEntity> SHORT_CHARGE_BARRAGE = (ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)new ChargeBarrageAttack(140, 5, 25, 6.0f, 0.6f, 15, 1.5f, 0.1f, 0.0f, 3, true).withSound(JSoundRegistry.STAR_PLATINUM_LUNGING_BARRAGE)).withShockwaves()).withBackstab(false)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.crsp3"), (Component)Component.m_237113_((String)"Lasts shorter. Less punishable on whiff."));
    public static final ChargeBarrageAttack<StarPlatinumEntity> CHARGE_BARRAGE = (ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)((ChargeBarrageAttack)new ChargeBarrageAttack(140, 5, 55, 7.0f, 0.6f, 15, 1.5f, 0.1f, 0.0f, 3, false).withSound(JSoundRegistry.STAR_PLATINUM_ADVANCING_BARRAGE)).withShockwaves()).withBackstab(false)).withCrouchingVariant(SHORT_CHARGE_BARRAGE)).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.sp3"), (Component)Component.m_237113_((String)"Fast combo starter/extender, medium stun, extremely punishable on whiff."));
    public static final StandbyActivationMove<StarPlatinumEntity> STANDBY_ON = new StandbyActivationMove(0, 1, 1, 0.75f);
    public static final StandbyDeactivationMove<StarPlatinumEntity> STANDBY_OFF = new StandbyDeactivationMove(0, 1, 1, -0.75f);
    public static final JumpMove<StarPlatinumEntity> JUMP = (JumpMove)new JumpMove(300, 5, 14, 1.0f, 1.5f).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.util"), (Component)Component.m_237113_((String)"Jumps in looked direction with slight upward bias, you must stay on the ground until Star Platinum jumps."));
    public static final TossMove<StarPlatinumEntity> TOSS = (TossMove)new TossMove(0, 1, 1, 0.75f).withAnim(State.ITEM_TOSS);
    public static final TossChargeMove<StarPlatinumEntity> TOSS_CHARGE = (TossChargeMove)new TossChargeMove(70, 61, 60, 1.0f, 10).withFollowup(TOSS);
    public static final InhaleAttack INHALE = (InhaleAttack)new InhaleAttack(800, 5, 5, 1.0f, 80).withInfo((Component)Component.m_237115_((String)"jcraft.starplatinum.ult"), (Component)Component.m_237113_((String)"Vacuums looked entities for 4 seconds."));
    private static final EntityDataAccessor<Integer> INHALE_TIME = SynchedEntityData.m_135353_(StarPlatinumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public StarPlatinumEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.STAR_PLATINUM.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.8f, 0.5f, 1.0f), new Vector3f(0.6f, 0.2f, 1.0f), new Vector3f(0.2f, 0.8f, 0.6f), new Vector3f(0.1f, 0.3f, 1.0f)};
    }

    private static void registerMoves(MoveMap<StarPlatinumEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.PUNCH);
        moves.register(MoveClass.HEAVY, STAR_BREAKER, State.HEAVY).withCrouchingVariant(State.GROUND_BREAKER);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, STAR_FINGER, State.STAR_FINGER).withCrouchingVariant(State.GRAB);
        moves.register(MoveClass.SPECIAL2, KNEE, State.KNEE).withAerialVariant(State.KNEE_UP);
        moves.register(MoveClass.SPECIAL3, CHARGE_BARRAGE, State.BARRAGE).withCrouchingVariant(State.BARRAGE);
        moves.register(MoveClass.ULTIMATE, INHALE, State.INHALE);
        moves.register(MoveClass.UTILITY, JUMP, State.JUMP);
        moves.register(MoveClass.STANDBY_OFF, STANDBY_OFF, State.IDLE);
        moves.register(MoveClass.TOSS, TOSS_CHARGE, State.ITEM_TOSS_CHARGE).withFollowup(State.ITEM_TOSS);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INHALE_TIME, (Object)0);
    }

    public void setInhaleTime(int time) {
        this.f_19804_.m_135381_(INHALE_TIME, (Object)time);
    }

    public int getInhaleTime() {
        return (Integer)this.f_19804_.m_135370_(INHALE_TIME);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    @NonNull
    public StarPlatinumEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NonNull
    protected String getSummonAnimation() {
        return "animation.starplatinum.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<StarPlatinumEntity>
    {
        IDLE((starPlatinum, builder) -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.starplatinum." + (starPlatinum.getInhaleTime() > 0 ? "inhaleidle" : "idle")))),
        PUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.starplatinum.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.heavy"))),
        GROUND_BREAKER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.ground_slam"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.starplatinum.barrage"))),
        STAR_FINGER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.star_finger"))),
        INHALE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.inhale"))),
        KNEE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.knee"))),
        KNEE_UP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.knee_up"))),
        JUMP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.jump"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.grabhit"))),
        UPPERCUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.uppercut"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.light_followup"))),
        ITEM_TOSS_CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.starplatinum.itemthrow_charge"))),
        ITEM_TOSS(builder -> builder.setAnimation(RawAnimation.begin().thenPlay("animation.starplatinum.itemthrow")));

        private final BiConsumer<StarPlatinumEntity, AnimationState<StarPlatinumEntity>> animator;

        private State(Consumer<AnimationState<StarPlatinumEntity>> animator) {
            this((StarPlatinumEntity stand, AnimationState<StarPlatinumEntity> builder) -> animator.accept((AnimationState<StarPlatinumEntity>)builder));
        }

        private State(BiConsumer<StarPlatinumEntity, AnimationState<StarPlatinumEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(StarPlatinumEntity attacker, AnimationState<StarPlatinumEntity> builder) {
            this.animator.accept(attacker, builder);
        }
    }
}

