/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JBlockRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.common.attack.actions.EffectAction;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.thefool.AirBarrageAttack;
import net.arna.jcraft.common.attack.moves.thefool.GlideMove;
import net.arna.jcraft.common.attack.moves.thefool.PoundAttack;
import net.arna.jcraft.common.attack.moves.thefool.SandCloneMove;
import net.arna.jcraft.common.attack.moves.thefool.SandTornadoMove;
import net.arna.jcraft.common.attack.moves.thefool.SandWaveAttack;
import net.arna.jcraft.common.attack.moves.thefool.SandstormAttack;
import net.arna.jcraft.common.attack.moves.thefool.SlamAttack;
import net.arna.jcraft.common.attack.moves.thefool.TFChargeAttack;
import net.arna.jcraft.common.attack.moves.thefool.TFComboAttack;
import net.arna.jcraft.common.attack.moves.thefool.TFLaunchAttack;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TheFoolEntity
extends StandEntity<TheFoolEntity, State> {
    public static final MoveSet<TheFoolEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.THE_FOOL, TheFoolEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(225.0f).idleDistance(2.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.thefool")).proCount(5).conCount(3).freeSpace((Component)Component.m_237113_((String)"CROUCHING reduces attack distance by half, allowing better space control\n\nBNBs:\n    Light>Pound~Slam>Launch>Light>Burn Rubber>Finisher*\n    Burn Rubber>Light>Pound~Slam>Launch>Finisher*\n    Launch>Light>Burn Rubber>Light>Pound~Slam>Finisher*\n\n    Stylish:\n    the social distancing\n    Light>Pound~Slam>Light>Combo>Charge>Sandwave\n    the pancake flip\n    Launch>Pound~Slam>Light>Burn Rubber>Finisher*\n\n    *Finisher: Light>...\n               Charge/Tornado>...\n               Sand Clone/Sandwave")).skinName((Component)Component.m_237113_((String)"Chilled")).skinName((Component)Component.m_237113_((String)"OVA")).skinName((Component)Component.m_237113_((String)"Neon")).build()).build();
    public static final SimpleMultiHitAttack<TheFoolEntity> DRILL = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(0, 14, 1.5f, 2.5f, 7, 1.5f, 0.2f, 0.25f, (IntCollection)IntSet.of((int)5, (int)8, (int)11)).withAnim(State.DRILL)).withBlockStun(4)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withExtraHitBox(1.75, -0.1, 0.75)).withInfo((Component)Component.m_237113_((String)"Drill"), (Component)Component.m_237113_((String)"fast, multi-hitting combo starter, low stun and blockstun"));
    public static final SimpleAttack<TheFoolEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 9, 16, 1.5f, 6.0f, 9, 2.0f, 1.5f, 0.0f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_2)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Swipe"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<TheFoolEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(30, 7, 14, 1.5f, 6.0f, 15, 2.0f, 0.5f, -0.1f).noLoopPrevention()).withImpactSound(JSoundRegistry.IMPACT_2)).withExtraHitBox(0.0, 0.25, 1.0)).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(DRILL)).withInfo((Component)Component.m_237113_((String)"Swipe"), (Component)Component.m_237113_((String)"slow, long-reaching poke"));
    public static final AirBarrageAttack AIR_BARRAGE = (AirBarrageAttack)((AirBarrageAttack)new AirBarrageAttack(240, 0, 30, 1.0f, 1.0f, 10, 2.0f, 0.1f, 0.0f, 3).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Burn Rubber"), (Component)Component.m_237113_((String)"slows down all movement, combo starter/extender"));
    public static final TFComboAttack COMBO = (TFComboAttack)((TFComboAttack)((TFComboAttack)((TFComboAttack)((TFComboAttack)new TFComboAttack(200, 29, 1.5f, 4.5f, 20, 1.75f, 0.1f, -0.1f, (IntCollection)IntSet.of((int[])new int[]{6, 14, 18, 19})).withAerialVariant(AIR_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_2)).withExtraHitBox(0.5, 0.0, 1.25)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"3-hit Combo"), (Component)Component.m_237113_((String)"fast knockdown provider"));
    public static final TFLaunchAttack LAUNCH = (TFLaunchAttack)((TFLaunchAttack)((TFLaunchAttack)((TFLaunchAttack)((TFLaunchAttack)((TFLaunchAttack)((TFLaunchAttack)new TFLaunchAttack(20, 16, 20, 1.25f, 8.0f, 25, 2.0f, 0.5f, -0.3f).withSound(JSoundRegistry.FOOL_LAUNCH)).withAction(EffectAction.inflict(MobEffects.f_19620_, 5, 19, true, false))).withExtraHitBox(1.5)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Launch"), (Component)Component.m_237113_((String)"uninterruptible, slow, vertically launching uppercut"));
    public static final SlamAttack SLAM = (SlamAttack)((SlamAttack)((SlamAttack)((SlamAttack)((SlamAttack)((SlamAttack)new SlamAttack(10, 4, 10, 1.25f, 4.0f, 24, 2.0f, 0.2f, 0.1f).withBlockStun(5)).withSound(JSoundRegistry.FOOL_BARK1)).withImpactSound(JSoundRegistry.IMPACT_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Slam"), (Component)Component.m_237113_((String)""));
    public static final PoundAttack POUND = (PoundAttack)((PoundAttack)((PoundAttack)((PoundAttack)((PoundAttack)((PoundAttack)((PoundAttack)new PoundAttack(0, 7, 22, 1.25f, 4.0f, 25, 1.5f, 0.1f, -0.1f).withFollowup(SLAM)).withSound(JSoundRegistry.FOOL_BARK2)).withImpactSound(JSoundRegistry.IMPACT_2)).withLift(false)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Pound"), (Component)Component.m_237113_((String)"has followups which create different sand patterns based on which key was pressed:\nSPECIAL 1 - no sand\nSPECIAL 2 - semicircle\nSPECIAL 3 - diagonal pattern (influenced by where the user is looking)"));
    public static final SandCloneMove SAND_CLONE = (SandCloneMove)((SandCloneMove)new SandCloneMove(200, 7, 11, 1.0f).withSound(SoundEvents.f_12334_)).withInfo((Component)Component.m_237113_((String)"Sand Manipulation"), (Component)Component.m_237113_((String)"creates a blinding sand cloud, then a clone or (if crouching) circles of sand"));
    public static final GlideMove GLIDE = (GlideMove)((GlideMove)new GlideMove(300, 5, 125, 0.0f).withSound(JSoundRegistry.FOOL_GLIDE)).withInfo((Component)Component.m_237113_((String)"Glider"), (Component)Component.m_237113_((String)"turns The Fool into a glider for 6s"));
    public static final SandWaveAttack SAND_WAVE = (SandWaveAttack)((SandWaveAttack)((SandWaveAttack)new SandWaveAttack(340, 0, 80, 0.0f, 1.0f, 0, 2.0f, 0.1f, 0.0f, 3, 15).withAerialVariant(GLIDE)).withBackstab(false)).withInfo((Component)Component.m_237113_((String)"Sandwave"), (Component)Component.m_237113_((String)"The Fool turns into a quick sandwave that knocks anything it touches down"));
    public static final SandTornadoMove SAND_TORNADO = (SandTornadoMove)((SandTornadoMove)new SandTornadoMove(200, 12, 13, 1.0f).withSound(JSoundRegistry.FOOL_LAUNCH)).withInfo((Component)Component.m_237113_((String)"Sand Tornado"), (Component)Component.m_237113_((String)"summons a slow, stunning sand tornado"));
    public static final TFChargeAttack CHARGE = (TFChargeAttack)((TFChargeAttack)((TFChargeAttack)((TFChargeAttack)((TFChargeAttack)((TFChargeAttack)((TFChargeAttack)new TFChargeAttack(200, 5, 20, 7.0f, 6.0f, 10, 1.5f, 1.2f, 0.0f).withSound(JSoundRegistry.FOOL_CHARGE)).withImpactSound(JSoundRegistry.IMPACT_2)).withAerialVariant(SAND_TORNADO)).withLaunch()).withBackstab(false)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Charge"), (Component)Component.m_237113_((String)"The Fool detaches from the user and charges forward, launches on hit"));
    public static final SandstormAttack SANDSTORM = (SandstormAttack)((SandstormAttack)((SandstormAttack)((SandstormAttack)((SandstormAttack)((SandstormAttack)((SandstormAttack)new SandstormAttack(800, 28, 41, 1.5f, 7.0f, 20, 2.0f, 0.1f, 0.0f).withSound(JSoundRegistry.FOOL_ULT)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withExtraHitBox(1.5)).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Suffocating Sandstorm"), (Component)Component.m_237113_((String)"very slow, traps the opponent in a cloud of blinding and slowing sand"));
    private static final BlockState sandState = Blocks.f_49992_.m_49966_();
    private static final EntityDataAccessor<Boolean> IS_SAND = SynchedEntityData.m_135353_(TheFoolEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_WAVE = SynchedEntityData.m_135353_(TheFoolEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public TheFoolEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.THE_FOOL.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 0.8f, 0.4f), new Vector3f(0.8f, 0.3f, 1.0f), new Vector3f(1.0f, 0.6f, 0.2f), new Vector3f(0.4f, 0.5f, 1.0f)};
    }

    private static void registerMoves(MoveMap<TheFoolEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.SWIPE);
        moves.register(MoveClass.HEAVY, LAUNCH, State.LAUNCH);
        moves.register(MoveClass.BARRAGE, COMBO, State.COMBO).withAerialVariant(State.AIR_BARRAGE);
        moves.register(MoveClass.SPECIAL1, POUND, State.POUND_UP);
        moves.register(MoveClass.SPECIAL2, CHARGE, State.CHARGE).withAerialVariant(State.TORNADO);
        moves.register(MoveClass.SPECIAL3, SAND_CLONE, State.CREATE);
        moves.register(MoveClass.ULTIMATE, SANDSTORM, State.SANDSTORM);
        moves.register(MoveClass.UTILITY, SAND_WAVE, State.SAND_WAVE).withAerialVariant(State.GLIDE);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        switch (moveClass) {
            case SPECIAL2: 
            case SPECIAL3: {
                boolean s = super.initMove(moveClass);
                if (moveClass == MoveClass.SPECIAL2 && !this.getUserOrThrow().m_20096_() || moveClass == MoveClass.SPECIAL3) {
                    this.setSand(true);
                }
                return s;
            }
            case LIGHT: {
                if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) break;
                return super.initMove(moveClass);
            }
        }
        return super.initMove(moveClass);
    }

    public boolean isSand() {
        return (Boolean)this.f_19804_.m_135370_(IS_SAND);
    }

    public void setSand(boolean b) {
        this.f_19804_.m_135381_(IS_SAND, (Object)b);
    }

    public boolean isWave() {
        return (Boolean)this.f_19804_.m_135370_(IS_WAVE);
    }

    public void setWave(boolean b) {
        this.setAlphaOverride(b ? 1.0f : -1.0f);
        this.f_19804_.m_135381_(IS_WAVE, (Object)b);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_SAND, (Object)false);
        this.m_20088_().m_135372_(IS_WAVE, (Object)false);
    }

    @Override
    public void standBlock() {
        LivingEntity user = this.getUser();
        if (user == null) {
            return;
        }
        if (this.getState() == State.GLIDE) {
            this.cancelMove();
        }
        boolean sand = user.m_20206_() < 1.8f;
        this.setSand(sand);
        if (sand) {
            this.setDistanceOffset(0.0f);
        }
        List toDeflect = this.m_9236_().m_6443_(Projectile.class, this.m_20191_().m_82400_(0.75), EntitySelector.f_20402_);
        for (Projectile projectile : toDeflect) {
            if (projectile.m_19749_() == user) continue;
            projectile.m_20256_(projectile.m_20184_().m_82490_(-0.5).m_82520_(0.0, -0.1, 0.0));
            projectile.f_19864_ = true;
        }
        user.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 2, 9, false, false, true));
        JCraft.stun(user, 2, 2);
        user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 4, false, false, true));
    }

    @Override
    public boolean shouldOffsetHeight() {
        if (this.getState() == State.GLIDE || this.getState() == State.SAND_WAVE || this.getState() == State.BLOCK) {
            return false;
        }
        return super.shouldOffsetHeight();
    }

    @Override
    public void setMove(AbstractMove<?, ? super TheFoolEntity> move, @Nullable State animState) {
        if (this.getUser() != null && this.getUser().m_6144_()) {
            this.setSand(true);
            super.setMove(((AbstractMove)move.copy()).withMoveDistance(move.getMoveDistance() / 2.0f), animState);
        } else {
            super.setMove(move, animState);
        }
    }

    @Override
    public void desummon() {
        SAND_CLONE.discardClone(this);
        SANDSTORM.discardSands(this);
        super.desummon();
    }

    public static void createFoolishSand(Level world, TheFoolEntity theFool, BlockPos pos, Vec3 vel) {
        BlockPos midBlockPos = pos.m_121996_(GravityChangerAPI.getGravityDirection((Entity)theFool).m_122436_());
        if (world.m_8055_(midBlockPos).m_60815_()) {
            return;
        }
        FallingBlockEntity sand = FallingBlockEntity.m_201971_((Level)world, (BlockPos)midBlockPos, (BlockState)((Block)JBlockRegistry.FOOLISH_SAND_BLOCK.get()).m_49966_());
        sand.m_149656_(5.0f, 5);
        sand.m_20256_(vel);
        sand.f_19864_ = true;
        sand.f_19812_ = true;
        sand.f_19850_ = false;
        sand.f_31943_ = false;
        world.m_7967_((Entity)sand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.hasUser()) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            if (this.f_19797_ % 2 != 0) {
                return;
            }
            int particleNum = this.isWave() ? 32 : 1 + Mth.m_14045_((int)(this.getMoveStun() / 2), (int)0, (int)5) * (this.isSand() ? 2 : 1);
            int height = this.isWave() || this.blocking ? 1 : 2;
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            for (int i = 0; i < particleNum; ++i) {
                BlockParticleOption effect = this.isWave() && this.f_19796_.m_188501_() * 0.5f > 0.0f ? new BlockParticleOption(ParticleTypes.f_123794_, sandState) : new BlockParticleOption(ParticleTypes.f_123814_, sandState);
                this.m_9236_().m_7106_((ParticleOptions)effect, x + this.f_19796_.m_216328_(0.0, 1.0), y + this.f_19796_.m_216328_((double)((float)height / 2.0f), (double)((float)height / 2.0f)), z + this.f_19796_.m_216328_(0.0, 1.0), 0.0, 0.0, 0.0);
            }
            return;
        }
        AbstractMove move = this.getCurrentMove();
        if (this.lastRemoteInputTime - this.f_19797_ > 4) {
            this.updateRemoteInputs(0, 0, false, false);
        }
        if (move == null && !this.blocking && this.getMoveStun() < 1) {
            this.setSand(false);
            this.setWave(false);
        }
    }

    @Override
    @NonNull
    public TheFoolEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.thefool.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<TheFoolEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool.idle"))),
        SWIPE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.light"))),
        BLOCK((theFool, builder) -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool." + (theFool.isSand() ? "crouchblock" : "block")))),
        COMBO(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.combo"))),
        AIR_BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool.airbarrage"))),
        LAUNCH(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.launch"))),
        POUND_UP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.poundup"))),
        POUND_DOWN(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.pounddown"))),
        CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool.charge"))),
        CHARGE_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.charge_hit"))),
        CREATE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.create"))),
        SAND_WAVE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool.sandwave"))),
        SANDSTORM(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.sandstorm"))),
        GLIDE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool.glide"))),
        TORNADO(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool.tornado"))),
        DRILL(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.thefool.drill"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.thefool.light_followup")));

        private final BiConsumer<TheFoolEntity, AnimationState<TheFoolEntity>> animator;

        private State(Consumer<AnimationState<TheFoolEntity>> animator) {
            this((TheFoolEntity fool, AnimationState<TheFoolEntity> builder) -> animator.accept((AnimationState<TheFoolEntity>)builder));
        }

        private State(BiConsumer<TheFoolEntity, AnimationState<TheFoolEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(TheFoolEntity attacker, AnimationState<TheFoolEntity> builder) {
            this.animator.accept(attacker, builder);
        }
    }
}

