/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.shared.GrabAttack;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleMultiHitAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.attack.moves.thehand.EraseGroundAttack;
import net.arna.jcraft.common.attack.moves.thehand.EraseSpaceAttack;
import net.arna.jcraft.common.attack.moves.thehand.RageAttack;
import net.arna.jcraft.common.attack.moves.thehand.SimpleEraseAttack;
import net.arna.jcraft.common.attack.moves.thehand.Stomp2Attack;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TheHandEntity
extends StandEntity<TheHandEntity, State> {
    public static final MoveSet<TheHandEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.THE_HAND, TheHandEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.the_hand")).proCount(4).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the stand up comedian\n    Light>Barrage>Sweep>cr.M1~M1>Stomp Barrage\n\n    -the st. louis devastator\n    (Sweep>)cr.M1~M1>Barrage>Rage")).skinName((Component)Component.m_237113_((String)"Shift")).skinName((Component)Component.m_237113_((String)"Inversion")).skinName((Component)Component.m_237113_((String)"Deletion")).build()).summonData(SummonData.of(JSoundRegistry.THE_HAND_SUMMON)).build();
    public static final Stomp2Attack CROUCHING_LIGHT_FOLLOWUP = (Stomp2Attack)((Stomp2Attack)((Stomp2Attack)((Stomp2Attack)((Stomp2Attack)((Stomp2Attack)((Stomp2Attack)new Stomp2Attack(0, 13, 20, 0.6f, 6.0f, 15, 1.75f, 0.3f, 0.4f, -0.3f).withAnim(State.CROUCHING_LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withImpactSound(JSoundRegistry.IMPACT_2)).withExtraHitBox(0.0, 0.0, 1.0)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Stomp (Second Hit)"), (Component)Component.m_237113_((String)"Lifts knocked down enemies off the ground."));
    public static final SimpleAttack<TheHandEntity> CROUCHING_LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack<TheHandEntity>(20, 9, 14, 0.5f, 5.0f, 15, 1.5f, 0.25f, 0.4f).withFollowup(CROUCHING_LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withBlockStun(12)).withInfo((Component)Component.m_237113_((String)"Stomp"), (Component)Component.m_237113_((String)"Relatively quick combo starter.\nShorter range.\nHigh blockstun."));
    public static final SimpleUppercutAttack<TheHandEntity> LIGHT_FOLLOWUP = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 9, 14, 0.75f, 6.0f, 8, 1.6f, 0.3f, -0.1f, 0.3f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withBlockStun(4)).withExtraHitBox(0.0, 0.0, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Gut Punch"), (Component)Component.m_237119_());
    public static final SimpleAttack<TheHandEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(20, 5, 10, 0.75f, 4.0f, 12, 1.5f, 0.25f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(CROUCHING_LIGHT)).withImpactSound(JSoundRegistry.IMPACT_6)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).noLoopPrevention()).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"Relatively quick combo starter."));
    public static final KnockdownAttack<TheHandEntity> STOMP_BARRAGE_FINISHER = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 6, 10, 1.0f, 6.0f, 6, 1.75f, 0.5f, 0.3f, 35).withImpactSound(JSoundRegistry.IMPACT_1)).withImpactSound(JSoundRegistry.IMPACT_2)).withExtraHitBox(0.0, 0.0, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Stomp Barrage (Last Hit)"), (Component)Component.m_237113_((String)"Lifts knocked down enemies off the ground."));
    public static final SimpleMultiHitAttack<TheHandEntity> STOMP_BARRAGE = (SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)((SimpleMultiHitAttack)new SimpleMultiHitAttack(100, 33, 1.0f, 1.0f, 10, 1.5f, 0.3f, 0.2f, (IntCollection)IntSet.of((int[])new int[]{6, 9, 13, 16, 19, 22})).withSound(JSoundRegistry.THE_HAND_KICK_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_1)).withFinisher(23, STOMP_BARRAGE_FINISHER)).withInfo((Component)Component.m_237113_((String)"Stomp Barrage"), (Component)Component.m_237113_((String)"Fast startup, and good advantage on block.\nLast hit knocks down, and cannot be comboed out of with cr.M1"));
    public static final MainBarrageAttack<TheHandEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(240, 0, 40, 0.75f, 0.8f, 30, 2.0f, 0.25f, 0.0f, 3, Blocks.f_152550_.m_155943_()).withSound(JSoundRegistry.D4C_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_2)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final KnockdownAttack<TheHandEntity> SWEEP = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 13, 18, 1.0f, 9.0f, 15, 1.6f, 0.4f, 0.3f, 35).withSound(JSoundRegistry.D4C_LIGHT)).withAnim(State.SWEEP)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_3)).withInfo((Component)Component.m_237113_((String)"Sweep"), (Component)Component.m_237113_((String)"Can be comboed out of with cr.M1~M1>..."));
    public static final SimpleUppercutAttack<TheHandEntity> KICK = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 13, 24, 0.75f, 9.0f, 12, 2.0f, 1.1f, 0.1f, 0.3f).withSound(JSoundRegistry.D4C_LIGHT)).withCrouchingVariant(SWEEP)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_3)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Home Run!"), (Component)Component.m_237113_((String)"Uninterruptible launcher."));
    public static final EraseGroundAttack ERASE_GROUND = (EraseGroundAttack)((EraseGroundAttack)((EraseGroundAttack)((EraseGroundAttack)((EraseGroundAttack)((EraseGroundAttack)new EraseGroundAttack(120, 18, 29, 0.75f, 8.0f, 14, 2.0f, 0.0f, 0.35f).withSound(JSoundRegistry.THE_HAND_SWIPE)).withAnim(State.ERASE_GROUND)).withImpactSound(JSoundRegistry.IMPACT_12)).withInfo((Component)Component.m_237113_((String)"Erase"), (Component)Component.m_237113_((String)"\u00a7eCan be cancelled back into itself.\u00a7r\nTwo points of armor granted by the initial attack.\nErases the ground in front of the user.\nWorks on any non-indestructible block."))).withStaticY()).withArmor(2);
    public static final SimpleEraseAttack ERASE = (SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)((SimpleEraseAttack)new SimpleEraseAttack(120, 18, 29, 0.75f, 8.0f, 14, 2.0f, 0.0f, 0.0f).withSound(JSoundRegistry.THE_HAND_SWIPE)).withAnim(State.ERASE)).withCrouchingVariant(ERASE_GROUND)).withImpactSound(JSoundRegistry.IMPACT_12)).withArmor(2)).withInfo((Component)Component.m_237113_((String)"Erase"), (Component)Component.m_237113_((String)"\u00a7eCan be cancelled back into itself.\u00a7r\nTwo points of armor granted by the initial attack.\nSlow, unblockable attack."));
    public static final SimpleAttack<TheHandEntity> GRAB_HIT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 14, 16, 0.75f, 8.0f, 5, 1.75f, 1.5f, 0.0f).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Grab (Hit)"), (Component)Component.m_237119_());
    public static final GrabAttack<TheHandEntity, State> GRAB = (GrabAttack)((GrabAttack)new GrabAttack(300, 10, 20, 0.75f, 0.0f, 16, 1.5f, 0.0f, 0.0f, GRAB_HIT, StateContainer.of(State.GRAB_HIT)).withSound(JSoundRegistry.THE_HAND_GRAB)).withInfo((Component)Component.m_237113_((String)"Grab"), (Component)Component.m_237113_((String)"unblockable, knocks back"));
    public static final EraseSpaceAttack ERASE_SPACE = (EraseSpaceAttack)((EraseSpaceAttack)((EraseSpaceAttack)((EraseSpaceAttack)new EraseSpaceAttack(300, 12, 20, 0.75f, 4.0f, 6, 2.0f, -0.5f, 0.0f).withSound(JSoundRegistry.THE_HAND_SWIPE_QUICK)).withAnim(State.ERASE_GROUND)).withImpactSound(JSoundRegistry.IMPACT_12)).withInfo((Component)Component.m_237113_((String)"Erase Space"), (Component)Component.m_237113_((String)"Brings any looked at entity.\nIf not looking at anything, will bring you forward."));
    public static final RageAttack RAGE = (RageAttack)((RageAttack)((RageAttack)((RageAttack)new RageAttack(600, 57, 0.75f, 6.0f, 20, 2.0f, 0.2f, 0.0f, IntSet.of((int)26, (int)40)).withSound(JSoundRegistry.THE_HAND_RAGE)).withImpactSound(JSoundRegistry.IMPACT_12)).withHyperArmor()).withInfo((Component)Component.m_237113_((String)"Rage"), (Component)Component.m_237113_((String)"First two hits are uninterruptible.\nIf the second hit makes contact, The Hand will beat the opponent down.\n"));

    public TheHandEntity(Level world) {
        super((StandType)JStandTypeRegistry.THE_HAND.get(), world);
        this.auraColors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.6f, 0.2f, 0.0f), new Vector3f(0.8f, 0.2f, 0.8f), new Vector3f(0.2f, 0.0f, 0.5f)};
    }

    private static void registerMoves(MoveMap<TheHandEntity, State> moves) {
        MoveMap.Entry<TheHandEntity, State> light = moves.register(MoveClass.LIGHT, LIGHT, State.LIGHT);
        light.withFollowup(State.LIGHT_FOLLOWUP);
        light.withCrouchingVariant(State.CROUCHING_LIGHT).withFollowup(State.CROUCHING_LIGHT_FOLLOWUP);
        moves.registerImmediate(MoveClass.HEAVY, KICK, State.KICK);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.registerImmediate(MoveClass.SPECIAL1, ERASE, State.ERASE);
        moves.register(MoveClass.SPECIAL2, STOMP_BARRAGE, State.STOMP_BARRAGE);
        moves.registerImmediate(MoveClass.SPECIAL3, GRAB, State.GRAB);
        moves.register(MoveClass.ULTIMATE, RAGE, State.RAGE);
        moves.register(MoveClass.UTILITY, ERASE_SPACE, State.ERASE_SPACE);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        AbstractMove repeat;
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        if (moveClass == MoveClass.SPECIAL1 && this.getCurrentMove() != null && this.getCurrentMove().getMoveClass() == MoveClass.SPECIAL1 && this.getMoveStun() < 4 && (repeat = this.getCurrentMove()) != null) {
            this.setMove(repeat, (State)repeat.getAnimation());
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    public void queueMove(MoveInputType type) {
        if (type == MoveInputType.SPECIAL1 && this.getCurrentMove() != null && this.getCurrentMove().getMoveClass() == MoveClass.SPECIAL1) {
            return;
        }
        super.queueMove(type);
    }

    @Override
    public boolean shouldOffsetHeight() {
        if (this.getState() == State.ERASE_GROUND) {
            return false;
        }
        return super.shouldOffsetHeight();
    }

    @Override
    @NonNull
    public TheHandEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.the_hand.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<TheHandEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.the_hand.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.light"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.light2"))),
        CROUCHING_LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.crouching_light"))),
        CROUCHING_LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.crouching_light2"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.the_hand.block"))),
        KICK(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.the_hand.barrage"))),
        ERASE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.erase"))),
        ERASE_GROUND(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.erase_ground"))),
        ERASE_SPACE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.erase_space"))),
        SWEEP(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.the_hand.sweep"))),
        GRAB(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.grab"))),
        GRAB_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.grab_hit"))),
        STOMP_BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.stomp_barrage"))),
        RAGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.rage"))),
        RAGE_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.the_hand.rage_followup")));

        private final Consumer<AnimationState<TheHandEntity>> animator;

        private State(Consumer<AnimationState<TheHandEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(TheHandEntity attacker, AnimationState<TheHandEntity> state) {
            this.animator.accept(state);
        }
    }
}

