/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.shared.NoOpMove;
import net.arna.jcraft.common.attack.moves.thesun.FireMeteorAttack;
import net.arna.jcraft.common.attack.moves.thesun.FireSunBeamAttack;
import net.arna.jcraft.common.attack.moves.thesun.MeteorShowerAttack;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class TheSunEntity
extends StandEntity<TheSunEntity, State> {
    public static final MoveSet<TheSunEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.THE_SUN, TheSunEntity::registerMoves, State.class);
    private static final EntityDataAccessor<Boolean> PASSIVE = SynchedEntityData.m_135353_(TheSunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(TheSunEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float prevScale = 1.0f;
    public float curScale = 1.0f;
    public static final float MAX_SCALE = 3.0f;
    public static final float MIN_SCALE = 1.0f;
    public static final double MAX_DISTANCE = 64.0;
    public static final double AIMING_DISTANCE = 128.0;
    private int overextensionTime = 0;
    private Vec3 desiredPosition;
    public static final StandData DATA = StandData.builder().idleRotation(0.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.the_sun")).proCount(2).conCount(2).freeSpace((Component)Component.m_237113_((String)"Cannot buffer moves.\n Must stay within 64.0 blocks of the user, otherwise it loses size and disappears.\nGrace period of 1 second before heat field activates after summoning.\nHeat field applies Nausea > Weakness > Slowness > Burning as entities get closer.")).skinName((Component)Component.m_237113_((String)":D")).skinName((Component)Component.m_237113_((String)"Neutron Star")).skinName((Component)Component.m_237113_((String)"Dark")).build()).summonData(SummonData.builder().sound((Supplier<SoundEvent>)JSoundRegistry.SUN_SUMMON).animDuration(40).build()).build();
    private static final FireSunBeamAttack FIRE_SUNBEAM = (FireSunBeamAttack)new FireSunBeamAttack(20, 5, 10, 1, 0.0f).withInfo(Component.m_130674_((String)"Fire Sunbeam"), Component.m_130674_((String)"Fires a sunbeam with perfect precision."));
    private static final FireMeteorAttack FIRE_METEOR = (FireMeteorAttack)((FireMeteorAttack)new FireMeteorAttack(20, 10, 1, 1.0f, 2.5f, 0.0f, true, (IntCollection)IntSet.of((int)5)).withCrouchingVariant(FIRE_SUNBEAM)).withInfo(Component.m_130674_((String)"Fire Meteor"), Component.m_130674_((String)"Fires a high-velocity meteor with perfect precision.\nAt max size, the meteor is explosive."));
    private static final FireMeteorAttack STARBURST = (FireMeteorAttack)new FireMeteorAttack(40, 24, 3, 1.75f, 2.5f, 10.0f, false, (IntCollection)IntSet.of((int)8, (int)16, (int)24)).withInfo(Component.m_130674_((String)"Starburst"), Component.m_130674_((String)"Fires 3 bursts of meteors with high spread.\nAmount of meteors changes proportional to the size of The Sun."));
    private static final MeteorShowerAttack METEOR_SHOWER = (MeteorShowerAttack)((MeteorShowerAttack)((MeteorShowerAttack)new MeteorShowerAttack(120, 10, 110, 2).withSound(JSoundRegistry.SUN_SHOWER)).withoutSlowness()).withInfo(Component.m_130674_((String)"Meteor Shower"), Component.m_130674_((String)"Fires a hail of meteors in all directions for 5 seconds.\nAmount of meteors changes proportional to the size of The Sun."));
    private static final FireSunBeamAttack INCINERATING_SUNSHINE = (FireSunBeamAttack)new FireSunBeamAttack(180, 8, 24, 3, 2.5f).withInfo(Component.m_130674_((String)"Incinerating Sunshine"), Component.m_130674_((String)"Fires 3 sunbeams."));
    private static final NoOpMove<TheSunEntity> CHANGE_SIZE = (NoOpMove)new NoOpMove(0, 0, 0.0f).withInfo(Component.m_130674_((String)"Change Size"), Component.m_130674_((String)"Use while standing to expand size.\nCrouch to shrink.\nSize decreases movement speed and increases heat field."));
    private static final NoOpMove<TheSunEntity> MOVE = (NoOpMove)((NoOpMove)new NoOpMove(0, 0, 0.0f).withHoldable()).withInfo(Component.m_130674_((String)"Move"), Component.m_130674_((String)"Moves The Sun to the looked location."));
    private static final NoOpMove<TheSunEntity> TOGGLE_PASSIVE = (NoOpMove)((NoOpMove)new NoOpMove(0, 0, 0.0f).withCrouchingVariant(MOVE)).withInfo(Component.m_130674_((String)"Toggle Passive"), Component.m_130674_((String)"Toggles The Sun between an Active and Passive mode.\nActive mode - the one it's in when summoned, allows usage of stand moves.\nPassive mode - allows usage of spec moves while keeping the Sun summoned."));

    public Vec3 randomPos() {
        return this.randomPos(this.getRawScale());
    }

    private Vec3 randomPos(double scale) {
        return new Vec3(this.m_20185_() + this.f_19796_.m_188583_() * scale, this.m_20186_() + this.f_19796_.m_188583_() * scale, this.m_20189_() + this.f_19796_.m_188583_() * scale);
    }

    public TheSunEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.THE_SUN.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 0.8f, 0.4f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.4f, 0.8f, 1.0f), new Vector3f(0.6f, 0.1f, 0.8f)};
        this.f_146794_ = 0.5f;
        this.m_20242_(true);
        this.setAlphaOverride(1.0f);
    }

    @Override
    public boolean canHoldMove(@Nullable MoveInputType type) {
        return type == MoveInputType.ULTIMATE;
    }

    private static void registerMoves(MoveMap<TheSunEntity, State> moves) {
        moves.register(MoveClass.HEAVY, FIRE_METEOR, null).withCrouchingVariant(null);
        moves.register(MoveClass.SPECIAL1, STARBURST, null);
        moves.register(MoveClass.SPECIAL2, METEOR_SHOWER, null);
        moves.register(MoveClass.SPECIAL3, INCINERATING_SUNSHINE, null);
        moves.register(MoveClass.ULTIMATE, CHANGE_SIZE, null);
        moves.register(MoveClass.UTILITY, TOGGLE_PASSIVE, null).withCrouchingVariant(null);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PASSIVE, (Object)false);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public boolean handleMove(MoveClass moveClass) {
        LivingEntity user = this.getUserOrThrow();
        boolean sneaking = user.m_6144_();
        switch (moveClass) {
            case ULTIMATE: {
                boolean shrink = user.m_6144_();
                float newScale = this.getRawScale() + (shrink ? -0.05f : 0.05f);
                if (!shrink && newScale <= 3.0f) {
                    int roundScale = Math.round(newScale * 1.2f);
                    AABB newBox = TheSunEntity.newBoundingBox(this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0, newScale * 2.0f);
                    BlockPos start = BlockPos.m_274561_((double)newBox.f_82288_, (double)newBox.f_82289_, (double)newBox.f_82290_);
                    BlockPos end = BlockPos.m_274561_((double)newBox.f_82291_, (double)newBox.f_82292_, (double)newBox.f_82293_);
                    for (int x = start.m_123341_(); x < end.m_123341_(); x += roundScale) {
                        for (int y = start.m_123342_(); y < end.m_123342_(); y += roundScale) {
                            for (int z = start.m_123343_(); z < end.m_123343_(); z += roundScale) {
                                BlockPos blockPos = new BlockPos(x, y, z);
                                if (!this.m_9236_().m_46575_(blockPos, (Entity)this)) continue;
                                return false;
                            }
                        }
                    }
                }
                this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(Mth.m_14036_((float)newScale, (float)1.0f, (float)3.0f)));
                break;
            }
            case UTILITY: {
                if (sneaking) {
                    Vec3 eP = user.m_146892_();
                    Vec3 rangeMod = user.m_20154_().m_82490_(64.0);
                    this.desiredPosition = this.m_9236_().m_45547_(new ClipContext(eP, eP.m_82549_(rangeMod), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user)).m_82450_();
                    break;
                }
                this.togglePassive();
                break;
            }
            default: {
                return super.handleMove(moveClass);
            }
        }
        return true;
    }

    public Vec3 acquireTargetPosition() {
        LivingEntity user = this.getUser();
        if (user == null) {
            return null;
        }
        Vec3 eP = user.m_146892_();
        Vec3 rangeMod = user.m_20154_().m_82490_(128.0);
        EntityHitResult eHit = ProjectileUtil.m_37287_((Entity)user, (Vec3)eP, (Vec3)eP.m_82549_(rangeMod), (AABB)user.m_20191_().m_82400_(128.0), (Predicate)EntitySelector.f_20406_, (double)16384.0);
        Vec3 targetPosition = Objects.requireNonNullElseGet(eHit, () -> user.m_9236_().m_45547_(new ClipContext(eP, eP.m_82549_(rangeMod), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user))).m_82450_();
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)((SimpleParticleType)JParticleTypeRegistry.SUN_LOCK_ON.get()), true, targetPosition.f_82479_, targetPosition.f_82480_, targetPosition.f_82481_, 0.0f, 0.0f, 0.0f, 0.0f, 1));
        }
        return targetPosition;
    }

    @Override
    public void queueMove(MoveInputType type) {
    }

    private void togglePassive() {
        boolean newPassive = (Boolean)this.f_19804_.m_135370_(PASSIVE) == false;
        this.f_19804_.m_135381_(PASSIVE, (Object)newPassive);
        this.getUserOrThrow().m_213846_(Component.m_130674_((String)(newPassive ? "PASSIVE" : "ACTIVE")));
    }

    public boolean isPassive() {
        return (Boolean)this.f_19804_.m_135370_(PASSIVE);
    }

    @Override
    public boolean allowMoveHandling() {
        return !this.isPassive();
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268745_) || source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean remoteControllable() {
        return false;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, @NonNull DamageSource damageSource) {
        if (damageSource == null) {
            throw new NullPointerException("damageSource is marked non-null but is null");
        }
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public void tryBlock() {
    }

    @Override
    public void m_7334_(@NotNull Entity entity) {
        double e;
        if (this.m_20365_(entity) || entity.f_19794_ || this.f_19794_ || !entity.m_6094_()) {
            return;
        }
        double d = entity.m_20185_() - this.m_20185_();
        double f = Mth.m_14005_((double)d, (double)(e = entity.m_20189_() - this.m_20189_()));
        if (f < 0.001) {
            return;
        }
        f = Math.sqrt(f);
        d /= f;
        e /= f;
        double g = 1.0 / f;
        if (g > 1.0) {
            g = 1.0;
        }
        d *= g;
        e *= g;
        entity.m_5997_(d *= 0.1, 0.0, e *= 0.1);
    }

    @Override
    public boolean m_7337_(@NotNull Entity other) {
        return other.m_5829_() && !this.m_20365_(other);
    }

    @Override
    public double getEngagementDistance() {
        return 128.0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity user = this.getUser();
        if (user == null) {
            return;
        }
        float scale = this.getRawScale();
        float heatFieldSize = scale * 20.0f;
        if (this.m_9236_().m_5776_()) {
            Vec3 pos = this.randomPos();
            Vec3 vel = JUtils.randUnitVec(this.f_19796_).m_82490_(0.2 * (double)scale).m_82549_(this.m_20184_());
            for (int i = 0; i < (int)heatFieldSize; ++i) {
                this.m_9236_().m_6493_((ParticleOptions)(this.getSkin() == 2 ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), false, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            }
        } else {
            this.f_146794_ = 0.5f / scale;
            Vec3 pos = this.m_20182_();
            Vec3 userPos = user.m_20182_();
            if (!this.isRemote()) {
                this.setRemote(true);
            }
            if (this.desiredPosition == null) {
                Direction gravity = GravityChangerAPI.getGravityDirection((Entity)user);
                int desiredHeight = 32;
                this.desiredPosition = userPos.m_82549_(Vec3.m_82528_((Vec3i)gravity.m_122436_().m_142393_(-desiredHeight)));
            } else {
                double distance;
                if (user instanceof Mob) {
                    if (Mth.m_14031_((float)((float)this.f_19797_ / 100.0f)) > 1.0f) {
                        this.initMove(MoveClass.ULTIMATE);
                    }
                    Direction gravity = GravityChangerAPI.getGravityDirection((Entity)user);
                    this.desiredPosition = userPos.m_82549_(Vec3.m_82528_((Vec3i)gravity.m_122436_().m_142393_((int)(-heatFieldSize))));
                }
                if ((distance = pos.m_82557_(userPos)) > 4096.0) {
                    this.desiredPosition = this.desiredPosition.m_82549_(userPos.m_82546_(pos).m_82541_());
                    if (++this.overextensionTime > 20) {
                        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(Mth.m_14036_((float)(this.getRawScale() - 0.1f), (float)1.0f, (float)3.0f)));
                    }
                } else {
                    this.overextensionTime = 0;
                }
                if (this.desiredPosition.m_82557_(pos) > (double)(scale * scale * 3.0f)) {
                    Vec3 towards = this.desiredPosition.m_82546_(pos).m_82541_().m_82490_((double)this.f_146794_);
                    this.m_20256_(towards);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
            }
            if (this.f_19797_ > 20) {
                if (this.f_19797_ % 40 == 0 && this.f_19796_.m_188500_() >= 0.5) {
                    this.m_5496_((SoundEvent)JSoundRegistry.SUN_IDLE.get(), 1.0f, this.f_19796_.m_188501_());
                }
                if (heatFieldSize > 0.0f) {
                    List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)heatFieldSize), EntitySelector.f_20402_.and(arg_0 -> ((TheSunEntity)this).m_142582_(arg_0)));
                    for (Entity entity : entities) {
                        LivingEntity living;
                        double distance = entity.m_20280_((Entity)this);
                        double exposure = 125.0 * (double)scale;
                        exposure = distance == 0.0 ? (exposure *= 10.0) : (exposure *= 1.0 / distance);
                        if (exposure > 2.0) {
                            if (exposure > 8.0) {
                                entity.m_6469_(JDamageSources.create(this.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268468_), 1.5f);
                            }
                            entity.m_20254_(2);
                        }
                        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_6084_() || !(exposure > 0.25)) continue;
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 10, 0, true, false));
                        if (!(exposure > 0.5)) continue;
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 10, 0, true, false));
                        if (!(exposure > 1.0)) continue;
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 0, true, false));
                    }
                }
            }
        }
        this.prevScale = this.curScale;
        this.curScale = this.getRawScale();
    }

    public static void dryOut(ServerLevel serverWorld, BlockPos pos) {
        BlockState blockState = serverWorld.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof BucketPickup) {
            BucketPickup fluidDrainable = (BucketPickup)block;
            fluidDrainable.m_142598_((LevelAccessor)serverWorld, pos, blockState);
        }
    }

    @NonNull
    protected AABB m_142242_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        float scale = this.getRawScale() * 1.5f;
        return TheSunEntity.newBoundingBox(x, y, z, scale);
    }

    private static AABB newBoundingBox(double x, double y, double z, float scale) {
        return new AABB(x - (double)scale, y - (double)scale, z - (double)scale, x + (double)scale, y + (double)scale, z + (double)scale);
    }

    public boolean m_6060_() {
        return false;
    }

    @Override
    public boolean m_20068_() {
        return true;
    }

    @Override
    @NonNull
    public TheSunEntity getThis() {
        return this;
    }

    public float getRawScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public float getScale(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.prevScale, (float)this.curScale);
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NonNull
    protected String getSummonAnimation() {
        return "animation.sun.summon";
    }

    @Override
    public State getBlockState() {
        return null;
    }

    public static enum State implements StandAnimationState<TheSunEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.sun.idle")));

        private final BiConsumer<TheSunEntity, AnimationState<TheSunEntity>> animator;

        private State(Consumer<AnimationState<TheSunEntity>> animator) {
            this((TheSunEntity silverChariot, AnimationState<TheSunEntity> builder) -> animator.accept((AnimationState<TheSunEntity>)builder));
        }

        private State(BiConsumer<TheSunEntity, AnimationState<TheSunEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(TheSunEntity attacker, AnimationState<TheSunEntity> builder) {
            this.animator.accept(attacker, builder);
        }
    }
}

