/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import com.mojang.datafixers.util.Either;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.pose.ModifierCondition;
import net.arna.jcraft.api.pose.PoseModifiers;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.PoseModifierGroup;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.LungeAction;
import net.arna.jcraft.common.attack.moves.shared.KnockdownAttack;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.attack.moves.shared.TimeSkipMove;
import net.arna.jcraft.common.attack.moves.shared.TimeStopMove;
import net.arna.jcraft.common.attack.moves.theworld.FeignBarrageCounterAttack;
import net.arna.jcraft.common.attack.moves.theworld.TWChargeAttack;
import net.arna.jcraft.common.attack.moves.theworld.TWDonutAttack;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.entity.stand.AbstractTheWorldEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class TheWorldEntity
extends AbstractTheWorldEntity<TheWorldEntity, State> {
    public static final MoveSet<TheWorldEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.THE_WORLD, TheWorldEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.theworld")).proCount(4).conCount(2).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the sauce boss\n    (Light>)Charge>cr.Light>Roundhouse>Barrage>Light>Donut>Sweep>Light~Light\n\n    -the afternoon coffee\n    Donut>Sweep>Charge>Light>Barrage>Roundhouse>Light~Light")).skinName((Component)Component.m_237113_((String)"OVA")).skinName((Component)Component.m_237113_((String)"Black")).skinName((Component)Component.m_237113_((String)"Greatest High")).build()).summonData(SummonData.of(JSoundRegistry.TW_SUMMON)).build();
    public static final Supplier<IPoseModifier> POSE = () -> PoseModifierGroup.builder().modifier(PoseModifiers.parse("leftArm.yRot = 15deg;\nleftArm.zRot = 2deg;\n", ModifierCondition.LEFT_ARM_EMPTY)).modifier(PoseModifiers.parse("rightArm.yRot = -15deg;\nrightArm.zRot = -2deg;\n", ModifierCondition.RIGHT_ARM_EMPTY)).modifier(PoseModifiers.parse("leftArm.xRot -= 10deg;\nrightArm.xRot -= 10deg;\nbody.xRot -= 10deg;\n\nleftLeg.z -= 2;\nrightLeg.z -= 2;\n\nleftArm.z += 0.25;\nrightArm.z += 0.25;\nleftArm.x += 0.5;\nrightArm.x -= 0.5;\n", ModifierCondition.USER_NOT_SPRINTING)).build();
    public static final SimpleAttack<TheWorldEntity> LOW_KICK = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 8, 14, 0.75f, 6.0f, 17, 1.5f, 0.2f, 0.65f).withAnim(State.LOW)).withImpactSound(JSoundRegistry.IMPACT_1)).withExtraHitBox(0.0, 0.0, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withInfo((Component)Component.m_237113_((String)"Low Kick"), (Component)Component.m_237113_((String)"slower, higher stun, low hitbox"));
    public static final SimpleAttack<TheWorldEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 11, 0.75f, 6.0f, 8, 1.5f, 1.0f, 0.0f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.0, 1.0)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<TheWorldEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(5, 7, 0.75f, 5.0f, 10, 0.1f, -0.1f).withImpactSound(JSoundRegistry.IMPACT_1)).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(LOW_KICK)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final MainBarrageAttack<TheWorldEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 40, 0.75f, 1.0f, 30, 2.0f, 0.25f, 0.0f, 3, Blocks.f_50080_.m_155943_()).withSound(JSoundRegistry.TW_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final SimpleAttack<TheWorldEntity> SWEEP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(16, 6, 16, 0.75f, 5.0f, 16, 1.85f, 0.5f, 0.4f).withSound(JSoundRegistry.TW_KICK)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Sweep"), (Component)Component.m_237113_((String)"fast, decent stun"));
    public static final SimpleUppercutAttack<TheWorldEntity> ROUNDHOUSE = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(13, 7, 13, 0.75f, 5.0f, 10, 1.75f, 0.5f, -0.2f, 0.4f).withCrouchingVariant(SWEEP)).withSound(JSoundRegistry.TW_KICK)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Roundhouse"), (Component)Component.m_237113_((String)"low stun"));
    public static final KnockdownAttack<TheWorldEntity> COUNTER_FOLLOWUP = (KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)((KnockdownAttack)new KnockdownAttack(0, 5, 9, 0.75f, 9.0f, 16, 1.75f, 0.7f, 0.1f, 35).withSound(JSoundRegistry.TW_COUNTER)).withImpactSound(JSoundRegistry.IMPACT_4)).withExtraHitBox(1.25)).withLaunch()).withHyperArmor()).withInfo((Component)Component.m_237113_((String)"Counter (Hit)"), (Component)Component.m_237113_((String)"quick, armored knockdown"));
    public static final FeignBarrageCounterAttack FEIGN_BARRAGE = (FeignBarrageCounterAttack)((FeignBarrageCounterAttack)new FeignBarrageCounterAttack(400, 5, 50, 0.75f, COUNTER_FOLLOWUP).withSound(JSoundRegistry.TW_BARRAGE)).withInfo((Component)Component.m_237113_((String)"Feign Barrage"), (Component)Component.m_237113_((String)"counter, 0.25s windup, 2.25s duration, teleports and knocks down on hit"));
    public static final TWDonutAttack DONUT = (TWDonutAttack)((TWDonutAttack)((TWDonutAttack)((TWDonutAttack)((TWDonutAttack)((TWDonutAttack)new TWDonutAttack(42, 20, 42, 1.0f, 9.0f, 52, 2.0f, 1.0f, 0.0f).withSound(JSoundRegistry.TW_DONUT)).withImpactSound(JSoundRegistry.TW_DONUT_HIT)).withExtraHitBox(1.5)).withHyperArmor()).withLaunch()).withInfo((Component)Component.m_237113_((String)"Donut"), (Component)Component.m_237113_((String)"slow, uninterruptible combo starter/extender, 1.5s stun on whiff"));
    public static final TimeSkipMove<TheWorldEntity> TIME_SKIP = (TimeSkipMove)new TimeSkipMove(300, 14.0).withSound((RegistrySupplier)JSoundRegistry.TIME_SKIP).withInfo((Component)Component.m_237113_((String)"Timeskip"), (Component)Component.m_237113_((String)"14m range"));
    public static final SimpleAttack<TheWorldEntity> LUNGE = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(100, 9, 14, 1.0f, 5.0f, 12, 1.5f, 0.6f, 0.2f).withExtraHitBox(1.0)).withInitAction(LungeAction.lunge(0.75f, 0.0f).isNotFree())).withSound(JSoundRegistry.TW_KICK)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Lunge"), (Component)Component.m_237113_((String)"user & stand charge forward, launches"));
    public static final TWChargeAttack CHARGE = (TWChargeAttack)((TWChargeAttack)((TWChargeAttack)((TWChargeAttack)((TWChargeAttack)((TWChargeAttack)((TWChargeAttack)new TWChargeAttack(100, 5, 19, 7.5f, 5.0f, 20, 1.5f, 0.25f, 0.0f).withCrouchingVariant(LUNGE)).withSound(JSoundRegistry.TW_CHARGE)).withImpactSound(JSoundRegistry.TW_CHARGE_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withBlockStun(11)).withInfo((Component)Component.m_237113_((String)"Forward Charge"), (Component)Component.m_237113_((String)"The World detaches from the user and lunges forward, combo starter"));
    public static final TimeStopMove<TheWorldEntity> TIME_STOP = (TimeStopMove)((TimeStopMove)new TimeStopMove(1400, 45, 52, (Either<Integer, IntOption>)Either.right((Object)JServerConfig.TW_TIME_STOP_DURATION)).withSound(JSoundRegistry.TW_TS)).withInfo((Component)Component.m_237113_((String)"Timestop"), (Component)Component.m_237113_((String)"4 seconds"));

    public TheWorldEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.THE_WORLD.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 0.7f, 0.3f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.6f, 0.0f), new Vector3f(0.7f, 0.3f, 1.0f)};
    }

    private static void registerMoves(MoveMap<TheWorldEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
        moves.register(MoveClass.HEAVY, DONUT, State.DONUT);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, ROUNDHOUSE, State.ROUNDHOUSE).withCrouchingVariant(State.SWEEP);
        moves.register(MoveClass.SPECIAL2, CHARGE, State.CHARGE).withCrouchingVariant(State.LUNGE);
        moves.register(MoveClass.SPECIAL3, FEIGN_BARRAGE, State.BARRAGE);
        moves.register(MoveClass.ULTIMATE, TIME_STOP, State.TIME_STOP);
        moves.register(MoveClass.UTILITY, TIME_SKIP, State.IDLE);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    protected void playSummonSound() {
        if (this.shouldNotPlaySummonSound()) {
            return;
        }
        this.m_5496_((SoundEvent)JSoundRegistry.TW_SUMMON.get(), 1.0f, 1.0f);
        this.m_5496_((SoundEvent)JSoundRegistry.MUDA_DA.get(), 1.0f, 1.0f);
    }

    @Override
    @NonNull
    public TheWorldEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @NotNull
    protected String getSummonAnimation() {
        return "animation.theworld.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<TheWorldEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.theworld.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.theworld.block"))),
        DONUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.donut"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.theworld.barrage"))),
        TIME_STOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.timestop"))),
        CHARGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.theworld.charge"))),
        CHARGE_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.charge_hit"))),
        ROUNDHOUSE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.roundhouse"))),
        SWEEP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.sweep"))),
        COUNTER_HIT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.counter_hit"))),
        COUNTER_MISS(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.counter_miss"))),
        LOW(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.low"))),
        TIMESKIP(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.theworld.idle"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.light_followup"))),
        LUNGE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.theworld.lunge")));

        private final Consumer<AnimationState<TheWorldEntity>> animator;

        private State(Consumer<AnimationState<TheWorldEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(TheWorldEntity attacker, AnimationState<TheWorldEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

