/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import com.mojang.datafixers.util.Either;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.Color;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.pose.modifier.IPoseModifier;
import net.arna.jcraft.api.pose.modifier.LevitationPoseModifier;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.attack.moves.shared.TimeSkipMove;
import net.arna.jcraft.common.attack.moves.shared.TimeStopMove;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.AerialDivineFinisherAttack;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.ChargeOverwriteMove;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.DivineFinisherAttack;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.LungeAttack;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.OverwriteAttack;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.SingularityAttack;
import net.arna.jcraft.common.attack.moves.theworld.overheaven.SmiteAttack;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TheWorldOverHeavenEntity
extends StandEntity<TheWorldOverHeavenEntity, State> {
    public static final MoveSet<TheWorldOverHeavenEntity, State> MOVE_SET = MoveSetManager.create(JStandTypeRegistry.THE_WORLD_OVER_HEAVEN, TheWorldOverHeavenEntity::registerMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(-45.0f).evolution(true).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.twoh")).proCount(4).conCount(4).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the ultrakill\n    Light>Barrage>Light>Knives>Overwrite~S1/S2>dash>Singularity>Smite>Light~Light\n\n    -JUDGE MENT\n    crouching Light~Light>dash>Barrage>...")).skinName((Component)Component.m_237113_((String)"Shooting Star")).skinName((Component)Component.m_237113_((String)"Above the Clouds")).skinName((Component)Component.m_237113_((String)"Dirt to Divinity")).build()).summonData(SummonData.builder().sound((Supplier<SoundEvent>)JSoundRegistry.TWOH_SUMMON).animDuration(29).build()).build();
    public static final Supplier<IPoseModifier> POSE = LevitationPoseModifier::new;
    public static final LungeAttack LUNGE = (LungeAttack)((LungeAttack)((LungeAttack)((LungeAttack)((LungeAttack)((LungeAttack)new LungeAttack(0, 10, 16, 0.75f, 8.0f, 10, 1.75f, 1.0f, 0.0f, 11, 5).withAnim(State.LUNGE)).withSound(JSoundRegistry.MUDA_DA)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_2)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Lunge"), (Component)Component.m_237113_((String)"medium speed launcher"));
    public static final SimpleAttack<TheWorldOverHeavenEntity> LOW_KICK = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(6, 12, 0.75f, 6.0f, 14, 0.25f, 0.25f).withAnim(State.LOW_KICK)).withFollowup(LUNGE)).withImpactSound(JSoundRegistry.IMPACT_1)).withBlockStun(7)).withInfo((Component)Component.m_237113_((String)"Low Kick"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleAttack<TheWorldOverHeavenEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 9, 13, 0.75f, 6.0f, 8, 1.75f, 1.25f, -0.1f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_1)).withLaunch()).withBlockStun(4)).withExtraHitBox(0.0, 0.25, 1.0)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Roundhouse"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<TheWorldOverHeavenEntity> PUNCH = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(4, 7, 0.75f, 5.0f, 11, 0.2f, -0.1f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(LOW_KICK)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final MainBarrageAttack<TheWorldOverHeavenEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(280, 0, 40, 0.75f, 1.0f, 30, 2.0f, 0.1f, 0.0f, 3, Blocks.f_50080_.m_155943_()).withSound(JSoundRegistry.TWOH_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_1)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, high stun"));
    public static final SingularityAttack SINGULARITY = (SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)new SingularityAttack(140, 11, 23, 1.0f, 0.0f, 25, 2.0f, 0.4f, 0.2f, true).withSound(JSoundRegistry.TWOH_SINGULARITY)).withAnim(State.SINGULARITY)).withImpactSound(JSoundRegistry.IMPACT_12)).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_3)).withInfo((Component)Component.m_237113_((String)"Singularity"), (Component)Component.m_237113_((String)"block bypass (stun will always hit, but the opponent can stay blocking)"));
    public static final SimpleUppercutAttack<TheWorldOverHeavenEntity> OVERHEAD_KICK = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 10, 20, 1.25f, 8.0f, 20, 1.5f, 0.3f, 0.0f, -1.0f).withAnim(State.AIR_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_3)).withExtraHitBox(1.0, 0.75, 1.0)).withExtraHitBox(1.0, -0.5, 1.0)).withInfo((Component)Component.m_237113_((String)"Overhead Kick"), (Component)Component.m_237113_((String)"high damage, good reach, launches down"));
    public static final SingularityAttack TRUE_STRIKE = (SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)((SingularityAttack)new SingularityAttack(0, 10, 22, 1.0f, 0.0f, 20, 2.0f, 0.3f, 0.0f, false).withBlockStun(20)).withAerialVariant(OVERHEAD_KICK)).withCrouchingVariant(SINGULARITY)).withSound(JSoundRegistry.TWOH_HEAVY)).withImpactSound(JSoundRegistry.IMPACT_12)).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"True Strike"), (Component)Component.m_237113_((String)"damage ignores potions and enchantments, good stun, high blockstun, medium windup"));
    public static final SmiteAttack AIR_SMITE = (SmiteAttack)((SmiteAttack)((SmiteAttack)((SmiteAttack)new SmiteAttack(200, 10, 20, 1.0f, 6.0f, 21, 3.0f, 0.0f, 0.0f, true, 7, 9).withSound(JSoundRegistry.TWOH_SMITE)).withBlockStun(13)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"You won't run away!"), (Component)Component.m_237113_((String)"summons a weaker lightning bolt at the aimed position"));
    public static final SmiteAttack SMITE = (SmiteAttack)((SmiteAttack)((SmiteAttack)((SmiteAttack)((SmiteAttack)new SmiteAttack(200, 10, 20, 1.0f, 8.0f, 21, 3.0f, 0.0f, 0.0f, false, 7, 9).withAerialVariant(AIR_SMITE)).withSound(JSoundRegistry.TWOH_SMITE)).withBlockStun(13)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Evaporate"), (Component)Component.m_237113_((String)"summons a powerful lightning bolt that deals high damage and stun"));
    public static final OverwriteAttack OVERWRITE = (OverwriteAttack)((OverwriteAttack)((OverwriteAttack)((OverwriteAttack)((OverwriteAttack)((OverwriteAttack)((OverwriteAttack)new OverwriteAttack(0, 7, 23, 1.0f, 0.0f, 40, 2.0f, 1.0f, 0.0f).withSound(JSoundRegistry.TWOH_OVERWRITE)).withImpactSound(JSoundRegistry.IMPACT_5)).withLaunch()).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE)).withHitSpark(JParticleType.HIT_SPARK_3)).withInfo((Component)Component.m_237113_((String)"Overwrite (Hit)"), (Component)Component.m_237119_());
    public static final ChargeOverwriteMove CHARGE_OVERWRITE = (ChargeOverwriteMove)((ChargeOverwriteMove)((ChargeOverwriteMove)new ChargeOverwriteMove(360, 71, 70, 1.0f, 20).withFollowup(OVERWRITE)).withSound(JSoundRegistry.TWOH_CHARGE_OVERWRITE)).withInfo((Component)Component.m_237113_((String)"Reality Overwrite"), (Component)Component.m_237113_((String)"charges (for a minimum of 1s) an unblockable punch that changes the reality of the hit victims\nWhile charging, (de)activate overwrite by pressing:\nSPECIAL 1 - makes victims unable to look at you (stops if TW:OH is desummoned)\nSPECIAL 2 - applies every damage over time effect to victims\nSPECIAL 3 - heals and enslaves mobs"));
    public static final AerialDivineFinisherAttack AERIAL_DIVINE_FINISHER = (AerialDivineFinisherAttack)((AerialDivineFinisherAttack)((AerialDivineFinisherAttack)new AerialDivineFinisherAttack(200, 16, 22, 0.75f, 0.0f, 20, 1.5f, 0.0f, 0.0f).withSound(JSoundRegistry.TWOH_KNIFETHROW)).withBlockStun(6)).withInfo((Component)Component.m_237113_((String)"Aerial Divine Finisher"), (Component)Component.m_237113_((String)"briefly stalls mid-air"));
    public static final DivineFinisherAttack DIVINE_FINISHER = (DivineFinisherAttack)((DivineFinisherAttack)((DivineFinisherAttack)((DivineFinisherAttack)new DivineFinisherAttack(280, 16, 22, 0.75f, 0.0f, 20, 1.5f, 0.0f, 0.0f).withAerialVariant(AERIAL_DIVINE_FINISHER)).withSound(JSoundRegistry.TWOH_KNIFESUMMON)).withBlockStun(6)).withInfo((Component)Component.m_237113_((String)"Divine Finisher"), (Component)Component.m_237113_((String)"fires 4 stunning knives that launch at a delay/in air summons and launches 8 knives"));
    public static final TimeStopMove<TheWorldOverHeavenEntity> TIME_STOP = (TimeStopMove)((TimeStopMove)new TimeStopMove(1400, 45, 50, (Either<Integer, IntOption>)Either.right((Object)JServerConfig.TWOH_TIME_STOP_DURATION)).withSound(JSoundRegistry.TWOH_TS)).withInfo((Component)Component.m_237113_((String)"Timestop"), (Component)Component.m_237113_((String)"5 seconds"));
    public static final TimeSkipMove<TheWorldOverHeavenEntity> TIME_SKIP = (TimeSkipMove)new TimeSkipMove(300, 14.0).withSound((RegistrySupplier)JSoundRegistry.TWOH_TIMESKIP).withInfo((Component)Component.m_237113_((String)"Timeskip"), (Component)Component.m_237113_((String)"14m range"));
    private static final EntityDataAccessor<Integer> OVERWRITE_TYPE = SynchedEntityData.m_135353_(TheWorldOverHeavenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public TheWorldOverHeavenEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.THE_WORLD_OVER_HEAVEN.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(0.1f, 0.1f, 0.1f), new Vector3f(1.0f, 0.6f, 0.8f), new Vector3f(0.9f, 0.9f, 1.0f), new Vector3f(1.0f, 0.0f, 0.2f)};
    }

    @Override
    public Vector3f getAuraColor() {
        if (this.getSkin() > 0) {
            return super.getAuraColor();
        }
        Color auraColor = Color.ofHSB((float)((float)this.f_19797_ % 360.0f / 360.0f), (float)0.5f, (float)0.5f);
        return new Vector3f((float)auraColor.getRed(), (float)auraColor.getGreen(), (float)auraColor.getBlue());
    }

    public int getOverwriteType() {
        return (Integer)this.f_19804_.m_135370_(OVERWRITE_TYPE);
    }

    public void setOverwriteType(int type) {
        this.f_19804_.m_135381_(OVERWRITE_TYPE, (Object)type);
    }

    @Override
    public void desummon() {
        if (this.tsTime > 0) {
            return;
        }
        super.desummon();
    }

    private static void registerMoves(MoveMap<TheWorldOverHeavenEntity, State> moves) {
        moves.registerImmediate(MoveClass.LIGHT, PUNCH, State.LIGHT);
        moves.registerImmediate(MoveClass.HEAVY, TRUE_STRIKE, State.HEAVY);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, SMITE, State.SMITE);
        moves.register(MoveClass.SPECIAL2, DIVINE_FINISHER, State.AIR_KNIVES).withAerialVariant(State.THROW);
        moves.register(MoveClass.SPECIAL3, CHARGE_OVERWRITE, State.CHARGE_OVERWRITE).withFollowup(State.OVERWRITE);
        moves.register(MoveClass.ULTIMATE, TIME_STOP, State.TIME_STOP);
        moves.register(MoveClass.UTILITY, TIME_SKIP, State.TIME_SKIP);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        switch (moveClass) {
            case ULTIMATE: {
                if (this.tsTime <= 0) {
                    return super.initMove(moveClass);
                }
                if (!this.hasUser()) break;
                JCraft.stopTimestop((Entity)this.getUserOrThrow());
                this.tsTime = 0;
                break;
            }
            case LIGHT: {
                if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) break;
                return super.initMove(moveClass);
            }
            default: {
                return super.initMove(moveClass);
            }
        }
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OVERWRITE_TYPE, (Object)0);
    }

    @Override
    protected void playSummonSound() {
        if (this.shouldNotPlaySummonSound()) {
            return;
        }
        this.m_5496_((SoundEvent)JSoundRegistry.TWOH_SUMMON.get(), 1.0f, 1.0f);
        this.m_5496_((SoundEvent)JSoundRegistry.TW_SUMMON.get(), 1.0f, 1.0f);
    }

    @Override
    @NonNull
    public TheWorldOverHeavenEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.twoh.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<TheWorldOverHeavenEntity>
    {
        IDLE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.twoh.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.twoh.block"))),
        HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.heavy"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.twoh.barrage"))),
        SMITE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.smite"))),
        TIME_STOP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.timestop"))),
        CHARGE_OVERWRITE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.twoh.chargeoverwrite"))),
        OVERWRITE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.overwrite"))),
        THROW(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.throw"))),
        AIR_KNIVES(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.airknives"))),
        TIME_SKIP(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.twoh.idle"))),
        LUNGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.twoh.lunge"))),
        LOW_KICK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.twoh.low_kick"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.light_followup"))),
        SINGULARITY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.singularity"))),
        AIR_HEAVY(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.twoh.air_heavy")));

        private final Consumer<AnimationState<TheWorldOverHeavenEntity>> animator;

        private State(Consumer<AnimationState<TheWorldOverHeavenEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(TheWorldOverHeavenEntity attacker, AnimationState<TheWorldOverHeavenEntity> builder) {
            this.animator.accept(builder);
        }
    }
}

