/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.stand;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveMap;
import net.arna.jcraft.api.attack.MoveSet;
import net.arna.jcraft.api.attack.MoveSetManager;
import net.arna.jcraft.api.attack.enums.BlockableType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandData;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandInfo;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.SummonData;
import net.arna.jcraft.common.attack.actions.EffectAction;
import net.arna.jcraft.common.attack.moves.shared.MainBarrageAttack;
import net.arna.jcraft.common.attack.moves.shared.PilotModeMove;
import net.arna.jcraft.common.attack.moves.shared.SimpleAttack;
import net.arna.jcraft.common.attack.moves.shared.SimpleUppercutAttack;
import net.arna.jcraft.common.attack.moves.whitesnake.ChargedSpewAttack;
import net.arna.jcraft.common.attack.moves.whitesnake.GiveStandAttack;
import net.arna.jcraft.common.attack.moves.whitesnake.MeltYourHeartAttack;
import net.arna.jcraft.common.attack.moves.whitesnake.PoisonSpewAttack;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.StandAnimationState;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class WhiteSnakeEntity
extends StandEntity<WhiteSnakeEntity, State> {
    public static final MoveSet<WhiteSnakeEntity, State> DEFAULT_MOVE_SET = MoveSetManager.create(JStandTypeRegistry.WHITE_SNAKE, WhiteSnakeEntity::registerDefaultMoves, State.class);
    public static final MoveSet<WhiteSnakeEntity, State> REMOTE_MOVE_SET = MoveSetManager.create(JStandTypeRegistry.WHITE_SNAKE, "remote", WhiteSnakeEntity::registerRemoteMoves, State.class);
    public static final StandData DATA = StandData.builder().idleRotation(220.0f).info(StandInfo.builder().name((Component)Component.m_237115_((String)"entity.jcraft.whitesnake")).proCount(3).conCount(3).freeSpace((Component)Component.m_237113_((String)"BNBs:\n    -the gimp\n    Light>Gut Punch>Poison Spew\n\n    -the el mayo (optimal damage with disk moves)\n    Memory Disk>Light>Barrage>Leg Crusher>Stand Disk>Light~Light\n\n    -the gazebo (optimal damage without disk)\n    Light>Barrage>Leg Crusher>Gut Punch>Light~Light\n\n    -the protein shake (sets up mixups)\n    Light>Barrage>Leg Crusher>Charged Spew")).skinName((Component)Component.m_237113_((String)"Mamba")).skinName((Component)Component.m_237113_((String)"Peppermint")).skinName((Component)Component.m_237113_((String)"Radioactive")).build()).summonData(SummonData.of(JSoundRegistry.WS_SUMMON)).build();
    public static final SimpleUppercutAttack<WhiteSnakeEntity> UPPERCUT = (SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)((SimpleUppercutAttack)new SimpleUppercutAttack(0, 8, 14, 1.0f, 6.0f, 16, 1.25f, 0.5f, -0.5f, 0.5f).withAnim(State.UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_3)).withExtraHitBox(1.0)).withInfo((Component)Component.m_237113_((String)"Uppercut"), (Component)Component.m_237113_((String)"decent stun, launches up"));
    public static final SimpleAttack<WhiteSnakeEntity> LIGHT_FOLLOWUP = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 7, 13, 0.75f, 6.0f, 10, 1.5f, 1.0f, 0.2f).withAnim(State.LIGHT_FOLLOWUP)).withImpactSound(JSoundRegistry.IMPACT_3)).withLaunch()).withBlockStun(4)).withHitSpark(JParticleType.HIT_SPARK_2)).withInfo((Component)Component.m_237113_((String)"Finisher"), (Component)Component.m_237113_((String)"quick combo finisher"));
    public static final SimpleAttack<WhiteSnakeEntity> LIGHT = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)SimpleAttack.lightAttack(7, 11, 0.75f, 5.0f, 13, 0.2f, 0.2f).withFollowup(LIGHT_FOLLOWUP)).withCrouchingVariant(UPPERCUT)).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Punch"), (Component)Component.m_237113_((String)"quick combo starter"));
    public static final SimpleAttack<WhiteSnakeEntity> MEDIUM = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 8, 13, 1.0f, 7.0f, 16, 1.75f, 0.4f, 0.0f).withSound(JSoundRegistry.WS_DONUT)).withImpactSound(JSoundRegistry.IMPACT_1)).withHitSpark(JParticleType.HIT_SPARK_2)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.CRUSH)).withInfo((Component)Component.m_237113_((String)"Gut Punch"), (Component)Component.m_237113_((String)"combo starter/extender"));
    public static final MainBarrageAttack<WhiteSnakeEntity> BARRAGE = (MainBarrageAttack)((MainBarrageAttack)((MainBarrageAttack)new MainBarrageAttack(240, 0, 40, 0.75f, 1.0f, 20, 2.0f, 0.25f, 0.0f, 3, Blocks.f_50705_.m_155943_()).withSound(JSoundRegistry.WS_BARRAGE)).withImpactSound(JSoundRegistry.IMPACT_3)).withInfo((Component)Component.m_237113_((String)"Barrage"), (Component)Component.m_237113_((String)"fast reliable combo starter/extender, medium stun"));
    public static final GiveStandAttack GIVE_STAND = (GiveStandAttack)((GiveStandAttack)((GiveStandAttack)((GiveStandAttack)((GiveStandAttack)((GiveStandAttack)new GiveStandAttack(400, 22, 34, 1.0f, 1, 2.0f, 0.0f, 0.0f).withSound(JSoundRegistry.WS_STAND_DISC)).withImpactSound(JSoundRegistry.IMPACT_2)).withHitSpark(null)).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE)).withInfo((Component)Component.m_237113_((String)"Give Stand Disk"), (Component)Component.m_237113_((String)"gives a single hit target a stand, provided they do not have one already, from a disk in the user's off hand"));
    public static final SimpleAttack<WhiteSnakeEntity> STAND_DISC = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(480, 22, 34, 1.0f, 8.0f, 20, 2.0f, 0.5f, 0.0f).withSound(JSoundRegistry.WS_STAND_DISC)).withImpactSound(JSoundRegistry.IMPACT_2)).withAction(EffectAction.inflict(JStatusRegistry.STANDLESS, 160, 0))).withHitSpark(JParticleType.HIT_SPARK_2)).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withCrouchingVariant(GIVE_STAND)).withInfo((Component)Component.m_237113_((String)"Take Stand Disk"), (Component)Component.m_237113_((String)"uninterruptible & unblockable, removes enemy stand for 8s"));
    public static final SimpleAttack<WhiteSnakeEntity> LEG_CRUSHER = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(0, 16, 22, 0.75f, 7.0f, 32, 1.75f, 0.35f, 0.4f).withSound(JSoundRegistry.WS_LEGCRUSH)).withImpactSound(JSoundRegistry.TW_KICK_HIT)).withHitSpark(JParticleType.HIT_SPARK_3)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.LOW)).withInfo((Component)Component.m_237113_((String)"Leg Crusher"), (Component)Component.m_237113_((String)"high stun, medium windup"));
    public static final SimpleAttack<WhiteSnakeEntity> MEMORY_DISC = (SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)((SimpleAttack)new SimpleAttack(140, 22, 34, 1.0f, 7.0f, 20, 2.0f, 0.5f, 0.0f).withSound(JSoundRegistry.WS_MEMORY_DISC)).withImpactSound(JSoundRegistry.IMPACT_2)).withAction(EffectAction.inflict(new MobEffectInstance(MobEffects.f_19613_, 600, 0), new MobEffectInstance(MobEffects.f_19599_, 600, 0)))).withHitSpark(JParticleType.HIT_SPARK_2)).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withHitAnimation(CommonHitPropertyComponent.HitAnimation.HIGH)).withInfo((Component)Component.m_237113_((String)"Take Memory Disk"), (Component)Component.m_237113_((String)"uninterruptible& unblockable, gives mining fatigue & weakness for 30s"));
    public static final ChargedSpewAttack CHARGED_SPEW = (ChargedSpewAttack)((ChargedSpewAttack)new ChargedSpewAttack(40, 20, 26, 0.75f, 0.0f, 0, 2.0f, 0.0f, 0.0f).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withInfo((Component)Component.m_237113_((String)"Poison Spew"), (Component)Component.m_237113_((String)"fires a spread of 5 acid projectiles that slow enemies and persist on the surface they hits for 5s"));
    public static final PoisonSpewAttack POISON_SPEW = (PoisonSpewAttack)((PoisonSpewAttack)((PoisonSpewAttack)new PoisonSpewAttack(20, 10, 14, 0.75f, 0.0f, 0, 2.0f, 0.0f, 0.0f).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withCrouchingVariant(CHARGED_SPEW)).withInfo((Component)Component.m_237113_((String)"Poison Spew"), (Component)Component.m_237113_((String)"fires an acid projectile that slows enemies and persists on the surface it hits for 5s"));
    public static final MeltYourHeartAttack MELT_YOUR_HEART = (MeltYourHeartAttack)((MeltYourHeartAttack)((MeltYourHeartAttack)((MeltYourHeartAttack)((MeltYourHeartAttack)((MeltYourHeartAttack)new MeltYourHeartAttack(800, 40, 50, 1.0f, 3.0f, 20, 2.0f, 1.0f, 0.0f).withSound(JSoundRegistry.WS_MYH)).withImpactSound(JSoundRegistry.IMPACT_2)).withHyperArmor()).withBlockableType(BlockableType.NON_BLOCKABLE_EFFECTS_ONLY)).withLaunch()).withInfo((Component)Component.m_237113_((String)"Melt your Heart"), (Component)Component.m_237113_((String)"remote-only and armored, expels a sphere of poison"));
    public static final PilotModeMove<WhiteSnakeEntity> PILOT_MODE = (PilotModeMove)new PilotModeMove(20).withInfo((Component)Component.m_237113_((String)"Pilot Mode"), (Component)Component.m_237119_());

    public WhiteSnakeEntity(Level worldIn) {
        super((StandType)JStandTypeRegistry.WHITE_SNAKE.get(), worldIn);
        this.auraColors = new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.4f, 0.4f, 0.5f), new Vector3f(1.0f, 0.0f, 0.0f)};
    }

    private static void registerDefaultMoves(MoveMap<WhiteSnakeEntity, State> moves) {
        WhiteSnakeEntity.registerMoves(moves, false);
    }

    private static void registerRemoteMoves(MoveMap<WhiteSnakeEntity, State> moves) {
        WhiteSnakeEntity.registerMoves(moves, true);
    }

    private static void registerMoves(MoveMap<WhiteSnakeEntity, State> moves, boolean remote) {
        moves.registerImmediate(MoveClass.LIGHT, LIGHT, State.LIGHT);
        moves.register(MoveClass.HEAVY, MEDIUM, State.MEDIUM);
        moves.register(MoveClass.BARRAGE, BARRAGE, State.BARRAGE);
        moves.register(MoveClass.SPECIAL1, MEMORY_DISC, State.DISC_TAKE);
        moves.register(MoveClass.SPECIAL2, LEG_CRUSHER, State.LEG_CRUSHER);
        moves.register(MoveClass.SPECIAL3, POISON_SPEW, State.ACID_SPEW).withCrouchingVariant(State.ACID_SPEW_CHARGED);
        if (remote) {
            moves.register(MoveClass.ULTIMATE, MELT_YOUR_HEART, State.MELT_YOUR_HEART);
        } else {
            moves.register(MoveClass.ULTIMATE, STAND_DISC, State.DISC_TAKE).withCrouchingVariant(State.DISC_GIVE);
        }
        moves.register(MoveClass.UTILITY, PILOT_MODE);
    }

    @Override
    public boolean initMove(MoveClass moveClass) {
        if (this.tryFollowUp(moveClass, MoveClass.LIGHT)) {
            return true;
        }
        return super.initMove(moveClass);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isRemoteAndControllable()) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            JCraft.getClientEntityHandler().whiteSnakeRemoteClientTick(this);
        } else {
            double f = this.getRemoteForwardInput();
            double s = this.getRemoteSideInput();
            boolean jump = this.getRemoteJumpInput();
            this.tickRemoteMovement(f, s, jump);
            if (this.getState() == State.IDLE) {
                if (s > 0.0) {
                    this.setStateNoReset(this.m_20096_() ? State.RIGHT : State.RIGHT_DASH);
                }
                if (s < 0.0) {
                    this.setStateNoReset(this.m_20096_() ? State.LEFT : State.LEFT_DASH);
                }
                if (f < 0.0) {
                    this.setStateNoReset(this.m_20096_() ? State.BACKWARD : State.BACKWARD_DASH);
                }
                if (f > 0.0) {
                    this.setStateNoReset(this.m_20096_() ? State.FORWARD : State.FORWARD_DASH);
                }
            }
        }
    }

    public void tickRemoteMovement(double f, double s, boolean jump) {
        boolean swimming;
        if (this.lastRemoteInputTime - this.f_19797_ > 2) {
            this.updateRemoteInputs(0, 0, false, false);
        }
        Vec3 pos = this.m_20182_();
        Vec3 rotVec = new Vec3(this.m_20154_().f_82479_, 0.0, this.m_20154_().f_82481_).m_82541_();
        double dragMult = this.getMoveStun() > 0 ? 0.2 : 0.4;
        double moveSpeed = 0.24;
        boolean onGround = this.m_20096_();
        boolean climbing = this.m_146900_().m_204343_().anyMatch(tag -> tag == BlockTags.f_13082_);
        boolean bl = swimming = !this.m_9236_().m_6425_(this.m_20183_()).m_76178_();
        if (climbing || swimming) {
            dragMult *= 0.5;
        }
        if ((climbing || swimming) && jump) {
            this.m_5997_(0.0, 0.1, 0.0);
        } else if (onGround) {
            if (jump) {
                this.m_5997_(0.0, 0.75, 0.0);
                this.setRemoteJumpInput(false);
            }
        } else {
            moveSpeed = 0.024;
            dragMult = 0.4;
        }
        this.remoteSpeed = this.remoteSpeed.m_82549_(rotVec.m_82490_(f * moveSpeed)).m_82549_(rotVec.m_82524_(1.5707963f).m_82490_(s * moveSpeed));
        this.remoteSpeed = this.remoteSpeed.m_82490_(dragMult);
        Vec3 userPos = this.getUserOrThrow().m_20182_();
        if (pos.m_82549_(this.remoteSpeed).m_82557_(userPos) > 400.0) {
            this.remoteSpeed = userPos.m_82546_(pos).m_82490_(0.025);
        }
        this.m_5997_(this.remoteSpeed.f_82479_, this.remoteSpeed.f_82480_, this.remoteSpeed.f_82481_);
        this.f_19812_ = true;
        this.f_19864_ = true;
    }

    @Override
    protected void beginRemote() {
        super.beginRemote();
        this.switchMoveSet(REMOTE_MOVE_SET.getName());
    }

    @Override
    protected void endRemote() {
        super.endRemote();
        this.switchMoveSet(DEFAULT_MOVE_SET.getName());
    }

    @Override
    @NonNull
    public WhiteSnakeEntity getThis() {
        return this;
    }

    protected State[] getStateValues() {
        return State.values();
    }

    @Override
    @Nullable
    protected String getSummonAnimation() {
        return "animation.whitesnake.summon";
    }

    @Override
    public State getBlockState() {
        return State.BLOCK;
    }

    public static enum State implements StandAnimationState<WhiteSnakeEntity>
    {
        IDLE((whitesnake, builder) -> builder.setAnimation(RawAnimation.begin().thenLoop(whitesnake.isRemote() ? "animation.whitesnake.remote_idle" : "animation.whitesnake.idle"))),
        LIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.light"))),
        BLOCK(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.block"))),
        MEDIUM(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.medium"))),
        BARRAGE(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.barrage"))),
        LEG_CRUSHER(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.legcrusher"))),
        ACID_SPEW(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.acidspew"))),
        ACID_SPEW_CHARGED(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.acidspew_charged"))),
        DISC_TAKE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.disc_take"))),
        DISC_GIVE(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.disc_give"))),
        UPPERCUT(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.uppercut"))),
        FORWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.forw"))),
        BACKWARD(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.back"))),
        LEFT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.left"))),
        RIGHT(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.right"))),
        FORWARD_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.fdash"))),
        BACKWARD_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.bdash"))),
        LEFT_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.ldash"))),
        RIGHT_DASH(builder -> builder.setAnimation(RawAnimation.begin().thenLoop("animation.whitesnake.rdash"))),
        MELT_YOUR_HEART(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.meltyourheart"))),
        LIGHT_FOLLOWUP(builder -> builder.setAnimation(RawAnimation.begin().thenPlayAndHold("animation.whitesnake.light_followup")));

        private final BiConsumer<WhiteSnakeEntity, AnimationState<WhiteSnakeEntity>> animator;

        private State(Consumer<AnimationState<WhiteSnakeEntity>> animator) {
            this((WhiteSnakeEntity whiteSnake, AnimationState<WhiteSnakeEntity> builder) -> animator.accept((AnimationState<WhiteSnakeEntity>)builder));
        }

        private State(BiConsumer<WhiteSnakeEntity, AnimationState<WhiteSnakeEntity>> animator) {
            this.animator = animator;
        }

        @Override
        public void playAnimation(WhiteSnakeEntity attacker, AnimationState<WhiteSnakeEntity> builder) {
            this.animator.accept(attacker, builder);
        }
    }
}

