/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.vehicle;

import java.util.Collections;
import lombok.NonNull;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.util.AzureLibUtil;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGroundVehicleEntity
extends LivingEntity
implements GeoEntity {
    protected boolean left = false;
    protected boolean right = false;
    protected boolean forward = false;
    protected boolean back = false;
    protected boolean space = false;
    protected boolean sneak = false;
    protected float oldYRot = 0.0f;
    private Entity owner;
    protected boolean stopsWithoutDriver = true;
    protected boolean pushBelow = true;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AbstractGroundVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> HURT_TIME;
    private static final EntityDataAccessor<Boolean> TURN_LEFT;
    private static final EntityDataAccessor<Boolean> TURN_RIGHT;
    private static final EntityDataAccessor<Boolean> MOVE_FORWARD;
    private static final EntityDataAccessor<Boolean> MOVE_BACK;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public AbstractGroundVehicleEntity(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TURN_LEFT, (Object)false);
        this.f_19804_.m_135372_(TURN_RIGHT, (Object)false);
        this.f_19804_.m_135372_(MOVE_FORWARD, (Object)false);
        this.f_19804_.m_135372_(MOVE_BACK, (Object)false);
        this.f_19804_.m_135372_(HURT_TIME, (Object)0);
    }

    public boolean m_7337_(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return Boat.m_38323_((Entity)this, (Entity)entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_6084_() {
        return !this.m_213877_();
    }

    public void updateInputs(int forward, int left, boolean jump, boolean sneak) {
        if (forward == 0) {
            this.forward = false;
            this.back = false;
        }
        if (forward > 0) {
            this.forward = true;
            this.back = false;
        }
        if (forward < 0) {
            this.forward = false;
            this.back = true;
        }
        if (left == 0) {
            this.left = false;
            this.right = false;
        }
        if (left > 0) {
            this.left = true;
            this.right = false;
        }
        if (left < 0) {
            this.left = false;
            this.right = true;
        }
        this.f_19804_.m_135381_(TURN_LEFT, (Object)this.left);
        this.f_19804_.m_135381_(TURN_RIGHT, (Object)this.right);
        this.f_19804_.m_135381_(MOVE_FORWARD, (Object)this.forward);
        this.f_19804_.m_135381_(MOVE_BACK, (Object)this.back);
        this.space = jump;
        this.sneak = sneak;
    }

    public final boolean steeringLeft() {
        return (Boolean)this.f_19804_.m_135370_(TURN_LEFT);
    }

    public final boolean steeringRignt() {
        return (Boolean)this.f_19804_.m_135370_(TURN_RIGHT);
    }

    public final boolean movingForward() {
        return (Boolean)this.f_19804_.m_135370_(MOVE_FORWARD);
    }

    public final boolean movingBack() {
        return (Boolean)this.f_19804_.m_135370_(MOVE_BACK);
    }

    public final float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public final void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public final int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(HURT_TIME);
    }

    public final void setHurtTime(int time) {
        this.f_19804_.m_135381_(HURT_TIME, (Object)time);
    }

    public void m_8119_() {
        int hurtTime;
        super.m_8119_();
        Level level = this.m_9236_();
        boolean client = level.m_5776_();
        if (this.stopsWithoutDriver && !this.m_20160_()) {
            this.updateInputs(0, 0, false, false);
        }
        if (client) {
            JCraft.getClientEntityHandler().vehicleMovementTick(this);
        } else {
            this.movementTick(this.forward, this.left, this.back, this.right, this.space, this.sneak);
        }
        if (this.m_6109_()) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.pushBelow && !client) {
            Direction gravity = GravityChangerAPI.getGravityDirection((Entity)this);
            Vec3 down = new Vec3((double)gravity.m_122429_(), (double)gravity.m_122430_(), (double)gravity.m_122431_());
            AABB beneathBox = this.m_20191_().m_82383_(down);
            for (Entity entity : level.m_45933_((Entity)this, beneathBox)) {
                if (!entity.m_6094_()) continue;
                JUtils.addVelocity(entity, entity.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.1));
            }
        }
        if ((hurtTime = this.getHurtTime()) > 0) {
            this.setHurtTime(hurtTime - 1);
        }
    }

    public abstract void movementTick(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6);

    public boolean m_6469_(@NonNull DamageSource source, float amount) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (super.m_6469_(source, amount)) {
            this.setHurtTime(5);
            return true;
        }
        return false;
    }

    public float getGroundFriction() {
        AABB aABB = this.m_20191_();
        AABB aABB2 = new AABB(aABB.f_82288_, aABB.f_82289_ - 0.001, aABB.f_82290_, aABB.f_82291_, aABB.f_82289_, aABB.f_82293_);
        int i = Mth.m_14107_((double)aABB2.f_82288_) - 1;
        int j = Mth.m_14165_((double)aABB2.f_82291_) + 1;
        int k = Mth.m_14107_((double)aABB2.f_82289_) - 1;
        int l = Mth.m_14165_((double)aABB2.f_82292_) + 1;
        int m = Mth.m_14107_((double)aABB2.f_82290_) - 1;
        int n = Mth.m_14165_((double)aABB2.f_82293_) + 1;
        VoxelShape voxelShape = Shapes.m_83064_((AABB)aABB2);
        float f = 0.0f;
        int o = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p != i && p != j - 1 ? 0 : 1) + (q != m && q != n - 1 ? 0 : 1);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutableBlockPos.m_122178_(p, s, q);
                    BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
                    if (blockState.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockState.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos).m_83216_((double)p, (double)s, (double)q), (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockState.m_60734_().m_49958_();
                    ++o;
                }
            }
        }
        return f / (float)o;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_6052_() {
        return false;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    public final AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getOldYRot() {
        return this.oldYRot;
    }

    public Entity getOwner() {
        return this.owner;
    }

    public void setOwner(Entity owner) {
        this.owner = owner;
    }

    static {
        TURN_LEFT = SynchedEntityData.m_135353_(AbstractGroundVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        TURN_RIGHT = SynchedEntityData.m_135353_(AbstractGroundVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        MOVE_FORWARD = SynchedEntityData.m_135353_(AbstractGroundVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        MOVE_BACK = SynchedEntityData.m_135353_(AbstractGroundVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        HURT_TIME = SynchedEntityData.m_135353_(AbstractGroundVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

