/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.entity.vehicle;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JEntityTypeRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.vehicle.AbstractGroundVehicleEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RoadRollerEntity
extends AbstractGroundVehicleEntity {
    private static boolean recipeChecked = false;
    private static Recipe<?> recipe = null;
    private int ridingTicks = 0;
    private static final double INLINE_SPEED = 0.1;
    private static final double TURN_RATE = 5.0;
    private static final Map<BlockState, BlockState> flattenedBlockStates = Map.ofEntries(Map.entry(Blocks.f_50493_.m_49966_(), Blocks.f_50093_.m_49966_()), Map.entry(Blocks.f_50440_.m_49966_(), Blocks.f_152481_.m_49966_()), Map.entry(Blocks.f_50652_.m_49966_(), Blocks.f_50069_.m_49966_()), Map.entry(Blocks.f_152551_.m_49966_(), Blocks.f_152550_.m_49966_()), Map.entry(Blocks.f_50062_.m_49966_(), Blocks.f_50471_.m_49966_()));
    private static final RawAnimation NEUTRAL = RawAnimation.begin().thenLoop("steer_neutral");
    private static final RawAnimation LEFT = RawAnimation.begin().thenLoop("steer_left");
    private static final RawAnimation RIGHT = RawAnimation.begin().thenLoop("steer_right");
    private static final RawAnimation FORWARD = RawAnimation.begin().thenLoop("forward");
    private static final RawAnimation BACK = RawAnimation.begin().thenLoop("back");
    private static final RawAnimation SHAKE = RawAnimation.begin().thenLoop("shake");
    private static final RawAnimation HIT = RawAnimation.begin().thenLoop("hit");
    private static final RawAnimation DEATH = RawAnimation.begin().thenLoop("explode");

    public RoadRollerEntity(Level level) {
        super((EntityType<? extends LivingEntity>)((EntityType)JEntityTypeRegistry.ROAD_ROLLER.get()), level);
        if (!recipeChecked) {
            Optional<Recipe> maybe = level.m_7465_().m_44051_().stream().filter(r -> r.m_8043_(level.m_9598_()).m_150930_((Item)JItemRegistry.ROAD_ROLLER.get())).findFirst();
            maybe.ifPresent(value -> {
                recipe = value;
            });
            recipeChecked = true;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.m_20160_()) {
                if ((this.ridingTicks - 52) % 82 == 0) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JSoundRegistry.ROAD_ROLLER_ACTIVE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, true);
                }
                ++this.ridingTicks;
                Direction gravity = GravityChangerAPI.getGravityDirection((Entity)this);
                float yaw = this.f_19859_ + 90.0f;
                Vec3 down = new Vec3((double)gravity.m_122429_(), (double)gravity.m_122430_(), (double)gravity.m_122431_());
                Vec3 forward = new Vec3((double)Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))), 0.0, (double)Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))));
                Vec3 right = new Vec3((double)Mth.m_14089_((float)((yaw + 90.0f) * ((float)Math.PI / 180))), 0.0, (double)Mth.m_14031_((float)((yaw + 90.0f) * ((float)Math.PI / 180))));
                Vec3 localPos = new Vec3(-forward.f_82479_ * 2.62 - right.f_82479_ * (0.65 + this.f_19796_.m_188500_() / 5.0 - 0.1) - down.f_82479_ * 2.25, -forward.f_82480_ * 2.62 - right.f_82480_ * (0.65 + this.f_19796_.m_188500_() / 5.0 - 0.1) - down.f_82480_ * 2.25, -forward.f_82481_ * 2.62 - right.f_82481_ * (0.65 + this.f_19796_.m_188500_() / 5.0 - 0.1) - down.f_82481_ * 2.25);
                Vec3 worldPos = RotationUtil.vecWorldToPlayer(localPos.f_82479_, localPos.f_82480_, localPos.f_82481_, gravity).m_82549_(this.m_20182_());
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, down.f_82479_ * 0.03 - forward.f_82479_ * 0.06 + this.f_19796_.m_188500_() * 0.05 - 0.025, down.f_82480_ * 0.03 - forward.f_82480_ * 0.06 + this.f_19796_.m_188500_() * 0.05 - 0.025, down.f_82481_ * 0.03 - forward.f_82481_ * 0.06 + this.f_19796_.m_188500_() * 0.05 - 0.025);
            } else {
                this.ridingTicks = 0;
            }
        }
    }

    protected void m_6153_() {
        super.m_6153_();
        if (this.f_20919_ == 1) {
            Level level = this.m_9236_();
            Vec3 pos = this.m_20182_();
            if (!level.m_5776_()) {
                level.m_254849_((Entity)this, pos.f_82479_, pos.f_82480_, pos.f_82481_, 2.0f, this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
                for (Ingredient ingredient : recipe.m_7527_()) {
                    ItemStack[] items;
                    for (ItemStack stack : items = ingredient.m_43908_()) {
                        ItemEntity drop = new ItemEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
                        drop.m_32010_(40);
                        drop.m_20256_(JUtils.randUnitVec(this.f_19796_));
                        level.m_7967_((Entity)drop);
                    }
                }
            }
        }
    }

    @Override
    public void movementTick(boolean w, boolean a, boolean s, boolean d, boolean space, boolean sneak) {
        boolean grounded;
        double drag = 0.99;
        Level level = this.m_9236_();
        Direction gravity = GravityChangerAPI.getGravityDirection((Entity)this);
        this.oldYRot = this.m_146908_();
        Vec3 movement = this.m_20184_();
        if (Double.isNaN(movement.f_82479_)) {
            movement = new Vec3(0.0, movement.f_82480_, movement.f_82481_);
        }
        if (Double.isNaN(movement.f_82480_)) {
            movement = new Vec3(movement.f_82479_, 0.0, movement.f_82481_);
        }
        if (Double.isNaN(movement.f_82481_)) {
            movement = new Vec3(movement.f_82479_, movement.f_82480_, 0.0);
        }
        if (grounded = this.m_20096_()) {
            drag = this.getGroundFriction();
        } else {
            Optional supporting = level.m_285750_((Entity)this, this.m_20191_().m_82400_(0.1));
            if (supporting.isPresent()) {
                grounded = true;
                drag = level.m_8055_((BlockPos)supporting.get()).m_60734_().m_49958_();
            }
        }
        if (grounded) {
            if (w || s) {
                double inline = w ? 0.1 : -0.1;
                if (a || d) {
                    double movementSpeed = movement.m_82553_();
                    if (Double.isNaN(movementSpeed)) {
                        movementSpeed = 0.0;
                    }
                    float turnCW = 0.0f;
                    turnCW = d ? (float)((double)turnCW + Math.sqrt(movementSpeed)) : (float)((double)turnCW - Math.sqrt(movementSpeed));
                    turnCW = (float)((double)turnCW * (s ? -5.0 : 5.0));
                    this.m_146922_(this.oldYRot + turnCW);
                }
                this.m_20256_(movement.m_82549_(this.m_20156_().m_82490_(inline)));
            }
        } else if (movement.m_82556_() == 0.0) {
            this.m_20256_(movement.m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, -0.02, 0.0), gravity)));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int x = -1; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        Vec3 offset = new Vec3((double)x, -0.1 * (double)y, (double)z);
                        offset = RotationUtil.vecPlayerToWorld(offset, gravity);
                        BlockPos blockPos = this.m_20183_().m_7918_(Mth.m_14107_((double)offset.f_82479_), Mth.m_14107_((double)offset.f_82480_), Mth.m_14107_((double)offset.f_82481_));
                        BlockState state = serverLevel.m_8055_(blockPos);
                        Block block = state.m_60734_();
                        if (flattenedBlockStates.containsKey(state)) {
                            serverLevel.m_7731_(blockPos, flattenedBlockStates.get(state), 3);
                            continue;
                        }
                        if (block == Blocks.f_152481_ || !state.m_247087_() && (y != 0 || !(block.m_7325_() <= 3.0f))) continue;
                        serverLevel.m_46961_(blockPos, true);
                    }
                }
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(drag));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (this.m_146895_() == null) {
            if (!this.m_9236_().m_5776_()) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public ItemStack m_142340_() {
        return ((Item)JItemRegistry.ROAD_ROLLER.get()).m_7968_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)JSoundRegistry.ROAD_ROLLER_HIT.get();
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (passenger == this.m_146895_()) {
            this.m_216990_((SoundEvent)JSoundRegistry.ROAD_ROLLER_IGNITION.get());
        }
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        MobEffect effect = effectInstance.m_19544_();
        if (effect == JStatusRegistry.KNOCKDOWN.get() || effect == JStatusRegistry.BLEEDING.get() || effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_) {
            return false;
        }
        return super.m_147207_(effectInstance, entity);
    }

    @Override
    public boolean m_6469_(@NonNull DamageSource source, float amount) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268656_) || source.m_276093_(DamageTypes.f_268440_) || source.m_276093_(DamageTypes.f_268441_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_183634_() {
        Level level = this.m_9236_();
        if (!level.m_5776_() && (double)this.f_19789_ > 6.0) {
            DamageSource ds = this.m_9236_().m_269111_().m_269354_();
            Set<LivingEntity> hurt = JUtils.generateHitbox(this.m_9236_(), this.m_20182_(), 3.5, Set.of(this));
            for (LivingEntity living : hurt) {
                if (!JUtils.canDamage(ds, (Entity)living)) continue;
                LivingEntity target = JUtils.getUserIfStand(living);
                if (this.getOwner() == target) continue;
                Attacks.damageLogic(this.m_9236_(), target, target.m_20182_().m_82546_(this.m_20182_()), 25, 3, false, 12.0f, false, 21, ds, this.getOwner(), CommonHitPropertyComponent.HitAnimation.CRUSH, false);
            }
            JComponentPlatformUtils.getShockwaveHandler(level).addShockwave(this.m_20182_(), Vec3.m_82528_((Vec3i)GravityChangerAPI.getGravityDirection((Entity)this).m_122436_()), 4.5f);
            ClientboundLevelParticlesPacket poofPacket = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123759_, false, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.2f, 0.2f, 0.2f, 0.3f, 32);
            JUtils.tracking((Entity)this).forEach(serverPlayer -> serverPlayer.f_8906_.m_9829_((Packet)poofPacket));
            this.m_216990_((SoundEvent)JSoundRegistry.ROAD_ROLLER_SLAM.get());
        }
        super.m_183634_();
    }

    public double m_6048_() {
        return 1.0;
    }

    public void m_7378_(CompoundTag compound) {
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "death", 0, this::deathPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shake", 0, this::shakePredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 5, this::movePredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "steering", 5, this::steerPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "hit", 0, this::hitPredicate)});
    }

    private <T extends GeoAnimatable> PlayState steerPredicate(AnimationState<T> state) {
        if (this.steeringLeft()) {
            return state.setAndContinue(LEFT);
        }
        if (this.steeringRignt()) {
            return state.setAndContinue(RIGHT);
        }
        return state.setAndContinue(NEUTRAL);
    }

    private <T extends GeoAnimatable> PlayState movePredicate(AnimationState<T> state) {
        if (this.movingForward()) {
            return state.setAndContinue(FORWARD);
        }
        if (this.movingBack()) {
            return state.setAndContinue(BACK);
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState shakePredicate(AnimationState<T> state) {
        if (this.m_20160_()) {
            return state.setAndContinue(SHAKE);
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState hitPredicate(AnimationState<T> state) {
        if (this.getHurtTime() > 0) {
            return state.setAndContinue(HIT);
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState deathPredicate(AnimationState<T> state) {
        if (this.f_20919_ > 0) {
            return state.setAndContinue(DEATH);
        }
        return PlayState.STOP;
    }
}

