/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.events;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.component.living.CommonVampireComponent;
import net.arna.jcraft.api.registry.JBlockRegistry;
import net.arna.jcraft.api.registry.JDimensionRegistry;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSpecTypeRegistry;
import net.arna.jcraft.api.registry.JStandTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.spec.SpecType;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.api.stand.StandType;
import net.arna.jcraft.api.stand.StandTypeUtil;
import net.arna.jcraft.common.block.CoffinBlock;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.data.AttackerDataLoader;
import net.arna.jcraft.common.entity.StandMeteorEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.item.MockItem;
import net.arna.jcraft.common.marker.BlockMarkerMoves;
import net.arna.jcraft.common.network.s2c.AttackerDataPacket;
import net.arna.jcraft.common.saveddata.ExclusiveStandsData;
import net.arna.jcraft.common.tickable.FrameDataRequests;
import net.arna.jcraft.common.tickable.JEnemies;
import net.arna.jcraft.common.tickable.MagneticFields;
import net.arna.jcraft.common.tickable.PastDimensions;
import net.arna.jcraft.common.tickable.PeacemakerReload;
import net.arna.jcraft.common.tickable.RazorCoughs;
import net.arna.jcraft.common.tickable.Revivables;
import net.arna.jcraft.common.tickable.RevolverFire;
import net.arna.jcraft.common.tickable.Timestops;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.DashData;
import net.arna.jcraft.common.util.EntityInterest;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.mixin_logic.EntityAddon;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JServerEvents {
    private static final List<Enchantment> JCRAFT_ARMOR_ENCHANTS = List.of(Enchantments.f_44965_, Enchantments.f_44969_, Enchantments.f_44968_, Enchantments.f_44966_, Enchantments.f_44986_);
    private static final List<List<Item>> EQUIPMENT = List.of(List.of(Items.f_41852_, Items.f_42479_, Items.f_42467_, Items.f_42471_, Items.f_42475_, Items.f_42483_), List.of(Items.f_41852_, Items.f_42478_, Items.f_42466_, Items.f_42470_, Items.f_42474_, Items.f_42482_), List.of(Items.f_41852_, Items.f_42477_, Items.f_42465_, Items.f_42469_, Items.f_42473_, Items.f_42481_), List.of(Items.f_41852_, Items.f_42476_, Items.f_42464_, Items.f_42468_, Items.f_42472_, Items.f_42480_));

    public static void finishLoading(MinecraftServer server) {
        JCraft.auWorld = server.m_129880_(JDimensionRegistry.AU_DIMENSION_KEY);
        JCraft.setExclusiveStandsData(ExclusiveStandsData.fromDefaultFile(server));
    }

    public static void saveExclusives(MinecraftServer server) {
        JCraft.getExclusiveStandsData().saveToDefaultFile(server);
    }

    public static void serverPostTick(MinecraftServer server) {
        if (JCraft.preloadLockTicks > 0) {
            --JCraft.preloadLockTicks;
        }
        RevolverFire.tick(server);
        PeacemakerReload.tick(server);
        PastDimensions.tick(server);
        Timestops.tick(server);
        Revivables.tick(server);
        JEnemies.tick();
        FrameDataRequests.tick();
        MagneticFields.tick();
        RazorCoughs.tick();
        for (ServerPlayer serverPlayer : JUtils.all(server)) {
            if (serverPlayer == null || !serverPlayer.m_6084_() || serverPlayer.m_21188_() == null) continue;
            JComponentPlatformUtils.getMiscData((LivingEntity)serverPlayer).startDamageTimer();
        }
        Object2IntOpenHashMap newBurstTimers = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : JCraft.burstTimers.object2IntEntrySet()) {
            LivingEntity player = (LivingEntity)entry.getKey();
            entry.setValue(entry.getIntValue() - 1);
            int newVal = entry.getIntValue();
            HashSet<LivingEntity> filter = new HashSet<LivingEntity>();
            filter.add(player);
            if (player.m_20160_()) {
                filter.addAll(player.m_20197_());
            }
            if (newVal > 0) {
                newBurstTimers.put((Object)player, newVal);
                continue;
            }
            player.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
            JCraft.stun(player, 10, 1);
            Vec3 pPos = player.m_146892_();
            AABB burstHitbox = AbstractSimpleAttack.createBox(pPos, 4.0);
            List toPush = player.m_9236_().m_6443_(Entity.class, burstHitbox, EntitySelector.f_20403_.and(e -> !filter.contains(e)));
            JUtils.displayHitbox(player.m_9236_(), burstHitbox);
            for (Entity ent : toPush) {
                Vec3 awayVector = ent.m_20182_().m_82546_(pPos).m_82541_();
                boolean pushAway = true;
                if (ent instanceof StandEntity) {
                    StandEntity stand = (StandEntity)ent;
                    if (stand.hasUser()) {
                        JCraft.stun(stand.getUser(), 10, 3, (Entity)player);
                        stand.cancelMove();
                    }
                } else {
                    Entity entity = ent.m_146895_();
                    if (entity instanceof StandEntity) {
                        StandEntity stand = (StandEntity)entity;
                        if (stand.blocking) {
                            pushAway = false;
                        } else if (ent instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)ent;
                            JCraft.stun(living, 10, 3, (Entity)player);
                            stand.cancelMove();
                        }
                    }
                }
                if (!pushAway) continue;
                JUtils.setVelocity(ent, awayVector.f_82479_, awayVector.f_82480_ / 5.0 + 0.4, awayVector.f_82481_);
            }
        }
        JCraft.burstTimers.clear();
        JCraft.burstTimers.putAll((Map)newBurstTimers);
        JCraft.pushblockCooldowns.replaceAll((key, value) -> value - 1);
        for (Map.Entry<LivingEntity, DashData> entry : new HashSet<Map.Entry<LivingEntity, DashData>>(JCraft.dashes.entrySet())) {
            DashData dash = entry.getValue();
            dash.tickDash();
            if (!dash.finished) continue;
            JCraft.dashes.remove(entry.getKey());
        }
        Map<Entity, EntityInterest> map = JCraft.getEntitiesOfInterest();
        HashMap<Entity, EntityInterest> hashMap = new HashMap<Entity, EntityInterest>();
        block8: for (Map.Entry<Entity, EntityInterest> entityAndInterest : map.entrySet()) {
            Entity entity = entityAndInterest.getKey();
            if (entity == null || !entity.m_6084_()) continue;
            EntityInterest interest = entityAndInterest.getValue();
            ServerLevel serverWorld = (ServerLevel)entity.m_9236_();
            boolean saveForNextIteration = true;
            switch (interest.getType()) {
                default: {
                    saveForNextIteration = false;
                    break;
                }
                case BLOCK_ATTRACTION: {
                    BlockPos attractionBlockPos = interest.getAttractionBlockPos();
                    if (entity.m_20275_((double)attractionBlockPos.m_123341_(), (double)attractionBlockPos.m_123342_(), (double)attractionBlockPos.m_123343_()) < 4.0) {
                        boolean griefing = serverWorld.m_46469_().m_46207_(JCraft.STAND_GRIEFING);
                        JServerEvents.dimensionalExplosion(serverWorld, griefing, entity);
                        if (!griefing) break;
                        serverWorld.m_46597_(attractionBlockPos, Blocks.f_50016_.m_49966_());
                        break;
                    }
                    BlockPos delta = attractionBlockPos.m_121996_((Vec3i)entity.m_20183_());
                    Vec3 towardsVel = new Vec3((double)delta.m_123341_(), (double)delta.m_123342_(), (double)delta.m_123343_()).m_82541_();
                    entity.m_5997_(towardsVel.f_82479_, towardsVel.f_82480_, towardsVel.f_82481_);
                    entity.f_19864_ = true;
                    break;
                }
                case ITEM_ATTRACTION: {
                    if (!(entity instanceof ItemEntity)) continue block8;
                    ItemEntity item = (ItemEntity)entity;
                    for (Map.Entry<Entity, EntityInterest> entityAndInterest2 : map.entrySet()) {
                        Entity entity2 = entityAndInterest2.getKey();
                        if (!(entity2 instanceof ItemEntity)) continue;
                        ItemEntity item2 = (ItemEntity)entity2;
                        if (entityAndInterest2.getValue().getType() != EntityInterest.ItemInterestType.ITEM_ATTRACTION || item2 == entity || item2.m_9236_() != serverWorld || item2.m_32055_().m_41720_() != item.m_32055_().m_41720_() || !(item2.m_20280_(entity) <= 256.0)) continue;
                        Vec3 converge = item2.m_20182_().m_82546_(entity.m_20182_());
                        Vec3 towardsVector = converge.m_82541_().m_82490_(0.25);
                        entity.m_5997_(towardsVector.f_82479_, towardsVector.f_82480_, towardsVector.f_82481_);
                        entity.f_19864_ = true;
                        if (!((double)item2.m_20270_(entity) <= 1.0)) continue;
                        JServerEvents.dimensionalExplosion(serverWorld, serverWorld.m_46469_().m_46207_(JCraft.STAND_GRIEFING), entity, (Entity)item2);
                        saveForNextIteration = false;
                    }
                }
            }
            if (!saveForNextIteration) continue;
            hashMap.put(entity, interest);
        }
        map.clear();
        map.putAll(hashMap);
        if (AttackerDataLoader.isDirty()) {
            AttackerDataPacket.send(server.m_6846_().m_11314_());
            AttackerDataLoader.setDirty(false);
        }
    }

    private static void dimensionalExplosion(ServerLevel serverWorld, boolean griefing, Entity one) {
        JServerEvents.dimensionalExplosion(serverWorld, griefing, one, null);
    }

    private static void dimensionalExplosion(ServerLevel serverWorld, boolean griefing, Entity one, @Nullable Entity other) {
        Vec3 midPos = one.m_20182_();
        if (other != null) {
            midPos = midPos.m_82549_(other.m_20182_()).m_82490_(0.5);
            other.m_146870_();
        }
        one.m_146870_();
        Explosion explosion = serverWorld.m_254849_(null, midPos.f_82479_, midPos.f_82480_, midPos.f_82481_, 1.0f, griefing ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        List toDamage = serverWorld.m_6443_(LivingEntity.class, new AABB(midPos.m_82520_(1.5, 1.5, 1.5), midPos.m_82492_(1.5, 1.5, 1.5)), EntitySelector.f_20402_);
        for (LivingEntity ent : toDamage) {
            ent.m_6469_(explosion.m_46077_(), 7.0f);
            JCraft.stun(ent, 10, 3);
            ent.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 35, 0));
        }
    }

    public static EventResult entityLoad(Entity entity, boolean worldGenSpawned) {
        ServerLevel world = (ServerLevel)entity.m_9236_();
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            ItemStack stack = item.m_32055_();
            if (stack.m_150930_((Item)JItemRegistry.ANUBIS.get())) {
                item.m_32010_(0);
                return EventResult.pass();
            }
            if (stack.m_150930_((Item)JItemRegistry.FV_REVOLVER.get())) {
                JCraft.markItemOfInterest((Entity)item, EntityInterest.itemAttractionInterest((Item)JItemRegistry.FV_REVOLVER.get()));
                return EventResult.pass();
            }
            if (world.m_46472_().equals(JDimensionRegistry.AU_DIMENSION_KEY)) {
                if (item.m_19749_() != null || MockItem.isMockItem(stack)) {
                    return EventResult.pass();
                }
                ItemStack mockStack = MockItem.createMockStack(stack);
                if (stack.m_41720_() instanceof BlockItem) {
                    mockStack.m_41784_().m_128385_("AttractPos", new int[]{item.m_146903_(), item.m_146904_(), item.m_146907_()});
                }
                item.m_32045_(mockStack);
            } else if (MockItem.isMockItem(stack)) {
                CompoundTag stackData = stack.m_41784_();
                if (stackData.m_128441_("AttractPos")) {
                    String itemId = stackData.m_128461_("MockItem");
                    int[] attractPos = stackData.m_128465_("AttractPos");
                    BlockPos attractBlockPos = new BlockPos(attractPos[0], attractPos[1], attractPos[2]);
                    if (BuiltInRegistries.f_257033_.m_7981_((Object)world.m_8055_(attractBlockPos).m_60734_().m_5456_()).toString().equals(itemId)) {
                        JCraft.markItemOfInterest((Entity)item, EntityInterest.blockAttractionInterest(attractBlockPos));
                    }
                } else {
                    JCraft.markItemOfInterest((Entity)item, EntityInterest.itemAttractionInterest(stack.m_41720_()));
                }
            }
        }
        if (entity instanceof Mob) {
            AttributeInstance movementSpeed;
            Mob mob = (Mob)entity;
            CommonStandComponent standData = JComponentPlatformUtils.getStandComponent((LivingEntity)mob);
            if (!StandTypeUtil.isNone(standData.getType())) {
                JEnemies.add(mob);
                return EventResult.pass();
            }
            if (!mob.m_6095_().m_204039_(JTagRegistry.CAN_HAVE_STAND)) {
                return EventResult.pass();
            }
            if (standData.isTagged()) {
                return EventResult.pass();
            }
            if (standData.getType() != null) {
                return EventResult.pass();
            }
            RandomSource random = mob.m_217043_();
            GameRules gameRules = world.m_46469_();
            standData.setTagged(true);
            if (!JServerConfig.SPAWNER_STANDS.getValue() && ((EntityAddon)mob).jcraft$isFromSpawner()) {
                return EventResult.pass();
            }
            if (100 - random.m_216339_(0, 100) > gameRules.m_46215_(JCraft.CHANCE_MOB_SPAWNS_WITH_STAND)) {
                return EventResult.pass();
            }
            StandType type = gameRules.m_46207_(JCraft.ALLOW_MOB_EVOLVED_STANDS) ? StandTypeUtil.getRandom(entity.m_9236_().f_46441_) : StandTypeUtil.getRandomRegular(entity.m_9236_().f_46441_);
            standData.setType(type);
            AttributeInstance followRange = mob.m_21051_(Attributes.f_22277_);
            if (followRange != null) {
                followRange.m_22100_(Mth.m_14008_((double)(128.0 * (1.0 + (double)entity.m_9236_().m_46791_().m_19028_()) / 4.0), (double)10.0, (double)128.0));
            }
            if ((movementSpeed = mob.m_21051_(Attributes.f_22279_)) != null && movementSpeed.m_22115_() < 0.3) {
                movementSpeed.m_22100_(0.3);
            }
            if ((double)mob.m_21233_() > 100.0) {
                return EventResult.pass();
            }
            NonNullList handItems = (NonNullList)mob.m_6167_();
            NonNullList armorItems = (NonNullList)mob.m_6168_();
            if (type == JStandTypeRegistry.SILVER_CHARIOT.get() && random.m_188503_(5) == 4) {
                handItems.set(0, (Object)new ItemStack((ItemLike)JItemRegistry.ANUBIS.get()));
            }
            if (random.m_216339_(0, 100) >= 90) {
                handItems.set(1, (Object)new ItemStack((ItemLike)JItemRegistry.STAND_ARROW.get()));
                mob.m_21409_(EquipmentSlot.OFFHAND, 100.0f);
            }
            int baseArmorLevel = random.m_216339_(1, 6);
            int enchantsSize = JCRAFT_ARMOR_ENCHANTS.size();
            for (int i = 0; i < 4; ++i) {
                int armorLevel = baseArmorLevel + random.m_216339_(-1, 1);
                ItemStack itemStack = new ItemStack((ItemLike)EQUIPMENT.get(i).get(armorLevel));
                Enchantment enchantment = JCRAFT_ARMOR_ENCHANTS.get(random.m_188503_(enchantsSize));
                itemStack.m_41663_(enchantment, enchantment.m_6586_());
                armorItems.set(i, (Object)itemStack);
                int diamondLevel = 4;
                if (armorLevel < 4) continue;
                mob.m_21409_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i), 0.0f);
            }
            JEnemies.add(mob);
        }
        return EventResult.pass();
    }

    public static EventResult rightClickBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction direction) {
        if (!JUtils.canAct((LivingEntity)player)) {
            return EventResult.interruptFalse();
        }
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        if (stand != null && stand.isRemoteAndControllable()) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static EventResult leftClickBlock(Player player, InteractionHand hand, BlockPos blockPos, Direction direction) {
        if (!JUtils.canAct((LivingEntity)player)) {
            return EventResult.interruptFalse();
        }
        StandEntity<?, ?> stand = JUtils.getStand((LivingEntity)player);
        if (stand != null && stand.isRemoteAndControllable()) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static CompoundEventResult<ItemStack> rightClick(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!JUtils.canAct((LivingEntity)player)) {
            return CompoundEventResult.interruptFalse((Object)stack);
        }
        return CompoundEventResult.pass();
    }

    public static EventResult death(LivingEntity living, DamageSource source) {
        Level level = living.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (living instanceof ServerPlayer) {
                Entity entity;
                ServerPlayer serverPlayer = (ServerPlayer)living;
                GameRules gameRules = serverWorld.m_46469_();
                if (!gameRules.m_46207_(JCraft.KEEP_STAND)) {
                    JComponentPlatformUtils.getStandComponent(living).setTypeAndSkin((StandType)JStandTypeRegistry.NONE.get(), 0);
                }
                if (!gameRules.m_46207_(JCraft.KEEP_SPEC)) {
                    JComponentPlatformUtils.getSpecData((LivingEntity)serverPlayer).setType((SpecType)JSpecTypeRegistry.NONE.get());
                }
                if ((entity = source.m_7639_()) instanceof LivingEntity) {
                    LivingEntity killer = (LivingEntity)entity;
                    JComponentPlatformUtils.getCooldowns(killer).clear(CooldownType.COMBO_BREAKER);
                    boolean killVampirism = JServerConfig.KILL_VAMPIRISM.getValue();
                    if (killer instanceof ServerPlayer) {
                        ServerPlayer killerPlayer = (ServerPlayer)killer;
                        if (killVampirism) {
                            killerPlayer.m_36324_().m_38707_(20, 20.0f);
                            CommonVampireComponent vampireComponent = JComponentPlatformUtils.getVampirism((LivingEntity)killerPlayer);
                            if (vampireComponent.isVampire()) {
                                vampireComponent.setBlood(20.0f);
                            }
                        }
                    }
                    if (killVampirism) {
                        killer.m_21153_(killer.m_21233_());
                    }
                }
            }
            Revivables.addRevivable(living.m_6095_(), living.m_20182_(), (ResourceKey<Level>)serverWorld.m_46472_());
        }
        return EventResult.pass();
    }

    public static EventResult hurt(LivingEntity entity, DamageSource source, float damage) {
        if (damage < 0.01f) {
            return EventResult.pass();
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            JServerEvents.maybeLaunch(entity, source, serverWorld, entity.m_21124_((MobEffect)JStatusRegistry.DAZED.get()), source.m_7639_());
        }
        return EventResult.pass();
    }

    public static void maybeLaunch(LivingEntity entity, DamageSource source, ServerLevel serverWorld, MobEffectInstance stun, Entity attacker) {
        if (stun != null && stun.m_19564_() != 2) {
            boolean toLaunch = false;
            boolean projectileAttack = false;
            if (attacker instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)attacker;
                projectileAttack = source.m_269533_(DamageTypeTags.f_268524_);
                boolean hasWeapon = projectileAttack;
                if (!hasWeapon) {
                    hasWeapon = !living.m_21205_().m_41638_(EquipmentSlot.MAINHAND).isEmpty();
                }
                toLaunch = hasWeapon;
            }
            if (source.m_276093_(DamageTypes.f_268565_)) {
                toLaunch = true;
            }
            if (toLaunch) {
                int duration = stun.m_19557_() / 3;
                entity.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
                JCraft.stun(entity, duration, 3, attacker);
                Vec3i upVec = GravityChangerAPI.getGravityDirection((Entity)entity).m_122436_();
                Vec3 upVecD = new Vec3((double)(-upVec.m_123341_()) / 3.0, (double)(-upVec.m_123342_()) / 3.0, (double)(-upVec.m_123343_()) / 3.0);
                Vec3 sourcePos = source.m_7270_();
                if (sourcePos == null) {
                    sourcePos = new Vec3(entity.m_217043_().m_188583_(), entity.m_217043_().m_188583_(), entity.m_217043_().m_188583_()).m_82549_(entity.m_20182_()).m_82546_(upVecD);
                }
                Vec3 knockback = entity.m_20182_().m_82546_(sourcePos).m_82541_().m_82549_(upVecD);
                GravityChangerAPI.setWorldVelocity((Entity)entity, knockback);
                entity.f_19864_ = true;
                JCraft.createParticle(serverWorld, entity.m_20185_() - (double)upVec.m_123341_(), entity.m_20186_() - (double)upVec.m_123342_(), entity.m_20189_() - (double)upVec.m_123343_(), projectileAttack ? JParticleType.STUN_PIERCE : JParticleType.STUN_SLASH);
            }
        }
    }

    public static InteractionResult allowSleep(Player player, BlockPos sleepingPos) {
        ServerLevel serverWorld;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && (serverWorld = (ServerLevel)level).m_8055_(sleepingPos).m_60713_((Block)JBlockRegistry.COFFIN_BLOCK.get())) {
            return serverWorld.m_46461_() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult allowBed(Entity entity, BlockPos sleepingPos, BlockState state, boolean b) {
        if (state.m_60713_((Block)JBlockRegistry.COFFIN_BLOCK.get()) && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.m_36317_() ? InteractionResult.FAIL : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Direction modifySleepingDirection(Entity entity, BlockPos sleepingPos, Direction sleepingDirection) {
        BlockState state = entity.m_9236_().m_8055_(sleepingPos);
        if (state.m_60713_((Block)JBlockRegistry.COFFIN_BLOCK.get())) {
            return (Direction)state.m_61143_((Property)CoffinBlock.f_54117_);
        }
        return sleepingDirection;
    }

    public static void stopSleeping(Entity entity, BlockPos sleepingPos) {
        ServerLevel serverWorld;
        BlockState state;
        Level level;
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).m_36317_() && (level = serverPlayer.m_9236_()) instanceof ServerLevel && (state = (serverWorld = (ServerLevel)level).m_8055_(sleepingPos)).m_60713_((Block)JBlockRegistry.COFFIN_BLOCK.get())) {
            if (serverWorld.f_143245_.m_144002_(serverWorld.m_46469_().m_46215_(GameRules.f_151486_)) && serverWorld.m_46469_().m_46207_(GameRules.f_46140_)) {
                serverWorld.m_8615_(serverWorld.m_46468_() / 24000L * 24000L + 13000L);
            }
            serverWorld.m_46597_(sleepingPos, (BlockState)state.m_61124_((Property)CoffinBlock.f_49441_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static void serverLevelPostTick(ServerLevel serverLevel) {
        DimensionType dimensionType = serverLevel.m_6042_();
        if (dimensionType.f_63856_() || !serverLevel.m_46469_().m_46207_(JCraft.FALLING_METEORS)) {
            return;
        }
        List players = serverLevel.m_8795_(LivingEntity::m_6084_);
        if (players.isEmpty()) {
            return;
        }
        double chance = (double)JServerConfig.METEOR_SPAWN_RATE.getValue() / 100.0 / 20.0;
        if (serverLevel.f_46441_.m_188500_() >= chance) {
            return;
        }
        ServerPlayer player = (ServerPlayer)players.get(serverLevel.f_46441_.m_188503_(players.size()));
        Vec3 randomPos = new Vec3(player.m_20185_() + serverLevel.f_46441_.m_188500_() * 128.0 - 64.0, (double)Math.min(242, serverLevel.m_151558_() - 1), player.m_20189_() + serverLevel.f_46441_.m_188500_() * 128.0 - 64.0);
        BlockPos randomBlockPos = BlockPos.m_274446_((Position)randomPos);
        if (serverLevel.m_46749_(randomBlockPos) && serverLevel.m_204166_(randomBlockPos).m_203656_(JTagRegistry.METEORS_CAN_FALL)) {
            StandMeteorEntity meteor = new StandMeteorEntity((Level)serverLevel);
            meteor.m_146884_(randomPos);
            serverLevel.m_7967_((Entity)meteor);
        }
    }

    public static EventResult beforeBlockSet(BlockPos blockPos, BlockState oldBlockState, BlockState newBlockState) {
        if (oldBlockState.m_204336_(BlockTags.f_13035_) && newBlockState.m_204336_(BlockTags.f_13035_)) {
            return EventResult.pass();
        }
        BlockMarkerMoves.mergeQueues();
        BlockMarkerMoves.forEach(move -> move.addBlock(blockPos, oldBlockState));
        return EventResult.pass();
    }
}

