/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity;

import net.arna.jcraft.common.gravity.util.QuaternionUtil;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RotationAnimation {
    private boolean inAnimation = false;
    private Quaternionf startGravityRotation;
    private Quaternionf endGravityRotation;
    private long startTimeMs;
    private long endTimeMs;

    public void applyRotationAnimation(Direction newGravity, Direction prevGravity, long durationTimeMs, Entity entity, long timeMs, boolean rotateView) {
        if (durationTimeMs == 0L) {
            this.inAnimation = false;
            return;
        }
        Validate.notNull((Object)entity);
        Vec3 newLookingDirection = this.getNewLookingDirection(newGravity, prevGravity, entity);
        Quaternionf oldViewRotation = QuaternionUtil.getViewRotation(entity.m_146909_(), entity.m_146908_());
        Quaternionf currentAnimatedGravityRotation = this.getCurrentGravityRotation(prevGravity, timeMs);
        Quaternionf currentAnimatedCameraRotation = QuaternionUtil.mult(oldViewRotation, currentAnimatedGravityRotation);
        Quaternionf newEndGravityRotation = RotationUtil.getWorldRotationQuaternion(newGravity);
        Vec2 newYawAndPitch = RotationUtil.vecToRot(RotationUtil.vecWorldToPlayer(newLookingDirection, newGravity));
        float newPitch = newYawAndPitch.f_82471_;
        float newYaw = newYawAndPitch.f_82470_;
        float deltaYaw = newYaw - entity.m_146908_();
        float deltaPitch = newPitch - entity.m_146909_();
        entity.m_146922_(entity.m_146908_() + deltaYaw);
        entity.m_146926_(entity.m_146909_() + deltaPitch);
        entity.f_19859_ += deltaYaw;
        entity.f_19860_ += deltaPitch;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20883_ += deltaYaw;
            livingEntity.f_20884_ += deltaYaw;
            livingEntity.f_20885_ += deltaYaw;
            livingEntity.f_20886_ += deltaYaw;
        }
        Quaternionf newViewRotation = QuaternionUtil.getViewRotation(entity.m_146909_(), entity.m_146908_());
        Quaternionf animationStartGravityRotation = QuaternionUtil.mult(QuaternionUtil.inversed(newViewRotation), currentAnimatedCameraRotation);
        this.inAnimation = true;
        this.startGravityRotation = animationStartGravityRotation;
        this.endGravityRotation = newEndGravityRotation;
        this.startTimeMs = timeMs;
        this.endTimeMs = timeMs + durationTimeMs;
    }

    private Vec3 getNewLookingDirection(Direction newGravity, Direction prevGravity, Entity player) {
        Vec3 oldLookingDirection = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(player.m_146908_(), player.m_146909_()), prevGravity);
        if (newGravity == prevGravity.m_122424_()) {
            return oldLookingDirection.m_82490_(-1.0);
        }
        Quaternionf deltaRotation = QuaternionUtil.getRotationBetween(Vec3.m_82528_((Vec3i)prevGravity.m_122436_()), Vec3.m_82528_((Vec3i)newGravity.m_122436_()));
        Vector3f lookingDirection = oldLookingDirection.m_252839_();
        lookingDirection.rotate((Quaternionfc)deltaRotation);
        return new Vec3(lookingDirection);
    }

    public Quaternionf getCurrentGravityRotation(Direction currentGravity, long timeMs) {
        if (timeMs > this.endTimeMs) {
            this.inAnimation = false;
        }
        if (!this.inAnimation) {
            return RotationUtil.getWorldRotationQuaternion(currentGravity);
        }
        double delta = (double)(timeMs - this.startTimeMs) / (double)(this.endTimeMs - this.startTimeMs);
        return RotationUtil.interpolate(this.startGravityRotation, this.endGravityRotation, RotationAnimation.mapProgress((float)delta));
    }

    private static float mapProgress(float delta) {
        return Mth.m_14036_((float)(delta * delta * (3.0f - 2.0f * delta)), (float)0.0f, (float)1.0f);
    }

    public void toNbt(CompoundTag nbt) {
        nbt.m_128379_("InAnimation", this.inAnimation);
        if (!this.inAnimation) {
            return;
        }
        nbt.m_128350_("Q0X", this.startGravityRotation.x());
        nbt.m_128350_("Q0Y", this.startGravityRotation.y());
        nbt.m_128350_("Q0Z", this.startGravityRotation.z());
        nbt.m_128350_("Q0W", this.startGravityRotation.w());
        nbt.m_128350_("Q1X", this.endGravityRotation.x());
        nbt.m_128350_("Q1Y", this.endGravityRotation.y());
        nbt.m_128350_("Q1Z", this.endGravityRotation.z());
        nbt.m_128350_("Q1W", this.endGravityRotation.w());
        nbt.m_128356_("StartTime", this.startTimeMs);
        nbt.m_128356_("EndTime", this.endTimeMs);
    }

    public void fromNbt(CompoundTag nbt) {
        this.inAnimation = nbt.m_128471_("InAnimation");
        if (!this.inAnimation) {
            return;
        }
        this.startGravityRotation = new Quaternionf(nbt.m_128457_("Q0X"), nbt.m_128457_("Q0Y"), nbt.m_128457_("Q0Z"), nbt.m_128457_("Q0W"));
        this.endGravityRotation = new Quaternionf(nbt.m_128457_("Q1X"), nbt.m_128457_("Q1Y"), nbt.m_128457_("Q1Z"), nbt.m_128457_("Q1W"));
        this.startTimeMs = nbt.m_128454_("StartTime");
        this.endTimeMs = nbt.m_128454_("EndTime");
    }

    public boolean isInAnimation() {
        return this.inAnimation;
    }
}

