/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.gravity.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.component.entity.CommonGravityComponent;
import net.arna.jcraft.common.gravity.RotationAnimation;
import net.arna.jcraft.common.gravity.api.RotationParameters;
import net.arna.jcraft.common.gravity.util.EntityTags;
import net.arna.jcraft.common.gravity.util.Gravity;
import net.arna.jcraft.common.gravity.util.GravityChannel;
import net.arna.jcraft.common.gravity.util.NetworkUtil;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.gravity.util.packet.DefaultGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.InvertGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.OverwriteGravityPacket;
import net.arna.jcraft.common.gravity.util.packet.UpdateGravityPacket;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class GravityChangerAPI {
    public static Direction getGravityDirection(Entity entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return JComponentPlatformUtils.getGravity(entity).map(CommonGravityComponent::getGravityDirection).orElse(Direction.DOWN);
        }
        return Direction.DOWN;
    }

    public static List<Gravity> getGravityList(Entity entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return JComponentPlatformUtils.getGravity(entity).map(CommonGravityComponent::getGravity).orElse(new ArrayList());
        }
        return new ArrayList<Gravity>();
    }

    public static Direction getPrevGravityDirection(Entity entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return JComponentPlatformUtils.getGravity(entity).map(CommonGravityComponent::getPrevGravityDirection).orElse(Direction.DOWN);
        }
        return Direction.DOWN;
    }

    public static Direction getDefaultGravityDirection(Entity entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return JComponentPlatformUtils.getGravity(entity).map(CommonGravityComponent::getDefaultGravityDirection).orElse(Direction.DOWN);
        }
        return Direction.DOWN;
    }

    public static Direction getActualGravityDirection(Entity entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return JComponentPlatformUtils.getGravity(entity).map(CommonGravityComponent::getActualGravityDirection).orElse(Direction.DOWN);
        }
        return Direction.DOWN;
    }

    public static boolean getIsInverted(Entity entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return JComponentPlatformUtils.getGravity(entity).map(CommonGravityComponent::getInvertGravity).orElse(false);
        }
        return false;
    }

    public static Optional<RotationAnimation> getGravityAnimation(Entity entity) {
        if (EntityTags.canChangeGravity(entity)) {
            return JComponentPlatformUtils.getGravity(entity).map(CommonGravityComponent::getGravityAnimation);
        }
        return Optional.empty();
    }

    public static void addGravity(Entity entity, Gravity gravity) {
        if (GravityChangerAPI.onWrongSide(entity) || !EntityTags.canChangeGravity(entity)) {
            return;
        }
        JComponentPlatformUtils.getGravity(entity).ifPresent(gc -> {
            gc.addGravity(gravity, false);
            GravityChannel.UPDATE_GRAVITY.sendToClient(entity, new UpdateGravityPacket(gravity, false), NetworkUtil.PacketMode.EVERYONE);
        });
    }

    public static void updateGravity(Entity entity) {
        GravityChangerAPI.updateGravity(entity, new RotationParameters());
    }

    public static void updateGravity(Entity entity, RotationParameters rotationParameters) {
        if (EntityTags.canChangeGravity(entity)) {
            JComponentPlatformUtils.getGravity(entity).ifPresent(gc -> gc.updateGravity(rotationParameters, false));
        }
    }

    public static void setGravity(Entity entity, List<Gravity> gravity) {
        if (GravityChangerAPI.onWrongSide(entity) || !EntityTags.canChangeGravity(entity)) {
            return;
        }
        JComponentPlatformUtils.getGravity(entity).ifPresent(gc -> {
            gc.setGravity(gravity, false);
            GravityChannel.OVERWRITE_GRAVITY.sendToClient(entity, new OverwriteGravityPacket(gravity, false), NetworkUtil.PacketMode.EVERYONE);
        });
    }

    public static void setIsInverted(Entity entity, boolean isInverted) {
        GravityChangerAPI.setIsInverted(entity, isInverted, new RotationParameters());
    }

    public static void setIsInverted(Entity entity, boolean isInverted, RotationParameters rotationParameters) {
        if (GravityChangerAPI.onWrongSide(entity) || !EntityTags.canChangeGravity(entity)) {
            return;
        }
        JComponentPlatformUtils.getGravity(entity).ifPresent(gc -> {
            gc.invertGravity(isInverted, rotationParameters, false);
            GravityChannel.INVERT_GRAVITY.sendToClient(entity, new InvertGravityPacket(isInverted, rotationParameters, false), NetworkUtil.PacketMode.EVERYONE);
        });
    }

    public static void clearGravity(Entity entity) {
        GravityChangerAPI.clearGravity(entity, new RotationParameters());
    }

    public static void clearGravity(Entity entity, RotationParameters rotationParameters) {
        if (GravityChangerAPI.onWrongSide(entity) || !EntityTags.canChangeGravity(entity)) {
            return;
        }
        JComponentPlatformUtils.getGravity(entity).ifPresent(gc -> {
            gc.clearGravity(rotationParameters, false);
            GravityChannel.OVERWRITE_GRAVITY.sendToClient(entity, new OverwriteGravityPacket(new ArrayList<Gravity>(), false), NetworkUtil.PacketMode.EVERYONE);
        });
    }

    @Deprecated
    public static void setDefaultGravityDirection(Entity entity, Direction gravityDirection, int animationDurationMs) {
        GravityChangerAPI.setDefaultGravityDirection(entity, gravityDirection, new RotationParameters().rotationTime(animationDurationMs));
    }

    public static void setDefaultGravityDirection(Entity entity, Direction gravityDirection) {
        GravityChangerAPI.setDefaultGravityDirection(entity, gravityDirection, new RotationParameters());
    }

    public static void setDefaultGravityDirection(Entity entity, Direction gravityDirection, RotationParameters rotationParameters) {
        if (GravityChangerAPI.onWrongSide(entity) || !EntityTags.canChangeGravity(entity)) {
            return;
        }
        JComponentPlatformUtils.getGravity(entity).ifPresent(gc -> {
            gc.setDefaultGravityDirection(gravityDirection, rotationParameters, false);
            GravityChannel.DEFAULT_GRAVITY.sendToClient(entity, new DefaultGravityPacket(gravityDirection, rotationParameters, false), NetworkUtil.PacketMode.EVERYONE);
        });
    }

    @Nullable
    public static CommonGravityComponent getGravityComponent(Entity entity) {
        return JComponentPlatformUtils.getGravity(entity).orElse(null);
    }

    public static Vec3 getWorldVelocity(Entity playerEntity) {
        return RotationUtil.vecPlayerToWorld(playerEntity.m_20184_(), GravityChangerAPI.getGravityDirection(playerEntity));
    }

    public static void setWorldVelocity(Entity entity, Vec3 worldVelocity) {
        entity.m_20256_(RotationUtil.vecWorldToPlayer(worldVelocity, GravityChangerAPI.getGravityDirection(entity)));
    }

    public static void setWorldVelocity(Entity entity, Vector3f worldVelocity) {
        entity.m_20256_(RotationUtil.vecWorldToPlayer(new Vec3(worldVelocity), GravityChangerAPI.getGravityDirection(entity)));
    }

    public static void addWorldVelocity(Entity entity, double x, double y, double z) {
        Vec3 corrected = RotationUtil.vecWorldToPlayer(new Vec3(x, y, z), GravityChangerAPI.getGravityDirection(entity));
        entity.m_5997_(corrected.f_82479_, corrected.f_82480_, corrected.f_82481_);
    }

    public static void addWorldVelocity(Entity entity, Vec3 worldVelocity) {
        Vec3 corrected = RotationUtil.vecWorldToPlayer(worldVelocity, GravityChangerAPI.getGravityDirection(entity));
        entity.m_5997_(corrected.f_82479_, corrected.f_82480_, corrected.f_82481_);
    }

    public static Vec3 getEyeOffset(Entity entity) {
        return RotationUtil.vecPlayerToWorld(0.0, (double)entity.m_20192_(), 0.0, GravityChangerAPI.getGravityDirection(entity));
    }

    private static boolean onWrongSide(Entity entity) {
        if (entity.m_9236_().f_46443_) {
            JCraft.LOGGER.error("GravityChangerAPI function cannot be called from the client, use dedicated client class. ", (Throwable)new Exception());
            return true;
        }
        return false;
    }
}

